/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.backup;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ProgressListener;
import org.cpsolver.ifs.util.ProgressWriter;
import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.CacheMode;
import org.hibernate.Hibernate;
import org.hibernate.UnknownEntityTypeException;
import org.hibernate.proxy.HibernateProxy;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.backup.BackupProgress;
import org.unitime.timetable.backup.SessionBackupInterface;
import org.unitime.timetable.backup.TableData;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.AssignmentInfo;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ConstraintInfo;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.LastLikeCourseDemand;
import org.unitime.timetable.model.OnlineSectioningLog;
import org.unitime.timetable.model.PitCourseOffering;
import org.unitime.timetable.model.PitDepartmentalInstructor;
import org.unitime.timetable.model.PitStudentAcadAreaMajorClassification;
import org.unitime.timetable.model.PitStudentAcadAreaMinorClassification;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.SectioningSolutionLog;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolutionInfo;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao._RootDAO;

public class SessionBackup
implements SessionBackupInterface {
    private static Log sLog = LogFactory.getLog(SessionBackup.class);
    private org.hibernate.Session iHibSession = null;
    private CodedOutputStream iOut = null;
    private PrintWriter iDebug = null;
    private Long iSessionId = null;
    private BackupProgress iProgress = null;
    private Metamodel iMetamodel = null;
    private SimpleDateFormat iDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private int iQueueItemCoutner = 0;
    private Map<String, Set<Serializable>> iExclude = new HashMap<String, Set<Serializable>>();

    public BackupProgress getProgress() {
        return this.iProgress;
    }

    private void add(TableData.Table table) throws IOException {
        this.iProgress.info("Writing " + table.getName().substring(table.getName().lastIndexOf(46) + 1) + " [" + table.getRecordCount() + " records, " + table.getSerializedSize() + " bytes]");
        this.iOut.writeInt32NoTag(table.getSerializedSize());
        table.writeTo(this.iOut);
        this.iOut.flush();
        if (this.iDebug != null) {
            this.iDebug.println("## " + table.getName() + " ##");
            this.iDebug.print(table.toString());
            this.iDebug.flush();
        }
    }

    public void debug(PrintWriter pw) {
        this.iDebug = pw;
    }

    private boolean hasSubclasses(EntityType type) {
        for (EntityType et : this.iMetamodel.getEntities()) {
            if (et.equals(type) || !type.getJavaType().isAssignableFrom(et.getJavaType())) continue;
            return true;
        }
        return false;
    }

    private boolean isNullable(Attribute attribute) {
        return attribute instanceof SingularAttribute && ((SingularAttribute)attribute).isOptional();
    }

    private boolean isEntity(Attribute attribute) {
        if (attribute.isCollection()) {
            return false;
        }
        try {
            return this.iMetamodel.entity(attribute.getJavaType()) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean hasCompositeId(EntityType meta) {
        return !meta.hasSingleIdAttribute();
    }

    private SingularAttribute getIdAttribute(EntityType meta) {
        if (meta.hasSingleIdAttribute()) {
            return meta.getId(meta.getIdType().getJavaType());
        }
        return null;
    }

    private List<SingularAttribute> getIdAttributes(EntityType meta) {
        if (meta.hasSingleIdAttribute()) {
            ArrayList<SingularAttribute> ret = new ArrayList<SingularAttribute>(1);
            ret.add(meta.getId(meta.getIdType().getJavaType()));
            return ret;
        }
        ArrayList<SingularAttribute> ret = new ArrayList<SingularAttribute>(meta.getIdClassAttributes().size());
        ret.addAll(meta.getIdClassAttributes());
        return ret;
    }

    private Object getProperty(Object object, Attribute attribute) {
        try {
            return ((Method)attribute.getJavaMember()).invoke(object, new Object[0]);
        }
        catch (Exception e) {
            this.iProgress.warn("Failed to get " + String.valueOf(attribute) + ": " + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backup(OutputStream out, BackupProgress progress, Long sessionId) throws IOException {
        this.iOut = CodedOutputStream.newInstance((OutputStream)out);
        this.iProgress = progress;
        this.iSessionId = sessionId;
        this.iHibSession = new _RootDAO().createNewSession();
        this.iHibSession.setCacheMode(CacheMode.IGNORE);
        this.iMetamodel = this.iHibSession.getMetamodel();
        try {
            List<QueueItem> items;
            String pDisallowed;
            this.iProgress.setStatus("Exporting Session");
            this.iProgress.setPhase("Loading Model", 3.0);
            TreeSet<EntityType> allMeta = new TreeSet<EntityType>(new Comparator<EntityType>(){

                @Override
                public int compare(EntityType m1, EntityType m2) {
                    return m1.getName().compareTo(m2.getName());
                }
            });
            allMeta.addAll(this.iMetamodel.getEntities());
            this.iProgress.incProgress();
            LinkedList<QueueItem> queue = new LinkedList<QueueItem>();
            queue.add(new QueueItem(this.iMetamodel.entity(Session.class), null, "uniqueId", Relation.None));
            HashSet<Object> avoid = new HashSet<Object>();
            avoid.add(TimetableManager.class.getName() + ".departments");
            avoid.add(TimetableManager.class.getName() + ".solverGroups");
            avoid.add(TimetableManager.class.getName() + ".settings");
            avoid.add(DistributionType.class.getName() + ".departments");
            avoid.add(LastLikeCourseDemand.class.getName() + ".student");
            avoid.add(Student.class.getName() + ".lastLikeCourseDemands");
            String pAvoid = ApplicationProperty.SessionBackupAvoid.value();
            if (pAvoid != null && !pAvoid.isEmpty()) {
                for (String av : pAvoid.split("[\n,;]")) {
                    if (av.isEmpty()) continue;
                    avoid.add(av.trim());
                }
            }
            HashSet<Object> disallowedNotNullRelations = new HashSet<Object>();
            disallowedNotNullRelations.add(Assignment.class.getName() + ".datePattern");
            disallowedNotNullRelations.add(Assignment.class.getName() + ".timePattern");
            disallowedNotNullRelations.add(LastLikeCourseDemand.class.getName() + ".student");
            disallowedNotNullRelations.add(OnlineSectioningLog.class.getName() + ".session");
            disallowedNotNullRelations.add(PointInTimeData.class.getName() + ".session");
            disallowedNotNullRelations.add(SectioningSolutionLog.class.getName() + ".session");
            if (ApplicationProperty.SessionBackupPointInTime.isFalse()) {
                disallowedNotNullRelations.add(PitStudentAcadAreaMajorClassification.class.getName() + ".academicArea");
                disallowedNotNullRelations.add(PitStudentAcadAreaMajorClassification.class.getName() + ".academicClassification");
                disallowedNotNullRelations.add(PitStudentAcadAreaMajorClassification.class.getName() + ".major");
                disallowedNotNullRelations.add(PitStudentAcadAreaMinorClassification.class.getName() + ".academicArea");
                disallowedNotNullRelations.add(PitStudentAcadAreaMinorClassification.class.getName() + ".academicClassification");
                disallowedNotNullRelations.add(PitStudentAcadAreaMinorClassification.class.getName() + ".minor");
                disallowedNotNullRelations.add(PitDepartmentalInstructor.class.getName() + ".department");
                disallowedNotNullRelations.add(PitCourseOffering.class.getName() + ".subjectArea");
            }
            if ((pDisallowed = ApplicationProperty.SessionBackupDisallowed.value()) != null && !pDisallowed.isEmpty()) {
                for (String dis : pDisallowed.split("[\n,;]")) {
                    if (dis.isEmpty()) continue;
                    disallowedNotNullRelations.add(dis.trim());
                }
            }
            HashMap<String, List<Object>> data = new HashMap<String, List<Object>>();
            ArrayList<QueueItem> sessions = new ArrayList<QueueItem>();
            sessions.add((QueueItem)queue.peek());
            data.put(((QueueItem)queue.peek()).name(), sessions);
            QueueItem item = null;
            while ((item = (QueueItem)queue.poll()) != null) {
                if (item.size() == 0) continue;
                for (EntityType meta : allMeta) {
                    if (this.hasSubclasses(meta)) continue;
                    for (Attribute attribute : meta.getAttributes()) {
                        QueueItem qi3;
                        String property = attribute.getName();
                        if (disallowedNotNullRelations.contains(meta.getJavaType().getName() + "." + property) || this.isNullable(attribute) || !this.isEntity(attribute) || !attribute.getJavaType().equals(item.clazz()) || data.containsKey((qi3 = new QueueItem(meta, item, property, Relation.Parent)).name())) continue;
                        items = new ArrayList<QueueItem>();
                        data.put(qi3.name(), items);
                        queue.add(qi3);
                        items.add(qi3);
                        if (qi3.size() <= 0) continue;
                        this.iProgress.info("Parent: " + String.valueOf(qi3));
                    }
                }
            }
            this.iProgress.incProgress();
            for (Iterator list : data.values()) {
                queue.addAll((Collection<QueueItem>)((Object)list));
            }
            ArrayList<QueueItem> distributions = new ArrayList<QueueItem>();
            for (QueueItem instructor : (List)data.get(DepartmentalInstructor.class.getName())) {
                QueueItem qi2 = new QueueItem(this.iMetamodel.entity(DistributionPref.class), instructor, "owner", Relation.Parent);
                distributions.add(qi2);
                queue.add(qi2);
                if (qi2.size() <= 0) continue;
                this.iProgress.info("Extra: " + String.valueOf(qi2));
            }
            data.put(DistributionPref.class.getName(), distributions);
            while ((item = (QueueItem)queue.poll()) != null) {
                if (item.size() == 0) continue;
                for (Attribute attribute : item.meta().getAttributes()) {
                    EntityType meta;
                    String property = attribute.getName();
                    if (this.isEntity(attribute)) {
                        if (avoid.contains(item.name() + "." + property)) continue;
                        meta = null;
                        try {
                            meta = this.iMetamodel.entity(attribute.getJavaType());
                        }
                        catch (IllegalArgumentException qi3) {
                            // empty catch block
                        }
                        if (meta == null || item.contains(meta.getJavaType().getName())) continue;
                        QueueItem qi4 = new QueueItem(meta, item, property, Relation.One);
                        items = (List)data.get(qi4.name());
                        if (items == null) {
                            items = new ArrayList();
                            data.put(qi4.name(), items);
                        }
                        queue.add(qi4);
                        items.add(qi4);
                        if (qi4.size() > 0) {
                            this.iProgress.info("One: " + String.valueOf(qi4));
                        }
                    }
                    if (!attribute.isCollection() || avoid.contains(item.name() + "." + property)) continue;
                    meta = null;
                    try {
                        meta = this.iMetamodel.entity(((PluralAttribute)attribute).getElementType().getJavaType());
                    }
                    catch (IllegalArgumentException qi4) {
                        // empty catch block
                    }
                    if (meta == null || item.contains(meta.getJavaType().getName())) continue;
                    QueueItem qi = new QueueItem(meta, item, property, Relation.Many);
                    items = (List)data.get(qi.name());
                    if (items == null) {
                        items = new ArrayList();
                        data.put(qi.name(), items);
                    }
                    queue.add(qi);
                    items.add(qi);
                    if (qi.size() <= 0) continue;
                    this.iProgress.info("Many: " + String.valueOf(qi));
                }
            }
            this.iProgress.incProgress();
            HashMap<String, HashSet<Serializable>> allExportedIds = new HashMap<String, HashSet<Serializable>>();
            for (String name : new TreeSet(data.keySet())) {
                List list = (List)data.get(name);
                HashMap<String, TableData.Table.Builder> tables = new HashMap<String, TableData.Table.Builder>();
                for (QueueItem current : list) {
                    if (current.size() == 0) continue;
                    this.iProgress.info("Loading " + String.valueOf(current));
                    List<Object> objects = current.list();
                    if (objects == null || objects.isEmpty()) continue;
                    this.iProgress.setPhase(current.abbv() + " [" + objects.size() + "]", objects.size());
                    block20: for (Object object : objects) {
                        this.iProgress.incProgress();
                        if (object instanceof HibernateProxy) {
                            object = Hibernate.unproxy((Object)object);
                        }
                        EntityType meta = null;
                        try {
                            meta = this.iMetamodel.entity(object.getClass());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        if (meta == null) {
                            meta = current.meta();
                        }
                        if (this.hasSubclasses(meta)) {
                            for (EntityType t : this.iMetamodel.getEntities()) {
                                if (!t.getJavaType().isInstance(object) || this.hasSubclasses(t)) continue;
                                meta = t;
                                break;
                            }
                        }
                        Serializable id = null;
                        if (this.hasCompositeId(meta)) {
                            List<SingularAttribute> idAttributes = this.getIdAttributes(meta);
                            Object[] ids = new Object[idAttributes.size()];
                            for (int i = 0; i < idAttributes.size(); ++i) {
                                Object value = this.getProperty(object, (Attribute)idAttributes.get(i));
                                if (value == null) continue;
                                ids[i] = this.isEntity((Attribute)idAttributes.get(i)) ? this.getProperty(value, (Attribute)this.getIdAttribute(this.iMetamodel.entity(idAttributes.get(i).getJavaType()))) : value;
                            }
                            id = new CompositeId(ids);
                        } else {
                            id = (Serializable)this.getProperty(object, (Attribute)this.getIdAttribute(meta));
                        }
                        HashSet<Serializable> exportedIds = (HashSet<Serializable>)allExportedIds.get(meta.getJavaType().getName());
                        if (exportedIds == null) {
                            exportedIds = new HashSet<Serializable>();
                            allExportedIds.put(meta.getJavaType().getName(), exportedIds);
                        }
                        if (!exportedIds.add(id)) continue;
                        for (Attribute attribute : meta.getAttributes()) {
                            Session s;
                            if (!attribute.getJavaType().equals(Session.class) || (s = (Session)this.getProperty(object, attribute)) == null || s.getUniqueId().equals(this.iSessionId)) continue;
                            this.iProgress.warn(meta.getName() + "@" + String.valueOf(id) + " belongs to a different academic session (" + String.valueOf(s) + ")");
                            continue block20;
                        }
                        TableData.Table.Builder table = (TableData.Table.Builder)tables.get(meta.getJavaType().getName());
                        if (table == null) {
                            table = TableData.Table.newBuilder();
                            tables.put(meta.getJavaType().getName(), table);
                            table.setName(meta.getJavaType().getName());
                        }
                        TableData.Record.Builder record = TableData.Record.newBuilder();
                        record.setId(id.toString());
                        ArrayList<Object> attributes = new ArrayList<Object>();
                        if (this.hasCompositeId(meta)) {
                            attributes.addAll(this.getIdAttributes(meta));
                        }
                        for (Attribute attribute : meta.getAttributes()) {
                            if (!attribute.isCollection() && ((SingularAttribute)attribute).isId()) continue;
                            attributes.add(attribute);
                        }
                        for (Attribute attribute : attributes) {
                            String property = attribute.getName();
                            Object value = this.getProperty(object, attribute);
                            if (value == null) continue;
                            TableData.Element.Builder element = TableData.Element.newBuilder();
                            element.setName(property);
                            if (value instanceof Boolean) {
                                element.addValue(value.toString());
                            } else if (value instanceof Byte) {
                                element.addValue(value.toString());
                            } else if (value instanceof Short) {
                                element.addValue(value.toString());
                            } else if (value instanceof Integer) {
                                element.addValue(value.toString());
                            } else if (value instanceof Long) {
                                element.addValue(value.toString());
                            } else if (value instanceof Float) {
                                element.addValue(value.toString());
                            } else if (value instanceof Double) {
                                element.addValue(value.toString());
                            } else if (value instanceof String) {
                                element.addValue(value.toString());
                            } else if (value instanceof Date) {
                                element.addValue(this.iDateFormat.format((Date)value));
                            } else if (value instanceof byte[]) {
                                element.addValueBytes(ByteString.copyFrom((byte[])((byte[])value)));
                            } else if (this.isEntity(attribute)) {
                                ids = current.relation(property, meta, id, false);
                                if (ids != null) {
                                    for (Object i : ids) {
                                        element.addValue(i.toString());
                                    }
                                }
                            } else if (attribute.isCollection()) {
                                ids = current.relation(property, meta, id, false);
                                if (ids != null) {
                                    for (Object i : ids) {
                                        element.addValue(i.toString());
                                    }
                                }
                            } else {
                                this.iProgress.warn("Unknown data type: " + String.valueOf(attribute.getJavaType()) + " (property " + meta.getName() + "." + property + ", " + String.valueOf(value.getClass()) + ")");
                                continue;
                            }
                            record.addElement(element.build());
                        }
                        table.addRecord(record.build());
                    }
                    current.clearCache();
                }
                for (TableData.Table.Builder table : tables.values()) {
                    this.add(table.build());
                }
            }
            this.iProgress.setStatus("All done.");
        }
        finally {
            this.iHibSession.close();
        }
    }

    public static void main(String[] args) {
        try {
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            Session session = Session.getSessionUsingInitiativeYearTerm(ApplicationProperties.getProperty("initiative", "PWL"), ApplicationProperties.getProperty("year", "2012"), ApplicationProperties.getProperty("term", "Spring"));
            if (session == null) {
                sLog.error((Object)"Academic session not found, use properties initiative, year, and term to set academic session.");
                System.exit(0);
            } else {
                sLog.info((Object)("Session: " + String.valueOf(session)));
            }
            FileOutputStream out = new FileOutputStream((String)(args.length == 0 ? session.getAcademicTerm() + session.getAcademicYear() + session.getAcademicInitiative() + ".dat" : args[0]));
            final Progress progress = Progress.getInstance();
            sLog.info((Object)("Using " + ApplicationProperty.SessionBackupInterface.value()));
            SessionBackup backup = (SessionBackup)Class.forName(ApplicationProperty.SessionBackupInterface.value()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            PrintWriter debug = null;
            if (args.length >= 2) {
                debug = new PrintWriter(args[1]);
                backup.debug(debug);
            }
            progress.addProgressListener((ProgressListener)new ProgressWriter(System.out));
            backup.backup(out, new BackupProgress(){

                @Override
                public void setStatus(String status) {
                    progress.setStatus(status);
                }

                @Override
                public void setPhase(String phase, double max) {
                    progress.setPhase(phase, Math.round(max));
                }

                @Override
                public void incProgress() {
                    progress.incProgress();
                }

                @Override
                public void info(String message) {
                    progress.info(message);
                }

                @Override
                public void warn(String message) {
                    progress.warn(message);
                }

                @Override
                public void error(String message) {
                    progress.error(message);
                }
            }, session.getUniqueId());
            out.close();
            if (debug != null) {
                debug.close();
            }
        }
        catch (Exception e) {
            sLog.fatal((Object)("Backup failed: " + e.getMessage()), (Throwable)e);
        }
    }

    class QueueItem {
        QueueItem iParent;
        EntityType iMeta;
        String iProperty;
        int iQueueItemId;
        Relation iRelation;
        int size;
        Map<String, Map<Serializable, List<Object>>> iRelationCache;

        QueueItem(EntityType meta, QueueItem parent, String property, Relation relation) {
            this.iQueueItemId = SessionBackup.this.iQueueItemCoutner++;
            this.size = -1;
            this.iRelationCache = new HashMap<String, Map<Serializable, List<Object>>>();
            this.iMeta = meta;
            this.iParent = parent;
            this.iProperty = property;
            this.iRelation = relation;
        }

        String property() {
            return this.iProperty;
        }

        QueueItem parent() {
            return this.iParent;
        }

        EntityType meta() {
            return this.iMeta;
        }

        String name() {
            return this.meta().getJavaType().getName();
        }

        String abbv() {
            return this.meta().getName();
        }

        Class clazz() {
            return this.meta().getJavaType();
        }

        int qid() {
            return this.iQueueItemId;
        }

        Relation relation() {
            return this.iRelation;
        }

        boolean contains(String name) {
            if (name.equals(this.name())) {
                return true;
            }
            if (this.parent() == null) {
                return false;
            }
            return this.parent().contains(name);
        }

        int depth() {
            return this.parent() == null ? 0 : 1 + this.parent().depth();
        }

        public String toString() {
            return this.abbv() + ": " + this.chain() + " [" + this.size() + "]";
        }

        public String chain() {
            switch (this.relation()) {
                case None: {
                    return this.property();
                }
                case Parent: {
                    return this.property() + "." + this.parent().chain();
                }
            }
            switch (this.parent().relation()) {
                case Parent: {
                    return "(" + this.parent().abbv() + "." + this.parent().chain() + ")." + this.property();
                }
                case None: {
                    return this.parent().abbv() + "." + this.property();
                }
            }
            return this.parent().chain() + "." + this.property();
        }

        String hqlName() {
            return "q" + this.qid();
        }

        String hqlFrom() {
            switch (this.relation()) {
                case One: 
                case Many: {
                    return this.parent().hqlFrom() + " inner join " + this.parent().hqlName() + "." + this.property() + " " + this.hqlName();
                }
            }
            return (String)(this.parent() == null ? "" : this.parent().hqlFrom() + ", ") + this.name() + " " + this.hqlName();
        }

        String hqlWhere() {
            Object where = null;
            switch (this.relation()) {
                case None: {
                    where = this.hqlName() + "." + this.property() + " = :sessionId";
                    break;
                }
                case Parent: {
                    where = this.hqlName() + "." + this.property() + " = " + this.parent().hqlName() + " and " + this.parent().hqlWhere();
                    break;
                }
                default: {
                    where = this.parent().hqlWhere();
                }
            }
            if (Solution.class.getName().equals(this.name())) {
                where = (String)where + " and " + this.hqlName() + ".commited = true";
            }
            if (Assignment.class.getName().equals(this.name())) {
                where = (String)where + " and " + this.hqlName() + ".solution.commited = true";
            }
            if (SolutionInfo.class.getName().equals(this.name())) {
                where = (String)where + " and " + this.hqlName() + ".definition.name = 'GlobalInfo'";
            }
            return where;
        }

        int size() {
            block12: {
                if (this.relation() == Relation.Empty) {
                    return 0;
                }
                if (AssignmentInfo.class.getName().equals(this.name())) {
                    return 0;
                }
                if (ConstraintInfo.class.getName().equals(this.name())) {
                    return 0;
                }
                if (ChangeLog.class.getName().equals(this.name())) {
                    return 0;
                }
                if (this.size >= 0) break block12;
                Set<Serializable> ids = SessionBackup.this.iExclude.get(this.name());
                if (ids == null) {
                    ids = new HashSet<Serializable>();
                    SessionBackup.this.iExclude.put(this.name(), ids);
                }
                this.size = 0;
                if (SessionBackup.this.hasCompositeId(this.meta())) {
                    List<SingularAttribute> idAttributes = SessionBackup.this.getIdAttributes(this.meta());
                    Object select = "";
                    int i = 0;
                    for (SingularAttribute singularAttribute : idAttributes) {
                        EntityType meta = null;
                        try {
                            meta = SessionBackup.this.iMetamodel.entity(singularAttribute.getJavaType());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        select = meta == null ? (String)select + (i > 0 ? ", " : "") + this.hqlName() + "." + singularAttribute.getName() : (String)select + (i > 0 ? ", " : "") + this.hqlName() + "." + singularAttribute.getName() + "." + SessionBackup.this.getIdAttribute(meta).getName();
                        ++i;
                    }
                    for (Object[] objectArray : SessionBackup.this.iHibSession.createQuery("select distinct " + (String)select + " from " + this.hqlFrom() + " where " + this.hqlWhere(), Object[].class).setParameter("sessionId", (Object)SessionBackup.this.iSessionId).list()) {
                        if (!ids.add(new CompositeId(objectArray))) continue;
                        ++this.size;
                    }
                } else {
                    for (Serializable id : SessionBackup.this.iHibSession.createQuery("select distinct " + this.hqlName() + "." + SessionBackup.this.getIdAttribute(this.meta()).getName() + " from " + this.hqlFrom() + " where " + this.hqlWhere(), Serializable.class).setParameter("sessionId", (Object)SessionBackup.this.iSessionId).list()) {
                        if (!ids.add(id)) continue;
                        ++this.size;
                    }
                }
            }
            return this.size;
        }

        boolean hasBlob() {
            for (Attribute attribute : this.meta().getAttributes()) {
                if (!attribute.getJavaType().equals(byte[].class)) continue;
                return true;
            }
            return false;
        }

        boolean distinct() {
            if (this.hasBlob()) {
                return true;
            }
            switch (this.relation()) {
                case Many: {
                    return false;
                }
                case One: {
                    return this.parent().distinct();
                }
            }
            return true;
        }

        List<Object> list() {
            if (this.relation() == Relation.Empty) {
                return null;
            }
            if (AssignmentInfo.class.getName().equals(this.name())) {
                return null;
            }
            if (ConstraintInfo.class.getName().equals(this.name())) {
                return null;
            }
            if (ChangeLog.class.getName().equals(this.name())) {
                return null;
            }
            return SessionBackup.this.iHibSession.createQuery("select " + (this.distinct() ? "" : "distinct ") + this.hqlName() + " from " + this.hqlFrom() + " where " + this.hqlWhere(), Object.class).setParameter("sessionId", (Object)SessionBackup.this.iSessionId).list();
        }

        List<Object> relation(String property, EntityType m, Serializable id, boolean data) {
            Map<Serializable, List<Object>> relation = this.iRelationCache.get(property);
            if (relation == null) {
                Object idProperty = null;
                boolean join = false;
                Attribute attribute = null;
                try {
                    attribute = this.meta().getAttribute(property);
                }
                catch (IllegalArgumentException e) {
                    attribute = m.getAttribute(property);
                    join = true;
                }
                catch (UnknownEntityTypeException e) {
                    attribute = m.getAttribute(property);
                    join = true;
                }
                int composite = 0;
                if (!data) {
                    EntityType meta = null;
                    try {
                        meta = attribute.isCollection() ? (EntityType)((PluralAttribute)attribute).getElementType() : (EntityType)((SingularAttribute)attribute).getType();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (meta == null) {
                        data = true;
                    } else if (SessionBackup.this.hasCompositeId(meta)) {
                        idProperty = "";
                        for (SingularAttribute idatt : SessionBackup.this.getIdAttributes(meta)) {
                            EntityType idmeta = null;
                            try {
                                idmeta = SessionBackup.this.iMetamodel.entity(idatt.getJavaType());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                            idProperty = idmeta == null ? (String)idProperty + (composite > 0 ? ", p." : "") + idatt.getName() : (String)idProperty + (composite > 0 ? ", p." : "") + idatt.getName() + "." + SessionBackup.this.getIdAttribute(idmeta).getName();
                            ++composite;
                        }
                    } else {
                        idProperty = SessionBackup.this.getIdAttribute(meta).getName();
                        if (this.name().equals(LastLikeCourseDemand.class.getName()) && "student".equals(property)) {
                            idProperty = "externalUniqueId";
                        }
                    }
                }
                relation = new HashMap<Serializable, List<Object>>();
                if (SessionBackup.this.hasCompositeId(this.meta())) {
                    List<SingularAttribute> idatts = SessionBackup.this.getIdAttributes(this.meta());
                    Object select = "";
                    for (int i = 0; i < idatts.size(); ++i) {
                        EntityType meta = null;
                        try {
                            meta = SessionBackup.this.iMetamodel.entity(idatts.get(i).getJavaType());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                        select = meta == null ? (String)select + (i > 0 ? ", " : "") + this.hqlName() + "." + idatts.get(i).getName() : (String)select + (i > 0 ? ", " : "") + this.hqlName() + "." + idatts.get(i).getName() + "." + SessionBackup.this.getIdAttribute(meta).getName();
                    }
                    String q = "select distinct " + (String)select + (String)(data ? ", p" : ", p." + (String)idProperty) + " from " + this.hqlFrom() + " inner join " + this.hqlName() + "." + property + " p where " + this.hqlWhere();
                    if (join) {
                        q = "select distinct " + (String)select + (String)(data ? ", p" : ", p." + (String)idProperty) + " from " + this.hqlFrom() + ", " + m.getName() + " x inner join x." + property + " p where " + this.hqlWhere();
                        for (int i = 0; i < idatts.size(); ++i) {
                            EntityType meta = null;
                            try {
                                meta = SessionBackup.this.iMetamodel.entity(idatts.get(i).getJavaType());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                            q = meta == null ? q + " and " + this.hqlName() + "." + idatts.get(i).getName() + " = x." + idatts.get(i).getName() : q + " and " + this.hqlName() + "." + idatts.get(i).getName() + "." + SessionBackup.this.getIdAttribute(meta).getName() + " = x." + idatts.get(i).getName() + "." + SessionBackup.this.getIdAttribute(meta).getName();
                        }
                    }
                    for (Object[] o : SessionBackup.this.iHibSession.createQuery(q, Object[].class).setParameter("sessionId", (Object)SessionBackup.this.iSessionId).list()) {
                        Object[] cid = new Object[idatts.size()];
                        for (int i = 0; i < idatts.size(); ++i) {
                            cid[i] = o[i];
                        }
                        Object obj = o[idatts.size()];
                        List<Object> list = relation.get(new CompositeId(cid));
                        if (list == null) {
                            list = new ArrayList<Object>();
                            relation.put(new CompositeId(cid), list);
                        }
                        if (composite > 1) {
                            Object[] oid = new Object[composite];
                            for (int i = 0; i < composite; ++i) {
                                oid[i] = o[idatts.size() + i];
                            }
                            list.add(new CompositeId(oid));
                            continue;
                        }
                        list.add(obj);
                    }
                } else {
                    SingularAttribute idattr = SessionBackup.this.getIdAttribute(this.meta());
                    String q = "select distinct " + this.hqlName() + "." + idattr.getName() + (String)(data ? ", p" : ", p." + (String)idProperty) + " from " + this.hqlFrom() + " inner join " + this.hqlName() + "." + property + " p where " + this.hqlWhere();
                    if (join) {
                        q = "select distinct " + this.hqlName() + "." + idattr.getName() + (String)(data ? ", p" : ", p." + (String)idProperty) + " from " + this.hqlFrom() + ", " + m.getName() + " x inner join x." + property + " p where " + this.hqlWhere() + " and " + this.hqlName() + "." + idattr.getName() + " = x." + idattr.getName();
                    }
                    for (Object[] o : SessionBackup.this.iHibSession.createQuery(q, Object[].class).setParameter("sessionId", (Object)SessionBackup.this.iSessionId).list()) {
                        List<Object> list = relation.get((Serializable)o[0]);
                        if (list == null) {
                            list = new ArrayList<Object>();
                            relation.put((Serializable)o[0], list);
                        }
                        if (composite > 1) {
                            Object[] oid = new Object[composite];
                            for (int i = 0; i < composite; ++i) {
                                oid[i] = o[1 + i];
                            }
                            list.add(new CompositeId(oid));
                            continue;
                        }
                        list.add(o[1]);
                    }
                }
                this.iRelationCache.put(property, relation);
            }
            return relation.get(id);
        }

        private void clearCache() {
            this.iRelationCache.clear();
        }
    }

    static enum Relation {
        None,
        Parent,
        One,
        Many,
        Empty;

    }

    public static class CompositeId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Serializable[] iId;

        public CompositeId(Object ... id) {
            this.iId = new Serializable[id.length];
            for (int i = 0; i < this.iId.length; ++i) {
                this.iId[i] = (Serializable)id[i];
            }
        }

        public int hashCode() {
            int hashCode = this.iId[0] == null ? 0 : this.iId[0].hashCode();
            for (int i = 1; i < this.iId.length; ++i) {
                if (this.iId[i] == null) continue;
                hashCode ^= this.iId[i].hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CompositeId)) {
                return false;
            }
            CompositeId id = (CompositeId)o;
            if (id.iId.length != this.iId.length) {
                return false;
            }
            for (int i = 0; i < this.iId.length; ++i) {
                if (ToolBox.equals((Object)this.iId[i], (Object)id.iId[i])) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            Object ret = "";
            for (int i = 0; i < this.iId.length; ++i) {
                ret = (String)ret + (i > 0 ? "|" : "") + (this.iId[i] == null ? "" : this.iId[i].toString());
            }
            return ret;
        }
    }
}

