/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api.connectors;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.unitime.timetable.api.ApiConnector;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.ExamStatus;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.context.UniTimeUserContext;
import org.unitime.timetable.security.rights.Right;

@Service(value="/api/roles")
public class RolesConnector
extends ApiConnector {
    @Override
    public void doGet(ApiHelper helper) throws IOException {
        helper.getSessionContext().checkPermissionAnyAuthority(Right.ApiRetrieveRoles, new Qualifiable[0]);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        List sessions = helper.getHibSession().createQuery("from Session order by academicInitiative, sessionBeginDateTime", Session.class).list();
        ArrayList<SessionInfo> response = new ArrayList<SessionInfo>();
        String externalId = helper.getParameter("id");
        if (externalId == null || externalId.isEmpty()) {
            for (Session session : sessions) {
                if (session.getStatusType() == null || session.getStatusType().isTestSession()) continue;
                response.add(new SessionInfo(format, session, null, null));
            }
        } else {
            if (ApplicationProperty.ApiTrimLeadingZerosFromUserExternalIds.isTrue()) {
                while (externalId.startsWith("0")) {
                    externalId = externalId.substring(1);
                }
            }
            UniTimeUserContext context = new UniTimeUserContext(externalId, null, null, null);
            for (Session session : sessions) {
                if (session.getStatusType() == null || session.getStatusType().isTestSession()) continue;
                ArrayList<String> roles = new ArrayList<String>();
                for (UserAuthority userAuthority : context.getAuthorities(null, session)) {
                    if ("No Role".equals(userAuthority.getRole()) || "Anonymous".equals(userAuthority.getRole())) continue;
                    roles.add(userAuthority.getRole());
                }
                if (roles.isEmpty()) continue;
                response.add(new SessionInfo(format, session, roles, session.getUniqueId().equals(context.getCurrentAcademicSessionId())));
            }
        }
        helper.setResponse(response);
    }

    @Override
    protected String getName() {
        return "roles";
    }

    class SessionInfo {
        Long iSessionId;
        String iReference;
        Boolean iSelected;
        String iYear;
        String iTerm;
        String iCampus;
        String iExternalTerm;
        String iExternalCampus;
        String iBeginDate;
        String iEndDate;
        String iClassEndDate;
        String iExamBeginDate;
        String iEventBeginDate;
        String iEventEndDate;
        StatusInfo iStatus;
        List<String> iRoles;

        SessionInfo(DateFormat format, Session session, List<String> roles, Boolean selected) {
            this.iSessionId = session.getUniqueId();
            this.iReference = session.getReference();
            this.iYear = session.getAcademicYear();
            this.iTerm = session.getAcademicTerm();
            this.iCampus = session.getAcademicInitiative();
            this.iBeginDate = format.format(session.getSessionBeginDateTime());
            this.iEndDate = format.format(session.getSessionEndDateTime());
            this.iClassEndDate = format.format(session.getClassesEndDateTime());
            this.iExamBeginDate = format.format(session.getExamBeginDate());
            this.iEventBeginDate = format.format(session.getEventBeginDate());
            this.iEventEndDate = format.format(session.getEventEndDate());
            if (session.getStatusType() != null) {
                this.iStatus = new StatusInfo(session);
            }
            this.iRoles = roles;
            this.iSelected = selected;
        }
    }

    class StatusInfo {
        String iRefenrece;
        String iLabel;
        Boolean iClasses;
        List<String> iExams;
        String iStudentScheduling;

        StatusInfo(Session session) {
            DepartmentStatusType status = session.getStatusType();
            if (status != null) {
                this.iRefenrece = status.getReference();
                this.iLabel = status.getLabel();
                this.iClasses = status.canNoRoleReportClass();
                this.iExams = new ArrayList<String>();
                for (ExamType type : ExamType.findAllUsed(session.getUniqueId())) {
                    ExamStatus examStatus = ExamStatus.findStatus(session.getUniqueId(), type.getUniqueId());
                    if (examStatus != null) {
                        if (type.getType() == 0 && examStatus.effectiveStatus().canNoRoleReportExamFinal()) {
                            this.iExams.add(type.getReference());
                        }
                        if (type.getType() != 1 || !examStatus.effectiveStatus().canNoRoleReportExamMidterm()) continue;
                        this.iExams.add(type.getReference());
                        continue;
                    }
                    if (type.getType() == 0 && status.canNoRoleReportExamFinal()) {
                        this.iExams.add(type.getReference());
                    }
                    if (type.getType() != 1 || !status.canNoRoleReportExamMidterm()) continue;
                    this.iExams.add(type.getReference());
                }
                if (status.canOnlineSectionStudents()) {
                    this.iStudentScheduling = "online";
                } else if (status.canSectionAssistStudents()) {
                    this.iStudentScheduling = "assistant";
                } else if (status.canPreRegisterStudents()) {
                    this.iStudentScheduling = "registration";
                }
            }
        }
    }
}

