/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Transaction;
import org.springframework.web.util.HtmlUtils;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.SolverGroupEditForm;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.webutil.PdfWebTable;

@Action(value="solverGroupEdit", results={@Result(name={"list"}, type="tiles", location="solverGroups.tiles"), @Result(name={"add"}, type="tiles", location="solverGroupAdd.tiles"), @Result(name={"edit"}, type="tiles", location="solverGroupEdit.tiles")})
@TilesDefinitions(value={@TilesDefinition(name="solverGroups.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Solver Groups"), @TilesPutAttribute(name="body", value="/admin/solverGroups.jsp")}), @TilesDefinition(name="solverGroupAdd.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Add Solver Group"), @TilesPutAttribute(name="body", value="/admin/solverGroups.jsp")}), @TilesDefinition(name="solverGroupEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Solver Group"), @TilesPutAttribute(name="body", value="/admin/solverGroups.jsp")})})
public class SolverGroupEditAction
extends UniTimeAction<SolverGroupEditForm> {
    private static final long serialVersionUID = -5571247262159758529L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private static Formats.Format<Date> sDF = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
    private Long id;
    private String nameFormat = null;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String execute() throws Exception {
        org.hibernate.Session hibSession;
        Transaction tx;
        if (this.form == null) {
            this.form = new SolverGroupEditForm();
        }
        this.sessionContext.checkPermission(Right.SolverGroups);
        if (this.op == null) {
            this.op = ((SolverGroupEditForm)this.form).getOp();
        }
        if (this.op == null || MSG.actionBackToSolverGroups().equals(this.op)) {
            ((SolverGroupEditForm)this.form).setOp("List");
            if (((SolverGroupEditForm)this.form).getUniqueId() != null) {
                this.request.setAttribute("hash", (Object)((SolverGroupEditForm)this.form).getUniqueId());
            }
        }
        Session session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
        if (MSG.actionUpdateSolverGroup().equals(this.op) || MSG.actionSaveSolverGroup().equals(this.op)) {
            ((SolverGroupEditForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                tx = null;
                try {
                    hibSession = SolverGroupDAO.getInstance().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    ((SolverGroupEditForm)this.form).saveOrUpdate(hibSession, this.sessionContext);
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                ((SolverGroupEditForm)this.form).setOp("List");
                if (((SolverGroupEditForm)this.form).getUniqueId() != null) {
                    this.request.setAttribute("hash", (Object)((SolverGroupEditForm)this.form).getUniqueId());
                }
            }
        }
        if ("Edit".equals(this.op)) {
            if (this.id == null) {
                this.addFieldError("form.uniqueId", MSG.errorRequiredField(MSG.fieldId()));
                return "edit";
            }
            SolverGroup group = (SolverGroup)SolverGroupDAO.getInstance().get(this.id);
            if (group == null) {
                this.addFieldError("form.uniqueId", MSG.errorDoesNotExists(this.id.toString()));
                return "edit";
            }
            ((SolverGroupEditForm)this.form).load(group, session, this.getNameFormat());
        }
        if (MSG.actionDeleteSolverGroup().equals(this.op)) {
            tx = null;
            try {
                hibSession = SolverGroupDAO.getInstance().getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                ((SolverGroupEditForm)this.form).delete(hibSession, this.sessionContext);
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            ((SolverGroupEditForm)this.form).setOp("List");
        }
        if (MSG.actionAddSolverGroup().equals(this.op)) {
            ((SolverGroupEditForm)this.form).load(null, session, this.getNameFormat());
        }
        if (MSG.actionDeleteAllSolverGroups().equals(this.op)) {
            tx = null;
            try {
                hibSession = SolverGroupDAO.getInstance().getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                for (SolverGroup group : SolverGroup.findBySessionId(session.getUniqueId())) {
                    if (!group.getSolutions().isEmpty()) continue;
                    for (Department dept : group.getDepartments()) {
                        dept.setSolverGroup(null);
                        hibSession.merge((Object)dept);
                    }
                    for (TimetableManager mgr : group.getTimetableManagers()) {
                        mgr.getSolverGroups().remove(group);
                        hibSession.merge((Object)mgr);
                    }
                    hibSession.remove((Object)group);
                }
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            ((SolverGroupEditForm)this.form).setOp("List");
        }
        if (MSG.actionAutoSetupSolverGroups().equals(this.op)) {
            tx = null;
            try {
                hibSession = SolverGroupDAO.getInstance().getSession();
                if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                    tx = hibSession.beginTransaction();
                }
                TreeSet<Department> allDepts = new TreeSet<Department>(new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Department d1 = (Department)o1;
                        Department d2 = (Department)o2;
                        int cmp = -Double.compare(d1.getTimetableManagers().size(), d2.getTimetableManagers().size());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return d1.getUniqueId().compareTo(d2.getUniqueId());
                    }
                });
                allDepts.addAll(session.getDepartments());
                for (Department d : allDepts) {
                    if (d.getSolverGroup() != null) continue;
                    if (d.isExternalManager().booleanValue()) {
                        SolverGroup sg = new SolverGroup();
                        sg.setAbbv(d.getExternalMgrAbbv());
                        sg.setName(d.getDeptCode() + " - " + d.getExternalMgrLabel().replaceAll(" Manager", ""));
                        sg.setSession(session);
                        sg.setTimetableManagers(new HashSet<TimetableManager>());
                        hibSession.persist((Object)sg);
                        d.setSolverGroup(sg);
                        hibSession.merge((Object)d);
                        for (TimetableManager mgr : d.getTimetableManagers()) {
                            mgr.getSolverGroups().add(sg);
                            sg.getTimetableManagers().add(mgr);
                            hibSession.merge((Object)mgr);
                        }
                        continue;
                    }
                    if (d.getSubjectAreas().isEmpty() || d.getTimetableManagers().isEmpty()) continue;
                    HashSet depts = null;
                    for (TimetableManager mgr : d.getTimetableManagers()) {
                        Set myDepts = mgr.departmentsForSession(session.getUniqueId());
                        if (depts == null) {
                            depts = new HashSet(myDepts);
                            continue;
                        }
                        depts.retainAll(myDepts);
                    }
                    Iterator<TimetableManager> j = depts.iterator();
                    while (j.hasNext()) {
                        Department x = (Department)((Object)j.next());
                        if (x.getSolverGroup() == null && !x.getSubjectAreas().isEmpty()) continue;
                        j.remove();
                    }
                    if (depts.isEmpty()) continue;
                    StringBuffer abbv = new StringBuffer();
                    StringBuffer name = new StringBuffer();
                    HashSet<TimetableManager> mgrs = new HashSet<TimetableManager>();
                    for (Department x : depts) {
                        mgrs.addAll(x.getTimetableManagers());
                        abbv.append(x.getShortLabel().trim());
                        if (name.length() > 0) {
                            name.append(", ");
                        }
                        name.append(x.getLabel());
                    }
                    SolverGroup sg = new SolverGroup();
                    sg.setAbbv((String)(abbv.length() <= 50 ? abbv.toString() : abbv.toString().substring(0, 47) + "..."));
                    sg.setName((String)(name.length() <= 50 ? name.toString() : name.toString().substring(0, 47) + "..."));
                    sg.setTimetableManagers(new HashSet<TimetableManager>());
                    sg.setSession(session);
                    hibSession.persist((Object)sg);
                    for (Department x : depts) {
                        x.setSolverGroup(sg);
                        hibSession.merge((Object)x);
                    }
                    for (TimetableManager mgr : mgrs) {
                        mgr.getSolverGroups().add(sg);
                        sg.getTimetableManagers().add(mgr);
                        hibSession.merge((Object)mgr);
                    }
                }
                if (tx != null) {
                    tx.commit();
                }
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            ((SolverGroupEditForm)this.form).setOp("List");
        }
        if (MSG.actionExportPdf().equals(this.op)) {
            ExportUtils.exportPDF(this.getSolverGroups(session, false), WebTable.getOrder(this.sessionContext, "solverGroups.ord"), this.response, "solverGroups");
            return null;
        }
        if (MSG.actionExportCsv().equals(this.op)) {
            ExportUtils.exportCSV(this.getSolverGroups(session, false), WebTable.getOrder(this.sessionContext, "solverGroups.ord"), this.response, "solverGroups");
            return null;
        }
        if ("List".equals(((SolverGroupEditForm)this.form).getOp())) {
            PdfWebTable table = this.getSolverGroups(session, true);
            this.request.setAttribute("table", (Object)table.printTable(WebTable.getOrder(this.sessionContext, "solverGroups.ord")));
            return "list";
        }
        return ((SolverGroupEditForm)this.form).getUniqueId() == null || ((SolverGroupEditForm)this.form).getUniqueId() < 0L ? "add" : "edit";
    }

    private PdfWebTable getSolverGroups(Session session, boolean html) throws Exception {
        WebTable.setOrder(this.sessionContext, "solverGroups.ord", this.request.getParameter("ord"), 1);
        PdfWebTable webTable = new PdfWebTable(5, html ? null : MSG.sectSolverGroupsForSession(session.getLabel()), "solverGroupEdit.action?ord=%%", new String[]{MSG.fieldAbbv(), MSG.fieldName(), MSG.fieldDepartments(), MSG.fieldManagers(), MSG.fieldCommitted()}, new String[]{"left", "left", "left", "left", "left"}, null);
        Set<SolverGroup> solverGroups = SolverGroup.findBySessionId(session.getUniqueId());
        if (solverGroups.isEmpty()) {
            webTable.addLine(null, new String[]{MSG.infoNoSolverGroupInThisSession()}, null, null);
        }
        org.hibernate.Session hibSession = SolverGroupDAO.getInstance().getSession();
        for (SolverGroup group : solverGroups) {
            if (group.getDepartments() == null || group.getTimetableManagers() == null) {
                hibSession.refresh((Object)group);
            }
            String onClick = "onClick=\"document.location='solverGroupEdit.action?op=Edit&id=" + group.getUniqueId() + "';\"";
            Object deptStr = "";
            Object deptCmp = "";
            Iterator<Department> j = new TreeSet<Department>(group.getDepartments()).iterator();
            while (j.hasNext()) {
                Department d = j.next();
                deptStr = (String)deptStr + (String)(html ? "<span title='" + HtmlUtils.htmlEscape((String)d.getLabel()) + "'>" + d.getDeptCode() + "</span>" : d.getDeptCode());
                deptCmp = (String)deptCmp + d.getDeptCode();
                if (!j.hasNext()) continue;
                deptStr = (String)deptStr + ", ";
                deptCmp = (String)deptCmp + ",";
            }
            Object mgrStr = "";
            Object mgrCmp = "";
            ArrayList<TimetableManager> managers = new ArrayList<TimetableManager>(group.getTimetableManagers());
            Collections.sort(managers, new Comparator<TimetableManager>(){

                @Override
                public int compare(TimetableManager m1, TimetableManager m2) {
                    int cmp = m1.getName(SolverGroupEditAction.this.nameFormat).compareToIgnoreCase(m2.getName(SolverGroupEditAction.this.nameFormat));
                    if (cmp != 0) {
                        return cmp;
                    }
                    return m1.compareTo(m2);
                }
            });
            Iterator j2 = managers.iterator();
            while (j2.hasNext()) {
                TimetableManager mgr = (TimetableManager)j2.next();
                String name = mgr.getName(this.getNameFormat());
                Object depts = "";
                for (Department d : new TreeSet(mgr.departmentsForSession(session.getUniqueId()))) {
                    depts = (String)depts + (((String)depts).isEmpty() ? "" : ", ") + d.getDeptCode();
                }
                mgrStr = (String)mgrStr + (String)(html ? "<span title=\"" + HtmlUtils.htmlEscape((String)(name + (String)(((String)depts).isEmpty() ? "" : " (" + (String)depts + ")"))) + "\">" + name + "</span>" : name);
                mgrCmp = (String)mgrCmp + name;
                if (!j2.hasNext()) continue;
                mgrStr = (String)mgrStr + ", ";
                mgrCmp = (String)mgrCmp + ",";
            }
            Date commitDate = null;
            if (group.getCommittedSolution() != null) {
                commitDate = group.getCommittedSolution().getCommitDate();
            }
            webTable.addLine(onClick, new String[]{html ? "<a name='" + group.getUniqueId() + "'>" + (html ? group.getAbbv().replaceAll(" ", "&nbsp;") : group.getAbbv()) + "</a>" : group.getAbbv(), html ? group.getName().replaceAll(" ", "&nbsp;") : group.getName(), deptStr, mgrStr, commitDate == null ? "" : sDF.format(commitDate)}, new Comparable[]{group.getAbbv(), group.getName(), deptCmp, mgrCmp, Long.valueOf(commitDate == null ? -1L : commitDate.getTime())});
        }
        return webTable;
    }

    public String getNameFormat() {
        if (this.nameFormat == null) {
            this.nameFormat = UserProperty.NameFormat.get(this.sessionContext.getUser());
        }
        return this.nameFormat;
    }

    public String getTitle() {
        return MSG.sectSolverGroupsForSession(this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Session").get(0).getQualifierLabel());
    }
}

