/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.LastChangesForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.webutil.PdfWebTable;

@Action(value="lastChanges", results={@Result(name={"list"}, type="tiles", location="lastChanges.tiles")})
@TilesDefinition(name="lastChanges.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Last Changes"), @TilesPutAttribute(name="body", value="/admin/lastChanges.jsp"), @TilesPutAttribute(name="showNavigation", value="false")})
public class LastChangesAction
extends UniTimeAction<LastChangesForm> {
    private static final long serialVersionUID = -5679046942523976307L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    public String execute() throws Exception {
        String op;
        if (this.getForm() == null) {
            this.setForm(new LastChangesForm());
        }
        this.sessionContext.checkPermission(Right.LastChanges);
        String string = op = ((LastChangesForm)this.getForm()).getOp() != null ? ((LastChangesForm)this.getForm()).getOp() : this.request.getParameter("op");
        if ("Apply".equals(op) || MSG.buttonApply().equals(op) || "Export PDF".equals(op) || MSG.buttonExportPDF().equals(op)) {
            ((LastChangesForm)this.getForm()).save(this.request);
        } else {
            ((LastChangesForm)this.getForm()).load(this.request);
        }
        Long sessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
        ArrayList<Department> departments = new ArrayList<Department>();
        Department d = new Department();
        d.setUniqueId(-1L);
        d.setDeptCode(MSG.itemAllDepartments());
        d.setName(MSG.itemAllDepartments());
        d.setExternalManager(Boolean.FALSE);
        departments.add(d);
        departments.addAll(Department.findAll(sessionId));
        this.request.setAttribute("departments", departments);
        ArrayList<SubjectArea> subjects = new ArrayList<SubjectArea>();
        SubjectArea sa = new SubjectArea();
        sa.setUniqueId(-1L);
        sa.setSubjectAreaAbbreviation(MSG.itemAllSubjects());
        subjects.add(sa);
        subjects.addAll(new TreeSet<SubjectArea>(SubjectArea.getSubjectAreaList(sessionId)));
        this.request.setAttribute("subjAreas", subjects);
        ArrayList<TimetableManager> managers = new ArrayList<TimetableManager>();
        TimetableManager tm = new TimetableManager();
        tm.setUniqueId(-1L);
        tm.setLastName(MSG.itemAllManagers());
        managers.add(tm);
        managers.addAll(TimetableManager.getManagerList());
        this.request.setAttribute("managers", managers);
        boolean html = true;
        String nl = html ? "<br>" : "\n";
        WebTable.setOrder(this.sessionContext, "lastChanges.ord2", this.request.getParameter("ord"), 1);
        WebTable webTable = new WebTable(7, MSG.columnLastChanges(), "lastChanges.action?ord=%%", new String[]{MSG.columnDate().replace("|", nl), MSG.columnDepartment().replace("|", nl), MSG.columnSubject().replace("|", nl), MSG.columnManager().replace("|", nl), MSG.columnPage().replace("|", nl), MSG.columnObject().replace("|", nl), MSG.columnOperation().replace("|", nl)}, new String[]{"left", "left", "left", "left", "left", "left", "left"}, new boolean[]{false, true, true, true, true, true, true});
        List<ChangeLog> changes = ChangeLog.findLastNChanges(sessionId, ((LastChangesForm)this.getForm()).getManagerId() == null || ((LastChangesForm)this.getForm()).getManagerId() < 0L ? null : ((LastChangesForm)this.getForm()).getManagerId(), ((LastChangesForm)this.getForm()).getSubjAreaId() == null || ((LastChangesForm)this.getForm()).getSubjAreaId() < 0L ? null : ((LastChangesForm)this.getForm()).getSubjAreaId(), ((LastChangesForm)this.getForm()).getDepartmentId() == null || ((LastChangesForm)this.getForm()).getDepartmentId() < 0L ? null : ((LastChangesForm)this.getForm()).getDepartmentId(), ((LastChangesForm)this.getForm()).getN());
        if (changes != null) {
            Iterator<ChangeLog> i = changes.iterator();
            while (i.hasNext()) {
                this.printLastChangeTableRow(webTable, i.next(), true);
            }
        }
        this.request.setAttribute("table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "lastChanges.ord2")));
        if (("Export PDF".equals(op) || MSG.buttonExportPDF().equals(op)) && changes != null) {
            html = false;
            nl = html ? "<br>" : "\n";
            PdfWebTable pdfTable = new PdfWebTable(7, "Last Changes", "lastChanges.do?ord=%%", new String[]{MSG.columnDate().replace("|", nl), MSG.columnDepartment().replace("|", nl), MSG.columnSubject().replace("|", nl), MSG.columnManager().replace("|", nl), MSG.columnPage().replace("|", nl), MSG.columnObject().replace("|", nl), MSG.columnOperation().replace("|", nl)}, new String[]{"left", "left", "left", "left", "left", "left", "left"}, new boolean[]{false, true, true, true, true, true, true});
            Iterator<ChangeLog> i = changes.iterator();
            while (i.hasNext()) {
                this.printLastChangeTableRow(pdfTable, i.next(), false);
            }
            ExportUtils.exportPDF(pdfTable, WebTable.getOrder(this.sessionContext, "lastChanges.ord2"), this.response, "lastChanges");
            return null;
        }
        return "list";
    }

    private int printLastChangeTableRow(WebTable webTable, ChangeLog lastChange, boolean html) {
        if (lastChange == null) {
            return 0;
        }
        webTable.addLine(null, new String[]{ChangeLog.sDF.format(lastChange.getTimeStamp()), lastChange.getDepartment() == null ? "" : (html ? "<span title='" + lastChange.getDepartment().getHtmlTitle() + "'>" + lastChange.getDepartment().getShortLabel() + "</span>" : lastChange.getDepartment().getShortLabel()), lastChange.getSubjectArea() == null ? "" : lastChange.getSubjectArea().getSubjectAreaAbbreviation(), html ? lastChange.getManager().getShortName() : lastChange.getManager().getShortName().replaceAll("&nbsp;", " "), lastChange.getSourceTitle(), lastChange.getObjectTitle(), lastChange.getOperationTitle()}, new Comparable[]{Long.valueOf(lastChange.getTimeStamp().getTime()), lastChange.getDepartment() == null ? "" : lastChange.getDepartment().getDeptCode(), lastChange.getSubjectArea() == null ? "" : lastChange.getSubjectArea().getSubjectAreaAbbreviation(), lastChange.getManager().getName(), lastChange.getSourceTitle(), lastChange.getObjectTitle(), Integer.valueOf(lastChange.getOperation().ordinal())});
        return 1;
    }
}

