/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.InstructorListUpdateForm;
import org.unitime.timetable.interfaces.ExternalClassEditAction;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Staff;
import org.unitime.timetable.model.comparators.DepartmentalInstructorComparator;
import org.unitime.timetable.model.comparators.StaffComparator;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LookupTables;

@Action(value="instructorListUpdate", results={@Result(name={"showUpdateInstructorList"}, type="tiles", location="instructorListUpdate.tiles"), @Result(name={"showList"}, type="redirect", location="/instructorSearch.action")})
@TilesDefinition(name="instructorListUpdate.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Manage Instructor List"), @TilesPutAttribute(name="body", value="/user/instructorListUpdate.jsp")})
public class InstructorListUpdateAction
extends UniTimeAction<InstructorListUpdateForm> {
    private static final long serialVersionUID = 241708052808479802L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    public String execute() throws Exception {
        Collection available;
        Collection assigned;
        this.sessionContext.checkPermission(Right.ManageInstructors);
        if (this.form == null) {
            this.form = new InstructorListUpdateForm();
        }
        this.fillInDepartmentName();
        if (this.op == null) {
            this.op = ((InstructorListUpdateForm)this.form).getOp();
        }
        if (MSG.actionBackToInstructors().equals(this.op)) {
            return "showList";
        }
        if (MSG.actionUpdateInstructorsList().equals(this.op)) {
            this.update();
            return "showList";
        }
        if (MSG.actionApplyInstructorFilter().equals(this.op)) {
            this.request.setAttribute("filterApplied", (Object)"1");
        }
        if ((assigned = this.getAssigned()) != null) {
            ((InstructorListUpdateForm)this.form).setAssignedInstr(assigned);
        }
        if ((available = this.getAvailable()) != null) {
            ((InstructorListUpdateForm)this.form).setAvailableInstr(available);
        }
        LookupTables.setupPositionTypes(this.request);
        this.setupFilters();
        ((InstructorListUpdateForm)this.form).setInstructors();
        ((InstructorListUpdateForm)this.form).setNameFormat(this.sessionContext.getUser().getProperty(UserProperty.NameFormat));
        return "showUpdateInstructorList";
    }

    private void setupFilters() {
        String[] defaultPosTypes = new String[]{"ADMIN_STAFF", "CLERICAL_STAFF", "SERVICE_STAFF", "FELLOWSHIP", "UNDRGRD_TEACH_ASST", "EMERITUS OTHER"};
        boolean filterSet = "1".equals(this.sessionContext.getUser().getProperty("instrListFilter", "0"));
        String filterApplied = (String)this.request.getAttribute("filterApplied");
        if (filterApplied != null && !filterApplied.equals("1")) {
            filterApplied = null;
        }
        if (!filterSet) {
            ((InstructorListUpdateForm)this.form).setDisplayListType("both");
            ((InstructorListUpdateForm)this.form).setDisplayPosType(defaultPosTypes);
        } else if (filterApplied == null) {
            ((InstructorListUpdateForm)this.form).setDisplayListType(this.sessionContext.getUser().getProperty("displayListType"));
            String displayPosType = this.sessionContext.getUser().getProperty("displayPosType");
            if (displayPosType != null) {
                String[] arr = null;
                if (displayPosType.trim().length() == 0) {
                    arr = new String[]{"X"};
                } else {
                    StringTokenizer strTok = new StringTokenizer(displayPosType);
                    arr = new String[strTok.countTokens()];
                    int ct = 0;
                    while (strTok.hasMoreTokens()) {
                        arr[ct++] = strTok.nextToken();
                    }
                }
                ((InstructorListUpdateForm)this.form).setDisplayPosType(arr);
            }
        }
        if (((InstructorListUpdateForm)this.form).getDisplayListType() == null || ((InstructorListUpdateForm)this.form).getDisplayListType().length() == 0) {
            ((InstructorListUpdateForm)this.form).setDisplayListType("both");
        }
        if (((InstructorListUpdateForm)this.form).getDisplayPosType() == null) {
            if (filterApplied != null) {
                ((InstructorListUpdateForm)this.form).setDisplayPosType(new String[]{"X"});
            } else {
                ((InstructorListUpdateForm)this.form).setDisplayPosType(defaultPosTypes);
            }
        }
        this.sessionContext.getUser().setProperty("instrListFilter", "1");
        this.sessionContext.getUser().setProperty("displayListType", ((InstructorListUpdateForm)this.form).getDisplayListType());
        this.sessionContext.getUser().setProperty("displayPosType", Constants.arrayToStr(((InstructorListUpdateForm)this.form).getDisplayPosType(), "", " "));
    }

    private void update() throws Exception {
        String[] selectedAssigned = ((InstructorListUpdateForm)this.form).getAssignedSelected();
        String[] selectedNotAssigned = ((InstructorListUpdateForm)this.form).getAvailableSelected();
        Collection assigned = this.getAssigned();
        Collection available = this.getAvailable();
        HashSet<String> s1 = new HashSet<String>();
        HashSet<String> s2 = new HashSet<String>();
        if (selectedAssigned.length != 0) {
            for (String id : selectedAssigned) {
                s1.add(id);
            }
        }
        if (selectedNotAssigned.length != 0) {
            for (String id : selectedNotAssigned) {
                s2.add(id);
            }
        }
        DepartmentalInstructorDAO idao = DepartmentalInstructorDAO.getInstance();
        Session hibSession = idao.getSession();
        Transaction tx = null;
        HashSet<Class_> updatedClasses = new HashSet<Class_>();
        try {
            tx = hibSession.beginTransaction();
            if (((InstructorListUpdateForm)this.form).getDisplayListType() != null && (((InstructorListUpdateForm)this.form).getDisplayListType().equals("assigned") || ((InstructorListUpdateForm)this.form).getDisplayListType().equals("both"))) {
                for (DepartmentalInstructor inst : assigned) {
                    if (s1.contains(inst.getUniqueId().toString()) || !inst.getExams().isEmpty() || !inst.getClasses().isEmpty()) continue;
                    ChangeLog.addChange(hibSession, this.sessionContext, inst, ChangeLog.Source.INSTRUCTOR_MANAGE, ChangeLog.Operation.DELETE, null, inst.getDepartment());
                    for (ClassInstructor ci : inst.getClasses()) {
                        updatedClasses.add(ci.getClassInstructing());
                        ci.getClassInstructing().getClassInstructors().remove(ci);
                        hibSession.remove((Object)ci);
                    }
                    for (Assignment a : inst.getAssignments()) {
                        a.getInstructors().remove(inst);
                        hibSession.merge((Object)a);
                    }
                    inst.getDepartment().getInstructors().remove(inst);
                    hibSession.remove((Object)inst);
                }
            }
            if (((InstructorListUpdateForm)this.form).getDisplayListType() != null && (((InstructorListUpdateForm)this.form).getDisplayListType().equals("available") || ((InstructorListUpdateForm)this.form).getDisplayListType().equals("both"))) {
                for (Staff staff : available) {
                    if (!s2.contains(staff.getUniqueId().toString())) continue;
                    DepartmentalInstructor inst = new DepartmentalInstructor();
                    inst.setLastName(staff.getLastName());
                    inst.setEmail(staff.getEmail());
                    String deptId = (String)this.request.getSession().getAttribute(Constants.DEPT_ID_ATTR_NAME);
                    Department d = (Department)DepartmentDAO.getInstance().get(Long.valueOf(deptId));
                    inst.setDepartment(d);
                    d.getInstructors().add(inst);
                    if (staff.getFirstName() != null) {
                        inst.setFirstName(staff.getFirstName());
                    }
                    if (staff.getMiddleName() != null) {
                        inst.setMiddleName(staff.getMiddleName());
                    }
                    if (staff.getAcademicTitle() != null) {
                        inst.setAcademicTitle(staff.getAcademicTitle());
                    }
                    if (staff.getExternalUniqueId() != null) {
                        inst.setExternalUniqueId(staff.getExternalUniqueId());
                    }
                    if (staff.getPositionType() != null) {
                        inst.setPositionType(staff.getPositionType());
                    }
                    inst.setIgnoreToFar(Boolean.FALSE);
                    hibSession.persist((Object)inst);
                    ChangeLog.addChange(hibSession, this.sessionContext, inst, ChangeLog.Source.INSTRUCTOR_MANAGE, ChangeLog.Operation.CREATE, null, inst.getDepartment());
                }
            }
            tx.commit();
            String className = ApplicationProperty.ExternalActionClassEdit.value();
            if (className != null && className.trim().length() > 0) {
                ExternalClassEditAction editAction = (ExternalClassEditAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (Class_ c : updatedClasses) {
                    editAction.performExternalClassEditAction(c, hibSession);
                }
            }
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private Collection getAvailable() throws Exception {
        if (this.request.getSession().getAttribute(Constants.DEPT_ID_ATTR_NAME) != null) {
            String deptId = (String)this.request.getSession().getAttribute(Constants.DEPT_ID_ATTR_NAME);
            Department d = (Department)DepartmentDAO.getInstance().get(Long.valueOf(deptId));
            List<Staff> available = Staff.getStaffByDept(d.getDeptCode().trim(), this.sessionContext.getUser().getCurrentAcademicSessionId());
            Collections.sort(available, new StaffComparator(2));
            return available;
        }
        return null;
    }

    private Collection getAssigned() throws Exception {
        String deptId = (String)this.sessionContext.getAttribute(SessionAttribute.DepartmentId);
        if (deptId != null) {
            List<DepartmentalInstructor> assigned = DepartmentalInstructor.findInstructorsForDepartment(Long.valueOf(deptId));
            if (ApplicationProperty.InstructorsDropdownFollowNameFormatting.isTrue()) {
                Collections.sort(assigned, new DepartmentalInstructorComparator(DepartmentalInstructorComparator.CompareBy.POSITION, UserProperty.NameFormat.get(this.sessionContext.getUser())));
            } else {
                Collections.sort(assigned, new DepartmentalInstructorComparator(DepartmentalInstructorComparator.CompareBy.POSITION));
            }
            return assigned;
        }
        return null;
    }

    private void fillInDepartmentName() {
        String deptId = (String)this.request.getSession().getAttribute(Constants.DEPT_ID_ATTR_NAME);
        if (deptId != null) {
            try {
                Department d = (Department)DepartmentDAO.getInstance().get(Long.valueOf(deptId));
                if (d != null) {
                    ((InstructorListUpdateForm)this.form).setDeptName(d.getName().trim());
                }
            }
            catch (Exception e) {
                Debug.error(e);
            }
        }
    }
}

