/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Session;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.PreferencesAction2;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.InstructorEditForm;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.interfaces.ExternalUidLookup;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorSurvey;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.ClassInstructorComparator;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DefaultRoomAvailabilityService;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.IdValue;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.Navigation;

@Action(value="instructorDetail", results={@Result(name={"showInstructorDetail"}, type="tiles", location="instructorDetail.tiles"), @Result(name={"backToInstructors"}, type="redirect", location="/instructorSearch.action")})
@TilesDefinition(name="instructorDetail.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Instructor Detail"), @TilesPutAttribute(name="body", value="/user/instructorDetail.jsp"), @TilesPutAttribute(name="showNavigation", value="true"), @TilesPutAttribute(name="showSolverWarnings", value="assignment"), @TilesPutAttribute(name="checkRole", value="false")})
public class InstructorDetailAction
extends PreferencesAction2<InstructorEditForm> {
    private static final long serialVersionUID = -7822668104506918852L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected static final GwtConstants CONST = Localization.create(GwtConstants.class);
    protected String instructorId = null;
    protected String op2 = null;

    public String getInstructorId() {
        return this.instructorId;
    }

    public void setInstructorId(String instructorId) {
        this.instructorId = instructorId;
    }

    public String getOp2() {
        return this.op2;
    }

    public void setOp2(String op2) {
        this.op2 = op2;
    }

    @Override
    public String execute() throws Exception {
        List<DepartmentalInstructor> instructors;
        if (ApplicationProperty.LegacyInstructors.isFalse()) {
            Object url = "instructor";
            boolean first = true;
            Enumeration e = this.getRequest().getParameterNames();
            while (e.hasMoreElements()) {
                String string = (String)e.nextElement();
                url = (String)url + (first ? "?" : "&") + string + "=" + URLEncoder.encode(this.getRequest().getParameter(string), "utf-8");
                first = false;
            }
            this.response.sendRedirect((String)url);
            return null;
        }
        if (this.form == null) {
            this.form = new InstructorEditForm();
        }
        super.execute();
        if (this.instructorId == null && this.request.getAttribute("instructorId") != null) {
            this.instructorId = (String)this.request.getAttribute("instructorId");
        }
        if (this.instructorId == null) {
            this.instructorId = ((InstructorEditForm)this.form).getInstructorId();
        }
        if (this.op == null) {
            this.op = ((InstructorEditForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        if ((this.instructorId == null || this.instructorId.isEmpty()) && (instructors = DepartmentalInstructor.getUserInstructors(this.sessionContext.getUser())) != null) {
            String deptId = (String)this.request.getSession().getAttribute(Constants.DEPT_ID_ATTR_NAME);
            if (deptId != null) {
                for (DepartmentalInstructor departmentalInstructor : instructors) {
                    if (!departmentalInstructor.getDepartment().getUniqueId().toString().equals(deptId) || !this.sessionContext.hasPermission(departmentalInstructor, Right.InstructorDetail)) continue;
                    this.instructorId = departmentalInstructor.getUniqueId().toString();
                    break;
                }
            }
            if (this.instructorId == null || this.instructorId.isEmpty()) {
                for (DepartmentalInstructor departmentalInstructor : instructors) {
                    if (!this.sessionContext.hasPermission(departmentalInstructor, Right.InstructorDetail)) continue;
                    this.instructorId = departmentalInstructor.getUniqueId().toString();
                    break;
                }
            }
        }
        this.sessionContext.checkPermission((Serializable)((Object)this.instructorId), "DepartmentalInstructor", Right.InstructorDetail);
        if (MSG.actionEditInstructor().equals(this.op) || MSG.actionEditInstructorPreferences().equals(this.op) || MSG.actionEditInstructorAssignmentPreferences().equals(this.op) || MSG.actionBackToInstructors().equals(this.op) || MSG.actionNextInstructor().equals(this.op) || MSG.actionPreviousInstructor().equals(this.op)) {
            this.instructorId = ((InstructorEditForm)this.form).getInstructorId();
        } else {
            ((InstructorEditForm)this.form).reset();
        }
        Debug.debug("op: " + this.op);
        Debug.debug("instructor: " + this.instructorId);
        if (this.instructorId == null || this.instructorId.trim().isEmpty()) {
            throw new Exception(MSG.errorNoInstructorId());
        }
        if (MSG.actionBackToInstructors().equals(this.op)) {
            return "backToInstructors";
        }
        DepartmentalInstructorDAO idao = DepartmentalInstructorDAO.getInstance();
        DepartmentalInstructor inst = (DepartmentalInstructor)idao.get(Long.valueOf(this.instructorId));
        LookupTables.setupInstructorDistribTypes(this.request, this.sessionContext, inst);
        if (MSG.actionEditInstructor().equals(this.op)) {
            this.sessionContext.checkPermission((Serializable)((Object)this.instructorId), "DepartmentalInstructor", Right.InstructorEdit);
            this.response.sendRedirect(this.response.encodeURL("instructorInfoEdit.action?instructorId=" + this.instructorId));
            return null;
        }
        if (MSG.actionEditInstructorPreferences().equals(this.op)) {
            this.sessionContext.checkPermission((Serializable)((Object)this.instructorId), "DepartmentalInstructor", Right.InstructorPreferences);
            this.response.sendRedirect(this.response.encodeURL("instructorPrefEdit.action?instructorId=" + this.instructorId));
            return null;
        }
        if (MSG.actionEditInstructorAssignmentPreferences().equals(this.op)) {
            this.sessionContext.checkPermission(inst.getDepartment(), Right.InstructorAssignmentPreferences);
            this.response.sendRedirect(this.response.encodeURL("instructorAssignmentPref.action?instructorId=" + this.instructorId));
            return null;
        }
        if (MSG.actionNextInstructor().equals(this.op)) {
            this.response.sendRedirect(this.response.encodeURL("instructorDetail.action?instructorId=" + ((InstructorEditForm)this.form).getNextId()));
            return null;
        }
        if (MSG.actionPreviousInstructor().equals(this.op)) {
            this.response.sendRedirect(this.response.encodeURL("instructorDetail.action?instructorId=" + ((InstructorEditForm)this.form).getPreviousId()));
            return null;
        }
        this.doLoad(inst);
        BackTracker.markForBack(this.request, "instructorDetail.action?instructorId=" + this.instructorId, MSG.backInstructor(((InstructorEditForm)this.form).getName() == null ? "null" : ((InstructorEditForm)this.form).getName().trim()), true, !this.sessionContext.hasPermission(Right.HasRole));
        HashSet<ClassInstructor> allClasses = new HashSet<ClassInstructor>();
        for (DepartmentalInstructor di : DepartmentalInstructor.getAllForInstructor(inst, inst.getDepartment().getSession().getUniqueId())) {
            allClasses.addAll(di.getClasses());
        }
        if (!allClasses.isEmpty()) {
            boolean bl = this.sessionContext.hasPermission(Right.ClassAssignments);
            WebTable classTable = bl ? new WebTable(10, null, new String[]{MSG.columnClass(), MSG.columnInstructorCheckConflicts(), MSG.columnInstructorShare(), MSG.columnTeachingResponsibility(), MSG.columnLimit(), MSG.columnEnrollment(), MSG.columnManager(), MSG.columnAssignedTime(), MSG.columnAssignedDatePattern(), MSG.columnAssignedRoom()}, new String[]{"left", "left", "left", "left", "left", "left", "left", "left", "left", "left"}, null) : new WebTable(6, null, new String[]{MSG.columnClass(), MSG.columnInstructorCheckConflicts(), MSG.columnInstructorShare(), MSG.columnTeachingResponsibility(), MSG.columnLimit(), MSG.columnManager()}, new String[]{"left", "left", "left", "left", "left", "left"}, null);
            String backType = this.request.getParameter("backType");
            String backId = this.request.getParameter("backId");
            TreeSet<ClassInstructor> classes = new TreeSet<ClassInstructor>(new ClassInstructorComparator(new ClassComparator(2)));
            classes.addAll(allClasses);
            Vector<Long> classIds = new Vector<Long>(classes.size());
            for (ClassInstructor ci : classes) {
                Class_ c = ci.getClassInstructing();
                classIds.add(c.getUniqueId());
                Object limitString = "";
                if (!c.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue()) {
                    if (c.getExpectedCapacity() != null) {
                        limitString = c.getExpectedCapacity().toString();
                        if (c.getMaxExpectedCapacity() != null && !c.getMaxExpectedCapacity().equals(c.getExpectedCapacity())) {
                            limitString = (String)limitString + "-" + c.getMaxExpectedCapacity().toString();
                        }
                    } else {
                        limitString = "0";
                        if (c.getMaxExpectedCapacity() != null && c.getMaxExpectedCapacity() != 0) {
                            limitString = (String)limitString + "-" + c.getMaxExpectedCapacity().toString();
                        }
                    }
                }
                String enrollmentString = "";
                enrollmentString = c.getEnrollment() != null ? c.getEnrollment().toString() : "0";
                String managingDept = null;
                if (c.getManagingDept() != null) {
                    Department d = c.getManagingDept();
                    managingDept = d.getManagingDeptAbbv();
                }
                String assignedTime = "";
                String assignedDate = "";
                Object assignedRoom = "";
                ClassAssignmentDetails ca = ClassAssignmentDetails.createClassAssignmentDetails(this.sessionContext, this.getCourseTimetablingSolverService().getSolver(), c.getUniqueId(), false);
                if (ca == null) {
                    try {
                        ClassAssignmentProxy.AssignmentInfo a = this.getClassAssignmentService().getAssignment().getAssignment(c);
                        if (a.getUniqueId() != null) {
                            ca = ClassAssignmentDetails.createClassAssignmentDetailsFromAssignment(this.sessionContext, a.getUniqueId(), false);
                        }
                    }
                    catch (Exception a) {
                        // empty catch block
                    }
                }
                if (ca != null) {
                    if (ca.getAssignedTime() != null) {
                        assignedTime = ca.getAssignedTime().toHtml(false, false, true, true);
                        assignedDate = ca.getAssignedTime().getDatePatternHtml();
                    }
                    if (ca.getAssignedRoom() != null) {
                        for (int i = 0; i < ca.getAssignedRoom().length; ++i) {
                            if (i > 0) {
                                assignedRoom = (String)assignedRoom + ", ";
                            }
                            assignedRoom = (String)assignedRoom + ca.getAssignedRoom()[i].toHtml(false, false, true);
                        }
                    }
                }
                String icon = null;
                String bgColor = null;
                String title = null;
                if (!c.isCancelled().booleanValue() && ci.isLead().booleanValue()) {
                    Set<ClassAssignmentProxy.AssignmentInfo> conflicts = null;
                    try {
                        conflicts = this.getClassAssignmentService().getAssignment().getConflicts(c.getUniqueId());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (conflicts != null && !conflicts.isEmpty()) {
                        bgColor = "#fff0f0";
                        Object s = "";
                        for (ClassAssignmentProxy.AssignmentInfo x : conflicts) {
                            if (!((String)s).isEmpty()) {
                                s = (String)s + ", ";
                            }
                            s = (String)s + (x.getClassName() + " " + x.getPlacement().getName(CONST.useAmPm())).trim();
                        }
                        title = MSG.classIsConflicting(c.getClassLabel(), (String)s);
                        icon = "<IMG alt='" + MSG.classIsConflicting(c.getClassLabel(), (String)s) + "' title='" + MSG.classIsConflicting(c.getClassLabel(), (String)s) + "' src='images/warning.png' style='margin-left: 1px; margin-right: 3px; vertical-align: top;'>";
                    } else {
                        Set<RoomAvailabilityInterface.TimeBlock> ec = null;
                        try {
                            ec = this.getClassAssignmentService().getAssignment().getConflictingTimeBlocks(c.getUniqueId());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (ec != null && !ec.isEmpty()) {
                            Object s = "";
                            String lastName = null;
                            String lastType = null;
                            for (RoomAvailabilityInterface.TimeBlock t : ec) {
                                if (lastName != null && lastName.equals(t.getEventName()) && lastType.equals(t.getEventType())) continue;
                                lastName = t.getEventName();
                                lastType = t.getEventType();
                                if (!((String)s).isEmpty()) {
                                    s = (String)s + ", ";
                                }
                                s = (String)s + lastName + " (" + lastType + ")";
                            }
                            bgColor = "#fff0f0";
                            title = MSG.classIsConflicting(c.getClassLabel(), (String)s);
                            icon = "<IMG alt='" + MSG.classIsConflicting(c.getClassLabel(), (String)s) + "' title='" + MSG.classIsConflicting(c.getClassLabel(), (String)s) + "' src='images/warning.png' style='margin-left: 1px; margin-right: 3px; vertical-align: top;'>";
                        }
                    }
                }
                String onClick = null;
                if (this.sessionContext.hasPermission(c, Right.ClassDetail)) {
                    onClick = "onClick=\"document.location='classDetail.action?cid=" + c.getUniqueId() + "';\"";
                }
                boolean back = "PreferenceGroup".equals(backType) && c.getUniqueId().toString().equals(backId);
                String responsibility = ci.getResponsibility() == null ? "" : ci.getResponsibility().getLabel();
                WebTable.WebTableLine line = null;
                line = bl ? classTable.addLine(onClick, new String[]{(back ? "<A name=\"back\"></A>" : "") + (String)(icon == null ? "" : icon) + c.getClassLabel(), ci.isLead() != false ? "<IMG border='0' alt='true' align='absmiddle' src='images/accept.png'>" : "", ci.getPercentShare() + "%", responsibility, limitString, enrollmentString, managingDept, assignedTime, assignedDate, assignedRoom}, null, null) : classTable.addLine(onClick, new String[]{(back ? "<A name=\"back\"></A>" : "") + c.getClassLabel(), ci.isLead() != false ? "<IMG border='0' alt='true' align='absmiddle' src='images/accept.png'>" : "", ci.getPercentShare() + "%", responsibility, limitString, managingDept}, null, null);
                if (bgColor != null) {
                    line.setBgColor(bgColor);
                }
                if (title != null) {
                    line.setTitle(title);
                }
                if (!c.isCancelled().booleanValue()) continue;
                line.setStyle("color: gray; font-style: italic;");
                line.setTitle(MSG.classNoteCancelled(c.getClassLabel()));
            }
            Navigation.set(this.sessionContext, Navigation.sClassLevel, classIds);
            String tblData = classTable.printTable();
            this.request.setAttribute("classTable", (Object)tblData);
        }
        if (ApplicationProperty.RoomAvailabilityIncludeInstructors.isTrue() && inst.getExternalUniqueId() != null && !inst.getExternalUniqueId().isEmpty() && RoomAvailability.getInstance() != null && RoomAvailability.getInstance() instanceof DefaultRoomAvailabilityService) {
            WebTable.setOrder(this.sessionContext, "instructorUnavailability.ord", this.request.getParameter("iuord"), 1);
            WebTable webTable = new WebTable(5, "Instructor Unavailability", "instructorDetail.action?instructorId=" + this.instructorId + "&iuord=%%", new String[]{"Event", "Type", "Date", "Time", "Room"}, new String[]{"left", "left", "left", "left", "left"}, null);
            Formats.Format<Date> dfShort = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT);
            Formats.Format<Date> dfLong = Formats.getDateFormat(Formats.Pattern.DATE_EVENT_LONG);
            Session hibSession = EventDAO.getInstance().getSession();
            HashMap<Event, HashSet<Meeting>> unavailabilities = new HashMap<Event, HashSet<Meeting>>();
            for (Meeting meeting : hibSession.createQuery("select distinct m from Event e inner join e.meetings m left outer join e.additionalContacts c, Session s where type(e) in (CourseEvent, SpecialEvent, UnavailableEvent) and m.meetingDate >= s.eventBeginDate and m.meetingDate <= s.eventEndDate and s.uniqueId = :sessionId and (e.mainContact.externalUniqueId = :user or c.externalUniqueId = :user) and m.approvalStatus = 1", Meeting.class).setParameter("sessionId", (Object)this.sessionContext.getUser().getCurrentAcademicSessionId()).setParameter("user", (Object)inst.getExternalUniqueId()).setCacheable(true).list()) {
                HashSet<Meeting> meetings = (HashSet<Meeting>)unavailabilities.get(meeting.getEvent());
                if (meetings == null) {
                    meetings = new HashSet<Meeting>();
                    unavailabilities.put(meeting.getEvent(), meetings);
                }
                meetings.add(meeting);
            }
            for (Event event : new TreeSet(unavailabilities.keySet())) {
                for (Event.MultiMeeting m : Event.getMultiMeetings((Collection)unavailabilities.get(event))) {
                    String date = m.getDays() + " " + (String)(m.getMeetings().size() == 1 ? dfLong.format(m.getMeetings().first().getMeetingDate()) : dfShort.format(m.getMeetings().first().getMeetingDate()) + " - " + dfLong.format(m.getMeetings().last().getMeetingDate()));
                    String time = m.getMeetings().first().startTime() + " - " + m.getMeetings().first().stopTime();
                    String room = m.getMeetings().first().getLocation() == null ? "" : m.getMeetings().first().getLocation().getLabelWithHint();
                    webTable.addLine(this.sessionContext.hasPermission(event, Right.EventDetail) ? "onClick=\"showGwtDialog('Event Detail', 'events?menu=hide#event=" + event.getUniqueId() + "','900','85%');\"" : null, new String[]{event.getEventName(), event.getEventTypeAbbv(), date, time, room}, new Comparable[]{event.getEventName(), Integer.valueOf(event.getEventType()), m.getMeetings().first().getMeetingDate(), m.getMeetings().first().getStartPeriod(), room});
                }
            }
            if (!webTable.getLines().isEmpty()) {
                this.request.setAttribute("eventTable", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "instructorUnavailability.ord")));
            }
        }
        ((InstructorEditForm)this.form).setDisplayPrefs(CommonValues.Yes.eq(this.sessionContext.getUser().getProperty(UserProperty.DispInstructorPrefs)));
        if (MSG.actionDisplayInstructorPreferences().equals(this.op) || "true".equals(this.request.getParameter("showPrefs"))) {
            ((InstructorEditForm)this.form).setDisplayPrefs(true);
            this.sessionContext.getUser().setProperty(UserProperty.DispInstructorPrefs, CommonValues.Yes.value());
        }
        if (MSG.actionHideInstructorPreferences().equals(this.op) || "false".equals(this.request.getParameter("showPrefs"))) {
            ((InstructorEditForm)this.form).setDisplayPrefs(false);
            this.sessionContext.getUser().setProperty(UserProperty.DispInstructorPrefs, CommonValues.No.value());
        }
        LookupTables.setupInstructorAttributeTypes(this.request, inst);
        LookupTables.setupInstructorAttributes(this.request, inst);
        if (((InstructorEditForm)this.form).isDisplayPrefs()) {
            HashSet<TimePattern> hashSet = new HashSet<TimePattern>();
            ((InstructorEditForm)this.form).setAvailableTimePatterns(null);
            this.initPrefs(inst, null, false);
            hashSet.add(new TimePattern(-1L));
            this.processPrefAction();
            for (Preference pref : inst.getPreferences()) {
                if (!(pref instanceof TimePref)) continue;
                ((InstructorEditForm)this.form).setAvailability(((TimePref)pref).getPreference());
                break;
            }
            LookupTables.setupRooms(this.request, inst);
            LookupTables.setupBldgs(this.request, inst);
            LookupTables.setupRoomFeatures(this.request, inst);
            LookupTables.setupRoomGroups(this.request, inst);
            LookupTables.setupCourses(this.request, inst);
        }
        ((InstructorEditForm)this.form).setMaxLoad(inst.getMaxLoad() == null ? null : Formats.getNumberFormat("0.##").format(inst.getMaxLoad()));
        ((InstructorEditForm)this.form).setTeachingPreference(inst.getTeachingPreference() == null ? PreferenceLevel.sProhibited : inst.getTeachingPreference().getPrefProlog());
        if (inst.getMaxLoad() == null && (inst.getTeachingPreference() == null || inst.getTeachingPreference().getPrefProlog().equals(PreferenceLevel.sProhibited))) {
            ((InstructorEditForm)this.form).setTeachingPreference(null);
        }
        ((InstructorEditForm)this.form).clearAttributes();
        for (InstructorAttribute attribute : inst.getAttributes()) {
            ((InstructorEditForm)this.form).setAttribute(attribute.getUniqueId(), (Boolean)true);
        }
        ((InstructorEditForm)this.form).setPreviousId(Navigation.getPrevious(this.sessionContext, Navigation.sInstructionalOfferingLevel, inst.getUniqueId()));
        ((InstructorEditForm)this.form).setNextId(Navigation.getNext(this.sessionContext, Navigation.sInstructionalOfferingLevel, inst.getUniqueId()));
        if (inst.getExternalUniqueId() != null && !inst.getExternalUniqueId().isEmpty()) {
            ArrayList<IdValue> arrayList = new ArrayList<IdValue>();
            for (DepartmentalInstructor di : DepartmentalInstructorDAO.getInstance().getSession().createQuery("from DepartmentalInstructor i where i.department.session.uniqueId = :sessionId and i.externalUniqueId = :externalId order by i.department.deptCode", DepartmentalInstructor.class).setParameter("sessionId", (Object)this.sessionContext.getUser().getCurrentAcademicSessionId()).setParameter("externalId", (Object)inst.getExternalUniqueId()).setCacheable(true).list()) {
                if (!this.sessionContext.hasPermission(di, Right.InstructorDetail)) continue;
                arrayList.add(new IdValue(di.getUniqueId(), di.getDepartment().getLabel()));
            }
            if (arrayList.size() > 1) {
                ((InstructorEditForm)this.form).setDepartments(arrayList);
            }
        }
        return "showInstructorDetail";
    }

    private void doLoad(DepartmentalInstructor inst) {
        String puid;
        ((InstructorEditForm)this.form).setInstructorId(this.instructorId);
        if (inst.hasUnavailabilities()) {
            this.request.setAttribute("unavailableDaysPattern", (Object)inst.getUnavailablePatternHtml(false));
        }
        NameFormat nameFormat = NameFormat.fromReference(this.sessionContext.getUser().getProperty(UserProperty.NameFormat));
        ((InstructorEditForm)this.form).setName(nameFormat.format(inst));
        ((InstructorEditForm)this.form).setEmail(inst.getEmail());
        ((InstructorEditForm)this.form).setDeptCode(inst.getDepartment().getDeptCode());
        ((InstructorEditForm)this.form).setDeptName(inst.getDepartment().getLabel());
        InstructorSurvey is = InstructorSurvey.getInstructorSurvey(inst);
        ((InstructorEditForm)this.form).setHasInstructorSurvey(is != null);
        if (inst.getExternalUniqueId() != null && !inst.getExternalUniqueId().isEmpty()) {
            ((InstructorEditForm)this.form).setShowInstructorSurvey(this.sessionContext.hasPermission(inst.getDepartment(), Right.InstructorSurveyAdmin));
            if (this.sessionContext.getUser().getExternalUserId().equals(inst.getExternalUniqueId()) && this.sessionContext.hasPermission(Right.InstructorSurvey)) {
                ((InstructorEditForm)this.form).setShowInstructorSurvey(true);
            }
        }
        if ((puid = inst.getExternalUniqueId()) != null) {
            ((InstructorEditForm)this.form).setPuId(puid);
        }
        if (inst.getPositionType() != null) {
            ((InstructorEditForm)this.form).setPosType(inst.getPositionType().getLabel().trim());
        }
        if (inst.getCareerAcct() != null) {
            ((InstructorEditForm)this.form).setCareerAcct(inst.getCareerAcct().trim());
        } else if (DepartmentalInstructor.canLookupInstructor()) {
            try {
                ExternalUidLookup.UserInfo user = DepartmentalInstructor.lookupInstructor(puid);
                if (user != null && user.getUserName() != null) {
                    ((InstructorEditForm)this.form).setCareerAcct(user.getUserName());
                }
            }
            catch (Exception user) {
                // empty catch block
            }
        }
        if (inst.getNote() != null) {
            ((InstructorEditForm)this.form).setNote(inst.getNote().trim());
        }
        this.request.getSession().setAttribute(Constants.DEPT_ID_ATTR_NAME, (Object)inst.getDepartment().getUniqueId().toString());
        String orderStr = this.request.getParameter("order");
        int cols = 2;
        int order = 1;
        if (orderStr != null && orderStr.trim().length() != 0) {
            try {
                order = Integer.parseInt(orderStr);
                if (Math.abs(order) > cols) {
                    order = 1;
                }
            }
            catch (Exception e) {
                order = 1;
            }
        }
        ((InstructorEditForm)this.form).setIgnoreDist(inst.isIgnoreToFar() == null ? false : inst.isIgnoreToFar());
    }
}

