/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.form.InstructionalOfferingConfigEditForm;
import org.unitime.timetable.interfaces.ExternalInstrOffrConfigChangeAction;
import org.unitime.timetable.interfaces.ExternalLinkLookup;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.SimpleItypeConfig;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.dao.ClassDurationTypeDAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalMethodDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.ItypeDescDAO;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.spring.SpringApplicationContextHolder;
import org.unitime.timetable.util.AccessDeniedException;
import org.unitime.timetable.util.ComboBoxLookup;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.duration.DurationModel;
import org.unitime.timetable.webutil.SchedulingSubpartTableBuilder;

@Action(value="instructionalOfferingConfigEdit", results={@Result(name={"displayForm"}, type="tiles", location="instructionalOfferingConfigEdit.tiles"), @Result(name={"instructionalOfferingSearch"}, type="redirect", location="/instructionalOfferingSearch.action"), @Result(name={"instructionalOfferingDetail"}, type="redirect", location="/instructionalOfferingDetail.action", params={"io", "${form.instrOfferingId}", "op", "view"})})
@TilesDefinition(name="instructionalOfferingConfigEdit.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Instructional Offering Configuration"), @TilesPutAttribute(name="body", value="/user/instructionalOfferingConfigEdit.jsp"), @TilesPutAttribute(name="showNavigation", value="true")})
public class InstructionalOfferingConfigEditAction
extends UniTimeAction<InstructionalOfferingConfigEditForm> {
    private static final long serialVersionUID = -4608795904003447557L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected String op2 = null;
    private Integer limit;
    private Long id;
    private Long uid;

    public String getHdnOp() {
        return this.op2;
    }

    public void setHdnOp(String hdnOp) {
        this.op2 = hdnOp;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public String execute() throws Exception {
        List<SimpleItypeConfig> sp;
        if (this.form == null) {
            this.form = new InstructionalOfferingConfigEditForm();
        }
        Department contrDept = null;
        if (((InstructionalOfferingConfigEditForm)this.form).getConfigId() == null || ((InstructionalOfferingConfigEditForm)this.form).getConfigId() == 0L) {
            InstructionalOffering offering = (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(Long.valueOf(((InstructionalOfferingConfigEditForm)this.form).getInstrOfferingId()));
            this.sessionContext.checkPermission(offering, Right.InstrOfferingConfigAdd);
            contrDept = offering.getControllingCourseOffering().getSubjectArea().getDepartment();
        }
        if (((InstructionalOfferingConfigEditForm)this.form).getConfigId() != null && ((InstructionalOfferingConfigEditForm)this.form).getConfigId() != 0L) {
            InstrOfferingConfig config = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(((InstructionalOfferingConfigEditForm)this.form).getConfigId());
            this.sessionContext.checkPermission(config, Right.InstrOfferingConfigEdit);
            contrDept = config.getInstructionalOffering().getControllingCourseOffering().getSubjectArea().getDepartment();
        }
        String html = "";
        if (this.op == null) {
            this.op = ((InstructionalOfferingConfigEditForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        if (this.op == null || this.op.trim().length() == 0) {
            throw new Exception(MSG.errorOperationNotInterpreted() + this.op);
        }
        if (MSG.actionBackToIODetail().equals(this.op)) {
            return "instructionalOfferingDetail";
        }
        ((InstructionalOfferingConfigEditForm)this.form).setOp(this.op);
        LookupTables.setupItypes(this.request, true);
        LookupTables.setupExternalDepts(this.request, this.sessionContext.getUser().getCurrentAcademicSessionId());
        TreeSet<Department> ts = new TreeSet<Department>();
        for (Department d : (TreeSet)this.request.getAttribute(Department.EXTERNAL_DEPT_ATTR_NAME)) {
            if (!this.sessionContext.hasPermission(d, Right.InstrOfferingConfigEditDepartment) || !this.getPermissionDepartment().check(this.sessionContext.getUser(), contrDept, DepartmentStatusType.Status.OwnerEdit, d, DepartmentStatusType.Status.ManagerEdit)) continue;
            ts.add(d);
        }
        this.request.setAttribute(Department.EXTERNAL_DEPT_ATTR_NAME, ts);
        this.request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
        this.search(-1111L, new ArrayList<Integer>(), true);
        if ("Edit".equals(this.op) || MSG.actionEditConfiguration().equals(this.op)) {
            if (((InstructionalOfferingConfigEditForm)this.form).getConfigId() == null) {
                throw new Exception(MSG.errorConfigIDNotValid() + ((InstructionalOfferingConfigEditForm)this.form).getConfigId());
            }
            this.sessionContext.checkPermission(((InstructionalOfferingConfigEditForm)this.form).getConfigId(), "InstrOfferingConfig", Right.InstrOfferingConfigEdit);
            this.loadDetailFromConfig(((InstructionalOfferingConfigEditForm)this.form).getConfigId(), false);
            sp = this.loadOriginalConfig(((InstructionalOfferingConfigEditForm)this.form).getConfigId());
            boolean createAsNew = false;
            if (sp != null && sp.size() > 0) {
                this.sessionContext.setAttribute(SessionAttribute.InstructionalOfferingConfigList, sp);
                html = SchedulingSubpartTableBuilder.buildSubpartsTable(this.request, this.sessionContext, ((InstructionalOfferingConfigEditForm)this.form).getLimit(), ((InstructionalOfferingConfigEditForm)this.form).getConfigId().toString(), createAsNew, ((InstructionalOfferingConfigEditForm)this.form).getUnlimited(), ((InstructionalOfferingConfigEditForm)this.form).getDurationTypeText());
                this.request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
            } else {
                this.sessionContext.setAttribute(SessionAttribute.InstructionalOfferingConfigList, null);
                this.request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, null);
            }
        }
        if (this.op.equals(MSG.actionAddConfiguration())) {
            if (this.uid == null) {
                throw new Exception(MSG.exceptionCourseOfferingIdNeeded());
            }
            this.sessionContext.checkPermission((Serializable)((Object)((InstructionalOfferingConfigEditForm)this.form).getInstrOfferingId()), "InstructionalOffering", Right.InstrOfferingConfigAdd);
            this.loadDetailFromCourseOffering(this.uid, true, false);
            this.sessionContext.setAttribute(SessionAttribute.InstructionalOfferingConfigList, null);
            this.request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)"");
        }
        if (this.op.equalsIgnoreCase(MSG.actionMakeOffered())) {
            if (this.uid == null) {
                throw new Exception(MSG.exceptionCourseOfferingIdNeeded());
            }
            this.loadDetailFromCourseOffering(this.uid, true, true);
            this.sessionContext.setAttribute(SessionAttribute.InstructionalOfferingConfigList, null);
            this.request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)"");
            if (((InstructionalOfferingConfigEditForm)this.form).getConfigId() != null && ((InstructionalOfferingConfigEditForm)this.form).getConfigId().intValue() > 0) {
                sp = this.loadOriginalConfig(((InstructionalOfferingConfigEditForm)this.form).getConfigId());
                if (sp != null && sp.size() > 0) {
                    this.sessionContext.setAttribute(SessionAttribute.InstructionalOfferingConfigList, sp);
                    html = SchedulingSubpartTableBuilder.buildSubpartsTable(this.request, this.sessionContext, ((InstructionalOfferingConfigEditForm)this.form).getLimit(), this.uid.toString(), false, ((InstructionalOfferingConfigEditForm)this.form).getUnlimited(), ((InstructionalOfferingConfigEditForm)this.form).getDurationTypeText());
                    this.request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
                } else {
                    this.sessionContext.setAttribute(SessionAttribute.InstructionalOfferingConfigList, null);
                    this.request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, null);
                }
            }
        }
        if (MSG.actionAddInstructionalTypeToConfig().equals(this.op)) {
            ((InstructionalOfferingConfigEditForm)this.form).validate(this);
            if (this.hasFieldErrors()) {
                html = SchedulingSubpartTableBuilder.buildSubpartsTable(this.request, this.sessionContext, ((InstructionalOfferingConfigEditForm)this.form).getLimit(), ((InstructionalOfferingConfigEditForm)this.form).getCourseOfferingId(), false, ((InstructionalOfferingConfigEditForm)this.form).getUnlimited(), ((InstructionalOfferingConfigEditForm)this.form).getDurationTypeText());
                this.request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
                return "displayForm";
            }
            this.addInstructionalType((InstructionalOfferingConfigEditForm)this.form);
            ((InstructionalOfferingConfigEditForm)this.form).setItype(Constants.BLANK_OPTION_VALUE);
            html = SchedulingSubpartTableBuilder.buildSubpartsTable(this.request, this.sessionContext, ((InstructionalOfferingConfigEditForm)this.form).getLimit(), ((InstructionalOfferingConfigEditForm)this.form).getCourseOfferingId(), false, ((InstructionalOfferingConfigEditForm)this.form).getUnlimited(), ((InstructionalOfferingConfigEditForm)this.form).getDurationTypeText());
            this.request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
        }
        if (this.op.indexOf("shift") >= 0 || this.op.equals("delete")) {
            if (this.limit != null) {
                ((InstructionalOfferingConfigEditForm)this.form).setLimit(this.limit);
            }
            this.processShiftOrDelete(this.id, this.op);
            html = SchedulingSubpartTableBuilder.buildSubpartsTable(this.request, this.sessionContext, ((InstructionalOfferingConfigEditForm)this.form).getLimit(), ((InstructionalOfferingConfigEditForm)this.form).getCourseOfferingId(), false, ((InstructionalOfferingConfigEditForm)this.form).getUnlimited(), ((InstructionalOfferingConfigEditForm)this.form).getDurationTypeText());
            this.request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
        }
        if (this.op.equalsIgnoreCase("multipleLimits")) {
            html = SchedulingSubpartTableBuilder.buildSubpartsTable(this.request, this.sessionContext, ((InstructionalOfferingConfigEditForm)this.form).getLimit(), ((InstructionalOfferingConfigEditForm)this.form).getCourseOfferingId(), false, ((InstructionalOfferingConfigEditForm)this.form).getUnlimited(), ((InstructionalOfferingConfigEditForm)this.form).getDurationTypeText());
            this.request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
        }
        if (this.op.equals(MSG.actionSaveConfiguration()) || this.op.equals(MSG.actionUpdateConfiguration())) {
            html = SchedulingSubpartTableBuilder.buildSubpartsTable(this.request, this.sessionContext, ((InstructionalOfferingConfigEditForm)this.form).getLimit(), ((InstructionalOfferingConfigEditForm)this.form).getCourseOfferingId(), false, ((InstructionalOfferingConfigEditForm)this.form).getUnlimited(), ((InstructionalOfferingConfigEditForm)this.form).getDurationTypeText());
            this.request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
            ((InstructionalOfferingConfigEditForm)this.form).validate(this);
            if (this.hasFieldErrors()) {
                return "displayForm";
            }
            try {
                this.updateConfig();
                return "instructionalOfferingDetail";
            }
            catch (Exception e) {
                this.addFieldError("form.subparts", MSG.errorConfigurationCouldNotBeUpdated());
                if (!e.getClass().getName().startsWith("org.hibernate.")) {
                    this.addFieldError("form.subparts", MSG.errorCaughtException(e.getMessage()));
                }
                return "displayForm";
            }
        }
        if (this.op.equals(MSG.actionDeleteConfiguration())) {
            this.sessionContext.checkPermission(((InstructionalOfferingConfigEditForm)this.form).getConfigId(), "InstrOfferingConfig", Right.InstrOfferingConfigDelete);
            this.deleteConfig(this.request, (InstructionalOfferingConfigEditForm)this.form);
            return "instructionalOfferingDetail";
        }
        if (this.op.equalsIgnoreCase("unlimitedEnrollment")) {
            html = SchedulingSubpartTableBuilder.buildSubpartsTable(this.request, this.sessionContext, ((InstructionalOfferingConfigEditForm)this.form).getLimit(), ((InstructionalOfferingConfigEditForm)this.form).getCourseOfferingId(), false, ((InstructionalOfferingConfigEditForm)this.form).getUnlimited(), ((InstructionalOfferingConfigEditForm)this.form).getDurationTypeText());
            this.request.setAttribute(SimpleItypeConfig.CONFIGS_ATTR_NAME, (Object)html);
            return "displayForm";
        }
        return "displayForm";
    }

    private void loadDetailFromConfig(Long configId, boolean init) throws Exception {
        ClassDurationType dtype;
        if (configId == null) {
            throw new Exception("Config Id need for operation. ");
        }
        InstrOfferingConfigDAO iocDao = InstrOfferingConfigDAO.getInstance();
        InstrOfferingConfig ioc = (InstrOfferingConfig)iocDao.get(configId);
        if (ioc == null) {
            throw new Exception("Congifuration not found for id: " + configId);
        }
        ((InstructionalOfferingConfigEditForm)this.form).setConfigId(configId);
        ((InstructionalOfferingConfigEditForm)this.form).setName(ioc.getName());
        ((InstructionalOfferingConfigEditForm)this.form).setUnlimited(ioc.isUnlimitedEnrollment());
        Long courseOfferingId = ioc.getControllingCourseOffering().getUniqueId();
        this.loadDetailFromCourseOffering(courseOfferingId, init, false);
        ((InstructionalOfferingConfigEditForm)this.form).setDurationType(ioc.getClassDurationType() == null ? -1L : ioc.getClassDurationType().getUniqueId());
        for (SchedulingSubpart subpart : ioc.getSchedulingSubparts()) {
            if (this.sessionContext.hasPermission(subpart, Right.InstrOfferingConfigEditSubpart)) continue;
            ((InstructionalOfferingConfigEditForm)this.form).setDurationTypeEditable(false);
            break;
        }
        if (((InstructionalOfferingConfigEditForm)this.form).getDurationTypes().size() <= 1 && (dtype = ioc.getEffectiveDurationType()) != null && dtype.isVisible().booleanValue()) {
            ((InstructionalOfferingConfigEditForm)this.form).setDurationTypeEditable(false);
        }
        ((InstructionalOfferingConfigEditForm)this.form).setInstructionalMethod(ioc.getInstructionalMethod() == null ? -1L : ioc.getInstructionalMethod().getUniqueId());
        ((InstructionalOfferingConfigEditForm)this.form).setInstructionalMethodEditable(ApplicationProperty.WaitListCanChangeInstructionalMethod.isTrue() || !ioc.getInstructionalOffering().effectiveReScheduleNow() || ioc.getEnrollment() == 0);
    }

    private void loadDetailFromCourseOffering(Long courseOfferingId, boolean init, boolean loadDefaultConfig) throws Exception {
        if (courseOfferingId == null) {
            throw new Exception("Course Offering Id need for operation. ");
        }
        CourseOfferingDAO coDao = CourseOfferingDAO.getInstance();
        CourseOffering co = (CourseOffering)coDao.get(courseOfferingId);
        if (co == null) {
            throw new Exception("Course Offering not found for id: " + courseOfferingId);
        }
        InstructionalOffering io = co.getInstructionalOffering();
        ((InstructionalOfferingConfigEditForm)this.form).setCourseOfferingId(co.getUniqueId().toString());
        ((InstructionalOfferingConfigEditForm)this.form).setSubjectArea(co.getSubjectAreaAbbv());
        ((InstructionalOfferingConfigEditForm)this.form).setCourseNumber(co.getCourseNbr());
        ((InstructionalOfferingConfigEditForm)this.form).setInstrOfferingName(co.getCourseNameWithTitle());
        ((InstructionalOfferingConfigEditForm)this.form).setInstrOfferingId(io.getUniqueId().toString());
        ((InstructionalOfferingConfigEditForm)this.form).setNotOffered(io.isNotOffered());
        ((InstructionalOfferingConfigEditForm)this.form).setDurationType(io.getSession().getDefaultClassDurationType() == null ? -1L : io.getSession().getDefaultClassDurationType().getUniqueId());
        ((InstructionalOfferingConfigEditForm)this.form).setDurationTypeDefault(io.getSession().getDefaultClassDurationType() == null ? MSG.systemDefaultDurationType() : MSG.sessionDefault(io.getSession().getDefaultClassDurationType().getLabel()));
        ((InstructionalOfferingConfigEditForm)this.form).setDurationTypeEditable(true);
        ((InstructionalOfferingConfigEditForm)this.form).setInstructionalMethod(null);
        ((InstructionalOfferingConfigEditForm)this.form).setInstructionalMethodDefault(io.getSession().getDefaultInstructionalMethod() == null ? null : io.getSession().getDefaultInstructionalMethod().getLabel());
        ((InstructionalOfferingConfigEditForm)this.form).setInstructionalMethodEditable(true);
        Set<InstrOfferingConfig> configs = io.getInstrOfferingConfigs();
        ((InstructionalOfferingConfigEditForm)this.form).setConfigCount(configs.size());
        String linkLookupClass = ApplicationProperty.CourseCatalogLinkProvider.value();
        if (linkLookupClass != null && linkLookupClass.trim().length() > 0) {
            ExternalLinkLookup lookup = (ExternalLinkLookup)Class.forName(linkLookupClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Map results = lookup.getLink(io);
            if (results == null) {
                throw new Exception(lookup.getErrorMessage());
            }
            ((InstructionalOfferingConfigEditForm)this.form).setCatalogLinkLabel((String)results.get("label"));
            ((InstructionalOfferingConfigEditForm)this.form).setCatalogLinkLocation((String)results.get("href"));
        }
        if (loadDefaultConfig) {
            if (configs == null || configs.size() == 0) {
                ((InstructionalOfferingConfigEditForm)this.form).setConfigId(null);
                ((InstructionalOfferingConfigEditForm)this.form).setName("1");
            } else {
                InstrOfferingConfig ioc = configs.iterator().next();
                ((InstructionalOfferingConfigEditForm)this.form).setConfigId(ioc.getUniqueId());
                if (init) {
                    ((InstructionalOfferingConfigEditForm)this.form).setName(ioc.getName());
                    ((InstructionalOfferingConfigEditForm)this.form).setUnlimited(ioc.isUnlimitedEnrollment());
                }
            }
        } else if (((InstructionalOfferingConfigEditForm)this.form).getName() == null || ((InstructionalOfferingConfigEditForm)this.form).getName().trim().length() == 0) {
            ((InstructionalOfferingConfigEditForm)this.form).setName(InstrOfferingConfig.getGeneratedName(io));
        }
    }

    private List<SimpleItypeConfig> loadOriginalConfig(Long configId) throws Exception {
        InstrOfferingConfig config = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(configId);
        ((InstructionalOfferingConfigEditForm)this.form).setLimit(config.getLimit());
        List<SimpleItypeConfig> sp = this.toSimpleItypeConfig(config);
        Collections.sort(sp);
        return sp;
    }

    private void addInstructionalType(InstructionalOfferingConfigEditForm form) throws Exception {
        ItypeDescDAO itypeDao = ItypeDescDAO.getInstance();
        ItypeDesc itype = (ItypeDesc)itypeDao.get(Integer.valueOf(form.getItype()));
        if (itype == null) {
            throw new Exception("Instructional Type not found");
        }
        ArrayList<SimpleItypeConfig> sp = (ArrayList<SimpleItypeConfig>)this.sessionContext.getAttribute(SessionAttribute.InstructionalOfferingConfigList);
        if (sp == null) {
            sp = new ArrayList<SimpleItypeConfig>();
        }
        SimpleItypeConfig sic = new SimpleItypeConfig(itype);
        sic.setSubpartId(-1L);
        sp.add(sic);
        this.sessionContext.setAttribute(SessionAttribute.InstructionalOfferingConfigList, sp);
    }

    private void processShiftOrDelete(long id, String op) throws Exception {
        SimpleItypeConfig tmp;
        SimpleItypeConfig subp;
        int i;
        SimpleItypeConfig tmp2;
        int indx2;
        int indx1;
        SimpleItypeConfig parent;
        List sp = (List)this.sessionContext.getAttribute(SessionAttribute.InstructionalOfferingConfigList);
        if (sp == null || sp.size() == 0) {
            throw new Exception("Could not retrieve user defined configs");
        }
        ArrayList<Integer> indx = new ArrayList<Integer>();
        SimpleItypeConfig result = this.search(id, indx, false);
        if (result == null) {
            throw new Exception("Could not retrieve config element: " + id);
        }
        int index = (Integer)indx.get(0);
        if (op.equalsIgnoreCase("shiftUp")) {
            parent = result.getParent();
            if (parent == null) {
                indx1 = index;
                indx2 = indx1 - 1;
                tmp2 = (SimpleItypeConfig)sp.get(indx1);
                sp.add(indx2, tmp2);
                sp.remove(indx1 + 1);
            } else {
                List<SimpleItypeConfig> v = parent.getSubparts();
                for (i = 0; i < v.size(); ++i) {
                    subp = v.get(i);
                    if (subp.getId() != id) continue;
                    tmp = v.get(i);
                    v.add(i - 1, tmp);
                    v.remove(i + 1);
                    break;
                }
            }
        }
        if (op.equalsIgnoreCase("shiftDown")) {
            parent = result.getParent();
            if (parent == null) {
                indx1 = index + 1;
                indx2 = index;
                tmp2 = (SimpleItypeConfig)sp.get(indx1);
                sp.add(indx2, tmp2);
                sp.remove(indx1 + 1);
            } else {
                List<SimpleItypeConfig> v = parent.getSubparts();
                for (i = 0; i < v.size(); ++i) {
                    subp = v.get(i);
                    if (subp.getId() != id) continue;
                    tmp = v.get(i + 1);
                    v.add(i, tmp);
                    v.remove(i + 2);
                    break;
                }
            }
        }
        if (op.equalsIgnoreCase("shiftLeft")) {
            parent = result.getParent();
            List<SimpleItypeConfig> v = parent.getSubparts();
            for (i = 0; i < v.size(); ++i) {
                subp = v.get(i);
                if (subp.getId() != id) continue;
                v.remove(i);
                break;
            }
            SimpleItypeConfig grandParent = parent.getParent();
            result.setParent(grandParent);
            if (grandParent == null) {
                sp.add(index + 1, result);
            } else {
                List<SimpleItypeConfig> v1 = grandParent.getSubparts();
                for (int i2 = 0; i2 < v1.size(); ++i2) {
                    SimpleItypeConfig subp2 = v1.get(i2);
                    if (subp2.getId() != parent.getId()) continue;
                    v1.add(i2 + 1, result);
                    break;
                }
            }
        }
        if (op.equalsIgnoreCase("shiftRight")) {
            parent = result.getParent();
            if (parent == null) {
                SimpleItypeConfig curr = (SimpleItypeConfig)sp.get(index);
                SimpleItypeConfig prev = (SimpleItypeConfig)sp.get(index - 1);
                prev.addSubpart(curr);
                sp.remove(index);
            } else {
                List<SimpleItypeConfig> v = parent.getSubparts();
                for (int i3 = 0; i3 < v.size(); ++i3) {
                    subp = v.get(i3);
                    if (subp.getId() != id) continue;
                    SimpleItypeConfig curr = v.get(i3);
                    SimpleItypeConfig prev = v.get(i3 - 1);
                    prev.addSubpart(curr);
                    v.remove(i3);
                    break;
                }
            }
        }
        if (op.equalsIgnoreCase("delete")) {
            parent = result.getParent();
            if (parent == null) {
                sp.remove(index);
            } else {
                List<SimpleItypeConfig> v = parent.getSubparts();
                for (int i4 = 0; i4 < v.size(); ++i4) {
                    subp = v.get(i4);
                    if (subp.getId() != id) continue;
                    v.remove(i4);
                    break;
                }
            }
        }
        this.sessionContext.setAttribute(SessionAttribute.InstructionalOfferingConfigList, (Object)sp);
    }

    private SimpleItypeConfig search(long id, List<Integer> indx, boolean clearErrorFlags) {
        List sp = (List)this.sessionContext.getAttribute(SessionAttribute.InstructionalOfferingConfigList);
        if (sp == null || sp.size() == 0) {
            return null;
        }
        SimpleItypeConfig result = null;
        for (int i = 0; i < sp.size(); ++i) {
            SimpleItypeConfig sic = (SimpleItypeConfig)sp.get(i);
            indx.clear();
            indx.add(i);
            if (clearErrorFlags) {
                sic.setHasError(false);
            }
            if ((result = this.searchR(sic, id, clearErrorFlags)) != null) break;
        }
        if (clearErrorFlags) {
            this.sessionContext.setAttribute(SessionAttribute.InstructionalOfferingConfigList, (Object)sp);
        }
        return result;
    }

    private SimpleItypeConfig searchR(SimpleItypeConfig sic, long id, boolean clearErrorFlags) {
        if (sic.getId() == id) {
            return sic;
        }
        List<SimpleItypeConfig> v = sic.getSubparts();
        SimpleItypeConfig result = null;
        for (int i = 0; i < v.size(); ++i) {
            SimpleItypeConfig sic1 = v.get(i);
            if (clearErrorFlags) {
                sic1.setHasError(false);
            }
            if ((result = this.searchR(sic1, id, clearErrorFlags)) != null) break;
        }
        return result;
    }

    private void deleteConfig(HttpServletRequest request, InstructionalOfferingConfigEditForm form) throws Exception {
        Session hibSession = null;
        Transaction tx = null;
        try {
            InstrOfferingConfigDAO iocDao = InstrOfferingConfigDAO.getInstance();
            hibSession = iocDao.getSession();
            tx = hibSession.beginTransaction();
            Long configId = form.getConfigId();
            InstrOfferingConfig ioc = (InstrOfferingConfig)iocDao.get(configId);
            InstructionalOffering io = ioc.getInstructionalOffering();
            this.deleteSubpart(hibSession, ioc, new HashMap());
            io.removeConfiguration(ioc);
            io.computeLabels(hibSession);
            ChangeLog.addChange(hibSession, this.sessionContext, io, io.getCourseName() + " [" + ioc.getName() + "]", ChangeLog.Source.INSTR_CFG_EDIT, ChangeLog.Operation.DELETE, io.getControllingCourseOffering().getSubjectArea(), null);
            Event.deleteFromEvents(hibSession, ioc);
            Exam.deleteFromExams(hibSession, ioc);
            hibSession.merge((Object)io);
            String className = ApplicationProperty.ExternalActionInstrOffrConfigChange.value();
            ExternalInstrOffrConfigChangeAction configChangeAction = null;
            if (className != null && className.trim().length() > 0 && !(configChangeAction = (ExternalInstrOffrConfigChangeAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).validateConfigChangeCanOccur(io, hibSession)) {
                throw new Exception("Configuration change violates rules for Add On, rolling back the change.");
            }
            hibSession.flush();
            tx.commit();
            if (configChangeAction != null) {
                configChangeAction.performExternalInstrOffrConfigChangeAction(io, hibSession);
            }
        }
        catch (Exception e) {
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Debug.error(e);
            throw e;
        }
    }

    private void updateConfig() throws Exception {
        List sp = (List)this.sessionContext.getAttribute(SessionAttribute.InstructionalOfferingConfigList);
        if (sp == null || sp.size() == 0) {
            return;
        }
        RoomGroup rg = RoomGroup.getGlobalDefaultRoomGroup(this.sessionContext.getUser().getCurrentAcademicSessionId());
        InstrOfferingConfig ioc = null;
        InstructionalOffering io = null;
        Session hibSession = null;
        Transaction tx = null;
        try {
            InstructionalMethod imeth;
            InstructionalOfferingDAO ioDao = InstructionalOfferingDAO.getInstance();
            InstrOfferingConfigDAO iocDao = InstrOfferingConfigDAO.getInstance();
            hibSession = iocDao.getSession();
            tx = hibSession.beginTransaction();
            io = (InstructionalOffering)ioDao.get(Long.valueOf(((InstructionalOfferingConfigEditForm)this.form).getInstrOfferingId()));
            Long configId = ((InstructionalOfferingConfigEditForm)this.form).getConfigId();
            Boolean unlimitedEnroll = ((InstructionalOfferingConfigEditForm)this.form).getUnlimited() == null ? Boolean.valueOf(false) : ((InstructionalOfferingConfigEditForm)this.form).getUnlimited();
            int limit = unlimitedEnroll != false ? 0 : ((InstructionalOfferingConfigEditForm)this.form).getLimit();
            ClassDurationType dtype = ((InstructionalOfferingConfigEditForm)this.form).getDurationType() == null || ((InstructionalOfferingConfigEditForm)this.form).getDurationType() < 0L ? null : (ClassDurationType)ClassDurationTypeDAO.getInstance().get(((InstructionalOfferingConfigEditForm)this.form).getDurationType(), hibSession);
            InstructionalMethod instructionalMethod = imeth = ((InstructionalOfferingConfigEditForm)this.form).getInstructionalMethod() == null || ((InstructionalOfferingConfigEditForm)this.form).getInstructionalMethod() < 0L ? null : (InstructionalMethod)InstructionalMethodDAO.getInstance().get(((InstructionalOfferingConfigEditForm)this.form).getInstructionalMethod(), hibSession);
            if (configId == null || configId.intValue() == 0) {
                ioc = new InstrOfferingConfig();
                ioc.setLimit(limit);
                ioc.setName(((InstructionalOfferingConfigEditForm)this.form).getName());
                ioc.setUnlimitedEnrollment(unlimitedEnroll);
                ioc.setInstructionalOffering(io);
                ioc.setClassDurationType(dtype);
                ioc.setInstructionalMethod(imeth);
                io.addToInstrOfferingConfigs(ioc);
                hibSession.persist((Object)ioc);
                hibSession.merge((Object)io);
            } else {
                ioc = (InstrOfferingConfig)iocDao.get(configId);
                ioc.setLimit(limit);
                ioc.setName(((InstructionalOfferingConfigEditForm)this.form).getName());
                ioc.setUnlimitedEnrollment(unlimitedEnroll);
                ioc.setClassDurationType(dtype);
                ioc.setInstructionalMethod(imeth);
            }
            HashMap notDeletedSubparts = new HashMap();
            for (int i = 0; i < sp.size(); ++i) {
                SimpleItypeConfig sic = (SimpleItypeConfig)sp.get(i);
                this.createOrUpdateSubpart(hibSession, sic, ioc, null, rg, notDeletedSubparts);
                this.createOrUpdateClasses(hibSession, sic, ioc, null);
            }
            Set<SchedulingSubpart> s = ioc.getSchedulingSubparts();
            for (SchedulingSubpart subp : s) {
                if (subp.getParentSubpart() != null) continue;
                Debug.debug("Setting parents for " + subp.getItypeDesc());
                this.updateParentClasses(subp, null, hibSession, notDeletedSubparts);
            }
            this.deleteSubpart(hibSession, ioc, notDeletedSubparts);
            hibSession.merge((Object)ioc);
            hibSession.merge((Object)io);
            String className = ApplicationProperty.ExternalActionInstrOffrConfigChange.value();
            ExternalInstrOffrConfigChangeAction configChangeAction = null;
            if (className != null && className.trim().length() > 0 && !(configChangeAction = (ExternalInstrOffrConfigChangeAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).validateConfigChangeCanOccur(io, hibSession)) {
                throw new Exception("Configuration change violates rules for Add On, rolling back the change.");
            }
            io.computeLabels(hibSession);
            ChangeLog.addChange(hibSession, this.sessionContext, ioc, ChangeLog.Source.INSTR_CFG_EDIT, configId == null || configId.intValue() == 0 ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, ioc.getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), null);
            hibSession.flush();
            tx.commit();
            if (configChangeAction != null) {
                configChangeAction.performExternalInstrOffrConfigChangeAction(io, hibSession);
            }
        }
        catch (Exception e) {
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Debug.error(e);
            throw e;
        }
    }

    private void updateParentClasses(SchedulingSubpart subpart, SchedulingSubpart parent, Session hibSession, HashMap notDeletedSubparts) {
        Set<SchedulingSubpart> childSubparts;
        if (parent == null) {
            Debug.debug("Parent is null. Setting all classes to have no parent");
            classes = subpart.getClasses();
            for (Class_ c : classes) {
                if (c.getParentClass() == null) continue;
                Class_ pc = c.getParentClass();
                if (pc != null) {
                    pc.getChildClasses().remove(c);
                }
                c.setParentClass(null);
                hibSession.merge((Object)c);
            }
        } else {
            classes = subpart.getClasses();
            ArrayList<Class_> classesList = new ArrayList<Class_>(classes);
            Collections.sort(classesList, new ClassComparator(1));
            ArrayList<Class_> parentClasses = new ArrayList<Class_>(parent.getClasses());
            int parentNumClasses = parentClasses.size();
            if (parentNumClasses > 0) {
                Class_ previousParentClass;
                Class_ childClass;
                Iterator<Class_> cci = classesList.iterator();
                int classPerParent = classesList.size() / parentNumClasses;
                int classPerParentRem = classesList.size() % parentNumClasses;
                Debug.debug("Setting " + classPerParent + " class(es) per parent");
                Debug.debug("Odd number of classes found - " + classPerParentRem + " classes ... ");
                Iterator<Class_> i = parentClasses.iterator();
                while (i.hasNext() && classPerParent != 0) {
                    Class_ parentClass = i.next();
                    for (int j = 0; j < classPerParent; ++j) {
                        Class_ pc;
                        childClass = cci.next();
                        if (notDeletedSubparts.get(childClass.getSchedulingSubpart().getUniqueId()) != null) {
                            previousParentClass = childClass.getParentClass();
                            if (!parentClass.equals(previousParentClass)) {
                                Debug.debug("Setting class " + childClass.getClassLabel() + " to parent " + parentClass.getClassLabel());
                                if (previousParentClass != null) {
                                    previousParentClass.getChildClasses().remove(childClass);
                                }
                                childClass.setParentClass(parentClass);
                                parentClass.addToChildClasses(childClass);
                                hibSession.merge((Object)childClass);
                            }
                        } else {
                            if (!this.sessionContext.hasPermission(childClass, Right.ClassDelete)) {
                                throw new AccessDeniedException("Class " + childClass.getClassLabel(hibSession) + " cannot be deleted.");
                            }
                            Debug.debug("Deleting class " + childClass.getClassLabel());
                            if (childClass.getParentClass() != null) {
                                pc = childClass.getParentClass();
                                pc.getChildClasses().remove(childClass);
                                hibSession.merge((Object)pc);
                                childClass.setParentClass(null);
                                hibSession.merge((Object)childClass);
                            }
                            classes.remove(childClass);
                            childClass.deleteAllDependentObjects(hibSession, false);
                            hibSession.remove((Object)childClass);
                            hibSession.merge((Object)subpart);
                        }
                        if (classPerParentRem == 0) continue;
                        if (cci.hasNext()) {
                            childClass = cci.next();
                            if (notDeletedSubparts.get(childClass.getSchedulingSubpart().getUniqueId()) != null) {
                                Debug.debug("Setting ODD class " + childClass.getClassLabel() + " to parent " + parentClass.getClassLabel());
                                previousParentClass = childClass.getParentClass();
                                if (previousParentClass != null) {
                                    previousParentClass.getChildClasses().remove(childClass);
                                }
                                childClass.setParentClass(parentClass);
                                parentClass.addToChildClasses(childClass);
                                hibSession.merge((Object)parentClass);
                                hibSession.merge((Object)childClass);
                            } else {
                                if (!this.sessionContext.hasPermission(childClass, Right.ClassDelete)) {
                                    throw new AccessDeniedException("Class " + childClass.getClassLabel(hibSession) + " cannot be deleted.");
                                }
                                Debug.debug("Deleting ODD class " + childClass.getClassLabel());
                                if (childClass.getParentClass() != null) {
                                    pc = childClass.getParentClass();
                                    pc.getChildClasses().remove(childClass);
                                    hibSession.merge((Object)pc);
                                    childClass.setParentClass(null);
                                    hibSession.merge((Object)childClass);
                                }
                                classes.remove(childClass);
                                childClass.deleteAllDependentObjects(hibSession, false);
                                hibSession.remove((Object)childClass);
                                hibSession.merge((Object)childClass.getSchedulingSubpart());
                            }
                        }
                        --classPerParentRem;
                    }
                }
                if (classPerParentRem != 0) {
                    Iterator<Class_> cci2 = classesList.iterator();
                    for (Class_ parentClass : parentClasses) {
                        if (cci2.hasNext()) {
                            childClass = cci2.next();
                            Debug.debug("Setting ODD class " + childClass.getClassLabel() + " to parent " + parentClass.getClassLabel());
                            previousParentClass = childClass.getParentClass();
                            if (previousParentClass != null) {
                                previousParentClass.getChildClasses().remove(childClass);
                            }
                            childClass.setParentClass(parentClass);
                            parentClass.addToChildClasses(childClass);
                            hibSession.merge((Object)parentClass);
                            hibSession.merge((Object)childClass);
                        }
                        if (--classPerParentRem != 0) continue;
                        break;
                    }
                }
                hibSession.merge((Object)parent);
            }
        }
        if ((childSubparts = subpart.getChildSubparts()) == null || childSubparts.size() == 0) {
            return;
        }
        for (SchedulingSubpart cs : new ArrayList<SchedulingSubpart>(childSubparts)) {
            this.updateParentClasses(cs, subpart, hibSession, notDeletedSubparts);
        }
    }

    private void deleteSubpart(Session hibSession, InstrOfferingConfig ioc, HashMap notDeletedSubparts) throws Exception {
        Set<SchedulingSubpart> s = ioc.getSchedulingSubparts();
        HashMap<Long, Long> deletedSubparts = new HashMap<Long, Long>();
        Iterator<SchedulingSubpart> i = s.iterator();
        while (i.hasNext()) {
            Set<SchedulingSubpart> childSubparts;
            SchedulingSubpart tmpSubpart = i.next();
            if (notDeletedSubparts.get(tmpSubpart.getUniqueId()) != null) continue;
            Debug.debug("Deleting subpart ... " + tmpSubpart.getUniqueId() + ", " + tmpSubpart.getItypeDesc());
            Set<Class_> classes = tmpSubpart.getClasses();
            Iterator<Class_> j = classes.iterator();
            while (j.hasNext()) {
                Class_ c = j.next();
                this.deleteChildClasses(c, hibSession, 1, false);
                Class_ pc = c.getParentClass();
                if (pc != null) {
                    pc.getChildClasses().remove(c);
                    if (notDeletedSubparts.get(pc.getSchedulingSubpart().getUniqueId()) != null) {
                        hibSession.merge((Object)pc);
                    }
                }
                j.remove();
            }
            tmpSubpart.deleteAllDistributionPreferences(hibSession);
            SchedulingSubpart parentSubpart = tmpSubpart.getParentSubpart();
            if (parentSubpart != null) {
                if (parentSubpart.getChildSubparts() != null) {
                    parentSubpart.getChildSubparts().remove(tmpSubpart);
                }
                tmpSubpart.setParentSubpart(null);
                if (deletedSubparts.get(parentSubpart.getUniqueId()) == null) {
                    hibSession.merge((Object)parentSubpart);
                }
            }
            if ((childSubparts = tmpSubpart.getChildSubparts()) != null) {
                Debug.debug("Child subparts exist ... " + childSubparts.size());
            }
            tmpSubpart.setChildSubparts(null);
            deletedSubparts.put(tmpSubpart.getUniqueId(), tmpSubpart.getUniqueId());
            hibSession.remove((Object)tmpSubpart);
            i.remove();
        }
        hibSession.merge((Object)ioc);
        hibSession.flush();
    }

    private void createOrUpdateSubpart(Session hibSession, SimpleItypeConfig sic, InstrOfferingConfig ioc, SchedulingSubpart parent, RoomGroup rg, HashMap notDeletedSubparts) throws Exception {
        String subpartId = this.request.getParameter("subpartId" + sic.getId());
        String minLimitPerClass = this.request.getParameter("mnlpc" + sic.getId());
        String maxLimitPerClass = this.request.getParameter("mxlpc" + sic.getId());
        String minPerWk = this.request.getParameter("mpw" + sic.getId());
        String numClasses = this.request.getParameter("nc" + sic.getId());
        String numRooms = this.request.getParameter("nr" + sic.getId());
        String roomRatio = this.request.getParameter("rr" + sic.getId());
        String managingDept = this.request.getParameter("md" + sic.getId());
        String splitAttendance = this.request.getParameter("sa" + sic.getId());
        String disabled = this.request.getParameter("disabled" + sic.getId());
        if (subpartId != null) {
            sic.setSubpartId(Long.parseLong(subpartId));
        }
        if (minLimitPerClass != null) {
            sic.setMinLimitPerClass(Constants.getPositiveInteger(minLimitPerClass, 0));
        }
        if (maxLimitPerClass != null) {
            sic.setMaxLimitPerClass(Constants.getPositiveInteger(maxLimitPerClass, 0));
        }
        if (minPerWk != null) {
            sic.setMinPerWeek(Integer.parseInt(minPerWk));
        }
        if (numClasses != null) {
            sic.setNumClasses(Integer.parseInt(numClasses));
        }
        if (numRooms != null) {
            sic.setNumRooms(Constants.getPositiveInteger(numRooms, 0));
        }
        if (splitAttendance != null) {
            sic.setSplitAttendance("true".equalsIgnoreCase(splitAttendance) || "on".equalsIgnoreCase(splitAttendance));
        } else {
            sic.setSplitAttendance(false);
        }
        if (roomRatio != null) {
            sic.setRoomRatio(Constants.getPositiveFloat(roomRatio, 0.0f));
        }
        if (managingDept != null) {
            sic.setManagingDeptId(Long.parseLong(managingDept));
        }
        if (disabled != null) {
            sic.setDisabled(Boolean.valueOf(this.request.getParameter("disabled" + sic.getId())));
        }
        long sid = sic.getSubpartId();
        int mnlpc = sic.getMinLimitPerClass();
        int mxlpc = sic.getMaxLimitPerClass();
        int mpw = sic.getMinPerWeek();
        int nr = sic.getNumRooms();
        float rr = sic.getRoomRatio();
        long md = sic.getManagingDeptId();
        boolean db = sic.isDisabled();
        boolean sa = sic.isSplitAttendance();
        if (ioc.isUnlimitedEnrollment().booleanValue()) {
            mnlpc = 0;
            mxlpc = 0;
            nr = 0;
            rr = 0.0f;
        }
        if (nr <= 1) {
            sa = false;
        }
        if (this.request.getParameter("varLimits") == null) {
            mnlpc = mxlpc;
        }
        SchedulingSubpart subpart = null;
        if (sid < 0L) {
            Debug.debug("Subpart does not exist ... Creating subpart - " + sic.getItype().getDesc());
            subpart = new SchedulingSubpart();
            subpart.setInstrOfferingConfig(ioc);
            subpart.setItype(sic.getItype());
            subpart.setMinutesPerWk(mpw);
            subpart.setParentSubpart(parent);
            if (parent != null) {
                parent.addToChildSubparts(subpart);
            }
            subpart.setAutoSpreadInTime(ApplicationProperty.SchedulingSubpartAutoSpreadInTimeDefault.isTrue());
            subpart.setStudentAllowOverlap(ApplicationProperty.SchedulingSubpartStudentOverlapsDefault.isTrue());
            subpart.setClasses(new HashSet<Class_>());
            subpart.setChildSubparts(new HashSet<SchedulingSubpart>());
            ioc.addToschedulingSubparts(subpart);
            if (md < 0L && !ioc.isUnlimitedEnrollment().booleanValue() && rg != null) {
                HashSet<Preference> prefs = new HashSet<Preference>();
                RoomGroupPref rgp = new RoomGroupPref();
                rgp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(PreferenceLevel.PREF_LEVEL_REQUIRED)));
                rgp.setRoomGroup(rg);
                rgp.setOwner(subpart);
                prefs.add(rgp);
                subpart.setPreferences(prefs);
            }
            hibSession.persist((Object)subpart);
            sid = subpart.getUniqueId();
            Debug.debug("New subpart uniqueid: " + sid);
            sic.setSubpartId(sid);
            notDeletedSubparts.put(sid, "");
        } else {
            Debug.debug("Subpart exists ... Updating");
            notDeletedSubparts.put(sid, "");
            Set<SchedulingSubpart> s = ioc.getSchedulingSubparts();
            for (SchedulingSubpart tmpSubpart : s) {
                if (tmpSubpart.getUniqueId() != sid) continue;
                subpart = tmpSubpart;
                break;
            }
            if (subpart == null) {
                throw new Exception("Scheduling Subpart " + sid + " was not found.");
            }
            Debug.debug("Creating / Updating subpart - " + subpart.getItypeDesc());
            Set<Class_> classes = subpart.getClasses();
            if (!db) {
                if (subpart.getMinutesPerWk() != mpw) {
                    Debug.debug("Minutes per week changed ... Deleting time prefs on subpart and classes");
                    subpart.setMinutesPerWk(mpw);
                }
                if (ApplicationProperty.ConfigEditDeleteTimePrefs.isTrue()) {
                    DurationModel model = subpart.getInstrOfferingConfig().getDurationModel();
                    Iterator<Serializable> i = subpart.getPreferences().iterator();
                    while (i.hasNext()) {
                        Preference pref = i.next();
                        if (!(pref instanceof TimePref) || model.isValidCombination(mpw, subpart.effectiveDatePattern(), ((TimePref)pref).getTimePattern())) continue;
                        pref.setOwner(null);
                        hibSession.remove((Object)pref);
                        i.remove();
                    }
                    for (Class_ c : classes) {
                        Set<Preference> cPrefs = c.getPreferences();
                        Iterator<Preference> j = cPrefs.iterator();
                        while (j.hasNext()) {
                            Preference pref = j.next();
                            if (!(pref instanceof TimePref) || model.isValidCombination(mpw, c.effectiveDatePattern(), ((TimePref)pref).getTimePattern())) continue;
                            pref.setOwner(null);
                            hibSession.remove((Object)pref);
                            j.remove();
                        }
                        hibSession.merge((Object)c);
                    }
                }
                boolean managerChanged = false;
                long mdId = md;
                if (md < 0L) {
                    mdId = subpart.getInstrOfferingConfig().getControllingCourseOffering().getSubjectArea().getDepartment().getUniqueId();
                }
                if (subpart.getManagingDept().getUniqueId() != mdId) {
                    Debug.debug("Subpart Managing department changed ...");
                    managerChanged = true;
                    subpart.deleteAllDistributionPreferences(hibSession);
                    Set<Preference> prefs = subpart.getPreferences();
                    Iterator<Preference> prefI = prefs.iterator();
                    while (prefI.hasNext()) {
                        Department mgDept;
                        Preference a = prefI.next();
                        if (a instanceof RoomPref || a instanceof BuildingPref || a instanceof RoomGroupPref || a instanceof RoomFeaturePref) {
                            prefI.remove();
                        }
                        if (!(a instanceof TimePref) || !(mgDept = (Department)DepartmentDAO.getInstance().get(mdId)).isExternalManager().booleanValue() || subpart.getControllingDept().isAllowReqTime() != null && subpart.getControllingDept().isAllowReqTime().booleanValue() || mgDept.isAllowReqTime() != null && mgDept.isAllowReqTime().booleanValue()) continue;
                        ((TimePref)a).weakenHardPreferences();
                    }
                    if (md < 0L && !ioc.isUnlimitedEnrollment().booleanValue() && rg != null) {
                        RoomGroupPref rgp = new RoomGroupPref();
                        rgp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(PreferenceLevel.PREF_LEVEL_REQUIRED)));
                        rgp.setRoomGroup(rg);
                        rgp.setOwner(subpart);
                        prefs.add(rgp);
                    }
                }
                Iterator<Class_> i = classes.iterator();
                while (i.hasNext()) {
                    Debug.debug("Updating expected capacity and room capacity on class ...");
                    Class_ c = i.next();
                    c.setExpectedCapacity(mnlpc);
                    c.setMaxExpectedCapacity(mxlpc);
                    c.setRoomRatio(Float.valueOf(rr));
                    c.setNbrRooms(nr);
                    c.setRoomsSplitAttendance(sa);
                    if (c.getDisplayInstructor() == null) {
                        c.setDisplayInstructor(true);
                    }
                    if (c.getEnabledForStudentScheduling() == null) {
                        c.setEnabledForStudentScheduling(true);
                    }
                    if (managerChanged) {
                        if (c.getManagingDept().getUniqueId() != mdId) {
                            Debug.debug("Class Managing department changed ...");
                            c.setManagingDept((Department)DepartmentDAO.getInstance().get(mdId), this.sessionContext.getUser(), hibSession);
                            c.deleteAllDistributionPreferences(hibSession);
                            Set<Preference> prefs = c.getPreferences();
                            Iterator<Preference> prefI = prefs.iterator();
                            while (prefI.hasNext()) {
                                Preference a = prefI.next();
                                if (a instanceof RoomPref || a instanceof BuildingPref || a instanceof RoomGroupPref || a instanceof RoomFeaturePref) {
                                    prefI.remove();
                                }
                                if (!(a instanceof TimePref)) continue;
                                if (((TimePref)a).getTimePattern().isExactTime()) {
                                    prefI.remove();
                                    continue;
                                }
                                if (!c.getManagingDept().isExternalManager().booleanValue() || c.getControllingDept().isAllowReqTime() != null && c.getControllingDept().isAllowReqTime().booleanValue() || c.getManagingDept().isAllowReqTime() != null && c.getManagingDept().isAllowReqTime().booleanValue()) continue;
                                ((TimePref)a).weakenHardPreferences();
                            }
                        } else {
                            Debug.debug("Class Managing department same as subpart ... ignoring");
                        }
                    }
                    hibSession.merge((Object)c);
                }
            }
            if (parent != null && subpart.getParentSubpart() != null && !subpart.getParentSubpart().equals(parent) || parent == null && subpart.getParentSubpart() != null || parent != null && subpart.getParentSubpart() == null) {
                Debug.debug("Updating parent subparts and classes ...");
                if (subpart.getParentSubpart() != null) {
                    subpart.getParentSubpart().getChildSubparts().remove(subpart);
                }
                subpart.setParentSubpart(parent);
                if (parent != null) {
                    parent.addToChildSubparts(subpart);
                }
                if (parent == null) {
                    Debug.debug("No parent subparts ... making top level class");
                    for (Class_ childClass : subpart.getClasses()) {
                        Class_ previousParentClass = childClass.getParentClass();
                        if (previousParentClass != null) {
                            previousParentClass.getChildClasses().remove(childClass);
                        }
                        childClass.setParentClass(null);
                        hibSession.merge((Object)childClass);
                    }
                } else {
                    Debug.debug("Parent subpart exists ... setting parent class");
                    ArrayList<Class_> classesList = new ArrayList<Class_>(classes);
                    Collections.sort(classesList, new ClassComparator(1));
                    Set<Class_> parentClasses = parent.getClasses();
                    int parentNumClasses = parentClasses.size();
                    if (parentNumClasses > 0) {
                        Class_ previousParentClass;
                        Class_ childClass;
                        Iterator<Class_> cci = classesList.iterator();
                        int classPerParent = classesList.size() / parentNumClasses;
                        int classPerParentRem = classesList.size() % parentNumClasses;
                        Debug.debug("Setting " + classPerParent + " class(es) per parent");
                        Debug.debug("Odd number of classes found - " + classPerParentRem + " classes ... ");
                        Iterator<Class_> i = parentClasses.iterator();
                        while (i.hasNext() && classPerParent != 0) {
                            Class_ parentClass = i.next();
                            for (int j = 0; j < classPerParent; ++j) {
                                childClass = cci.next();
                                previousParentClass = childClass.getParentClass();
                                if (!parentClass.equals(previousParentClass)) {
                                    Debug.debug("Setting class " + childClass.getClassLabel() + " to parent " + parentClass.getClassLabel());
                                    if (previousParentClass != null) {
                                        previousParentClass.getChildClasses().remove(childClass);
                                    }
                                    childClass.setParentClass(parentClass);
                                    parentClass.addToChildClasses(childClass);
                                    hibSession.merge((Object)childClass);
                                }
                                if (classPerParentRem == 0) continue;
                                if (cci.hasNext()) {
                                    childClass = cci.next();
                                    Debug.debug("Setting ODD class " + childClass.getClassLabel() + " to parent " + parentClass.getClassLabel());
                                    previousParentClass = childClass.getParentClass();
                                    if (previousParentClass != null) {
                                        previousParentClass.getChildClasses().remove(childClass);
                                    }
                                    childClass.setParentClass(parentClass);
                                    parentClass.addToChildClasses(childClass);
                                    hibSession.merge((Object)childClass);
                                }
                                --classPerParentRem;
                            }
                        }
                        if (classPerParentRem != 0) {
                            Iterator<Class_> cci2 = classesList.iterator();
                            for (Class_ parentClass : parentClasses) {
                                if (cci2.hasNext()) {
                                    childClass = cci2.next();
                                    Debug.debug("Setting ODD class " + childClass.getClassLabel() + " to parent " + parentClass.getClassLabel());
                                    previousParentClass = childClass.getParentClass();
                                    if (previousParentClass != null) {
                                        previousParentClass.getChildClasses().remove(childClass);
                                    }
                                    childClass.setParentClass(parentClass);
                                    parentClass.addToChildClasses(childClass);
                                    hibSession.merge((Object)childClass);
                                }
                                if (--classPerParentRem != 0) continue;
                                break;
                            }
                        }
                        hibSession.merge((Object)parent);
                    }
                }
            }
            hibSession.merge((Object)subpart);
        }
        List<SimpleItypeConfig> v = sic.getSubparts();
        for (int i = 0; i < v.size(); ++i) {
            SimpleItypeConfig sic1 = v.get(i);
            this.createOrUpdateSubpart(hibSession, sic1, ioc, subpart, rg, notDeletedSubparts);
        }
        hibSession.merge((Object)ioc);
        hibSession.flush();
    }

    private void createOrUpdateClasses(Session hibSession, SimpleItypeConfig sic, InstrOfferingConfig ioc, SchedulingSubpart parent) throws Exception {
        long sid = sic.getSubpartId();
        int mnlpc = sic.getMinLimitPerClass();
        int mxlpc = sic.getMaxLimitPerClass();
        int nc = sic.getNumClasses();
        int nr = sic.getNumRooms();
        boolean sa = sic.isSplitAttendance();
        float rr = sic.getRoomRatio();
        long md = sic.getManagingDeptId();
        boolean db = sic.isDisabled();
        if (ioc.isUnlimitedEnrollment().booleanValue()) {
            mnlpc = 0;
            mxlpc = 0;
            nr = 0;
            rr = 0.0f;
            sa = false;
        }
        if (nr <= 1) {
            sa = false;
        }
        if (this.request.getParameter("varLimits") == null) {
            mnlpc = mxlpc;
        }
        Comparator<Class_> classComparator = new Comparator<Class_>(){

            @Override
            public int compare(Class_ c1, Class_ c2) {
                if (c1.isCancelled().booleanValue() && !c2.isCancelled().booleanValue()) {
                    return 1;
                }
                if (!c1.isCancelled().booleanValue() && c2.isCancelled().booleanValue()) {
                    return -1;
                }
                if (c1.getEnrollment() == 0 && c2.getEnrollment() != 0) {
                    return 1;
                }
                if (c1.getEnrollment() != 0 && c2.getEnrollment() == 0) {
                    return -1;
                }
                return c1.getUniqueId().compareTo(c2.getUniqueId());
            }
        };
        SchedulingSubpart subpart = null;
        if (sid < 0L) {
            throw new Exception("Subpart does not exist ... Cannot create classes ");
        }
        Set<SchedulingSubpart> s = ioc.getSchedulingSubparts();
        for (SchedulingSubpart tmpSubpart : s) {
            if (tmpSubpart.getUniqueId() != sid) continue;
            subpart = tmpSubpart;
            break;
        }
        if (subpart == null) {
            throw new Exception("Scheduling Subpart " + sid + " was not found.");
        }
        Debug.debug("Creating / Updating classes for subpart - " + subpart.getItypeDesc());
        Set<Class_> classes = subpart.getClasses();
        int numCls = classes.size();
        boolean readOnly = false;
        if (db) {
            Debug.debug("Subpart is readonly ... cannot change classes");
            readOnly = true;
        }
        HashMap<Long, Integer> cpClasses = new HashMap<Long, Integer>();
        if (parent != null) {
            int peerNumClasses;
            for (Class_ c : classes) {
                if (c.getParentClass() == null) continue;
                Integer classCount = (Integer)cpClasses.get(c.getParentClass().getUniqueId());
                if (classCount == null) {
                    cpClasses.put(c.getParentClass().getUniqueId(), 1);
                    continue;
                }
                cpClasses.put(c.getParentClass().getUniqueId(), classCount + 1);
            }
            int cpNumClasses = cpClasses.size();
            if (cpNumClasses != (peerNumClasses = parent.getClasses().size())) {
                if (readOnly) {
                    throw new Exception("Subpart " + subpart.toString() + " has read-only permissions - Number of classes cannot be changed. ");
                }
                Debug.debug("Parents per child ( " + cpNumClasses + " ) do not match up to - " + peerNumClasses);
                int classesPerParent = numCls / peerNumClasses;
                if (numCls > classesPerParent && cpClasses.size() > 0) {
                    diff = (numCls - classesPerParent) / cpClasses.size();
                    Debug.debug("Deleting " + diff + " classes per current parent");
                    Set parentClassKeys = cpClasses.keySet();
                    for (Long parentClassId : parentClassKeys) {
                        int parentClassCount = (Integer)cpClasses.get(parentClassId);
                        int deleteCount = parentClassCount - classesPerParent;
                        Debug.debug("Deleting " + deleteCount + " classes for parent class: " + parentClassId.toString());
                        ArrayList<Class_> adepts = new ArrayList<Class_>();
                        for (Class_ c1 : classes) {
                            if (!c1.getParentClass().getUniqueId().equals(parentClassId)) continue;
                            adepts.add(c1);
                        }
                        Collections.sort(adepts, classComparator);
                        for (int ct = adepts.size() - deleteCount; ct < adepts.size(); ++ct) {
                            Class_ c = (Class_)adepts.get(ct);
                            if (!this.deleteChildClasses(c, hibSession, 1, true)) continue;
                            Class_ pc = c.getParentClass();
                            if (pc != null) {
                                pc.getChildClasses().remove(c);
                                hibSession.merge((Object)pc);
                            }
                            classes.remove(c);
                        }
                        hibSession.merge((Object)subpart);
                        hibSession.merge((Object)parent);
                        hibSession.flush();
                    }
                } else {
                    diff = classesPerParent - numCls;
                    Debug.debug("Adding  " + diff + " classes");
                }
            }
        }
        if ((numCls = classes.size()) != nc) {
            if (readOnly) {
                throw new Exception("Subpart " + subpart.toString() + " has read-only permissions - Number of classes cannot be changed. ");
            }
            if (nc > numCls) {
                Debug.debug("No. of classes increased ... Adding " + (nc - numCls) + " classes");
                for (int ct = 0; ct < nc - numCls; ++ct) {
                    Class_ c = new Class_();
                    c.setSchedulingSubpart(subpart);
                    c.setExpectedCapacity(mnlpc);
                    c.setMaxExpectedCapacity(mxlpc);
                    c.setRoomRatio(Float.valueOf(rr));
                    c.setNbrRooms(nr);
                    c.setRoomsSplitAttendance(sa);
                    c.setDisplayInstructor(true);
                    c.setEnabledForStudentScheduling(true);
                    c.setPreferences(new HashSet<Preference>());
                    if (md > 0L) {
                        c.setManagingDept((Department)DepartmentDAO.getInstance().get(md), this.sessionContext.getUser(), hibSession);
                    }
                    c.setCancelled(false);
                    subpart.addToClasses(c);
                }
                hibSession.merge((Object)subpart);
                hibSession.flush();
                this.setParentClass(hibSession, subpart, parent, nc);
            } else {
                Debug.debug("No. of classes decreased ... Deleting " + (numCls - nc) + " classes");
                ArrayList<Class_> adepts = new ArrayList<Class_>(classes);
                Collections.sort(adepts, classComparator);
                if (parent == null || numCls - nc == 1) {
                    for (int ct = nc; ct < numCls; ++ct) {
                        Class_ c = adepts.get(ct);
                        if (!this.deleteChildClasses(c, hibSession, 1, true)) continue;
                        Class_ pc = c.getParentClass();
                        if (pc != null) {
                            pc.getChildClasses().remove(c);
                            hibSession.merge((Object)pc);
                        }
                        classes.remove(c);
                    }
                } else {
                    cpClasses.clear();
                    for (Class_ c : classes) {
                        if (c.getParentClass() == null) continue;
                        Integer classCount = (Integer)cpClasses.get(c.getParentClass().getUniqueId());
                        if (classCount == null) {
                            cpClasses.put(c.getParentClass().getUniqueId(), 1);
                            continue;
                        }
                        cpClasses.put(c.getParentClass().getUniqueId(), classCount + 1);
                    }
                    int diff = (numCls - nc) / cpClasses.size();
                    Debug.debug("Deleting " + diff + " classes per current parent");
                    Set parentClassKeys = cpClasses.keySet();
                    for (Long parentClassId : parentClassKeys) {
                        Debug.debug("Deleting " + diff + " classes for parent class: " + parentClassId.toString());
                        adepts.clear();
                        for (Class_ c1 : classes) {
                            if (!c1.getParentClass().getUniqueId().equals(parentClassId)) continue;
                            adepts.add(c1);
                        }
                        Collections.sort(adepts, classComparator);
                        for (int ct = adepts.size() - diff; ct < adepts.size(); ++ct) {
                            Class_ c = adepts.get(ct);
                            if (!this.deleteChildClasses(c, hibSession, 1, true)) continue;
                            Class_ pc = c.getParentClass();
                            if (pc != null) {
                                pc.getChildClasses().remove(c);
                                hibSession.merge((Object)pc);
                            }
                            classes.remove(c);
                        }
                        hibSession.merge((Object)subpart);
                        hibSession.merge((Object)parent);
                        hibSession.flush();
                    }
                }
                hibSession.merge((Object)subpart);
            }
        }
        List<SimpleItypeConfig> v = sic.getSubparts();
        for (int i = 0; i < v.size(); ++i) {
            SimpleItypeConfig sic1 = v.get(i);
            this.createOrUpdateClasses(hibSession, sic1, ioc, subpart);
        }
    }

    public boolean deleteChildClasses(Class_ c, Session hibSession, int recurseLevel, boolean canCancel) {
        Debug.debug("Deleting class (" + recurseLevel + ") ... " + c.getClassLabel() + " - " + c.getUniqueId());
        Iterator<Class_> i = c.getChildClasses().iterator();
        while (i.hasNext()) {
            Class_ cc = i.next();
            SchedulingSubpart ps = cc.getSchedulingSubpart();
            if (!this.deleteChildClasses(cc, hibSession, recurseLevel + 1, canCancel)) continue;
            ps.getClasses().remove(cc);
            hibSession.merge((Object)ps);
            i.remove();
        }
        if (this.sessionContext.hasPermission(c, Right.ClassDelete)) {
            c.deleteAllDependentObjects(hibSession, false);
            hibSession.remove((Object)c);
            return true;
        }
        if (canCancel && this.sessionContext.hasPermission(c, Right.ClassCancel)) {
            c.setCancelled(true);
            c.cancelEvent(this.sessionContext.getUser(), hibSession, true);
            hibSession.merge((Object)c);
            return false;
        }
        throw new AccessDeniedException("Class " + c.getClassLabel(hibSession) + " cannot be deleted or cancelled.");
    }

    public void setParentClass(Session hibSession, SchedulingSubpart subpart, SchedulingSubpart parent, int subpartNumClasses) {
        if (parent != null) {
            Set<Class_> parentClasses = parent.getClasses();
            int parentNumClasses = parentClasses.size();
            int classesPerParent = subpartNumClasses / parentNumClasses;
            HashMap<Long, Integer> cpClasses = new HashMap<Long, Integer>();
            for (Class_ c : parent.getClasses()) {
                int childClassCount = 0;
                Set<Class_> ccl = c.getChildClasses();
                if (ccl != null) {
                    for (Class_ cc : ccl) {
                        if (!cc.getSchedulingSubpart().equals(subpart)) continue;
                        ++childClassCount;
                    }
                }
                cpClasses.put(c.getUniqueId(), childClassCount);
            }
            ArrayList parentClassKeys = new ArrayList(cpClasses.keySet());
            Collections.sort(parentClassKeys);
            for (Long parentClassId : parentClassKeys) {
                int parentClassCount = (Integer)cpClasses.get(parentClassId);
                if (classesPerParent <= parentClassCount) continue;
                int addCount = classesPerParent - parentClassCount;
                Debug.debug("Adding " + addCount + " classes for parent class: " + parentClassId.toString());
                ArrayList<Class_> ccList = new ArrayList<Class_>(subpart.getClasses());
                Collections.sort(ccList, new ClassComparator(1));
                Iterator<Class_> cci = ccList.iterator();
                for (Class_ parentClass : parentClasses) {
                    if (!parentClass.getUniqueId().equals(parentClassId)) continue;
                    for (int j = 0; j < addCount; ++j) {
                        Class_ childClass = null;
                        while ((childClass = cci.next()).getParentClass() != null) {
                        }
                        Class_ previousParentClass = childClass.getParentClass();
                        if (previousParentClass != null) {
                            previousParentClass.getChildClasses().remove(childClass);
                        }
                        childClass.setParentClass(parentClass);
                        parentClass.addToChildClasses(childClass);
                        hibSession.merge((Object)childClass);
                    }
                }
            }
            hibSession.merge((Object)parent);
        }
    }

    public List<SimpleItypeConfig> toSimpleItypeConfig(InstrOfferingConfig config) throws Exception {
        ArrayList<SimpleItypeConfig> sp = new ArrayList<SimpleItypeConfig>();
        Set<SchedulingSubpart> subparts = config.getSchedulingSubparts();
        for (SchedulingSubpart subpart : subparts) {
            if (subpart.getParentSubpart() != null) continue;
            SimpleItypeConfig sic = this.toSimpleItypeConfig(config, subpart);
            sp.add(sic);
        }
        return sp;
    }

    private SimpleItypeConfig toSimpleItypeConfig(InstrOfferingConfig config, SchedulingSubpart subpart) throws Exception {
        ItypeDesc itype = subpart.getItype();
        SimpleItypeConfig sic = new SimpleItypeConfig(itype);
        boolean isDisabled = this.setSicProps(config, subpart, sic);
        Set<SchedulingSubpart> s = subpart.getChildSubparts();
        for (SchedulingSubpart child : s) {
            SimpleItypeConfig childSic = this.toSimpleItypeConfig(config, child);
            boolean isDisabledChild = this.setSicProps(config, child, childSic);
            sic.addSubpart(childSic);
            if (!isDisabledChild) continue;
            isDisabled = true;
        }
        if (isDisabled) {
            sic.setDisabled(true);
        }
        return sic;
    }

    private boolean setSicProps(InstrOfferingConfig config, SchedulingSubpart subpart, SimpleItypeConfig sic) {
        int mnlpc = subpart.getMinClassLimit();
        int mxlpc = subpart.getMaxClassLimit();
        int mpw = subpart.getMinutesPerWk();
        int numClasses = subpart.getNumClasses();
        int numRooms = subpart.getMaxRooms();
        float rc = subpart.getMaxRoomRatio();
        long md = subpart.getManagingDept().getUniqueId();
        boolean mixedManaged = subpart.hasMixedManagedClasses();
        if (mnlpc < 0) {
            mnlpc = config.getLimit();
        }
        if (mxlpc < 0) {
            mxlpc = mnlpc;
        }
        if (numClasses < 0) {
            numClasses = 0;
        }
        if (mixedManaged) {
            md = 0L;
        }
        sic.setMinLimitPerClass(mnlpc);
        sic.setMaxLimitPerClass(mxlpc);
        sic.setMinPerWeek(mpw);
        sic.setNumClasses(numClasses);
        sic.setNumRooms(numRooms);
        sic.setRoomRatio(rc);
        sic.setSubpartId(subpart.getUniqueId());
        sic.setManagingDeptId(md);
        sic.setSplitAttendance(subpart.isRoomSplitAttendance());
        if (!this.sessionContext.hasPermission(subpart, Right.InstrOfferingConfigEditSubpart) || mixedManaged) {
            sic.setDisabled(true);
            sic.setNotOwned(true);
            return true;
        }
        for (Class_ c : subpart.getClasses()) {
            if (this.sessionContext.hasPermission(c, Right.ClassDelete)) continue;
            sic.setNotOwned(true);
            break;
        }
        return false;
    }

    protected Permission.PermissionDepartment getPermissionDepartment() {
        return (Permission.PermissionDepartment)SpringApplicationContextHolder.getBean("permissionDepartment");
    }

    public String getCrsNbr() {
        return (String)this.sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber);
    }

    public String getSubjArea() {
        return (String)this.sessionContext.getAttribute(SessionAttribute.OfferingsSubjectArea);
    }

    public List<ComboBoxLookup> getItypes() {
        ArrayList<ComboBoxLookup> ret = new ArrayList<ComboBoxLookup>();
        ret.add(new ComboBoxLookup(MSG.itemSelect(), ""));
        for (ItypeDesc it : ItypeDesc.findAll(true)) {
            ret.add(new ComboBoxLookup(it.getDesc(), it.getItype().toString()));
        }
        ret.add(new ComboBoxLookup(MSG.selectMoreOptions(), "more"));
        return ret;
    }
}

