/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.PreferencesAction2;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ExamEditForm;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamConflict;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.security.context.HttpSessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.ExamDistributionPrefsTableBuilder;
import org.unitime.timetable.webutil.Navigation;

@Action(value="examDetail", results={@Result(name={"showExamDetail"}, type="tiles", location="examDetail.tiles"), @Result(name={"addDistributionPrefs"}, type="redirect", location="/examDistributionPrefs.action", params={"examId", "${form.examId}", "op", "${op}"}), @Result(name={"showList"}, type="redirect", location="/examList.action")})
@TilesDefinition(name="examDetail.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Examination Detail"), @TilesPutAttribute(name="body", value="/user/examDetail.jsp"), @TilesPutAttribute(name="showNavigation", value="true"), @TilesPutAttribute(name="showSolverWarnings", value="exams")})
public class ExamDetailAction
extends PreferencesAction2<ExamEditForm> {
    private static final long serialVersionUID = 2704790729386013602L;
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static ExaminationMessages EXMSG = Localization.create(ExaminationMessages.class);
    protected String examId = null;
    protected String op2 = null;

    public String getExamId() {
        return this.examId;
    }

    public void setExamId(String examId) {
        this.examId = examId;
    }

    public String getOp2() {
        return this.op2;
    }

    public void setOp2(String op2) {
        this.op2 = op2;
    }

    @Override
    public String execute() throws Exception {
        if (this.form == null) {
            this.form = new ExamEditForm();
        }
        super.execute();
        if (this.examId == null && this.request.getAttribute("examId") != null) {
            this.examId = (String)this.request.getAttribute("examId");
        }
        if (this.op == null) {
            this.op = ((ExamEditForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        if ("Edit".equals(this.op) || "Clone".equals(this.op) || "Add Distribution Preference".equals(this.op) || "Next".equals(this.op) || "Previous".equals(this.op) || "Delete".equals(this.op)) {
            this.examId = ((ExamEditForm)this.form).getExamId();
        } else if (EXMSG.accessExamEdit().equals(this.op) || EXMSG.accessExamClone().equals(this.op) || EXMSG.accessExamAddDistributionPref().equals(this.op) || EXMSG.accessExamNext().equals(this.op) || EXMSG.accessExamPrevious().equals(this.op) || EXMSG.accessExamDelete().equals(this.op)) {
            this.examId = ((ExamEditForm)this.form).getExamId();
        } else {
            List<ExamType> types;
            ((ExamEditForm)this.form).reset();
            if (this.request.getSession().getAttribute("Exam.Type") != null) {
                ((ExamEditForm)this.form).setExamType((Long)this.request.getSession().getAttribute("Exam.Type"));
            }
            if (((ExamEditForm)this.form).getExamType() == null && !(types = ExamType.findAllUsedApplicable(HttpSessionContext.getSessionContext(this.request.getSession().getServletContext()).getUser(), DepartmentStatusType.Status.ExamEdit, DepartmentStatusType.Status.ExamTimetable)).isEmpty()) {
                ((ExamEditForm)this.form).setExamType(types.get(0).getUniqueId());
            }
        }
        Debug.debug("op: " + this.op);
        Debug.debug("exam: " + this.examId);
        if (this.examId == null || this.examId.trim().isEmpty()) {
            throw new Exception(EXMSG.errorNoExamId());
        }
        boolean timeVertical = CommonValues.VerticalGrid.eq(this.sessionContext.getUser().getProperty(UserProperty.GridOrientation));
        Exam exam = (Exam)ExamDAO.getInstance().get(Long.valueOf(this.examId));
        if (exam == null && BackTracker.hasBack(this.request, 1)) {
            if (this.request.getParameter("backType") != null) {
                this.request.setAttribute("backType", (Object)this.request.getParameter("backType"));
            }
            if (this.request.getParameter("backId") != null) {
                this.request.setAttribute("backId", (Object)this.request.getParameter("backId"));
            }
            BackTracker.doBack(this.request, this.response);
            return null;
        }
        this.sessionContext.checkPermission((Serializable)((Object)this.examId), "Exam", Right.ExaminationDetail);
        if (("Edit".equals(this.op) || EXMSG.accessExamEdit().equals(this.op)) && this.examId != null && this.examId.trim() != "") {
            this.sessionContext.checkPermission(exam, Right.ExaminationEdit);
            this.response.sendRedirect(this.response.encodeURL("examEdit.action?examId=" + this.examId));
            return null;
        }
        if (("Clone".equals(this.op) || EXMSG.accessExamClone().equals(this.op)) && this.examId != null && this.examId.trim() != "") {
            this.sessionContext.checkPermission(exam, Right.ExaminationClone);
            this.response.sendRedirect(this.response.encodeURL("examEdit.action?examId=" + this.examId + "&clone=true"));
            return null;
        }
        if ("Next".equals(this.op) || EXMSG.accessExamNext().equals(this.op)) {
            this.response.sendRedirect(this.response.encodeURL("examDetail.action?examId=" + ((ExamEditForm)this.form).getNextId()));
            return null;
        }
        if ("Previous".equals(this.op) || EXMSG.accessExamPrevious().equals(this.op)) {
            this.response.sendRedirect(this.response.encodeURL("examDetail.action?examId=" + ((ExamEditForm)this.form).getPreviousId()));
            return null;
        }
        if ("Delete".equals(this.op) || EXMSG.accessExamDelete().equals(this.op)) {
            this.sessionContext.checkPermission(exam, Right.ExaminationDelete);
            Session hibSession = ExamDAO.getInstance().getSession();
            Transaction tx = null;
            try {
                tx = hibSession.beginTransaction();
                ChangeLog.addChange(hibSession, this.sessionContext, exam, ChangeLog.Source.EXAM_EDIT, ChangeLog.Operation.DELETE, exam.firstSubjectArea(), exam.firstDepartment());
                exam.deleteDependentObjects(hibSession, false);
                Iterator<ExamConflict> j = exam.getConflicts().iterator();
                while (j.hasNext()) {
                    ExamConflict conf = j.next();
                    for (Exam x : conf.getExams()) {
                        if (x.equals(exam)) continue;
                        x.getConflicts().remove(conf);
                    }
                    hibSession.remove((Object)conf);
                    j.remove();
                }
                hibSession.remove((Object)exam);
                tx.commit();
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                throw e;
            }
            if (BackTracker.hasBack(this.request, 1)) {
                this.request.setAttribute("backType", (Object)"Exam");
                this.request.setAttribute("backId", (Object)"-1");
                BackTracker.doBack(this.request, this.response);
                return null;
            }
            return "showList";
        }
        if ("Add Distribution Preference".equals(this.op) || EXMSG.accessExamAddDistributionPref().equals(this.op)) {
            this.sessionContext.checkPermission(exam, Right.DistributionPreferenceExam);
            this.request.setAttribute("examId", (Object)this.examId);
            return "addDistributionPrefs";
        }
        this.doLoad(exam);
        ExamDistributionPrefsTableBuilder tbl = new ExamDistributionPrefsTableBuilder();
        String html = tbl.getDistPrefsTable(this.request, this.sessionContext, exam);
        if (html != null) {
            this.request.setAttribute("distPrefs", (Object)html);
        }
        if (!exam.getOwners().isEmpty()) {
            WebTable table = new WebTable(7, null, new String[]{EXMSG.colExamOwnerObject(), EXMSG.colExamOwnerType(), EXMSG.colExamOwnerTitle(), EXMSG.colExamOwnerManager(), EXMSG.colExamOwnerStudents(), EXMSG.colExamOwnerLimit(), EXMSG.colExamOwnerAssignment()}, new String[]{"left", "center", "left", "left", "right", "right", "left"}, new boolean[]{true, true, true, true, true, true, true});
            for (ExamOwner owner : new TreeSet<ExamOwner>(exam.getOwners())) {
                String onclick = null;
                String name = null;
                String type = null;
                String students = String.valueOf(owner.countStudents());
                String limit = String.valueOf(owner.getLimit());
                String manager = null;
                String assignment = null;
                String title = null;
                String rowStyle = null;
                String rowTitle = null;
                switch (owner.getOwnerType()) {
                    case 3: {
                        Class_ clazz = (Class_)owner.getOwnerObject();
                        if (this.sessionContext.hasPermission(clazz, Right.ClassDetail)) {
                            onclick = "onClick=\"document.location='classDetail.action?cid=" + clazz.getUniqueId() + "';\"";
                        }
                        name = owner.getLabel();
                        type = EXMSG.examTypeClass();
                        manager = clazz.getManagingDept().getShortLabel();
                        if (clazz.getCommittedAssignment() != null) {
                            assignment = clazz.getCommittedAssignment().getPlacement().getLongName(CONSTANTS.useAmPm());
                        }
                        if ((title = clazz.getSchedulePrintNote()) == null || title.length() == 0) {
                            title = clazz.getSchedulingSubpart().getControllingCourseOffering().getTitle();
                        }
                        if (!clazz.isCancelled().booleanValue()) break;
                        rowStyle = "color: gray; font-style: italic;";
                        rowTitle = MSG.classNoteCancelled(clazz.getClassLabel());
                        break;
                    }
                    case 2: {
                        InstrOfferingConfig config = (InstrOfferingConfig)owner.getOwnerObject();
                        if (this.sessionContext.hasPermission(config.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                            onclick = "onClick=\"document.location='instructionalOfferingDetail.action?io=" + config.getInstructionalOffering().getUniqueId() + "';\"";
                        }
                        name = owner.getLabel();
                        type = EXMSG.examTypeConfig();
                        manager = config.getInstructionalOffering().getControllingCourseOffering().getDepartment().getShortLabel();
                        title = config.getControllingCourseOffering().getTitle();
                        break;
                    }
                    case 0: {
                        InstructionalOffering offering = (InstructionalOffering)owner.getOwnerObject();
                        if (this.sessionContext.hasPermission(offering, Right.InstructionalOfferingDetail)) {
                            onclick = "onClick=\"document.location='instructionalOfferingDetail.action?io=" + offering.getUniqueId() + "';\"";
                        }
                        name = owner.getLabel();
                        type = EXMSG.examTypeOffering();
                        manager = offering.getControllingCourseOffering().getDepartment().getShortLabel();
                        title = offering.getControllingCourseOffering().getTitle();
                        break;
                    }
                    case 1: {
                        CourseOffering course = (CourseOffering)owner.getOwnerObject();
                        if (this.sessionContext.hasPermission(course.getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                            onclick = "onClick=\"document.location='instructionalOfferingDetail.action?io=" + course.getInstructionalOffering().getUniqueId() + "';\"";
                        }
                        name = owner.getLabel();
                        type = EXMSG.examTypeCourse();
                        manager = course.getDepartment().getShortLabel();
                        title = course.getTitle();
                    }
                }
                WebTable.WebTableLine line = table.addLine(onclick, new String[]{name, type, title, manager, students, limit, assignment}, null);
                if (rowStyle != null) {
                    line.setStyle(rowStyle);
                }
                if (rowTitle == null) continue;
                line.setTitle(rowTitle);
            }
            this.request.setAttribute("table", (Object)table.printTable());
        }
        ExamAssignment ea = null;
        ExamSolverProxy examAssignment = WebSolver.getExamSolver(this.request.getSession());
        if (examAssignment != null && examAssignment.getExamTypeId().equals(exam.getExamType().getUniqueId())) {
            ea = examAssignment.getAssignmentInfo(exam.getUniqueId());
        } else if (exam.getAssignedPeriod() != null) {
            ea = new ExamAssignmentInfo(exam);
        }
        if (ea != null && ea.getPeriod() != null) {
            String assignment = "<tr><td>" + EXMSG.propExamAssignedPeriod() + "</td><td>" + ea.getPeriodNameWithPref() + "</td></tr>";
            if (!ea.getRooms().isEmpty()) {
                assignment = assignment + "<tr><td>" + (ea.getRooms().size() > 1 ? EXMSG.propExamAssignedRooms() : EXMSG.propExamAssignedRoom()) + "</td><td>";
                assignment = assignment + ea.getRoomsNameWithPref("<br>");
                assignment = assignment + "</td></tr>";
            }
            if (((ExamAssignmentInfo)ea).getNrDistributionConflicts() > 0) {
                assignment = assignment + "<tr><td>" + EXMSG.propExamViolatedDistConstraints() + "</td><td>";
                assignment = assignment + ((ExamAssignmentInfo)ea).getDistributionConflictTable();
                assignment = assignment + "</td></tr>";
            }
            if (((ExamAssignmentInfo)ea).getHasConflicts()) {
                assignment = assignment + "<tr><td>" + EXMSG.propExamStudentConflicts() + "</td><td>";
                assignment = assignment + ((ExamAssignmentInfo)ea).getConflictTable();
                assignment = assignment + "</td></tr>";
            }
            if (((ExamAssignmentInfo)ea).getHasInstructorConflicts()) {
                assignment = assignment + "<tr><td>" + EXMSG.propExamInstructorConflicts() + "</td><td>";
                assignment = assignment + ((ExamAssignmentInfo)ea).getInstructorConflictTable();
                assignment = assignment + "</td></tr>";
            }
            this.request.setAttribute("assignment", (Object)assignment);
        }
        BackTracker.markForBack(this.request, "examDetail.action?examId=" + this.examId, EXMSG.backToExam(((ExamEditForm)this.form).getName() == null ? ((ExamEditForm)this.form).getLabel().trim() : ((ExamEditForm)this.form).getName().trim()), true, false);
        ((ExamEditForm)this.form).setAvailableTimePatterns(null);
        this.initPrefs(exam, null, false);
        this.generateExamPeriodGrid(exam, "init", timeVertical, false);
        this.processPrefAction();
        this.setupInstructors(exam);
        LookupTables.setupRooms(this.request, exam);
        LookupTables.setupBldgs(this.request, exam);
        LookupTables.setupRoomFeatures(this.request, exam);
        LookupTables.setupRoomGroups(this.request, exam);
        LookupTables.setupExamTypes(this.request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamTimetable, DepartmentStatusType.Status.ExamView);
        return "showExamDetail";
    }

    protected void doLoad(Exam exam) {
        ((ExamEditForm)this.form).setExamId(exam.getUniqueId().toString());
        ((ExamEditForm)this.form).setLabel(exam.getLabel());
        ((ExamEditForm)this.form).setName(exam.generateName().equals(exam.getName()) ? null : exam.getName());
        ((ExamEditForm)this.form).setNote(exam.getNote() == null ? null : exam.getNote().replaceAll("\n", "<br>"));
        ((ExamEditForm)this.form).setLength(exam.getLength());
        ((ExamEditForm)this.form).setSize(String.valueOf(exam.getSize()));
        ((ExamEditForm)this.form).setPrintOffset(exam.getPrintOffset() == null || exam.getPrintOffset() == 0 ? null : (exam.getPrintOffset() > 0 ? "+" : "") + exam.getPrintOffset());
        ((ExamEditForm)this.form).setSeatingType(Exam.getSeatingTypeLabel(exam.getSeatingType()));
        ((ExamEditForm)this.form).setMaxNbrRooms(exam.getMaxNbrRooms());
        ((ExamEditForm)this.form).setExamType(exam.getExamType().getUniqueId());
        ((ExamEditForm)this.form).setAccommodation(StudentAccomodation.toHtml(StudentAccomodation.getAccommodations(exam)));
        TreeSet<DepartmentalInstructor> instructors = new TreeSet<DepartmentalInstructor>(exam.getInstructors());
        for (DepartmentalInstructor instr : instructors) {
            ((ExamEditForm)this.form).getInstructors().add(instr.getUniqueId().toString());
        }
        Long nextId = Navigation.getNext(this.sessionContext, Navigation.sInstructionalOfferingLevel, exam.getUniqueId());
        Long prevId = Navigation.getPrevious(this.sessionContext, Navigation.sInstructionalOfferingLevel, exam.getUniqueId());
        ((ExamEditForm)this.form).setPreviousId(prevId == null ? null : prevId.toString());
        ((ExamEditForm)this.form).setNextId(nextId == null ? null : nextId.toString());
        ExamPeriod avgPeriod = exam.getAveragePeriod();
        ((ExamEditForm)this.form).setAvgPeriod(avgPeriod == null ? null : avgPeriod.getName());
    }

    protected void setupInstructors(Exam exam) throws Exception {
        List<String> instructors = ((ExamEditForm)this.form).getInstructors();
        if (instructors.size() == 0) {
            return;
        }
        HashSet<Long> deptIds = new HashSet<Long>();
        for (DepartmentalInstructor instr : exam.getInstructors()) {
            deptIds.add(instr.getDepartment().getUniqueId());
        }
        for (ExamOwner own : exam.getOwners()) {
            deptIds.add(own.getCourse().getDepartment().getUniqueId());
        }
        Long[] deptsIdsArray = new Long[deptIds.size()];
        int idx = 0;
        Iterator i = deptIds.iterator();
        while (i.hasNext()) {
            deptsIdsArray[idx++] = (Long)i.next();
        }
        LookupTables.setupInstructors(this.request, this.sessionContext, deptsIdsArray);
    }
}

