/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.hibernate.util;

import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.cfgxml.spi.LoadedConfig;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.service.ServiceRegistry;

public class HibernateContext {
    private ServiceRegistry iServiceRegistry;
    private Metadata iMetadata;
    private LoadedConfig iConfig;
    private SessionFactory iSessionFactory;

    public HibernateContext(LoadedConfig config, ServiceRegistry registry, Metadata meta, SessionFactory factory) {
        this.iServiceRegistry = registry;
        this.iConfig = config;
        this.iMetadata = meta;
        this.iSessionFactory = factory;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.iServiceRegistry;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.iServiceRegistry = serviceRegistry;
    }

    public Metadata getMetadata() {
        return this.iMetadata;
    }

    public void setMetadata(Metadata metadata) {
        this.iMetadata = metadata;
    }

    public LoadedConfig getConfig() {
        return this.iConfig;
    }

    public void setConfig(LoadedConfig config) {
        this.iConfig = config;
    }

    public SessionFactory getSessionFactory() {
        return this.iSessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.iSessionFactory = sessionFactory;
    }

    public String getProperty(String key) {
        return (String)this.getConfig().getConfigurationValues().get(key);
    }

    public PersistentClass getClassMapping(String entityName) {
        return this.getMetadata().getEntityBinding(entityName);
    }

    public void close() {
        if (this.iSessionFactory != null) {
            this.iSessionFactory.close();
        }
    }
}

