/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.hibernate.id;

import java.lang.reflect.Member;
import java.util.EnumSet;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.cfgxml.spi.LoadedConfig;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.AnnotationBasedGenerator;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.EventType;
import org.hibernate.generator.EventTypeSets;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class UniqueIdGenerator
implements BeforeExecutionGenerator,
AnnotationBasedGenerator<org.unitime.commons.annotations.UniqueIdGenerator> {
    private static final long serialVersionUID = -2217592981811005640L;
    IdentifierGenerator iGenerator = null;
    private static String sGenClass = null;
    private static String sDefaultSchema = null;
    private boolean iInitialized = false;

    public static void configure(LoadedConfig config) {
        sGenClass = (String)config.getConfigurationValues().get("tmtbl.uniqueid.generator");
        if (sGenClass == null) {
            sGenClass = "org.hibernate.id.enhanced.SequenceStyleGenerator";
        }
        sDefaultSchema = (String)config.getConfigurationValues().get("hibernate.default_schema");
    }

    public void initialize(org.unitime.commons.annotations.UniqueIdGenerator config, Member idMember, GeneratorCreationContext context) {
        Properties params = new Properties();
        params.put("sequence_name", config.sequence());
        this.configure(context.getProperty().getType(), params, context.getServiceRegistry());
        this.registerExportables(context.getDatabase());
    }

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        if (params.getProperty("schema") == null && sDefaultSchema != null) {
            params.setProperty("schema", sDefaultSchema);
        }
        if (this.getGenerator() instanceof TableGenerator) {
            params.setProperty("segment_value", "default");
            params.setProperty("optimizer", "legacy-hilo");
            params.setProperty("increment_size", "32767");
            params.setProperty("value_column_name", "next_hi");
            params.setProperty("table_name", "hibernate_unique_key");
        } else if (this.getGenerator() instanceof SequenceStyleGenerator) {
            params.setProperty("increment_size", "1");
        }
        this.getGenerator().configure(type, params, serviceRegistry);
    }

    public void registerExportables(Database database) {
        this.getGenerator().registerExportables(database);
    }

    public synchronized void initialize(SqlStringGenerationContext context) {
        if (!this.iInitialized) {
            this.getGenerator().initialize(context);
        }
        this.iInitialized = true;
    }

    public IdentifierGenerator getGenerator() throws HibernateException {
        if (this.iGenerator == null) {
            if (sGenClass == null) {
                throw new HibernateException("UniqueIdGenerator is not configured, please call configure(Config) first.");
            }
            if ("org.hibernate.id.TableHiLoGenerator".equals(sGenClass)) {
                this.iGenerator = new TableGenerator();
            } else if ("org.hibernate.id.SequenceGenerator".equals(sGenClass)) {
                this.iGenerator = new SequenceStyleGenerator();
            } else {
                try {
                    this.iGenerator = (IdentifierGenerator)Class.forName(sGenClass).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new HibernateException("Unable to initialize uniqueId generator, reason: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.iGenerator;
    }

    public EnumSet<EventType> getEventTypes() {
        return EventTypeSets.INSERT_ONLY;
    }

    public Object generate(SharedSessionContractImplementor session, Object owner) {
        this.initialize(session.getSessionFactory().getSqlStringGenerationContext());
        return this.getGenerator().generate(session, owner);
    }

    public Object generate(SharedSessionContractImplementor session, Object owner, Object currentValue, EventType eventType) {
        return this.generate(session, owner);
    }
}

