/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.function.IntBinaryOperator;
import org.jgroups.Message;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.ReliableUnicast;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Buffer;
import org.jgroups.util.FixedBuffer;

public class UNICAST4
extends ReliableUnicast {
    protected static final Buffer.Options BLOCKING_SENDS = new Buffer.Options().block(true);
    @Property(description="Size of the send/receive buffers, in messages", writable=false)
    protected int capacity = 2048;
    @Property(description="Number of ACKs to skip before one is sent. For example, a value of 500 means that only every 500th ACk is sent; all others are dropped. If not set, defaulted to capacity/4", type=AttributeType.SCALAR)
    protected int ack_threshold;
    protected final IntBinaryOperator add_acks = (current_acks_sent, acks_to_be_sent) -> {
        if (current_acks_sent + acks_to_be_sent >= this.ack_threshold) {
            return 0;
        }
        return current_acks_sent + acks_to_be_sent;
    };

    @ManagedAttribute(description="Number of times sender threads were blocked on a full send window", type=AttributeType.SCALAR)
    public long getNumBlockings() {
        long total = 0L;
        for (ReliableUnicast.Entry e : this.send_table.values()) {
            FixedBuffer buf = (FixedBuffer)e.buf();
            total += buf.numBlockings();
        }
        return total;
    }

    @ManagedAttribute(description="Average time blocked")
    public AverageMinMax getAvgTimeBlocked() {
        AverageMinMax first = null;
        for (ReliableUnicast.Entry e : this.send_table.values()) {
            FixedBuffer buf = (FixedBuffer)e.buf();
            AverageMinMax avg = buf.avgTimeBlocked();
            if (first == null) {
                first = avg;
                continue;
            }
            first.merge(avg);
        }
        return first;
    }

    @ManagedOperation
    public void changeCapacity(int new_capacity) {
        if (new_capacity == this.capacity) {
            return;
        }
        this.send_table.values().stream().map(ReliableUnicast.Entry::buf).forEach(buf -> ((FixedBuffer)buf).changeCapacity(new_capacity));
        this.recv_table.values().stream().map(ReliableUnicast.Entry::buf).forEach(buf -> ((FixedBuffer)buf).changeCapacity(new_capacity));
        this.capacity = new_capacity;
        this.ack_threshold = this.capacity / 4;
    }

    @Override
    protected Buffer<Message> createBuffer(long seqno) {
        return new FixedBuffer<Message>(this.capacity, seqno);
    }

    @Override
    public Buffer.Options sendOptions() {
        return BLOCKING_SENDS;
    }

    public int capacity() {
        return this.capacity;
    }

    public UNICAST4 capacity(int c) {
        this.capacity = c;
        return this;
    }

    public int ackThreshold() {
        return this.ack_threshold;
    }

    public UNICAST4 ackThreshold(int t) {
        this.ack_threshold = t;
        return this;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.ack_threshold <= 0) {
            this.ack_threshold = this.capacity / 4;
            this.log.debug("defaulted ack_threshold to %d", this.ack_threshold);
        }
    }

    @Override
    protected boolean needToSendAck(ReliableUnicast.Entry e, int num_acks) {
        return e.update(num_acks, this.add_acks);
    }
}

