/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.rebind.FieldWriter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import java.util.Locale;

public class CellPanelParser
implements ElementParser {
    private static final String HALIGN_ATTR = "horizontalAlignment";
    private static final String VALIGN_ATTR = "verticalAlignment";
    private static final String WIDTH_ATTR = "width";
    private static final String HEIGHT_ATTR = "height";
    private static final String CELL_TAG = "Cell";

    protected static void parseCellAttributes(XMLElement cellElem, String fieldName, FieldWriter childField, UiBinderWriter writer) throws UnableToCompleteException {
        String value;
        JClassType hAlignConstantType = writer.getOracle().findType(HasHorizontalAlignment.HorizontalAlignmentConstant.class.getCanonicalName());
        JClassType vAlignConstantType = writer.getOracle().findType(HasVerticalAlignment.VerticalAlignmentConstant.class.getCanonicalName());
        if (cellElem.hasAttribute(HALIGN_ATTR)) {
            value = cellElem.consumeAttribute(HALIGN_ATTR, (JType)hAlignConstantType);
            writer.addStatement("%1$s.setCellHorizontalAlignment(%2$s, %3$s);", new Object[]{fieldName, childField.getNextReference(), value});
        }
        if (cellElem.hasAttribute(VALIGN_ATTR)) {
            value = cellElem.consumeAttribute(VALIGN_ATTR, (JType)vAlignConstantType);
            writer.addStatement("%1$s.setCellVerticalAlignment(%2$s, %3$s);", new Object[]{fieldName, childField.getNextReference(), value});
        }
        if (cellElem.hasAttribute(WIDTH_ATTR)) {
            value = cellElem.consumeStringAttribute(WIDTH_ATTR);
            writer.addStatement("%1$s.setCellWidth(%2$s, %3$s);", new Object[]{fieldName, childField.getNextReference(), value});
        }
        if (cellElem.hasAttribute(HEIGHT_ATTR)) {
            value = cellElem.consumeStringAttribute(HEIGHT_ATTR);
            writer.addStatement("%1$s.setCellHeight(%2$s, %3$s);", new Object[]{fieldName, childField.getNextReference(), value});
        }
    }

    @Override
    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        for (XMLElement child : elem.consumeChildElements()) {
            String ns = child.getNamespaceUri();
            String tagName = child.getLocalName();
            if (ns != null && ns.equals(elem.getNamespaceUri()) && this.localTagNameIsCell(tagName)) {
                XMLElement widget = child.consumeSingleChildElement();
                FieldWriter childField = writer.parseElementToField(widget);
                writer.addStatement("%1$s.add(%2$s);", new Object[]{fieldName, childField.getNextReference()});
                CellPanelParser.parseCellAttributes(child, fieldName, childField, writer);
                continue;
            }
            if (!writer.isWidgetElement(child)) {
                writer.die(elem, "Expected a widget or <%s:%s>, found %s", new Object[]{elem.getPrefix(), CELL_TAG.toLowerCase(Locale.ROOT), child});
            }
            FieldWriter childField = writer.parseElementToField(child);
            writer.addStatement("%1$s.add(%2$s);", new Object[]{fieldName, childField.getNextReference()});
        }
    }

    private boolean localTagNameIsCell(String tagName) {
        return tagName.equals(CELL_TAG) || tagName.equals(CELL_TAG.toLowerCase(Locale.ROOT));
    }
}

