/*
 * Decompiled with CFR 0.152.
 */
package biweekly.component;

import biweekly.ICalVersion;
import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.component.VAlarm;
import biweekly.property.Attachment;
import biweekly.property.Attendee;
import biweekly.property.Categories;
import biweekly.property.Classification;
import biweekly.property.Color;
import biweekly.property.Comment;
import biweekly.property.Conference;
import biweekly.property.Contact;
import biweekly.property.Created;
import biweekly.property.DateEnd;
import biweekly.property.DateStart;
import biweekly.property.DateTimeStamp;
import biweekly.property.Description;
import biweekly.property.DurationProperty;
import biweekly.property.ExceptionDates;
import biweekly.property.ExceptionRule;
import biweekly.property.Geo;
import biweekly.property.Image;
import biweekly.property.LastModified;
import biweekly.property.Location;
import biweekly.property.Method;
import biweekly.property.Organizer;
import biweekly.property.Priority;
import biweekly.property.RecurrenceDates;
import biweekly.property.RecurrenceId;
import biweekly.property.RecurrenceRule;
import biweekly.property.RelatedTo;
import biweekly.property.RequestStatus;
import biweekly.property.Resources;
import biweekly.property.Sequence;
import biweekly.property.Status;
import biweekly.property.Summary;
import biweekly.property.Transparency;
import biweekly.property.Uid;
import biweekly.property.Url;
import biweekly.property.ValuedProperty;
import biweekly.util.Duration;
import biweekly.util.Google2445Utils;
import biweekly.util.ICalDate;
import biweekly.util.Recurrence;
import biweekly.util.com.google.ical.compat.javautil.DateIterator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class VEvent
extends ICalComponent {
    public VEvent() {
        this.setUid(Uid.random());
        this.setDateTimeStamp(new Date());
    }

    public VEvent(VEvent original) {
        super(original);
    }

    public Uid getUid() {
        return this.getProperty(Uid.class);
    }

    public void setUid(Uid uid) {
        this.setProperty(Uid.class, uid);
    }

    public Uid setUid(String uid) {
        Uid prop = uid == null ? null : new Uid(uid);
        this.setUid(prop);
        return prop;
    }

    public DateTimeStamp getDateTimeStamp() {
        return this.getProperty(DateTimeStamp.class);
    }

    public void setDateTimeStamp(DateTimeStamp dateTimeStamp) {
        this.setProperty(DateTimeStamp.class, dateTimeStamp);
    }

    public DateTimeStamp setDateTimeStamp(Date dateTimeStamp) {
        DateTimeStamp prop = dateTimeStamp == null ? null : new DateTimeStamp(dateTimeStamp);
        this.setDateTimeStamp(prop);
        return prop;
    }

    public DateStart getDateStart() {
        return this.getProperty(DateStart.class);
    }

    public void setDateStart(DateStart dateStart) {
        this.setProperty(DateStart.class, dateStart);
    }

    public DateStart setDateStart(Date dateStart) {
        return this.setDateStart(dateStart, true);
    }

    public DateStart setDateStart(Date dateStart, boolean hasTime) {
        DateStart prop = dateStart == null ? null : new DateStart(dateStart, hasTime);
        this.setDateStart(prop);
        return prop;
    }

    public Classification getClassification() {
        return this.getProperty(Classification.class);
    }

    public void setClassification(Classification classification) {
        this.setProperty(Classification.class, classification);
    }

    public Classification setClassification(String classification) {
        Classification prop = classification == null ? null : new Classification(classification);
        this.setClassification(prop);
        return prop;
    }

    public Description getDescription() {
        return this.getProperty(Description.class);
    }

    public void setDescription(Description description) {
        this.setProperty(Description.class, description);
    }

    public Description setDescription(String description) {
        Description prop = description == null ? null : new Description(description);
        this.setDescription(prop);
        return prop;
    }

    public Geo getGeo() {
        return this.getProperty(Geo.class);
    }

    public void setGeo(Geo geo) {
        this.setProperty(Geo.class, geo);
    }

    public Location getLocation() {
        return this.getProperty(Location.class);
    }

    public void setLocation(Location location) {
        this.setProperty(Location.class, location);
    }

    public Location setLocation(String location) {
        Location prop = location == null ? null : new Location(location);
        this.setLocation(prop);
        return prop;
    }

    public Priority getPriority() {
        return this.getProperty(Priority.class);
    }

    public void setPriority(Priority priority) {
        this.setProperty(Priority.class, priority);
    }

    public Priority setPriority(Integer priority) {
        Priority prop = priority == null ? null : new Priority(priority);
        this.setPriority(prop);
        return prop;
    }

    public Status getStatus() {
        return this.getProperty(Status.class);
    }

    public void setStatus(Status status) {
        this.setProperty(Status.class, status);
    }

    public Summary getSummary() {
        return this.getProperty(Summary.class);
    }

    public void setSummary(Summary summary) {
        this.setProperty(Summary.class, summary);
    }

    public Summary setSummary(String summary) {
        Summary prop = summary == null ? null : new Summary(summary);
        this.setSummary(prop);
        return prop;
    }

    public Transparency getTransparency() {
        return this.getProperty(Transparency.class);
    }

    public void setTransparency(Transparency transparency) {
        this.setProperty(Transparency.class, transparency);
    }

    public Transparency setTransparency(Boolean transparent) {
        Transparency prop = null;
        if (transparent != null) {
            prop = transparent != false ? Transparency.transparent() : Transparency.opaque();
        }
        this.setTransparency(prop);
        return prop;
    }

    public Organizer getOrganizer() {
        return this.getProperty(Organizer.class);
    }

    public void setOrganizer(Organizer organizer) {
        this.setProperty(Organizer.class, organizer);
    }

    public Organizer setOrganizer(String email) {
        Organizer prop = email == null ? null : new Organizer(null, email);
        this.setOrganizer(prop);
        return prop;
    }

    public RecurrenceId getRecurrenceId() {
        return this.getProperty(RecurrenceId.class);
    }

    public void setRecurrenceId(RecurrenceId recurrenceId) {
        this.setProperty(RecurrenceId.class, recurrenceId);
    }

    public RecurrenceId setRecurrenceId(Date originalStartDate) {
        RecurrenceId prop = originalStartDate == null ? null : new RecurrenceId(originalStartDate);
        this.setRecurrenceId(prop);
        return prop;
    }

    public Url getUrl() {
        return this.getProperty(Url.class);
    }

    public void setUrl(Url url) {
        this.setProperty(Url.class, url);
    }

    public Url setUrl(String url) {
        Url prop = url == null ? null : new Url(url);
        this.setUrl(prop);
        return prop;
    }

    public RecurrenceRule getRecurrenceRule() {
        return this.getProperty(RecurrenceRule.class);
    }

    public RecurrenceRule setRecurrenceRule(Recurrence recur) {
        RecurrenceRule prop = recur == null ? null : new RecurrenceRule(recur);
        this.setRecurrenceRule(prop);
        return prop;
    }

    public void setRecurrenceRule(RecurrenceRule recurrenceRule) {
        this.setProperty(RecurrenceRule.class, recurrenceRule);
    }

    public DateEnd getDateEnd() {
        return this.getProperty(DateEnd.class);
    }

    public void setDateEnd(DateEnd dateEnd) {
        this.setProperty(DateEnd.class, dateEnd);
    }

    public DateEnd setDateEnd(Date dateEnd) {
        return this.setDateEnd(dateEnd, true);
    }

    public DateEnd setDateEnd(Date dateEnd, boolean hasTime) {
        DateEnd prop = dateEnd == null ? null : new DateEnd(dateEnd, hasTime);
        this.setDateEnd(prop);
        return prop;
    }

    public DurationProperty getDuration() {
        return this.getProperty(DurationProperty.class);
    }

    public void setDuration(DurationProperty duration) {
        this.setProperty(DurationProperty.class, duration);
    }

    public DurationProperty setDuration(Duration duration) {
        DurationProperty prop = duration == null ? null : new DurationProperty(duration);
        this.setDuration(prop);
        return prop;
    }

    public Created getCreated() {
        return this.getProperty(Created.class);
    }

    public void setCreated(Created created) {
        this.setProperty(Created.class, created);
    }

    public Created setCreated(Date created) {
        Created prop = created == null ? null : new Created(created);
        this.setCreated(prop);
        return prop;
    }

    public LastModified getLastModified() {
        return this.getProperty(LastModified.class);
    }

    public void setLastModified(LastModified lastModified) {
        this.setProperty(LastModified.class, lastModified);
    }

    public LastModified setLastModified(Date lastModified) {
        LastModified prop = lastModified == null ? null : new LastModified(lastModified);
        this.setLastModified(prop);
        return prop;
    }

    public Sequence getSequence() {
        return this.getProperty(Sequence.class);
    }

    public void setSequence(Sequence sequence) {
        this.setProperty(Sequence.class, sequence);
    }

    public Sequence setSequence(Integer sequence) {
        Sequence prop = sequence == null ? null : new Sequence(sequence);
        this.setSequence(prop);
        return prop;
    }

    public void incrementSequence() {
        Sequence sequence = this.getSequence();
        if (sequence == null) {
            this.setSequence(1);
        } else {
            sequence.increment();
        }
    }

    public List<Attachment> getAttachments() {
        return this.getProperties(Attachment.class);
    }

    public void addAttachment(Attachment attachment) {
        this.addProperty(attachment);
    }

    public List<Attendee> getAttendees() {
        return this.getProperties(Attendee.class);
    }

    public void addAttendee(Attendee attendee) {
        this.addProperty(attendee);
    }

    public Attendee addAttendee(String email) {
        Attendee prop = new Attendee(null, email);
        this.addAttendee(prop);
        return prop;
    }

    public List<Categories> getCategories() {
        return this.getProperties(Categories.class);
    }

    public void addCategories(Categories categories) {
        this.addProperty(categories);
    }

    public Categories addCategories(String ... categories) {
        Categories prop = new Categories(categories);
        this.addCategories(prop);
        return prop;
    }

    public Categories addCategories(List<String> categories) {
        Categories prop = new Categories(categories);
        this.addCategories(prop);
        return prop;
    }

    public List<Comment> getComments() {
        return this.getProperties(Comment.class);
    }

    public void addComment(Comment comment) {
        this.addProperty(comment);
    }

    public Comment addComment(String comment) {
        Comment prop = new Comment(comment);
        this.addComment(prop);
        return prop;
    }

    public List<Contact> getContacts() {
        return this.getProperties(Contact.class);
    }

    public void addContact(Contact contact) {
        this.addProperty(contact);
    }

    public Contact addContact(String contact) {
        Contact prop = new Contact(contact);
        this.addContact(prop);
        return prop;
    }

    public List<ExceptionDates> getExceptionDates() {
        return this.getProperties(ExceptionDates.class);
    }

    public void addExceptionDates(ExceptionDates exceptionDates) {
        this.addProperty(exceptionDates);
    }

    public RequestStatus getRequestStatus() {
        return this.getProperty(RequestStatus.class);
    }

    public void setRequestStatus(RequestStatus requestStatus) {
        this.setProperty(RequestStatus.class, requestStatus);
    }

    public List<RelatedTo> getRelatedTo() {
        return this.getProperties(RelatedTo.class);
    }

    public void addRelatedTo(RelatedTo relatedTo) {
        this.addProperty(relatedTo);
    }

    public RelatedTo addRelatedTo(String uid) {
        RelatedTo prop = new RelatedTo(uid);
        this.addRelatedTo(prop);
        return prop;
    }

    public List<Resources> getResources() {
        return this.getProperties(Resources.class);
    }

    public void addResources(Resources resources) {
        this.addProperty(resources);
    }

    public Resources addResources(String ... resources) {
        Resources prop = new Resources(resources);
        this.addResources(prop);
        return prop;
    }

    public Resources addResources(List<String> resources) {
        Resources prop = new Resources(resources);
        this.addResources(prop);
        return prop;
    }

    public List<RecurrenceDates> getRecurrenceDates() {
        return this.getProperties(RecurrenceDates.class);
    }

    public void addRecurrenceDates(RecurrenceDates recurrenceDates) {
        this.addProperty(recurrenceDates);
    }

    public List<VAlarm> getAlarms() {
        return this.getComponents(VAlarm.class);
    }

    public void addAlarm(VAlarm alarm) {
        this.addComponent(alarm);
    }

    public List<ExceptionRule> getExceptionRules() {
        return this.getProperties(ExceptionRule.class);
    }

    public ExceptionRule addExceptionRule(Recurrence recur) {
        ExceptionRule prop = new ExceptionRule(recur);
        this.addExceptionRule(prop);
        return prop;
    }

    public void addExceptionRule(ExceptionRule exceptionRule) {
        this.addProperty(exceptionRule);
    }

    public Color getColor() {
        return this.getProperty(Color.class);
    }

    public void setColor(Color color) {
        this.setProperty(Color.class, color);
    }

    public Color setColor(String color) {
        Color prop = color == null ? null : new Color(color);
        this.setColor(prop);
        return prop;
    }

    public List<Image> getImages() {
        return this.getProperties(Image.class);
    }

    public void addImage(Image image) {
        this.addProperty(image);
    }

    public List<Conference> getConferences() {
        return this.getProperties(Conference.class);
    }

    public void addConference(Conference conference) {
        this.addProperty(conference);
    }

    public DateIterator getDateIterator(TimeZone timezone) {
        return Google2445Utils.getDateIterator(this, timezone);
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
        ICalDate recurrenceId;
        if (version != ICalVersion.V1_0) {
            this.checkRequiredCardinality(warnings, Uid.class, DateTimeStamp.class);
            this.checkOptionalCardinality(warnings, Classification.class, Created.class, Description.class, Geo.class, LastModified.class, Location.class, Organizer.class, Priority.class, Status.class, Summary.class, Transparency.class, Url.class, RecurrenceId.class);
        }
        this.checkOptionalCardinality(warnings, Color.class);
        Status[] validStatuses = this.getValidStatuses(version);
        this.checkStatus(warnings, validStatuses);
        ICalDate dateStart = ValuedProperty.getValue(this.getDateStart());
        ICalDate dateEnd = ValuedProperty.getValue(this.getDateEnd());
        ICalComponent ical = components.get(0);
        if (version != ICalVersion.V1_0 && dateStart == null && ical.getProperty(Method.class) == null) {
            warnings.add(new ValidationWarning(14, new Object[0]));
        }
        if (dateEnd != null && dateStart == null) {
            warnings.add(new ValidationWarning(15, new Object[0]));
        }
        if (dateStart != null && dateEnd != null) {
            if (dateStart.compareTo(dateEnd) > 0) {
                warnings.add(new ValidationWarning(16, new Object[0]));
            }
            if (dateStart.hasTime() != dateEnd.hasTime()) {
                warnings.add(new ValidationWarning(17, new Object[0]));
            }
        }
        if (dateEnd != null && this.getDuration() != null) {
            warnings.add(new ValidationWarning(18, new Object[0]));
        }
        if ((recurrenceId = ValuedProperty.getValue(this.getRecurrenceId())) != null && dateStart != null && dateStart.hasTime() != recurrenceId.hasTime()) {
            warnings.add(new ValidationWarning(19, new Object[0]));
        }
        Recurrence rrule = ValuedProperty.getValue(this.getRecurrenceRule());
        if (!(dateStart == null || rrule == null || dateStart.hasTime() || rrule.getByHour().isEmpty() && rrule.getByMinute().isEmpty() && rrule.getBySecond().isEmpty())) {
            warnings.add(new ValidationWarning(5, new Object[0]));
        }
        if (this.getProperties(RecurrenceRule.class).size() > 1) {
            warnings.add(new ValidationWarning(6, new Object[0]));
        }
    }

    private Status[] getValidStatuses(ICalVersion version) {
        Status[] statusArray;
        if (version == ICalVersion.V1_0) {
            Status[] statusArray2 = new Status[6];
            statusArray2[0] = Status.tentative();
            statusArray2[1] = Status.confirmed();
            statusArray2[2] = Status.declined();
            statusArray2[3] = Status.needsAction();
            statusArray2[4] = Status.sent();
            statusArray = statusArray2;
            statusArray2[5] = Status.delegated();
        } else {
            Status[] statusArray3 = new Status[3];
            statusArray3[0] = Status.tentative();
            statusArray3[1] = Status.confirmed();
            statusArray = statusArray3;
            statusArray3[2] = Status.cancelled();
        }
        return statusArray;
    }

    @Override
    public VEvent copy() {
        return new VEvent(this);
    }
}

