/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.SharedSessionContract;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.mapping.AttributeMetadata;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.DiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.StandardVirtualTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.type.AnyType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;

public class DiscriminatedAssociationAttributeMapping
extends AbstractSingularAttributeMapping
implements DiscriminatedAssociationModelPart {
    private final NavigableRole navigableRole;
    private final DiscriminatedAssociationMapping discriminatorMapping;
    private final SessionFactoryImplementor sessionFactory;

    public DiscriminatedAssociationAttributeMapping(NavigableRole attributeRole, JavaType<?> baseAssociationJtd, ManagedMappingType declaringType, int stateArrayPosition, int fetchableIndex, AttributeMetadata attributeMetadata, FetchTiming fetchTiming, PropertyAccess propertyAccess, Property bootProperty, AnyType anyType, Any bootValueMapping, MappingModelCreationProcess creationProcess) {
        super(bootProperty.getName(), stateArrayPosition, fetchableIndex, attributeMetadata, fetchTiming, FetchStyle.SELECT, declaringType, propertyAccess);
        this.navigableRole = attributeRole;
        this.discriminatorMapping = DiscriminatedAssociationMapping.from(attributeRole, baseAssociationJtd, this, anyType, bootValueMapping, creationProcess);
        this.sessionFactory = creationProcess.getCreationContext().getSessionFactory();
    }

    @Override
    public DiscriminatorMapping getDiscriminatorMapping() {
        return this.discriminatorMapping.getDiscriminatorPart();
    }

    @Override
    public BasicValuedModelPart getKeyPart() {
        return this.discriminatorMapping.getKeyPart();
    }

    @Override
    public EntityMappingType resolveDiscriminatorValue(Object discriminatorValue) {
        return this.discriminatorMapping.resolveDiscriminatorValueToEntityMapping(discriminatorValue);
    }

    @Override
    public Object resolveDiscriminatorForEntityType(EntityMappingType entityMappingType) {
        return this.discriminatorMapping.resolveDiscriminatorValueToEntityMapping(entityMappingType);
    }

    public String toString() {
        return "DiscriminatedAssociationAttributeMapping(" + this.navigableRole + ")@" + System.identityHashCode(this);
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        return this.discriminatorMapping.generateFetch(fetchParent, fetchablePath, fetchTiming, selected, resultVariable, creationState);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return this.discriminatorMapping.createDomainResult(navigablePath, tableGroup, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.discriminatorMapping.getDiscriminatorPart().applySqlSelections(navigablePath, tableGroup, creationState);
        this.discriminatorMapping.getKeyPart().applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.discriminatorMapping.getDiscriminatorPart().applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
        this.discriminatorMapping.getKeyPart().applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public MappingType getMappedType() {
        return this.discriminatorMapping;
    }

    @Override
    public int getNumberOfFetchables() {
        return 2;
    }

    @Override
    public Fetchable getFetchable(int position) {
        switch (position) {
            case 0: {
                assert (this.getDiscriminatorPart().getFetchableKey() == 0);
                return this.getDiscriminatorPart();
            }
            case 1: {
                assert (this.getKeyPart().getFetchableKey() == 1);
                return this.getKeyPart();
            }
        }
        throw new IndexOutOfBoundsException(position);
    }

    @Override
    public String getContainingTableExpression() {
        return this.getDiscriminatorPart().getContainingTableExpression();
    }

    @Override
    public int getJdbcTypeCount() {
        return this.getDiscriminatorPart().getJdbcTypeCount() + this.getKeyPart().getJdbcTypeCount();
    }

    @Override
    public JdbcMapping getJdbcMapping(int index) {
        switch (index) {
            case 0: {
                return this.discriminatorMapping.getDiscriminatorPart().getJdbcMapping();
            }
            case 1: {
                return this.discriminatorMapping.getKeyPart().getJdbcMapping();
            }
        }
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    public SelectableMapping getSelectable(int columnIndex) {
        if (columnIndex == 0) {
            return this.getDiscriminatorPart();
        }
        return this.getKeyPart();
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        EntityMappingType concreteMappingType = this.determineConcreteType(value, session);
        EntityIdentifierMapping identifierMapping = concreteMappingType.getIdentifierMapping();
        Object discriminator = this.discriminatorMapping.getModelPart().resolveDiscriminatorForEntityType(concreteMappingType);
        Object identifier = identifierMapping.getIdentifier(value);
        return new Object[]{this.discriminatorMapping.getDiscriminatorPart().disassemble(discriminator, session), identifierMapping.disassemble(identifier, session)};
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        if (value == null) {
            cacheKey.addValue(null);
            cacheKey.addHashCode(0);
        } else {
            EntityMappingType concreteMappingType = this.determineConcreteType(value, session);
            Object discriminator = this.discriminatorMapping.getModelPart().resolveDiscriminatorForEntityType(concreteMappingType);
            this.discriminatorMapping.getDiscriminatorPart().addToCacheKey(cacheKey, discriminator, session);
            EntityIdentifierMapping identifierMapping = concreteMappingType.getIdentifierMapping();
            identifierMapping.addToCacheKey(cacheKey, identifierMapping.getIdentifier(value), session);
        }
    }

    private EntityMappingType determineConcreteType(Object entity, SharedSessionContractImplementor session) {
        String entityName = session == null ? this.sessionFactory.bestGuessEntityName(entity) : session.bestGuessEntityName(entity);
        return this.sessionFactory.getRuntimeMetamodels().getEntityMappingType(entityName);
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        this.discriminatorMapping.getDiscriminatorPart().forEachSelectable(offset, consumer);
        this.discriminatorMapping.getKeyPart().forEachSelectable(offset + 1, consumer);
        return 2;
    }

    @Override
    public int forEachJdbcType(IndexedConsumer<JdbcMapping> action) {
        action.accept(0, this.discriminatorMapping.getDiscriminatorPart().getJdbcMapping());
        action.accept(1, this.discriminatorMapping.getKeyPart().getJdbcMapping());
        return 2;
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        if (value == null) {
            valuesConsumer.consume(offset, x, y, null, this.discriminatorMapping.getDiscriminatorPart().getJdbcMapping());
            valuesConsumer.consume(offset + 1, x, y, null, this.discriminatorMapping.getKeyPart().getJdbcMapping());
        } else if (value.getClass().isArray()) {
            Object[] values = (Object[])value;
            valuesConsumer.consume(offset, x, y, values[0], this.discriminatorMapping.getDiscriminatorPart().getJdbcMapping());
            valuesConsumer.consume(offset + 1, x, y, values[1], this.discriminatorMapping.getKeyPart().getJdbcMapping());
        } else {
            EntityMappingType concreteMappingType = this.determineConcreteType(value, session);
            Object discriminator = this.discriminatorMapping.getModelPart().resolveDiscriminatorForEntityType(concreteMappingType);
            Object disassembledDiscriminator = this.discriminatorMapping.getDiscriminatorPart().disassemble(discriminator, session);
            valuesConsumer.consume(offset, x, y, disassembledDiscriminator, this.discriminatorMapping.getDiscriminatorPart().getJdbcMapping());
            EntityIdentifierMapping identifierMapping = concreteMappingType.getIdentifierMapping();
            Object identifier = identifierMapping.getIdentifier(value);
            Object disassembledKey = this.discriminatorMapping.getKeyPart().disassemble(identifier, session);
            valuesConsumer.consume(offset + 1, x, y, disassembledKey, this.discriminatorMapping.getKeyPart().getJdbcMapping());
        }
        return 2;
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        return this.discriminatorMapping.breakDownJdbcValues(offset, x, y, domainValue, valueConsumer, session);
    }

    @Override
    public <X, Y> int decompose(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        return this.discriminatorMapping.decompose(offset, x, y, domainValue, valueConsumer, session);
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        int span = this.getDiscriminatorPart().forEachJdbcType(offset, action);
        return span + this.getKeyPart().forEachJdbcType(offset + span, action);
    }

    @Override
    public void visitFetchables(Consumer<? super Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
        fetchableConsumer.accept(this.getDiscriminatorPart());
        fetchableConsumer.accept(this.getKeyPart());
    }

    @Override
    public void visitFetchables(IndexedConsumer<? super Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
        this.forEachSubPart(fetchableConsumer, treatTargetType);
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        return this.discriminatorMapping.findSubPart(name, treatTargetType);
    }

    @Override
    public void forEachSubPart(IndexedConsumer<ModelPart> consumer, EntityMappingType treatTarget) {
        consumer.accept(0, this.getDiscriminatorPart());
        consumer.accept(1, this.getKeyPart());
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        consumer.accept(this.getDiscriminatorPart());
        consumer.accept(this.getKeyPart());
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return this.discriminatorMapping.getDiscriminatorPart().isPartitioned() || this.discriminatorMapping.getKeyPart().isPartitioned();
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, @Nullable String explicitSourceAlias, @Nullable SqlAliasBase explicitSqlAliasBase, @Nullable SqlAstJoinType requestedJoinType, boolean fetched, boolean addsPredicate, SqlAstCreationState creationState) {
        SqlAstJoinType joinType = Objects.requireNonNullElse(requestedJoinType, SqlAstJoinType.INNER);
        TableGroup tableGroup = this.createRootTableGroupJoin(navigablePath, lhs, explicitSourceAlias, explicitSqlAliasBase, requestedJoinType, fetched, null, creationState);
        return new TableGroupJoin(navigablePath, joinType, tableGroup);
    }

    @Override
    public TableGroup createRootTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, @Nullable String explicitSourceAlias, @Nullable SqlAliasBase explicitSqlAliasBase, @Nullable SqlAstJoinType sqlAstJoinType, boolean fetched, @Nullable Consumer<Predicate> predicateConsumer, SqlAstCreationState creationState) {
        return new StandardVirtualTableGroup(navigablePath, this, lhs, fetched);
    }

    @Override
    public SqlAstJoinType getDefaultSqlAstJoinType(TableGroup parentTableGroup) {
        return SqlAstJoinType.LEFT;
    }

    @Override
    public String getSqlAliasStem() {
        return this.getAttributeName();
    }

    @Override
    public void applyDiscriminator(Consumer<Predicate> predicateConsumer, String alias, TableGroup tableGroup, SqlAstCreationState creationState) {
        throw new UnsupportedOperationException();
    }

    public static class MutabilityPlanImpl
    implements MutabilityPlan<Object> {
        private final AnyType anyType;

        public MutabilityPlanImpl(AnyType anyType) {
            this.anyType = anyType;
        }

        @Override
        public boolean isMutable() {
            return this.anyType.isMutable();
        }

        @Override
        public Object deepCopy(Object value) {
            return value;
        }

        @Override
        public Serializable disassemble(Object value, SharedSessionContract session) {
            SharedSessionContractImplementor persistenceContext = (SharedSessionContractImplementor)session;
            return this.anyType.disassemble(value, persistenceContext, null);
        }

        @Override
        public Object assemble(Serializable cached, SharedSessionContract session) {
            SharedSessionContractImplementor persistenceContext = (SharedSessionContractImplementor)session;
            return this.anyType.assemble(cached, persistenceContext, null);
        }
    }
}

