/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.event.shared.testing;

import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.HandlerRegistration;
import com.google.web.bindery.event.shared.SimpleEventBus;
import java.util.HashMap;
import java.util.Map;

public class CountingEventBus
extends EventBus {
    private final KeyedCounter<Event.Type<?>> handlerCounts = new KeyedCounter();
    private final KeyedCounter<Event.Type<?>> firedCounts = new KeyedCounter();
    private final KeyedCounter<TypeSourcePair> sourceCounts = new KeyedCounter();
    private final EventBus wrapped;

    public CountingEventBus() {
        this(new SimpleEventBus());
    }

    public CountingEventBus(EventBus wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public <H> HandlerRegistration addHandler(Event.Type<H> type, H handler) {
        HandlerRegistration superReg = this.wrapped.addHandler(type, handler);
        this.handlerCounts.increment(type);
        return this.makeReg(type, superReg);
    }

    @Override
    public <H> HandlerRegistration addHandlerToSource(Event.Type<H> type, Object source, H handler) {
        HandlerRegistration superReg = this.wrapped.addHandlerToSource(type, source, handler);
        this.handlerCounts.increment(type);
        return this.makeReg(type, superReg);
    }

    @Override
    public void fireEvent(Event<?> event) {
        this.wrapped.fireEvent(event);
        this.firedCounts.increment(event.getAssociatedType());
        this.sourceCounts.increment(new TypeSourcePair(event.getAssociatedType(), null));
    }

    @Override
    public void fireEventFromSource(Event<?> event, Object source) {
        this.wrapped.fireEventFromSource(event, source);
        this.firedCounts.increment(event.getAssociatedType());
        this.sourceCounts.increment(new TypeSourcePair(event.getAssociatedType(), source));
    }

    @Deprecated
    public int getCount(Event.Type<?> type) {
        return this.getHandlerCount(type);
    }

    public int getFiredCount(Event.Type<?> type) {
        return this.firedCounts.getCount(type);
    }

    public int getFiredCountFromSource(Event.Type<?> type, Object source) {
        return this.sourceCounts.getCount(new TypeSourcePair(type, source));
    }

    public int getHandlerCount(Event.Type<?> type) {
        return this.handlerCounts.getCount(type);
    }

    private <H> HandlerRegistration makeReg(final Event.Type<H> type, final HandlerRegistration superReg) {
        return new HandlerRegistration(){
            final /* synthetic */ CountingEventBus this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void removeHandler() {
                this.this$0.handlerCounts.decrement(type);
                superReg.removeHandler();
            }
        };
    }

    private class KeyedCounter<K> {
        private Map<K, Integer> counts = new HashMap<K, Integer>();

        private KeyedCounter() {
        }

        int getCount(K key) {
            Integer count = this.counts.get(key);
            return count == null ? 0 : count;
        }

        void decrement(K key) {
            this.counts.put(key, this.getCount(key) - 1);
        }

        void increment(K key) {
            this.counts.put(key, this.getCount(key) + 1);
        }
    }

    private class TypeSourcePair {
        final Event.Type<?> type;
        final Object source;

        TypeSourcePair(Event.Type<?> type, Object source) {
            this.type = type;
            this.source = source;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeSourcePair)) {
                return false;
            }
            TypeSourcePair pair = (TypeSourcePair)o;
            return this.doNullEquals(this.type, pair.type) && this.doNullEquals(this.source, pair.source);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + (this.type == null ? 0 : this.type.hashCode());
            hash = hash * 31 + (this.source == null ? 0 : this.source.hashCode());
            return hash;
        }

        private boolean doNullEquals(Object a, Object b) {
            if (a == null ^ b == null) {
                return false;
            }
            return a == null && b == null || a.equals(b);
        }
    }
}

