/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.impl;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.impl.SerializabilityUtil;
import com.google.gwt.user.server.rpc.impl.TypeNameObfuscator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.TooManyListenersException;
import java.util.Vector;

public class LegacySerializationPolicy
extends SerializationPolicy
implements TypeNameObfuscator {
    private static final String ELISION_ERROR = "Type name elision in RPC payloads is only supported if the RPC whitelist file is used.";
    private static final Class<?>[] JRE_BLACKLIST = new Class[]{ArrayStoreException.class, AssertionError.class, Boolean.class, Byte.class, Character.class, Class.class, ClassCastException.class, Double.class, Error.class, Float.class, IllegalArgumentException.class, IllegalStateException.class, IndexOutOfBoundsException.class, Integer.class, Long.class, NegativeArraySizeException.class, NullPointerException.class, Number.class, NumberFormatException.class, Short.class, StackTraceElement.class, String.class, StringBuffer.class, StringIndexOutOfBoundsException.class, UnsupportedOperationException.class, ArrayList.class, ConcurrentModificationException.class, Date.class, EmptyStackException.class, EventObject.class, HashMap.class, HashSet.class, MissingResourceException.class, NoSuchElementException.class, Stack.class, TooManyListenersException.class, Vector.class};
    private static final Set<Class<?>> JRE_BLACKSET = new HashSet(Arrays.asList(JRE_BLACKLIST));
    private static final LegacySerializationPolicy sInstance = new LegacySerializationPolicy();

    public static LegacySerializationPolicy getInstance() {
        return sInstance;
    }

    private LegacySerializationPolicy() {
    }

    @Override
    public final String getClassNameForTypeId(String id) throws SerializationException {
        throw new SerializationException(ELISION_ERROR);
    }

    @Override
    public final String getTypeIdForClass(Class<?> clazz) throws SerializationException {
        throw new SerializationException(ELISION_ERROR);
    }

    @Override
    public boolean shouldDeserializeFields(Class<?> clazz) {
        return this.isFieldSerializable(clazz);
    }

    @Override
    public boolean shouldSerializeFields(Class<?> clazz) {
        return this.isFieldSerializable(clazz);
    }

    @Override
    public void validateDeserialize(Class<?> clazz) throws SerializationException {
        if (!this.isInstantiable(clazz)) {
            throw new SerializationException("Type '" + clazz.getName() + "' was not assignable to '" + IsSerializable.class.getName() + "' and did not have a custom field serializer. For security purposes, this type will not be deserialized.");
        }
    }

    @Override
    public void validateSerialize(Class<?> clazz) throws SerializationException {
        if (!this.isInstantiable(clazz)) {
            throw new SerializationException("Type '" + clazz.getName() + "' was not assignable to '" + IsSerializable.class.getName() + "' and did not have a custom field serializer.For security purposes, this type will not be serialized.");
        }
    }

    private boolean isFieldSerializable(Class<?> clazz) {
        if (this.isInstantiable(clazz)) {
            return true;
        }
        if (Serializable.class.isAssignableFrom(clazz)) {
            return !JRE_BLACKSET.contains(clazz);
        }
        return false;
    }

    private boolean isInstantiable(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz.isArray()) {
            return this.isInstantiable(clazz.getComponentType());
        }
        if (IsSerializable.class.isAssignableFrom(clazz)) {
            return true;
        }
        return SerializabilityUtil.hasCustomFieldSerializer(clazz) != null;
    }

    @Override
    public boolean hasClientFields() {
        return false;
    }
}

