/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.local;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.ReferenceList;
import org.restlet.data.Status;
import org.restlet.engine.local.Entity;
import org.restlet.engine.util.StringUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Directory;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;

public class DirectoryServerResource
extends ServerResource {
    private volatile List<Variant> variantsGet;
    private volatile String baseName;
    private volatile Variant baseVariant;
    private volatile Restlet directoryClientDispatcher;
    private volatile Directory directory;
    private volatile ReferenceList directoryContent;
    private volatile boolean directoryRedirection;
    private volatile boolean directoryTarget;
    private volatile String directoryUri;
    private volatile Representation fileContent;
    private volatile boolean fileTarget;
    private volatile boolean indexTarget;
    private volatile Reference originalRef;
    private volatile Variant protoVariant;
    private volatile String relativePart;
    private volatile String targetUri;
    private volatile Reference uniqueReference;

    @Override
    public Representation delete() throws ResourceException {
        if (!this.directory.isModifiable()) {
            this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED, "The directory is not modifiable.");
            return null;
        }
        Request contextRequest = new Request(Method.DELETE, this.targetUri);
        Response contextResponse = new Response(contextRequest);
        if (this.directoryTarget && !this.indexTarget) {
            contextRequest.setResourceRef(this.targetUri);
            this.dispatchRequest(contextRequest, contextResponse);
            this.setStatus(contextResponse.getStatus());
            return null;
        }
        ReferenceList references = this.getVariantsReferences();
        if (references.isEmpty()) {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        } else if (this.uniqueReference != null) {
            contextRequest.setResourceRef(this.uniqueReference);
            this.dispatchRequest(contextRequest, contextResponse);
            this.setStatus(contextResponse.getStatus());
        } else {
            this.setStatus(Status.CLIENT_ERROR_NOT_ACCEPTABLE, "Unable to process properly the request. Several variants exist but none of them suits precisely. ");
        }
        return null;
    }

    @Override
    public void doInit() throws ResourceException {
        int index;
        this.directory = (Directory)this.getRequestAttributes().get("org.restlet.directory");
        Restlet restlet = this.directoryClientDispatcher = this.getDirectory().getContext() != null ? this.getDirectory().getContext().getClientDispatcher() : null;
        if (this.getClientDispatcher() == null) {
            this.getLogger().warning("No client dispatcher is available. Can't get the target URI: " + this.targetUri);
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "No client dispatcher is available.");
        }
        this.setNegotiated(this.directory.isNegotiatingContent());
        this.relativePart = this.getReference().getRemainingPart(false, false);
        this.originalRef = this.getOriginalRef();
        if (this.originalRef != null && this.getApplication() != null && this.getApplication().getTunnelService().isExtensionsTunnel()) {
            Reference originalBaseRef = new Reference(this.originalRef);
            originalBaseRef.setPath(this.getReference().getBaseRef().getPath());
            this.originalRef.setBaseRef(originalBaseRef);
            this.relativePart = this.originalRef.getRemainingPart(false, false);
        }
        if (this.relativePart.startsWith("/")) {
            this.relativePart = this.relativePart.substring(1);
        }
        this.targetUri = new Reference(this.directory.getRootRef().toString() + this.relativePart).toString(false, false);
        this.preventUpperDirectoryAccess();
        Response contextResponse = this.getRepresentation(this.targetUri);
        if (contextResponse.getEntity() != null) {
            if (MediaType.TEXT_URI_LIST.equals(contextResponse.getEntity().getMediaType())) {
                this.directoryTarget = true;
                this.fileTarget = false;
                this.directoryContent = this.tryToConvertAsReferenceList(contextResponse.getEntity());
                if (!this.getReference().getPath().endsWith("/")) {
                    this.directoryRedirection = true;
                }
                if (!this.targetUri.endsWith("/")) {
                    this.targetUri = this.targetUri + "/";
                    this.relativePart = this.relativePart + "/";
                }
                if (!StringUtils.isNullOrEmpty(this.getDirectory().getIndexName())) {
                    this.directoryUri = this.targetUri;
                    this.baseName = this.getDirectory().getIndexName();
                    this.targetUri = this.directoryUri + this.baseName;
                    this.indexTarget = true;
                } else {
                    this.directoryUri = this.targetUri;
                    this.baseName = null;
                }
            } else {
                this.directoryTarget = false;
                this.fileTarget = true;
                this.fileContent = contextResponse.getEntity();
            }
        } else {
            this.directoryTarget = false;
            this.fileTarget = false;
            if (this.targetUri.endsWith("/")) {
                if (!StringUtils.isNullOrEmpty(this.getDirectory().getIndexName())) {
                    this.directoryUri = this.targetUri;
                    this.directoryTarget = true;
                    contextResponse = this.getRepresentation(this.directoryUri + this.getDirectory().getIndexName());
                    if (contextResponse.getEntity() != null) {
                        this.baseName = this.getDirectory().getIndexName();
                        this.targetUri = this.directoryUri + this.baseName;
                        this.directoryContent = new ReferenceList();
                        this.directoryContent.add(new Reference(this.targetUri));
                        this.indexTarget = true;
                    }
                }
            } else if (!StringUtils.isNullOrEmpty(this.getDirectory().getIndexName()) && (contextResponse = this.getRepresentation(this.targetUri + "/" + this.getDirectory().getIndexName())).getEntity() != null) {
                this.directoryUri = this.targetUri + "/";
                this.baseName = this.getDirectory().getIndexName();
                this.targetUri = this.directoryUri + this.baseName;
                this.directoryTarget = true;
                this.directoryRedirection = true;
                this.directoryContent = new ReferenceList();
                this.directoryContent.add(new Reference(this.targetUri));
                this.indexTarget = true;
            }
        }
        if (this.isNegotiated() && !this.directoryTarget && !this.fileTarget && this.originalRef != null) {
            this.relativePart = this.getReference().getRemainingPart();
            this.targetUri = new Reference(this.directory.getRootRef().toString() + this.relativePart).normalize().toString(false, false);
            if (!this.targetUri.startsWith(this.directory.getRootRef().toString())) {
                this.targetUri = this.directory.getRootRef().toString();
            }
        }
        if (!this.fileTarget || this.fileContent == null || !this.getRequest().getMethod().isSafe()) {
            List<Variant> variants;
            if (!this.directoryTarget) {
                int lastSlashIndex = this.targetUri.lastIndexOf(47);
                if (lastSlashIndex == -1) {
                    this.directoryUri = "";
                    this.baseName = this.targetUri;
                } else {
                    this.directoryUri = this.targetUri.substring(0, lastSlashIndex + 1);
                    this.baseName = this.targetUri.substring(lastSlashIndex + 1);
                }
                contextResponse = this.getRepresentation(this.directoryUri);
                if (contextResponse.getEntity() != null && MediaType.TEXT_URI_LIST.equals(contextResponse.getEntity().getMediaType())) {
                    this.directoryContent = this.tryToConvertAsReferenceList(contextResponse.getEntity());
                }
            }
            if (this.baseName != null) {
                this.baseVariant = new Variant();
                Entity.updateMetadata(this.baseName, this.baseVariant, true, this.getMetadataService());
                this.protoVariant = new Variant();
                Entity.updateMetadata(this.baseName, this.protoVariant, false, this.getMetadataService());
                this.baseName = Entity.getBaseName(this.baseName, this.getMetadataService());
            }
            if ((variants = this.getVariants(Method.GET)) == null || variants.isEmpty()) {
                this.setExisting(false);
            }
        }
        if (this.isExisting() && !this.directory.isDeeplyAccessible() && (index = this.relativePart.indexOf("/")) != -1) {
            this.setExisting((index = this.relativePart.indexOf("/", index)) == -1);
        }
        this.getLogger().fine("Converted target URI: " + this.targetUri);
        this.getLogger().fine("Converted base name : " + this.baseName);
    }

    private ReferenceList tryToConvertAsReferenceList(Representation entity) throws ResourceException {
        try {
            return new ReferenceList(entity);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    @Override
    protected Representation get() throws ResourceException {
        List<Variant> variants = this.getVariants(Method.GET);
        if (variants == null || variants.isEmpty()) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (variants.size() == 1) {
            return (Representation)variants.get(0);
        }
        ReferenceList variantRefs = new ReferenceList();
        for (Variant variant : variants) {
            if (variant.getLocationRef() != null) {
                variantRefs.add(variant.getLocationRef());
                continue;
            }
            this.getLogger().warning("A resource with multiple variants should provide a location for each variant when content negotiation is turned off");
        }
        if (!variantRefs.isEmpty()) {
            this.setStatus(Status.REDIRECTION_MULTIPLE_CHOICES);
            return variantRefs.getTextRepresentation();
        }
        throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
    }

    public String getBaseName() {
        return this.baseName;
    }

    protected Restlet getClientDispatcher() {
        return this.directoryClientDispatcher;
    }

    public Directory getDirectory() {
        return this.directory;
    }

    protected ReferenceList getDirectoryContent() {
        return this.directoryContent;
    }

    public String getDirectoryUri() {
        return this.directoryUri;
    }

    private Response getRepresentation(String resourceUri) {
        return this.dispatchRequest(new Request(Method.GET, resourceUri));
    }

    protected Response getRepresentation(String resourceUri, MediaType acceptedMediaType) {
        Request request = new Request(Method.GET, resourceUri);
        if (acceptedMediaType != null) {
            request.getClientInfo().accept(acceptedMediaType);
        }
        return this.dispatchRequest(request);
    }

    private Comparator<Representation> getRepresentationsComparator() {
        Comparator<Representation> identifiersComparator = new Comparator<Representation>(){

            @Override
            public int compare(Representation rep0, Representation rep1) {
                boolean bRep1Null;
                boolean bRep0Null = rep0.getLocationRef() == null;
                boolean bl = bRep1Null = rep1.getLocationRef() == null;
                if (bRep0Null && bRep1Null) {
                    return 0;
                }
                if (bRep0Null) {
                    return -1;
                }
                if (bRep1Null) {
                    return 1;
                }
                return rep0.getLocationRef().getLastSegment().compareTo(rep1.getLocationRef().getLastSegment());
            }
        };
        return identifiersComparator;
    }

    public String getTargetUri() {
        return this.targetUri;
    }

    @Override
    public List<Variant> getVariants() {
        return this.getVariants(this.getMethod());
    }

    @Override
    protected List<Variant> getVariants(Method method) {
        if (!Method.GET.equals(method) && !Method.HEAD.equals(method)) {
            return null;
        }
        if (this.variantsGet != null) {
            return this.variantsGet;
        }
        this.getLogger().fine("Getting variants for: " + this.getTargetUri());
        if (this.fileTarget && this.fileContent != null) {
            if (this.getOriginalRef() != null) {
                this.fileContent.setLocationRef(this.getRequest().getOriginalRef());
            } else {
                this.fileContent.setLocationRef(this.getReference());
            }
            this.variantsGet = Arrays.asList(this.fileContent);
            return this.variantsGet;
        }
        if (this.directoryContent != null && this.getReference() != null && this.getReference().getBaseRef() != null) {
            TreeSet<Representation> resultSet = new TreeSet<Representation>(this.getRepresentationsComparator());
            String baseReference = this.getVariantsBaseReference();
            int rootLength = this.getDirectoryUri().length();
            if (this.baseName != null) {
                for (Object ref : this.getVariantsReferences()) {
                    Response contextResponse = this.getRepresentation(((Reference)ref).toString());
                    if (!contextResponse.getStatus().isSuccess() || contextResponse.getEntity() == null) continue;
                    String filePath = ((Reference)ref).toString(false, false).substring(rootLength);
                    Representation rep = contextResponse.getEntity();
                    if (filePath.startsWith("/")) {
                        rep.setLocationRef(baseReference + filePath);
                    } else {
                        rep.setLocationRef(baseReference + "/" + filePath);
                    }
                    resultSet.add(rep);
                }
            }
            if (!resultSet.isEmpty()) {
                this.variantsGet = new ArrayList<Representation>(resultSet);
                return this.variantsGet;
            }
            if (this.directoryTarget && this.getDirectory().isListingAllowed()) {
                ReferenceList userList = new ReferenceList(this.directoryContent.size());
                userList.setIdentifier(baseReference);
                TreeSet<Reference> sortedSet = new TreeSet<Reference>(this.getDirectory().getComparator());
                sortedSet.addAll(this.directoryContent);
                for (Reference ref : sortedSet) {
                    String filePart = ref.toString(false, false).substring(rootLength);
                    StringBuilder filePath = new StringBuilder();
                    if (!baseReference.endsWith("/") && !filePart.startsWith("/")) {
                        filePath.append('/');
                    }
                    filePath.append(filePart);
                    userList.add(baseReference + filePath);
                }
                List<Variant> list = this.getDirectory().getIndexVariants(userList);
                if (list != null && !list.isEmpty()) {
                    this.variantsGet = new ArrayList<Variant>();
                    for (Variant variant : list) {
                        this.variantsGet.add(this.getDirectory().getIndexRepresentation(variant, userList));
                    }
                }
            }
        }
        return this.variantsGet;
    }

    private String getVariantsBaseReference() {
        int lastIndex;
        String baseRef = this.getReference().getBaseRef().toString(false, false);
        if (!baseRef.endsWith("/")) {
            baseRef = baseRef + "/";
        }
        if ((lastIndex = this.relativePart.lastIndexOf("/")) != -1) {
            baseRef = baseRef + this.relativePart.substring(0, lastIndex);
        }
        return baseRef;
    }

    private ReferenceList getVariantsReferences() {
        ReferenceList listVariants;
        this.uniqueReference = null;
        Response contextResponse = this.getRepresentation(this.targetUri, MediaType.TEXT_URI_LIST);
        if (contextResponse.getEntity() == null) {
            return new ReferenceList(0);
        }
        if (!MediaType.TEXT_URI_LIST.equals(contextResponse.getEntity().getMediaType())) {
            this.uniqueReference = contextResponse.getEntity().getLocationRef();
            return new ReferenceList(Arrays.asList(contextResponse.getEntity().getLocationRef()));
        }
        try {
            listVariants = new ReferenceList(contextResponse.getEntity());
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Unable to get resource variants", ioe);
            return new ReferenceList(0);
        }
        ReferenceList variantsReferences = new ReferenceList(0);
        for (Reference variantReference : listVariants) {
            String baseEntryName;
            String entryUri = variantReference.toString();
            int lastSlashIndex = entryUri.lastIndexOf(47);
            String fullEntryName = lastSlashIndex == -1 ? entryUri : entryUri.substring(lastSlashIndex + 1);
            int firstDotIndex = fullEntryName.indexOf(46);
            String string = baseEntryName = firstDotIndex != -1 ? fullEntryName.substring(0, firstDotIndex) : fullEntryName;
            if (!baseEntryName.equals(this.baseName)) continue;
            Variant variant = new Variant();
            Entity.updateMetadata(fullEntryName, variant, true, this.getMetadataService());
            if (!this.protoVariant.includes(variant)) continue;
            variantsReferences.add(variantReference);
            if (!variant.equals(this.baseVariant)) continue;
            this.uniqueReference = variantReference;
        }
        return variantsReferences;
    }

    @Override
    public Representation handle() {
        Reference directoryReference;
        if (!this.directoryRedirection) {
            return super.handle();
        }
        Reference reference = directoryReference = this.originalRef != null ? this.originalRef : this.getReference().getTargetRef();
        if (directoryReference.hasQuery()) {
            this.redirectSeeOther(directoryReference.toString(false, false) + "/?" + directoryReference.getQuery());
        } else {
            this.redirectSeeOther(directoryReference.toString(false, false) + "/");
        }
        return null;
    }

    public boolean isDirectoryTarget() {
        return this.directoryTarget;
    }

    public boolean isFileTarget() {
        return this.fileTarget;
    }

    private Response dispatchRequest(Request request) {
        Response response = new Response(request);
        this.dispatchRequest(request, response);
        if (response.getStatus().equals(Status.CLIENT_ERROR_FORBIDDEN)) {
            throw new ResourceException(response.getStatus());
        }
        return response;
    }

    private void dispatchRequest(Request request, Response response) {
        request.getAttributes().put("org.restlet.directory", this.directory);
        this.getClientDispatcher().handle(request, response);
    }

    public void preventUpperDirectoryAccess() {
        String targetUriPath = Reference.decode(this.targetUri);
        if (!targetUriPath.startsWith(Reference.decode(this.directory.getRootRef().toString()))) {
            throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN);
        }
    }

    @Override
    public Representation put(Representation entity) throws ResourceException {
        if (!this.directory.isModifiable()) {
            this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED, "The directory is not modifiable.");
            return null;
        }
        Request contextRequest = new Request(Method.PUT, this.targetUri);
        contextRequest.getRanges().addAll(this.getRanges());
        contextRequest.setEntity(entity);
        Response contextResponse = new Response(contextRequest);
        contextRequest.setResourceRef(this.targetUri);
        this.dispatchRequest(contextRequest, contextResponse);
        this.setStatus(contextResponse.getStatus());
        return null;
    }

    public void setTargetUri(String targetUri) {
        this.targetUri = targetUri;
    }
}

