/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online.expectations;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.OnlineConfig;
import org.cpsolver.studentsct.online.OnlineSection;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;

public class PercentageOverExpected
implements OverExpectedCriterion {
    private Double iPercentage = null;
    private Rounding iRounding = Rounding.ROUND;

    public PercentageOverExpected(DataProperties config) {
        this.iPercentage = config.getPropertyDouble("OverExpected.Percentage", this.iPercentage);
        this.iRounding = Rounding.valueOf(config.getProperty("OverExpected.Rounding", this.iRounding.name()).toUpperCase());
    }

    public PercentageOverExpected(Double percentage) {
        this.iPercentage = percentage;
    }

    public PercentageOverExpected() {
        this((Double)null);
    }

    public double getPercentage() {
        return this.iPercentage == null ? 1.0 : this.iPercentage;
    }

    public void setPercentage(Double percentage) {
        this.iPercentage = percentage;
    }

    protected double round(double value) {
        switch (this.iRounding) {
            case CEIL: {
                return Math.ceil(value);
            }
            case FLOOR: {
                return Math.floor(value);
            }
            case ROUND: {
                return Math.round(value);
            }
        }
        return value;
    }

    protected boolean hasExpectations(Subpart subpart) {
        for (Section section : subpart.getSections()) {
            if (!(this.round(section.getSpaceExpected()) > 0.0)) continue;
            return true;
        }
        return false;
    }

    protected double getEnrollment(Assignment<Request, Enrollment> assignment, Config config, Request request) {
        if (config instanceof OnlineConfig) {
            return ((OnlineConfig)config).getEnrollment();
        }
        return config.getEnrollmentWeight(assignment, request);
    }

    protected double getEnrollment(Assignment<Request, Enrollment> assignment, Section section, Request request) {
        if (section instanceof OnlineSection) {
            return ((OnlineSection)section).getEnrollment();
        }
        return section.getEnrollmentWeight(assignment, request);
    }

    protected int getLimit(Section section) {
        if (section.getLimit() < 0) {
            return section.getLimit();
        }
        if (section instanceof OnlineSection) {
            return section.getLimit() + ((OnlineSection)section).getEnrollment();
        }
        return section.getLimit();
    }

    protected int getLimit(Subpart subpart) {
        int limit = subpart.getLimit();
        if (limit < 0) {
            return limit;
        }
        if (subpart.getConfig() instanceof OnlineConfig) {
            limit += ((OnlineConfig)subpart.getConfig()).getEnrollment();
        }
        return limit;
    }

    @Override
    public double getOverExpected(Assignment<Request, Enrollment> assignment, Section section, Request request) {
        if (section.getLimit() <= 0) {
            return 0.0;
        }
        double expected = this.round(this.getPercentage() * section.getSpaceExpected());
        double enrolled = this.getEnrollment(assignment, section, request) + request.getWeight();
        double limit = this.getLimit(section);
        int subparts = section.getSubpart().getConfig().getSubparts().size();
        return expected + enrolled > limit ? 1.0 / (double)subparts : 0.0;
    }

    @Override
    public Integer getExpected(int sectionLimit, double expectedSpace) {
        if (sectionLimit <= 0) {
            return null;
        }
        double expected = this.round(this.getPercentage() * expectedSpace);
        if (expected > 0.0) {
            return (int)Math.floor(expected);
        }
        return null;
    }

    public String toString() {
        return "perc(" + this.getPercentage() + ")";
    }

    public static enum Rounding {
        NONE,
        CEIL,
        FLOOR,
        ROUND;

    }
}

