/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.studentord;

import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.heuristics.studentord.StudentChoiceOrder;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class StudentByRequestDate
extends StudentChoiceOrder {
    public StudentByRequestDate(DataProperties config) {
        super(config);
    }

    public Long getRequestDate(Student s) {
        long total = 0L;
        long cnt = 0L;
        for (Request r : s.getRequests()) {
            CourseRequest cr;
            if (!(r instanceof CourseRequest) || (cr = (CourseRequest)r).getTimeStamp() == null) continue;
            total += cr.getTimeStamp().longValue();
            ++cnt;
        }
        if (cnt > 0L) {
            return total / cnt;
        }
        return Long.MAX_VALUE;
    }

    @Override
    public int compare(Student s1, Student s2) {
        int cmp = this.getRequestDate(s1).compareTo(this.getRequestDate(s2));
        if (cmp != 0) {
            return (this.isReverse() ? -1 : 1) * cmp;
        }
        return -super.compare(s1, s2);
    }
}

