/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.example.jobshop;

import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.example.jobshop.Location;
import org.cpsolver.ifs.example.jobshop.Operation;
import org.cpsolver.ifs.model.Constraint;

public class Job
extends Constraint<Operation, Location> {
    private int iJobNumber = 0;
    private int iDueTime = -1;

    public Job(int jobNumber) {
        this.iJobNumber = jobNumber;
    }

    public void setDueTime(int dueTime) {
        this.iDueTime = dueTime;
    }

    public int getDueTime() {
        return this.iDueTime;
    }

    public int getJobNumner() {
        return this.iJobNumber;
    }

    public int countOperations() {
        return this.variables().size();
    }

    public Operation getOperation(int opNumber) {
        return (Operation)this.variables().get(opNumber);
    }

    @Override
    public void computeConflicts(Assignment<Operation, Location> assignment, Location location, Set<Location> conflicts) {
        for (Operation o : this.assignedVariables(assignment)) {
            if (o.getOperationNumber() == ((Operation)location.variable()).getOperationNumber()) continue;
            Location l = assignment.getValue(o);
            if (o.getOperationNumber() < ((Operation)location.variable()).getOperationNumber()) {
                if (l.before(location)) continue;
                conflicts.add(l);
                continue;
            }
            if (l.after(location)) continue;
            conflicts.add(l);
        }
    }

    @Override
    public boolean inConflict(Assignment<Operation, Location> assignment, Location location) {
        for (Operation o : this.assignedVariables(assignment)) {
            if (o.getOperationNumber() == ((Operation)location.variable()).getOperationNumber()) continue;
            Location l = assignment.getValue(o);
            if (!(o.getOperationNumber() < ((Operation)location.variable()).getOperationNumber() ? !l.before(location) : !l.after(location))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConsistent(Location location1, Location location2) {
        Operation operation1 = (Operation)location1.variable();
        Operation operation2 = (Operation)location2.variable();
        return operation1.getOperationNumber() < operation2.getOperationNumber() ? location1.before(location2) : location2.before(location1);
    }

    public String toString() {
        return "J" + this.iJobNumber;
    }

    @Override
    public String getName() {
        return "J" + this.iJobNumber;
    }
}

