/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.sectioning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.custom.DeterministicStudentSectioning;
import org.cpsolver.coursett.model.Configuration;
import org.cpsolver.coursett.model.DefaultStudentSectioning;
import org.cpsolver.coursett.model.InitialSectioning;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.coursett.sectioning.SctModel;
import org.cpsolver.coursett.sectioning.StudentSwapSectioning;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.InfoProvider;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.termination.TerminationCondition;
import org.cpsolver.ifs.util.Progress;

public class SctSectioning
extends DefaultStudentSectioning
implements InfoProvider<Lecture, Placement> {
    private boolean iUseCriteria = true;
    private int iNrRounds = 3;
    private List<StudentConflict> iStudentConflictCriteria = null;

    public SctSectioning(TimetableModel model) {
        super(model);
        this.iUseCriteria = model.getProperties().getPropertyBoolean("SctSectioning.UseCriteria", true);
        this.iNrRounds = model.getProperties().getPropertyInt("SctSectioning.NrRounds", 3);
    }

    @Override
    public boolean hasFinalSectioning() {
        return true;
    }

    protected List<StudentConflict> getStudentConflictCriteria() {
        if (!this.iUseCriteria) {
            return null;
        }
        if (this.iStudentConflictCriteria == null && this.iModel != null) {
            this.iStudentConflictCriteria = new ArrayList<StudentConflict>();
            for (Criterion criterion : this.iModel.getCriteria()) {
                if (!(criterion instanceof StudentConflict)) continue;
                this.iStudentConflictCriteria.add((StudentConflict)criterion);
            }
        }
        return this.iStudentConflictCriteria;
    }

    protected double value(Solution<Lecture, Placement> solution) {
        List<StudentConflict> criteria = this.getStudentConflictCriteria();
        if (criteria == null) {
            double value = 0.0;
            for (JenrlConstraint constraint : ((TimetableModel)solution.getModel()).getJenrlConstraints()) {
                if (!constraint.isInConflict(solution.getAssignment())) continue;
                value += constraint.jenrl();
            }
            return value;
        }
        double value = 0.0;
        for (StudentConflict criterion : criteria) {
            value += criterion.getWeightedValue(solution.getAssignment());
        }
        return value;
    }

    @Override
    public void switchStudents(Solution<Lecture, Placement> solution, TerminationCondition<Lecture, Placement> termination) {
        this.getProgress().setStatus("Student Sectioning...");
        this.getProgress().info("Student Conflicts: " + sDF2.format(this.value(solution)) + " (group: " + sDF2.format(StudentSwapSectioning.gp(solution)) + "%)");
        for (int i = 1; i <= this.iNrRounds; ++i) {
            this.getProgress().setPhase("Swapping students [" + i + "]...", this.iModel.variables().size());
            HashSet<Long> offeringIds = new HashSet<Long>();
            for (Lecture lecture : this.iModel.variables()) {
                this.getProgress().incProgress();
                if (lecture.students().isEmpty() || lecture.isSingleSection()) continue;
                if (termination != null && !termination.canContinue(solution)) {
                    return;
                }
                if (!offeringIds.add(lecture.getConfiguration().getOfferingId())) continue;
                SctModel model = new SctModel(this.iModel, solution.getAssignment());
                model.setConfiguration(lecture.getConfiguration());
                SctModel.SctSolution s1 = model.currentSolution();
                SctModel.SctSolution s2 = model.computeSolution();
                if (model.isTimeOutReached()) {
                    this.getProgress().info("Timeout reached for " + lecture.getName());
                }
                if (!s2.isBetter(s1)) continue;
                model.unassign();
                model.assign(s2);
                this.getProgress().info("Student Conflicts: " + sDF2.format(this.value(solution)) + " (group: " + sDF2.format(StudentSwapSectioning.gp(solution)) + "%)");
            }
            this.getProgress().info("Student Conflicts: " + sDF2.format(this.value(solution)) + " (group: " + sDF2.format(StudentSwapSectioning.gp(solution)) + "%)");
        }
    }

    @Override
    public void resection(Assignment<Lecture, Placement> assignment, Lecture lecture, boolean recursive, boolean configAsWell) {
        SctModel model = new SctModel(this.iModel, assignment);
        model.setConfiguration(lecture.getConfiguration());
        SctModel.SctSolution s1 = model.currentSolution();
        SctModel.SctSolution s2 = model.computeSolution();
        if (s2.isBetter(s1)) {
            model.unassign();
            model.assign(s2);
        }
    }

    protected boolean hasStudentGroups(Collection<Student> students) {
        for (Student student : students) {
            if (student.getGroups().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected InitialSectioning.Group[] studentsToConfigurations(Long offeringId, Collection<Student> students, Collection<Configuration> configurations) {
        if (this.hasStudentGroups(students)) {
            GroupBasedInitialSectioning sect = new GroupBasedInitialSectioning(this.getProgress(), offeringId, configurations, students);
            return sect.getGroups();
        }
        return super.studentsToConfigurations(offeringId, students, configurations);
    }

    @Override
    protected InitialSectioning.Group[] studentsToLectures(Long offeringId, Collection<Student> students, Collection<Lecture> lectures) {
        if (this.hasStudentGroups(students)) {
            TreeSet<Lecture> sortedLectures = new TreeSet<Lecture>(new Comparator<Lecture>(){

                @Override
                public int compare(Lecture l1, Lecture l2) {
                    return l1.getClassId().compareTo(l2.getClassId());
                }
            });
            sortedLectures.addAll(lectures);
            GroupBasedInitialSectioning sect = new GroupBasedInitialSectioning(this.getProgress(), offeringId, sortedLectures, students);
            return sect.getGroups();
        }
        return super.studentsToLectures(offeringId, students, lectures);
    }

    protected static class GroupBasedInitialSectioning
    extends DeterministicStudentSectioning.DeterministicInitialSectioning {
        public GroupBasedInitialSectioning(Progress progress, Long offeringId, Collection<?> lectureOrConfigurations, Collection<Student> students) {
            super(progress, offeringId, lectureOrConfigurations, students);
        }

        @Override
        public int compare(Student s1, Student s2) {
            int cmp = s1.getGroupNames().compareToIgnoreCase(s2.getGroupNames());
            if (cmp != 0) {
                return cmp;
            }
            return super.compare(s1, s2);
        }
    }
}

