/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria.additional;

import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.criteria.StudentConflict;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class QuadraticStudentConflict
extends StudentConflict {
    @Override
    public boolean isApplicable(Lecture l1, Lecture l2) {
        return l1 != null && l2 != null && !QuadraticStudentConflict.ignore(l1, l2) && QuadraticStudentConflict.applicable(l1, l2);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.StudentConflictWeight", 1.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.NrStudConfsWeight";
    }

    @Override
    protected double jointEnrollment(JenrlConstraint jenrl) {
        return jenrl.jenrl() * jenrl.jenrl();
    }

    @Override
    public void incJenrl(Assignment<Lecture, Placement> assignment, JenrlConstraint jenrl, double studentWeight, Double conflictPriority, Student student) {
        if (this.isApplicable((Lecture)jenrl.first(), (Lecture)jenrl.second()) && this.inConflict(assignment.getValue((Lecture)jenrl.first()), assignment.getValue((Lecture)jenrl.second()))) {
            this.inc(assignment, jenrl.jenrl() * jenrl.jenrl() - (jenrl.jenrl() - studentWeight) * (jenrl.jenrl() - studentWeight));
        }
    }
}

