/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria.additional;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.SoftInstructorConstraint;
import org.cpsolver.coursett.criteria.TimetablingCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.util.DataProperties;

public class InstructorConflict
extends TimetablingCriterion {
    public InstructorConflict() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.NoUpdate);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.InstructorConflictWeight", 100.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.InstructorConflictWeight";
    }

    protected int penalty(Assignment<Lecture, Placement> assignment, Placement value) {
        int ret = 0;
        for (InstructorConstraint ic : ((Lecture)value.variable()).getInstructorConstraints()) {
            if (!(ic instanceof SoftInstructorConstraint)) continue;
            ret += ((SoftInstructorConstraint)ic).getConflicts(assignment, value);
        }
        return ret;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        double ret = this.penalty(assignment, value);
        if (conflicts != null) {
            for (Placement conflict : conflicts) {
                ret -= (double)this.penalty(assignment, conflict);
            }
        }
        return ret;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double ret = 0.0;
        HashSet<InstructorConstraint> constraints = new HashSet<InstructorConstraint>();
        for (Lecture lect : variables) {
            for (InstructorConstraint ic : lect.getInstructorConstraints()) {
                if (!constraints.add(ic) || !(ic instanceof SoftInstructorConstraint)) continue;
                ret += (double)((SoftInstructorConstraint)ic).getConflicts(assignment);
            }
        }
        return ret;
    }

    @Override
    protected double[] computeBounds(Assignment<Lecture, Placement> assignment) {
        double[] bounds = new double[]{0.0, 0.0};
        for (InstructorConstraint ic : ((TimetableModel)this.getModel()).getInstructorConstraints()) {
            if (!(ic instanceof SoftInstructorConstraint)) continue;
            bounds[1] = bounds[1] + (double)((SoftInstructorConstraint)ic).getWorstConflicts();
        }
        return bounds;
    }

    @Override
    public double[] getBounds(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        HashSet<InstructorConstraint> constraints = new HashSet<InstructorConstraint>();
        for (Lecture lect : variables) {
            for (InstructorConstraint ic : lect.getInstructorConstraints()) {
                if (!constraints.add(ic) || !(ic instanceof SoftInstructorConstraint)) continue;
                bounds[1] = bounds[1] + (double)((SoftInstructorConstraint)ic).getWorstConflicts();
            }
        }
        return bounds;
    }

    @Override
    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info) {
        super.getInfo(assignment, info);
        double conf = this.getValue(assignment);
        if (conf > 0.0) {
            info.put("Instructor conflicts", sDoubleFormat.format(conf));
        }
    }

    @Override
    public void getInfo(Assignment<Lecture, Placement> assignment, Map<String, String> info, Collection<Lecture> variables) {
        super.getInfo(assignment, info, variables);
        double conf = this.getValue(assignment, variables);
        if (conf > 0.0) {
            info.put("Instructor conflicts", sDoubleFormat.format(conf));
        }
    }
}

