/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett;

import org.cpsolver.coursett.heuristics.NeighbourSelectionWithSuggestions;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.Progress;

@Deprecated
public class TimetableSolver
extends Solver<Lecture, Placement> {
    private long iLastCompleteSolutionFixIteration = -1L;
    private long iLastIncompleteSolutionFixIteration = -1L;
    private long iCompleteSolutionFixInterval = 1L;
    private long iIncompleteSolutionFixInterval = 5000L;

    public TimetableSolver(DataProperties properties) {
        super(properties);
    }

    @Override
    public void initSolver() {
        super.initSolver();
        this.iCompleteSolutionFixInterval = this.getProperties().getPropertyLong("General.CompleteSolutionFixInterval", this.iCompleteSolutionFixInterval);
        this.iIncompleteSolutionFixInterval = this.getProperties().getPropertyLong("General.IncompleteSolutionFixInterval", this.iIncompleteSolutionFixInterval);
    }

    @Override
    protected void onAssigned(double startTime, Solution<Lecture, Placement> solution) {
        if (solution.getModel().nrUnassignedVariables(solution.getAssignment()) == 0) {
            if (this.iCompleteSolutionFixInterval < 0L) {
                return;
            }
            if (this.iCompleteSolutionFixInterval == 0L ? this.iLastCompleteSolutionFixIteration >= 0L : this.iLastCompleteSolutionFixIteration >= 0L && solution.getIteration() - this.iLastCompleteSolutionFixIteration < this.iCompleteSolutionFixInterval) {
                return;
            }
            if (this.getSolutionComparator().isBetterThanBestSolution(solution)) {
                this.fixCompleteSolution(solution, startTime);
                this.iLastCompleteSolutionFixIteration = solution.getIteration();
            }
        } else if (solution.getBestInfo() == null) {
            if (this.iIncompleteSolutionFixInterval < 0L) {
                return;
            }
            if (this.iIncompleteSolutionFixInterval == 0L ? this.iLastIncompleteSolutionFixIteration >= 0L : this.iLastIncompleteSolutionFixIteration >= 0L && solution.getIteration() - this.iLastIncompleteSolutionFixIteration < this.iIncompleteSolutionFixInterval) {
                return;
            }
            if (this.getSolutionComparator().isBetterThanBestSolution(solution)) {
                this.fixCompleteSolution(solution, startTime);
                this.iLastIncompleteSolutionFixIteration = solution.getIteration();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fixCompleteSolution(Solution<Lecture, Placement> solution, double startTime) {
        Progress progress = Progress.getInstance(solution.getModel());
        TimetableModel model = (TimetableModel)solution.getModel();
        Assignment<Lecture, Placement> assignment = solution.getAssignment();
        solution.saveBest();
        progress.save();
        double solutionValue = 0.0;
        double newSolutionValue = model.getTotalValue(assignment);
        do {
            solutionValue = newSolutionValue;
            progress.setPhase("Fixing solution", model.variables().size());
            for (Lecture variable : model.variables()) {
                Placement bestValue = null;
                double bestVal = 0.0;
                Placement currentValue = assignment.getValue(variable);
                if (currentValue == null) continue;
                double currentVal = currentValue.toDouble(assignment);
                for (Placement value : variable.values()) {
                    if (value.equals(currentValue) || !model.conflictValues(assignment, value).isEmpty()) continue;
                    double val = value.toDouble(assignment);
                    if (bestValue != null && !(val < bestVal)) continue;
                    bestValue = value;
                    bestVal = val;
                }
                if (bestValue != null && bestVal < currentVal) {
                    assignment.assign(0L, bestValue);
                }
                solution.update(JProf.currentTimeSec() - startTime);
                progress.incProgress();
                if (!this.iStop) continue;
                break;
            }
            if (!((newSolutionValue = model.getTotalValue(assignment)) < solutionValue)) continue;
            progress.debug("New solution value is  " + newSolutionValue);
        } while (!this.iStop && newSolutionValue < solutionValue && this.getTerminationCondition().canContinue(solution));
        progress.restore();
        if (!solution.getModel().unassignedVariables(assignment).isEmpty()) {
            return;
        }
        progress.save();
        try {
            progress.setPhase("Fixing solution [2]", model.variables().size());
            NeighbourSelectionWithSuggestions ns = new NeighbourSelectionWithSuggestions(this);
            for (Lecture lecture : model.variables()) {
                Neighbour<Lecture, Placement> n = ns.selectNeighbourWithSuggestions(solution, lecture, 2);
                if (n != null && n.value(assignment) <= 0.0) {
                    n.assign(assignment, 0L);
                }
                solution.update(JProf.currentTimeSec() - startTime);
                progress.incProgress();
                if (!this.iStop) continue;
                break;
            }
        }
        catch (Exception e) {
            sLogger.debug(e.getMessage(), (Throwable)e);
        }
        finally {
            progress.restore();
        }
    }
}

