/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jgroups.Message;
import org.jgroups.util.Buffer;
import org.jgroups.util.LongTuple;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

public class DynamicBuffer<T>
extends Buffer<T> {
    protected final int num_rows;
    protected final int elements_per_row;
    protected final double resize_factor;
    protected T[][] matrix;
    protected long max_compaction_time = TimeUnit.NANOSECONDS.convert(10000L, TimeUnit.MILLISECONDS);
    protected long last_compaction_timestamp;
    protected int num_compactions;
    protected int num_resizes;
    protected int num_moves;
    protected int num_purges;
    protected static final long DEFAULT_MAX_COMPACTION_TIME = 10000L;
    protected static final double DEFAULT_RESIZE_FACTOR = 1.2;

    public DynamicBuffer() {
        this(5, 8192, 0L, 1.2);
    }

    public DynamicBuffer(long offset) {
        this();
        this.high = this.hd = offset;
        this.low = this.hd;
        this.offset = this.hd;
    }

    public DynamicBuffer(int num_rows, int elements_per_row, long offset) {
        this(num_rows, elements_per_row, offset, 1.2);
    }

    public DynamicBuffer(int num_rows, int elements_per_row, long offset, double resize_factor) {
        this(num_rows, elements_per_row, offset, resize_factor, 10000L);
    }

    public DynamicBuffer(int num_rows, int elements_per_row, long offset, double resize_factor, long max_compaction_time) {
        this.num_rows = num_rows;
        this.elements_per_row = Util.getNextHigherPowerOfTwo(elements_per_row);
        this.resize_factor = resize_factor;
        this.max_compaction_time = TimeUnit.NANOSECONDS.convert(max_compaction_time, TimeUnit.MILLISECONDS);
        this.high = this.hd = offset;
        this.low = this.hd;
        this.offset = this.hd;
        this.matrix = new Object[num_rows][];
        if (resize_factor <= 1.0) {
            throw new IllegalArgumentException("resize_factor needs to be > 1");
        }
    }

    public int getElementsPerRow() {
        return this.elements_per_row;
    }

    @Override
    public int capacity() {
        return this.matrix.length * this.elements_per_row;
    }

    public int getNumRows() {
        return this.matrix.length;
    }

    public int getNumCompactions() {
        return this.num_compactions;
    }

    public int getNumMoves() {
        return this.num_moves;
    }

    public int getNumResizes() {
        return this.num_resizes;
    }

    public int getNumPurges() {
        return this.num_purges;
    }

    public long getMaxCompactionTime() {
        return this.max_compaction_time;
    }

    public DynamicBuffer<T> setMaxCompactionTime(long max_compaction_time) {
        this.max_compaction_time = TimeUnit.NANOSECONDS.convert(max_compaction_time, TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public void resetStats() {
        this.num_purges = 0;
        this.num_resizes = 0;
        this.num_moves = 0;
        this.num_compactions = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(long seqno, T element, Predicate<T> remove_filter, Buffer.Options __, boolean ignored) {
        this.lock.lock();
        try {
            int index;
            T[] row;
            T existing_element;
            if (seqno - this.hd <= 0L) {
                boolean bl = false;
                return bl;
            }
            int row_index = this.computeRow(seqno);
            if (row_index >= this.matrix.length) {
                this.resize(seqno);
                row_index = this.computeRow(seqno);
            }
            if ((existing_element = (row = this.getRow(row_index))[index = this.computeIndex(seqno)]) != null) {
                boolean bl = false;
                return bl;
            }
            row[index] = element;
            ++this.size;
            if (seqno - this.high > 0L) {
                this.high = seqno;
            }
            if (remove_filter != null && seqno - this.hd > 0L) {
                Buffer.Visitor<Object> v = (seq, msg) -> {
                    if (msg == null || !remove_filter.test(msg)) {
                        return false;
                    }
                    if (seq - this.hd > 0L) {
                        this.hd = seq;
                    }
                    this.size = Math.max(this.size - 1, 0);
                    return true;
                };
                this.forEach(v, false);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(MessageBatch batch, Function<T, Long> seqno_getter, boolean remove_from_batch, T const_value) {
        if (batch == null || batch.isEmpty()) {
            return false;
        }
        Objects.requireNonNull(seqno_getter);
        boolean retval = false;
        long highest_seqno = DynamicBuffer.findHighestSeqno(batch, seqno_getter);
        this.lock.lock();
        try {
            if (highest_seqno != -1L && this.computeRow(highest_seqno) >= this.matrix.length) {
                this.resize(highest_seqno);
            }
            Iterator<Message> it = batch.iterator();
            while (it.hasNext()) {
                Message msg = it.next();
                long seqno = seqno_getter.apply(msg);
                if (seqno < 0L) continue;
                Object element = const_value != null ? const_value : msg;
                boolean added = this.add(seqno, element, null, Buffer.Options.DEFAULT(), false);
                boolean bl = retval = retval || added;
                if (added && !remove_from_batch) continue;
                it.remove();
            }
            boolean bl = retval;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(List<LongTuple<T>> list, boolean remove_added_elements, T const_value) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        boolean added = false;
        long highest_seqno = this.findHighestSeqno(list);
        this.lock.lock();
        try {
            if (highest_seqno != -1L && this.computeRow(highest_seqno) >= this.matrix.length) {
                this.resize(highest_seqno);
            }
            Iterator<LongTuple<T>> it = list.iterator();
            while (it.hasNext()) {
                T element;
                LongTuple<T> tuple = it.next();
                long seqno = tuple.getVal1();
                T t = element = const_value != null ? const_value : tuple.getVal2();
                if (this.add(seqno, element, null, null, false)) {
                    added = true;
                    continue;
                }
                if (!remove_added_elements) continue;
                it.remove();
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long seqno) {
        this.lock.lock();
        try {
            if (seqno - this.low <= 0L || seqno - this.high > 0L) {
                T t = null;
                return t;
            }
            int row_index = this.computeRow(seqno);
            if (row_index < 0 || row_index >= this.matrix.length) {
                T t = null;
                return t;
            }
            T[] row = this.matrix[row_index];
            if (row == null) {
                T t = null;
                return t;
            }
            int index = this.computeIndex(seqno);
            T t = index >= 0 ? (T)row[index] : null;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T _get(long seqno) {
        this.lock.lock();
        try {
            int row_index = this.computeRow(seqno);
            if (row_index < 0 || row_index >= this.matrix.length) {
                T t = null;
                return t;
            }
            T[] row = this.matrix[row_index];
            if (row == null) {
                T t = null;
                return t;
            }
            int index = this.computeIndex(seqno);
            T t = index >= 0 ? (T)row[index] : null;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(boolean nullify) {
        this.lock.lock();
        try {
            int row_index = this.computeRow(this.hd + 1L);
            if (row_index < 0 || row_index >= this.matrix.length) {
                T t = null;
                return t;
            }
            T[] row = this.matrix[row_index];
            if (row == null) {
                T t = null;
                return t;
            }
            int index = this.computeIndex(this.hd + 1L);
            if (index < 0) {
                T t = null;
                return t;
            }
            T existing_element = row[index];
            if (existing_element != null) {
                ++this.hd;
                this.size = Math.max(this.size - 1, 0);
                if (nullify) {
                    row[index] = null;
                    if (this.hd - this.low > 0L) {
                        this.low = this.hd;
                    }
                }
            }
            T t = existing_element;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<T> removeMany(boolean nullify, int max_results, Predicate<T> filter) {
        return this.removeMany(nullify, max_results, filter, LinkedList::new, LinkedList::add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R removeMany(boolean nullify, int max_results, Predicate<T> filter, Supplier<R> result_creator, BiConsumer<R, T> accumulator) {
        this.lock.lock();
        try {
            Buffer.Remover<R> remover = new Buffer.Remover<R>(max_results, filter, result_creator, accumulator);
            this.forEach(remover, nullify);
            R r = remover.getResult();
            return r;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int purge(long seqno, boolean force) {
        int purged = 0;
        this.lock.lock();
        try {
            int index;
            if (seqno - this.low <= 0L) {
                int n = 0;
                return n;
            }
            if (force) {
                if (seqno - this.high > 0L) {
                    seqno = this.high;
                }
            } else if (seqno - this.hd > 0L) {
                seqno = this.hd;
            }
            int start_row = this.computeRow(this.low);
            int end_row = this.computeRow(seqno);
            if (start_row < 0) {
                start_row = 0;
            }
            if (end_row < 0) {
                int n = purged;
                return n;
            }
            for (int i = start_row; i < end_row; ++i) {
                this.matrix[i] = null;
            }
            if (this.matrix[end_row] != null) {
                index = this.computeIndex(seqno);
                for (int i = 0; i <= index; ++i) {
                    if (this.matrix[end_row][i] == null) continue;
                    this.matrix[end_row][i] = null;
                    ++purged;
                }
            }
            if (seqno - this.low > 0L) {
                this.low = seqno;
            }
            if (force) {
                if (seqno - this.hd > 0L) {
                    this.low = this.hd = seqno;
                }
                this.size = this.computeSize();
            }
            ++this.num_purges;
            if (this.max_compaction_time <= 0L) {
                index = purged;
                return index;
            }
            long current_time = System.nanoTime();
            if (this.last_compaction_timestamp > 0L) {
                if (current_time - this.last_compaction_timestamp >= this.max_compaction_time) {
                    this._compact();
                    this.last_compaction_timestamp = current_time;
                }
            } else {
                this.last_compaction_timestamp = current_time;
            }
            int n = purged;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void compact() {
        this.lock.lock();
        try {
            this._compact();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void forEach(long from, long to, Buffer.Visitor<T> visitor, boolean nullify) {
        if (from - to > 0L) {
            return;
        }
        int row = this.computeRow(from);
        int column = this.computeIndex(from);
        int distance = (int)(to - from + 1L);
        T[] current_row = row + 1 > this.matrix.length ? null : this.matrix[row];
        for (int i = 0; i < distance; ++i) {
            boolean stop;
            Object element = current_row == null ? null : (Object)current_row[column];
            boolean bl = stop = visitor != null && !visitor.visit(from, element);
            if (nullify && element != null) {
                this.matrix[row][column] = null;
                if (column == this.elements_per_row - 1) {
                    this.matrix[row] = null;
                }
                if (from - this.low > 0L) {
                    this.low = from;
                }
            }
            if (stop) break;
            ++from;
            if (++column < this.elements_per_row) continue;
            column = 0;
            current_row = ++row + 1 > this.matrix.length ? null : this.matrix[row];
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new TableIterator();
    }

    @Override
    public Iterator<T> iterator(long from, long to) {
        return new TableIterator(from, to);
    }

    @Override
    public Stream<T> stream() {
        Spliterator<T> sp = Spliterators.spliterator(this.iterator(), (long)this.size(), 0);
        return StreamSupport.stream(sp, false);
    }

    @Override
    public Stream<T> stream(long from, long to) {
        Spliterator<T> sp = Spliterators.spliterator(this.iterator(from, to), (long)this.size(), 0);
        return StreamSupport.stream(sp, false);
    }

    protected long findHighestSeqno(List<LongTuple<T>> list) {
        long seqno = -1L;
        for (LongTuple<T> tuple : list) {
            long val = tuple.getVal1();
            if (val - seqno <= 0L) continue;
            seqno = val;
        }
        return seqno;
    }

    protected static <T> long findHighestSeqno(MessageBatch batch, Function<T, Long> seqno_getter) {
        long seqno = -1L;
        for (Message msg : batch) {
            long val = seqno_getter.apply(msg);
            if (val < 0L || val - seqno <= 0L) continue;
            seqno = val;
        }
        return seqno;
    }

    protected void resize(long seqno) {
        int num_rows_to_purge = this.computeRow(this.low);
        int row_index = this.computeRow(seqno) - num_rows_to_purge;
        if (row_index < 0) {
            return;
        }
        int new_size = Math.max(row_index + 1, this.matrix.length);
        if (new_size > this.matrix.length) {
            Object[][] new_matrix = new Object[new_size][];
            System.arraycopy(this.matrix, num_rows_to_purge, new_matrix, 0, this.matrix.length - num_rows_to_purge);
            this.matrix = new_matrix;
            ++this.num_resizes;
        } else if (num_rows_to_purge > 0) {
            this.move(num_rows_to_purge);
        }
        this.offset += (long)num_rows_to_purge * (long)this.elements_per_row;
    }

    protected void move(int num_rows) {
        int i;
        if (num_rows <= 0 || num_rows > this.matrix.length) {
            return;
        }
        int target_index = 0;
        for (i = num_rows; i < this.matrix.length; ++i) {
            this.matrix[target_index++] = this.matrix[i];
        }
        for (i = this.matrix.length - num_rows; i < this.matrix.length; ++i) {
            this.matrix[i] = null;
        }
        ++this.num_moves;
    }

    protected void _compact() {
        int from = this.computeRow(this.low);
        int to = this.computeRow(this.high);
        int range = to - from + 1;
        int new_size = (int)Math.max((double)range * this.resize_factor, (double)range + 1.0);
        if ((new_size = Math.max(new_size, this.num_rows)) < this.matrix.length) {
            Object[][] new_matrix = new Object[new_size][];
            System.arraycopy(this.matrix, from, new_matrix, 0, range);
            this.matrix = new_matrix;
            this.offset += (long)from * (long)this.elements_per_row;
            ++this.num_compactions;
        }
    }

    protected T[] getRow(int index) {
        Object[] row = this.matrix[index];
        if (row == null) {
            row = new Object[this.elements_per_row];
            this.matrix[index] = row;
        }
        return row;
    }

    protected int computeRow(long seqno) {
        int diff = (int)(seqno - this.offset);
        if (diff < 0) {
            return diff;
        }
        return diff / this.elements_per_row;
    }

    protected int computeIndex(long seqno) {
        int diff = (int)(seqno - this.offset);
        if (diff < 0) {
            return diff;
        }
        return diff & this.elements_per_row - 1;
    }

    protected class TableIterator
    implements Iterator<T> {
        protected int row;
        protected int column;
        protected T[] current_row;
        protected long from;
        protected final long to;

        protected TableIterator() {
            this(this$0.hd + 1L, this$0.high);
        }

        protected TableIterator(long from, long to) {
            this.from = from;
            this.to = to;
            this.row = DynamicBuffer.this.computeRow(from);
            this.column = DynamicBuffer.this.computeIndex(from);
            this.current_row = this.row + 1 > DynamicBuffer.this.matrix.length ? null : DynamicBuffer.this.matrix[this.row];
        }

        @Override
        public boolean hasNext() {
            return this.to - this.from >= 0L;
        }

        @Override
        public T next() {
            if (this.row > DynamicBuffer.this.matrix.length) {
                throw new NoSuchElementException(String.format("row (%d) is > matrix.length (%d)", this.row, DynamicBuffer.this.matrix.length));
            }
            Object element = this.current_row == null ? null : (Object)this.current_row[this.column];
            ++this.from;
            if (++this.column >= DynamicBuffer.this.elements_per_row) {
                this.column = 0;
                ++this.row;
                this.current_row = this.row + 1 > DynamicBuffer.this.matrix.length ? null : DynamicBuffer.this.matrix[this.row];
            }
            return element;
        }
    }
}

