/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.jgroups.Address;

public class AckTable {
    protected final Map<Address, Long> acks = new HashMap<Address, Long>();
    protected final Lock lock = new ReentrantLock();
    protected volatile long min;

    public long min() {
        this.lock.lock();
        try {
            long l = this.min;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] ack(Address sender, long seqno) {
        this.lock.lock();
        try {
            long[] retval = new long[]{this.min, this.min};
            Long existing = this.acks.get(sender);
            if (existing != null && existing >= seqno) {
                long[] lArray = retval;
                return lArray;
            }
            this.acks.put(sender, seqno);
            retval[1] = this.min = this.computeMin();
            long[] lArray = retval;
            return lArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AckTable adjust(List<Address> mbrs) {
        if (mbrs == null) {
            return this;
        }
        this.lock.lock();
        try {
            this.acks.keySet().retainAll(mbrs);
            for (Address mbr : mbrs) {
                this.acks.putIfAbsent(mbr, 0L);
            }
            this.min = this.computeMin();
            AckTable ackTable = this;
            return ackTable;
        }
        finally {
            this.lock.unlock();
        }
    }

    public AckTable clear() {
        this.lock.lock();
        try {
            this.acks.clear();
            this.min = this.computeMin();
            AckTable ackTable = this;
            return ackTable;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int size() {
        this.lock.lock();
        try {
            int n = this.acks.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        String tmp = this.acks.entrySet().stream().map(e -> String.format("%s: %,d", e.getKey(), e.getValue())).collect(Collectors.joining("\n"));
        return tmp.isEmpty() ? String.format("min: %,d", this.min) : String.format("%s\nmin: %,d", tmp, this.min);
    }

    protected long computeMin() {
        Optional<Long> m = this.acks.values().stream().min(Long::compareTo);
        return m.orElse(this.min);
    }
}

