/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util.com.google.ical.iter;

import biweekly.util.ByDay;
import biweekly.util.DayOfWeek;
import biweekly.util.com.google.ical.iter.IntSet;
import biweekly.util.com.google.ical.util.DTBuilder;
import biweekly.util.com.google.ical.util.TimeUtils;
import biweekly.util.com.google.ical.values.DateValue;

class Util {
    static DateValue nextWeekStart(DateValue date, DayOfWeek weekday) {
        DTBuilder builder = new DTBuilder(date);
        builder.day += (7 - (7 + (TimeUtils.dayOfWeek(date).getCalendarConstant() - weekday.getCalendarConstant())) % 7) % 7;
        return builder.toDate();
    }

    static int[] uniquify(int[] ints) {
        IntSet iset = new IntSet();
        for (int i : ints) {
            iset.add(i);
        }
        return iset.toIntArray();
    }

    static int dayNumToDate(DayOfWeek dow0, int nDays, int weekNum, DayOfWeek dow, int d0, int nDaysInMonth) {
        int date;
        int firstDateOfGivenDow = 1 + (7 + dow.getCalendarConstant() - dow0.getCalendarConstant()) % 7;
        if (weekNum > 0) {
            date = (weekNum - 1) * 7 + firstDateOfGivenDow - d0;
        } else {
            int lastDateOfGivenDow = firstDateOfGivenDow + 378;
            lastDateOfGivenDow -= 7 * ((lastDateOfGivenDow - nDays + 6) / 7);
            date = lastDateOfGivenDow + 7 * (weekNum + 1) - d0;
        }
        return date <= 0 || date > nDaysInMonth ? 0 : date;
    }

    static int invertWeekdayNum(ByDay weekdayNum, DayOfWeek dow0, int nDays) {
        return Util.countInPeriod(weekdayNum.getDay(), dow0, nDays) + weekdayNum.getNum() + 1;
    }

    static int countInPeriod(DayOfWeek dow, DayOfWeek dow0, int nDays) {
        if (dow.getCalendarConstant() >= dow0.getCalendarConstant()) {
            return 1 + (nDays - (dow.getCalendarConstant() - dow0.getCalendarConstant()) - 1) / 7;
        }
        return 1 + (nDays - (7 - (dow0.getCalendarConstant() - dow.getCalendarConstant())) - 1) / 7;
    }

    private Util() {
    }
}

