/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalVersion;
import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.property.ICalProperty;
import biweekly.util.ICalDate;
import biweekly.util.Period;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RecurrenceDates
extends ICalProperty {
    private final List<ICalDate> dates;
    private final List<Period> periods;

    public RecurrenceDates() {
        this.dates = new ArrayList<ICalDate>();
        this.periods = new ArrayList<Period>();
    }

    public RecurrenceDates(RecurrenceDates original) {
        super(original);
        this.dates = new ArrayList<ICalDate>(original.dates.size());
        for (ICalDate date : original.dates) {
            this.dates.add(new ICalDate(date));
        }
        this.periods = new ArrayList<Period>(original.periods.size());
        for (Period period : original.periods) {
            this.periods.add(new Period(period));
        }
    }

    public List<ICalDate> getDates() {
        return this.dates;
    }

    public List<Period> getPeriods() {
        return this.periods;
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
        if (this.dates.isEmpty() && this.periods.isEmpty()) {
            warnings.add(new ValidationWarning(26, new Object[0]));
        }
        if (!this.dates.isEmpty() && !this.periods.isEmpty()) {
            warnings.add(new ValidationWarning(49, new Object[0]));
        }
        if (version == ICalVersion.V1_0 && !this.periods.isEmpty()) {
            warnings.add(new ValidationWarning(51, new Object[0]));
        }
        if (!this.dates.isEmpty()) {
            boolean hasTime = this.dates.get(0).hasTime();
            for (ICalDate date : this.dates.subList(1, this.dates.size())) {
                if (date.hasTime() == hasTime) continue;
                warnings.add(new ValidationWarning(50, new Object[0]));
                break;
            }
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("dates", this.dates);
        values.put("periods", this.periods);
        return values;
    }

    @Override
    public RecurrenceDates copy() {
        return new RecurrenceDates(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.dates.hashCode();
        result = 31 * result + this.periods.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RecurrenceDates other = (RecurrenceDates)obj;
        if (!this.dates.equals(other.dates)) {
            return false;
        }
        return this.periods.equals(other.periods);
    }
}

