/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Objects;
import org.jgroups.JChannel;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.UNICAST3;
import org.jgroups.protocols.pbcast.NAKACK2;
import org.jgroups.stack.MessageProcessingPolicy;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;

public class Tests {
    public static boolean mcastRetransmissionAvailable(JChannel ... channels) {
        for (JChannel ch : channels) {
            ProtocolStack stack = ch.getProtocolStack();
            Object nak = stack.findProtocol((Class<? extends Protocol>)NAKACK2.class);
            if (nak != null) continue;
            return false;
        }
        return true;
    }

    public static boolean ucastRetransmissionAvailable(JChannel ... channels) {
        for (JChannel ch : channels) {
            ProtocolStack stack = ch.getProtocolStack();
            Object prot = stack.findProtocol((Class<? extends Protocol>)UNICAST3.class);
            if (prot != null) continue;
            return false;
        }
        return true;
    }

    public static boolean hasThreadPool(JChannel ... channels) {
        for (JChannel ch : channels) {
            TP tp = ch.getProtocolStack().getTransport();
            if (tp.getThreadPool().isEnabled()) continue;
            return false;
        }
        return true;
    }

    public static boolean processingPolicyIs(Class<? extends MessageProcessingPolicy> policy_class, JChannel ... channels) {
        for (JChannel ch : channels) {
            TP tp = ch.getProtocolStack().getTransport();
            MessageProcessingPolicy pol = tp.getMessageProcessingPolicy();
            if (Objects.equals(policy_class, pol.getClass())) continue;
            return false;
        }
        return true;
    }
}

