/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.property.ICalProperty;
import com.github.mangstadt.vinnie.SyntaxStyle;
import com.github.mangstadt.vinnie.validate.AllowedCharacters;
import com.github.mangstadt.vinnie.validate.VObjectValidator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RawProperty
extends ICalProperty {
    private String name;
    private ICalDataType dataType;
    private String value;

    public RawProperty(String name, String value) {
        this(name, null, value);
    }

    public RawProperty(String name, ICalDataType dataType, String value) {
        this.name = name;
        this.dataType = dataType;
        this.value = value;
    }

    public RawProperty(RawProperty original) {
        super(original);
        this.name = original.name;
        this.dataType = original.dataType;
        this.value = original.value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ICalDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(ICalDataType dataType) {
        this.dataType = dataType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
        SyntaxStyle syntax = version.getSyntaxStyle();
        AllowedCharacters allowed = VObjectValidator.allowedCharactersParameterName((SyntaxStyle)syntax, (boolean)true);
        if (!allowed.check(this.name)) {
            if (syntax == SyntaxStyle.OLD) {
                AllowedCharacters notAllowed = allowed.flip();
                warnings.add(new ValidationWarning(59, this.name, notAllowed.toString(true)));
            } else {
                warnings.add(new ValidationWarning(52, this.name));
            }
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("name", this.name);
        values.put("value", this.value);
        values.put("dataType", this.dataType);
        return values;
    }

    @Override
    public RawProperty copy() {
        return new RawProperty(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.toLowerCase().hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RawProperty other = (RawProperty)obj;
        if (this.dataType != other.dataType) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equalsIgnoreCase(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

