/*
 * Decompiled with CFR 0.152.
 */
package biweekly.component;

import biweekly.ICalVersion;
import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.component.VEvent;
import biweekly.component.VTodo;
import biweekly.parameter.Related;
import biweekly.property.Action;
import biweekly.property.Attachment;
import biweekly.property.Attendee;
import biweekly.property.DateDue;
import biweekly.property.DateEnd;
import biweekly.property.DateStart;
import biweekly.property.Description;
import biweekly.property.DurationProperty;
import biweekly.property.Repeat;
import biweekly.property.Summary;
import biweekly.property.Trigger;
import biweekly.util.Duration;
import java.util.Arrays;
import java.util.List;

public class VAlarm
extends ICalComponent {
    public VAlarm(Action action, Trigger trigger) {
        this.setAction(action);
        this.setTrigger(trigger);
    }

    public VAlarm(VAlarm original) {
        super(original);
    }

    public static VAlarm audio(Trigger trigger) {
        return VAlarm.audio(trigger, null);
    }

    public static VAlarm audio(Trigger trigger, Attachment sound) {
        VAlarm alarm = new VAlarm(Action.audio(), trigger);
        if (sound != null) {
            alarm.addAttachment(sound);
        }
        return alarm;
    }

    public static VAlarm display(Trigger trigger, String displayText) {
        VAlarm alarm = new VAlarm(Action.display(), trigger);
        alarm.setDescription(displayText);
        return alarm;
    }

    public static VAlarm email(Trigger trigger, String subject, String body, String ... recipients) {
        return VAlarm.email(trigger, subject, body, Arrays.asList(recipients));
    }

    public static VAlarm procedure(Trigger trigger, String path) {
        VAlarm alarm = new VAlarm(Action.procedure(), trigger);
        alarm.setDescription(path);
        return alarm;
    }

    public static VAlarm email(Trigger trigger, String subject, String body, List<String> recipients) {
        VAlarm alarm = new VAlarm(Action.email(), trigger);
        alarm.setSummary(subject);
        alarm.setDescription(body);
        for (String recipient : recipients) {
            alarm.addAttendee(new Attendee(null, recipient));
        }
        return alarm;
    }

    public List<Attachment> getAttachments() {
        return this.getProperties(Attachment.class);
    }

    public void addAttachment(Attachment attachment) {
        this.addProperty(attachment);
    }

    public Description getDescription() {
        return this.getProperty(Description.class);
    }

    public void setDescription(Description description) {
        this.setProperty(Description.class, description);
    }

    public Description setDescription(String description) {
        Description prop = description == null ? null : new Description(description);
        this.setDescription(prop);
        return prop;
    }

    public Summary getSummary() {
        return this.getProperty(Summary.class);
    }

    public void setSummary(Summary summary) {
        this.setProperty(Summary.class, summary);
    }

    public Summary setSummary(String summary) {
        Summary prop = summary == null ? null : new Summary(summary);
        this.setSummary(prop);
        return prop;
    }

    public List<Attendee> getAttendees() {
        return this.getProperties(Attendee.class);
    }

    public void addAttendee(Attendee attendee) {
        this.addProperty(attendee);
    }

    public Action getAction() {
        return this.getProperty(Action.class);
    }

    public void setAction(Action action) {
        this.setProperty(Action.class, action);
    }

    public DurationProperty getDuration() {
        return this.getProperty(DurationProperty.class);
    }

    public void setDuration(DurationProperty duration) {
        this.setProperty(DurationProperty.class, duration);
    }

    public DurationProperty setDuration(Duration duration) {
        DurationProperty prop = duration == null ? null : new DurationProperty(duration);
        this.setDuration(prop);
        return prop;
    }

    public Repeat getRepeat() {
        return this.getProperty(Repeat.class);
    }

    public void setRepeat(Repeat repeat) {
        this.setProperty(Repeat.class, repeat);
    }

    public Repeat setRepeat(Integer count) {
        Repeat prop = count == null ? null : new Repeat(count);
        this.setRepeat(prop);
        return prop;
    }

    public void setRepeat(int count, Duration pauseDuration) {
        Repeat repeat = new Repeat(count);
        DurationProperty duration = new DurationProperty(pauseDuration);
        this.setRepeat(repeat);
        this.setDuration(duration);
    }

    public Trigger getTrigger() {
        return this.getProperty(Trigger.class);
    }

    public void setTrigger(Trigger trigger) {
        this.setProperty(Trigger.class, trigger);
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
        this.checkRequiredCardinality(warnings, Action.class, Trigger.class);
        this.validateAction(warnings);
        this.validateTrigger(components, warnings);
    }

    private void validateAction(List<ValidationWarning> warnings) {
        Action action = this.getAction();
        if (action == null) {
            return;
        }
        if (action.isAudio() && this.getAttachments().size() > 1) {
            warnings.add(new ValidationWarning(7, new Object[0]));
        }
        if (action.isDisplay()) {
            this.checkRequiredCardinality(warnings, Description.class);
        }
        if (action.isEmail()) {
            this.checkRequiredCardinality(warnings, Summary.class, Description.class);
            if (this.getAttendees().isEmpty()) {
                warnings.add(new ValidationWarning(8, new Object[0]));
            }
        } else if (!this.getAttendees().isEmpty()) {
            warnings.add(new ValidationWarning(9, new Object[0]));
        }
        if (action.isProcedure()) {
            this.checkRequiredCardinality(warnings, Description.class);
        }
    }

    private void validateTrigger(List<ICalComponent> components, List<ValidationWarning> warnings) {
        Trigger trigger = this.getTrigger();
        if (trigger == null) {
            return;
        }
        Related related = trigger.getRelated();
        if (related == null) {
            return;
        }
        ICalComponent parent = components.get(components.size() - 1);
        if (related == Related.START && parent.getProperty(DateStart.class) == null) {
            warnings.add(new ValidationWarning(11, new Object[0]));
        }
        if (related == Related.END) {
            boolean noEndDate = false;
            if (parent instanceof VEvent) {
                noEndDate = parent.getProperty(DateEnd.class) == null && (parent.getProperty(DateStart.class) == null || parent.getProperty(DurationProperty.class) == null);
            } else if (parent instanceof VTodo) {
                boolean bl = noEndDate = parent.getProperty(DateDue.class) == null && (parent.getProperty(DateStart.class) == null || parent.getProperty(DurationProperty.class) == null);
            }
            if (noEndDate) {
                warnings.add(new ValidationWarning(12, new Object[0]));
            }
        }
    }

    @Override
    public VAlarm copy() {
        return new VAlarm(this);
    }
}

