/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.storage.client;

import com.google.gwt.storage.client.Storage;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class StorageMap
extends AbstractMap<String, String> {
    private final Storage storage;

    public StorageMap(Storage storage) {
        assert (storage != null) : "storage cannot be null";
        this.storage = storage;
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            if (!value.equals(this.storage.getItem(this.storage.key(i)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new StorageEntrySet();
    }

    @Override
    public String get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.storage.getItem(key.toString());
    }

    @Override
    public String put(String key, String value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        String old = this.storage.getItem(key);
        this.storage.setItem(key, value);
        return old;
    }

    @Override
    public String remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        String k = key.toString();
        String old = this.storage.getItem(k);
        this.storage.removeItem(k);
        return old;
    }

    @Override
    public int size() {
        return this.storage.getLength();
    }

    private class StorageEntrySet
    extends AbstractSet<Map.Entry<String, String>> {
        private StorageEntrySet() {
        }

        @Override
        public void clear() {
            StorageMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object value = e.getValue();
            return key != null && value != null && value.equals(StorageMap.this.get(key));
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new StorageEntryIterator();
        }

        @Override
        public boolean remove(Object o) {
            if (!this.contains(o)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return StorageMap.this.remove(entry.getKey()) != null;
        }

        @Override
        public int size() {
            return StorageMap.this.size();
        }
    }

    private class StorageEntryIterator
    implements Iterator<Map.Entry<String, String>> {
        private int index = -1;
        private String lastKey;

        private StorageEntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < StorageMap.this.size() - 1;
        }

        @Override
        public Map.Entry<String, String> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            this.lastKey = StorageMap.this.storage.key(this.index);
            return new StorageEntry(this.lastKey);
        }

        @Override
        public void remove() {
            if (this.lastKey == null) {
                throw new IllegalStateException();
            }
            StorageMap.this.storage.removeItem(this.lastKey);
            this.lastKey = null;
            --this.index;
        }
    }

    private class StorageEntry
    implements Map.Entry<String, String> {
        private final String key;

        public StorageEntry(String key) {
            this.key = key;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)obj;
            return this.eq(this.key, e.getKey()) && this.eq(this.getValue(), e.getValue());
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return StorageMap.this.get(this.key);
        }

        @Override
        public int hashCode() {
            return this.hashCode(this.key) ^ this.hashCode(this.getValue());
        }

        @Override
        public String setValue(String value) {
            return StorageMap.this.put(this.key, value);
        }

        private boolean eq(Object a, Object b) {
            return a == b || a != null && a.equals(b);
        }

        private int hashCode(Object o) {
            return o != null ? o.hashCode() : 0;
        }
    }
}

