/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.model;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparable;
import org.cpsolver.ifs.assignment.context.AbstractClassWithContext;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.CanInheritContext;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.model.Unavailability;
import org.cpsolver.studentsct.reservation.Reservation;

public class Section
extends AbstractClassWithContext<Request, Enrollment, SectionContext>
implements SctAssignment,
AssignmentComparable<Section, Request, Enrollment>,
CanInheritContext<Request, Enrollment, SectionContext> {
    private static DecimalFormat sDF = new DecimalFormat("0.000");
    private long iId = -1L;
    private String iName = null;
    private Map<Long, String> iNameByCourse = null;
    private Subpart iSubpart = null;
    private Section iParent = null;
    private Placement iPlacement = null;
    private int iLimit = 0;
    private List<Instructor> iInstructors = null;
    private double iPenalty = 0.0;
    private double iSpaceExpected = 0.0;
    private double iSpaceHeld = 0.0;
    private String iNote = null;
    private Set<Long> iIgnoreConflictsWith = null;
    private boolean iCancelled = false;
    private boolean iEnabled = true;
    private boolean iOnline = false;
    private boolean iPast = false;
    private List<Unavailability> iUnavailabilities = new ArrayList<Unavailability>();
    private Double iTotalUnreservedSpace = null;
    private List<Reservation> iReservations = null;
    private List<Reservation> iSectionReservations = null;

    public Section(long id, int limit, String name, Subpart subpart, Placement placement, List<Instructor> instructors, Section parent) {
        this.iId = id;
        this.iLimit = limit;
        this.iName = name;
        this.iSubpart = subpart;
        if (this.iSubpart != null) {
            this.iSubpart.getSections().add(this);
        }
        this.iPlacement = placement;
        this.iParent = parent;
        this.iInstructors = instructors;
    }

    public Section(long id, int limit, String name, Subpart subpart, Placement placement, Section parent, Instructor ... instructors) {
        this(id, limit, name, subpart, placement, Arrays.asList(instructors), parent);
    }

    @Deprecated
    public Section(long id, int limit, String name, Subpart subpart, Placement placement, String instructorIds, String instructorNames, Section parent) {
        this(id, limit, name, subpart, placement, Instructor.toInstructors(instructorIds, instructorNames), parent);
    }

    @Override
    public long getId() {
        return this.iId;
    }

    public int getLimit() {
        return this.iLimit;
    }

    public void setLimit(int limit) {
        this.iLimit = limit;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public Subpart getSubpart() {
        return this.iSubpart;
    }

    public Section getParent() {
        return this.iParent;
    }

    public Placement getPlacement() {
        return this.iPlacement;
    }

    public void setPlacement(Placement placement) {
        this.iPlacement = placement;
    }

    @Override
    public TimeLocation getTime() {
        return this.iPlacement == null ? null : this.iPlacement.getTimeLocation();
    }

    public boolean hasTime() {
        return this.iPlacement != null && this.iPlacement.getTimeLocation() != null && this.iPlacement.getTimeLocation().getDayCode() != 0;
    }

    public boolean sameInstructionalType(Section section) {
        return this.getSubpart().getInstructionalType().equals(section.getSubpart().getInstructionalType());
    }

    public boolean sameTime(Section section) {
        return this.getTime() == null ? section.getTime() == null : this.getTime().equals(section.getTime());
    }

    public boolean sameInstructors(Section section) {
        if (this.nrInstructors() != section.nrInstructors()) {
            return false;
        }
        return !this.hasInstructors() || this.getInstructors().containsAll(section.getInstructors());
    }

    public boolean sameChoice(Section section) {
        return this.sameInstructionalType(section) && this.sameTime(section) && this.sameInstructors(section);
    }

    @Override
    public int getNrRooms() {
        return this.iPlacement == null ? 0 : this.iPlacement.getNrRooms();
    }

    @Override
    public List<RoomLocation> getRooms() {
        if (this.iPlacement == null) {
            return null;
        }
        if (this.iPlacement.getRoomLocations() == null && this.iPlacement.getRoomLocation() != null) {
            ArrayList<RoomLocation> ret = new ArrayList<RoomLocation>(1);
            ret.add(this.iPlacement.getRoomLocation());
            return ret;
        }
        return this.iPlacement.getRoomLocations();
    }

    @Override
    public boolean isOverlapping(SctAssignment assignment) {
        if (this.isAllowOverlap() || assignment.isAllowOverlap()) {
            return false;
        }
        if (this.getTime() == null || assignment.getTime() == null) {
            return false;
        }
        if (assignment instanceof Section && this.isToIgnoreStudentConflictsWith(assignment.getId())) {
            return false;
        }
        return this.getTime().hasIntersection(assignment.getTime());
    }

    @Override
    public boolean isOverlapping(Set<? extends SctAssignment> assignments) {
        if (this.isAllowOverlap()) {
            return false;
        }
        if (this.getTime() == null || assignments == null) {
            return false;
        }
        for (SctAssignment sctAssignment : assignments) {
            if (sctAssignment.isAllowOverlap() || sctAssignment.getTime() == null || sctAssignment instanceof Section && this.isToIgnoreStudentConflictsWith(sctAssignment.getId()) || !this.getTime().hasIntersection(sctAssignment.getTime())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void assigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        ((SectionContext)this.getContext(assignment)).assigned(assignment, enrollment);
    }

    @Override
    public void unassigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
        ((SectionContext)this.getContext(assignment)).unassigned(assignment, enrollment);
    }

    public String getLongName(boolean useAmPm) {
        return this.getSubpart().getName() + " " + this.getName() + " " + (this.getTime() == null ? "" : " " + this.getTime().getLongName(useAmPm)) + (this.getNrRooms() == 0 ? "" : " " + this.getPlacement().getRoomName(",")) + (this.hasInstructors() ? " " + this.getInstructorNames(",") : "");
    }

    @Deprecated
    public String getLongName() {
        return this.getLongName(true);
    }

    public String toString() {
        return this.getSubpart().getConfig().getOffering().getName() + " " + this.getSubpart().getName() + " " + this.getName() + (this.getTime() == null ? "" : " " + this.getTime().getLongName(true)) + (this.getNrRooms() == 0 ? "" : " " + this.getPlacement().getRoomName(",")) + (this.hasInstructors() ? " " + this.getInstructorNames(",") : "") + " (L:" + (this.getLimit() < 0 ? "unlimited" : "" + this.getLimit()) + (this.getPenalty() == 0.0 ? "" : ",P:" + sDF.format(this.getPenalty())) + ")";
    }

    public List<Instructor> getInstructors() {
        return this.iInstructors;
    }

    public boolean hasInstructors() {
        return this.iInstructors != null && !this.iInstructors.isEmpty();
    }

    public int nrInstructors() {
        return this.iInstructors == null ? 0 : this.iInstructors.size();
    }

    public String getInstructorNames(String delim) {
        if (this.iInstructors == null || this.iInstructors.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator<Instructor> i = this.iInstructors.iterator();
        while (i.hasNext()) {
            Instructor instructor = i.next();
            sb.append(instructor.getName() != null ? instructor.getName() : (instructor.getExternalId() != null ? instructor.getExternalId() : "I" + instructor.getId()));
            if (!i.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public double getPenalty() {
        return this.iPenalty;
    }

    public void setPenalty(double penalty) {
        this.iPenalty = penalty;
    }

    @Override
    public int compareTo(Assignment<Request, Enrollment> assignment, Section s) {
        int cmp = Double.compare(this.getPenalty(), s.getPenalty());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Double.compare(this.getLimit() < 0 ? ((SectionContext)this.getContext(assignment)).getEnrollmentWeight(assignment, null) : ((SectionContext)this.getContext(assignment)).getEnrollmentWeight(assignment, null) - (double)this.getLimit(), s.getLimit() < 0 ? ((SectionContext)s.getContext(assignment)).getEnrollmentWeight(assignment, null) : ((SectionContext)s.getContext(assignment)).getEnrollmentWeight(assignment, null) - (double)s.getLimit());
        if (cmp != 0) {
            return cmp;
        }
        return Double.compare(this.getId(), s.getId());
    }

    @Override
    public int compareTo(Section s) {
        int cmp = Double.compare(this.getPenalty(), s.getPenalty());
        if (cmp != 0) {
            return cmp;
        }
        return Double.compare(this.getId(), s.getId());
    }

    public double getSpaceHeld() {
        return this.iSpaceHeld;
    }

    public void setSpaceHeld(double spaceHeld) {
        this.iSpaceHeld = spaceHeld;
    }

    public double getSpaceExpected() {
        return this.iSpaceExpected;
    }

    public void setSpaceExpected(double spaceExpected) {
        this.iSpaceExpected = spaceExpected;
    }

    public double getOnlineSectioningPenalty(Assignment<Request, Enrollment> assignment) {
        if (this.getLimit() <= 0) {
            return 0.0;
        }
        double available = (double)this.getLimit() - ((SectionContext)this.getContext(assignment)).getEnrollmentWeight(assignment, null);
        double penalty = (this.getSpaceExpected() - available) / (double)this.getLimit();
        return Math.max(-1.0, Math.min(1.0, penalty));
    }

    @Override
    public boolean isAllowOverlap() {
        return this.iSubpart.isAllowOverlap();
    }

    @Override
    public int compareById(SctAssignment a) {
        if (a instanceof Section) {
            return Long.valueOf(this.getId()).compareTo(((Section)a).getId());
        }
        return -1;
    }

    public double getUnreservedSpace(Assignment<Request, Enrollment> assignment, Request excludeRequest) {
        if (this.getLimit() < 0) {
            for (Reservation r : this.getSectionReservations()) {
                if (r.isExpired() || !(r.getLimit(this.getSubpart().getConfig()) < 0.0)) continue;
                return 0.0;
            }
            return Double.MAX_VALUE;
        }
        double available = (double)this.getLimit() - ((SectionContext)this.getContext(assignment)).getEnrollmentWeight(assignment, excludeRequest);
        for (Reservation r : this.getSectionReservations()) {
            if (r.isExpired()) continue;
            if (r.getLimit(this.getSubpart().getConfig()) < 0.0) {
                return 0.0;
            }
            double reserved = ((Reservation.ReservationContext)r.getContext(assignment)).getReservedAvailableSpace(assignment, this.getSubpart().getConfig(), excludeRequest);
            available -= Math.max(0.0, reserved);
        }
        return available;
    }

    public synchronized double getTotalUnreservedSpace() {
        if (this.iTotalUnreservedSpace == null) {
            this.iTotalUnreservedSpace = this.getTotalUnreservedSpaceNoCache();
        }
        return this.iTotalUnreservedSpace;
    }

    private double getTotalUnreservedSpaceNoCache() {
        if (this.getLimit() < 0) {
            for (Reservation r : this.getSectionReservations()) {
                if (r.isExpired() || !(r.getLimit(this.getSubpart().getConfig()) < 0.0)) continue;
                return 0.0;
            }
            return Double.MAX_VALUE;
        }
        double available = this.getLimit();
        double reserved = 0.0;
        double exclusive = 0.0;
        HashSet<Section> sections = new HashSet<Section>();
        block1: for (Reservation r : this.getSectionReservations()) {
            if (r.isExpired()) continue;
            if (r.getLimit(this.getSubpart().getConfig()) < 0.0) {
                return 0.0;
            }
            for (Section s : r.getSections(this.getSubpart())) {
                if (s.equals(this)) continue;
                if (s.getLimit() < 0) continue block1;
                if (!sections.add(s)) continue;
                available += (double)s.getLimit();
            }
            reserved += r.getLimit(this.getSubpart().getConfig());
            if (r.getSections(this.getSubpart()).size() != 1) continue;
            exclusive += r.getLimit(this.getSubpart().getConfig());
        }
        return Math.min(available - reserved, (double)this.getLimit() - exclusive);
    }

    public synchronized List<Reservation> getReservations() {
        if (this.iReservations == null) {
            this.iReservations = new ArrayList<Reservation>();
            for (Reservation r : this.getSubpart().getConfig().getOffering().getReservations()) {
                if (r.getSections(this.getSubpart()) != null && !r.getSections(this.getSubpart()).contains(this)) continue;
                this.iReservations.add(r);
            }
        }
        return this.iReservations;
    }

    public synchronized List<Reservation> getSectionReservations() {
        if (this.iSectionReservations == null) {
            this.iSectionReservations = new ArrayList<Reservation>();
            for (Reservation r : this.getSubpart().getSectionReservations()) {
                if (!r.getSections(this.getSubpart()).contains(this)) continue;
                this.iSectionReservations.add(r);
            }
        }
        return this.iSectionReservations;
    }

    public synchronized void clearReservationCache() {
        this.iReservations = null;
        this.iSectionReservations = null;
        this.iTotalUnreservedSpace = null;
    }

    public String getName(long courseId) {
        if (this.iNameByCourse == null) {
            return this.getName();
        }
        String name = this.iNameByCourse.get(courseId);
        return name == null ? this.getName() : name;
    }

    public void setName(long courseId, String name) {
        if (this.iNameByCourse == null) {
            this.iNameByCourse = new HashMap<Long, String>();
        }
        this.iNameByCourse.put(courseId, name);
    }

    public Map<Long, String> getNameByCourse() {
        return this.iNameByCourse;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Section)) {
            return false;
        }
        return this.getId() == ((Section)o).getId();
    }

    public int hashCode() {
        return (int)(this.iId ^ this.iId >>> 32);
    }

    public String getNote() {
        return this.iNote;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    public void addIgnoreConflictWith(long sectionId) {
        if (this.iIgnoreConflictsWith == null) {
            this.iIgnoreConflictsWith = new HashSet<Long>();
        }
        this.iIgnoreConflictsWith.add(sectionId);
    }

    public boolean isToIgnoreStudentConflictsWith(long sectionId) {
        return this.iIgnoreConflictsWith != null && this.iIgnoreConflictsWith.contains(sectionId);
    }

    public Set<Long> getIgnoreConflictWithSectionIds() {
        return this.iIgnoreConflictsWith;
    }

    @Override
    public Set<Enrollment> getEnrollments(Assignment<Request, Enrollment> assignment) {
        return ((SectionContext)this.getContext(assignment)).getEnrollments();
    }

    public double getEnrollmentWeight(Assignment<Request, Enrollment> assignment, Request excludeRequest) {
        return ((SectionContext)this.getContext(assignment)).getEnrollmentWeight(assignment, excludeRequest);
    }

    public double getEnrollmentTotalWeight(Assignment<Request, Enrollment> assignment, Request excludeRequest) {
        return ((SectionContext)this.getContext(assignment)).getEnrollmentTotalWeight(assignment, excludeRequest);
    }

    public double getMaxEnrollmentWeight(Assignment<Request, Enrollment> assignment) {
        return ((SectionContext)this.getContext(assignment)).getMaxEnrollmentWeight();
    }

    public double getMinEnrollmentWeight(Assignment<Request, Enrollment> assignment) {
        return ((SectionContext)this.getContext(assignment)).getMinEnrollmentWeight();
    }

    public boolean isCancelled() {
        return this.iCancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.iCancelled = cancelled;
    }

    public boolean isPast() {
        return this.iPast;
    }

    public void setPast(boolean past) {
        this.iPast = past;
    }

    public boolean isEnabled() {
        return this.iEnabled;
    }

    public boolean isEnabled(Student student) {
        if (!this.iEnabled) {
            return false;
        }
        if (student != null && student.getModalityPreference() == Student.ModalityPreference.ONLINE_REQUIRED && !this.isOnline()) {
            return false;
        }
        if (student != null && this.getPlacement() != null && this.getPlacement().getTimeLocation() != null) {
            if (student.getClassFirstDate() != null) {
                int firstMeeting;
                if (this.getPlacement().getTimeLocation().getDayCode() != 0 && this.getPlacement().getTimeLocation().getFirstMeeting(this.getDayOfWeekOffset()) < student.getClassFirstDate()) {
                    return false;
                }
                if (this.getPlacement().getTimeLocation().getDayCode() == 0 && (firstMeeting = this.getPlacement().getTimeLocation().getWeekCode().nextSetBit(0)) >= 0 && firstMeeting < student.getClassFirstDate()) {
                    return false;
                }
            }
            if (student.getClassLastDate() != null) {
                int lastMeeting;
                if (this.getPlacement().getTimeLocation().getDayCode() != 0 && this.getPlacement().getTimeLocation().getLastMeeting(this.getDayOfWeekOffset()) > student.getClassLastDate()) {
                    return false;
                }
                if (this.getPlacement().getTimeLocation().getDayCode() == 0 && (lastMeeting = this.getPlacement().getTimeLocation().getWeekCode().length() - 1) >= 0 && lastMeeting > student.getClassLastDate()) {
                    return false;
                }
            }
        }
        return true;
    }

    protected int getDayOfWeekOffset() {
        Model<Request, Enrollment> model = this.getModel();
        if (model != null && model instanceof StudentSectioningModel) {
            return ((StudentSectioningModel)model).getDayOfWeekOffset();
        }
        return 0;
    }

    public void setEnabled(boolean enabled) {
        this.iEnabled = enabled;
    }

    public boolean isOnline() {
        return this.iOnline;
    }

    public boolean isModalityPreferred(Student student) {
        if (student.getModalityPreference() == null) {
            return false;
        }
        switch (student.getModalityPreference()) {
            case ONLINE_PREFERRED: {
                return this.isOnline();
            }
            case ONILNE_DISCOURAGED: {
                return !this.isOnline();
            }
        }
        return false;
    }

    public void setOnline(boolean online) {
        this.iOnline = online;
    }

    @Override
    public Model<Request, Enrollment> getModel() {
        return this.getSubpart().getConfig().getOffering().getModel();
    }

    @Override
    public SectionContext createAssignmentContext(Assignment<Request, Enrollment> assignment) {
        return new SectionContext(assignment);
    }

    @Override
    public SectionContext inheritAssignmentContext(Assignment<Request, Enrollment> assignment, SectionContext parentContext) {
        return new SectionContext(parentContext);
    }

    public Choice getChoice() {
        return new Choice(this);
    }

    public List<Unavailability> getUnavailabilities() {
        return this.iUnavailabilities;
    }

    public class SectionContext
    implements AssignmentConstraintContext<Request, Enrollment> {
        private Set<Enrollment> iEnrollments = null;
        private double iEnrollmentWeight = 0.0;
        private double iEnrollmentTotalWeight = 0.0;
        private double iMaxEnrollmentWeight = 0.0;
        private double iMinEnrollmentWeight = 0.0;
        private boolean iReadOnly = false;

        public SectionContext(Assignment<Request, Enrollment> assignment) {
            this.iEnrollments = new HashSet<Enrollment>();
            for (Course course : Section.this.getSubpart().getConfig().getOffering().getCourses()) {
                for (CourseRequest request : course.getRequests()) {
                    Enrollment enrollment = assignment.getValue(request);
                    if (enrollment == null || !enrollment.getSections().contains(Section.this)) continue;
                    this.assigned(assignment, enrollment);
                }
            }
        }

        public SectionContext(SectionContext parent) {
            this.iEnrollmentWeight = parent.iEnrollmentWeight;
            this.iEnrollmentTotalWeight = parent.iEnrollmentTotalWeight;
            this.iMaxEnrollmentWeight = parent.iMaxEnrollmentWeight;
            this.iMinEnrollmentWeight = parent.iMinEnrollmentWeight;
            this.iEnrollments = parent.iEnrollments;
            this.iReadOnly = true;
        }

        @Override
        public void assigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            if (this.iReadOnly) {
                this.iEnrollments = new HashSet<Enrollment>(this.iEnrollments);
                this.iReadOnly = false;
            }
            if (this.iEnrollments.isEmpty()) {
                this.iMinEnrollmentWeight = this.iMaxEnrollmentWeight = enrollment.getRequest().getWeight();
            } else {
                this.iMaxEnrollmentWeight = Math.max(this.iMaxEnrollmentWeight, enrollment.getRequest().getWeight());
                this.iMinEnrollmentWeight = Math.min(this.iMinEnrollmentWeight, enrollment.getRequest().getWeight());
            }
            if (this.iEnrollments.add(enrollment)) {
                this.iEnrollmentTotalWeight += enrollment.getRequest().getWeight();
                if (enrollment.getReservation() == null || !enrollment.getReservation().canBatchAssignOverLimit()) {
                    this.iEnrollmentWeight += enrollment.getRequest().getWeight();
                }
            }
        }

        @Override
        public void unassigned(Assignment<Request, Enrollment> assignment, Enrollment enrollment) {
            if (this.iReadOnly) {
                this.iEnrollments = new HashSet<Enrollment>(this.iEnrollments);
                this.iReadOnly = false;
            }
            if (this.iEnrollments.remove(enrollment)) {
                this.iEnrollmentTotalWeight -= enrollment.getRequest().getWeight();
                if (enrollment.getReservation() == null || !enrollment.getReservation().canBatchAssignOverLimit()) {
                    this.iEnrollmentWeight -= enrollment.getRequest().getWeight();
                }
            }
            if (this.iEnrollments.isEmpty()) {
                this.iMaxEnrollmentWeight = 0.0;
                this.iMinEnrollmentWeight = 0.0;
            } else if (this.iMinEnrollmentWeight != this.iMaxEnrollmentWeight) {
                if (this.iMinEnrollmentWeight == enrollment.getRequest().getWeight()) {
                    double newMinEnrollmentWeight = Double.MAX_VALUE;
                    for (Enrollment e : this.iEnrollments) {
                        if (e.getRequest().getWeight() == this.iMinEnrollmentWeight) {
                            newMinEnrollmentWeight = this.iMinEnrollmentWeight;
                            break;
                        }
                        newMinEnrollmentWeight = Math.min(newMinEnrollmentWeight, e.getRequest().getWeight());
                    }
                    this.iMinEnrollmentWeight = newMinEnrollmentWeight;
                }
                if (this.iMaxEnrollmentWeight == enrollment.getRequest().getWeight()) {
                    double newMaxEnrollmentWeight = Double.MIN_VALUE;
                    for (Enrollment e : this.iEnrollments) {
                        if (e.getRequest().getWeight() == this.iMaxEnrollmentWeight) {
                            newMaxEnrollmentWeight = this.iMaxEnrollmentWeight;
                            break;
                        }
                        newMaxEnrollmentWeight = Math.max(newMaxEnrollmentWeight, e.getRequest().getWeight());
                    }
                    this.iMaxEnrollmentWeight = newMaxEnrollmentWeight;
                }
            }
        }

        public Set<Enrollment> getEnrollments() {
            return this.iEnrollments;
        }

        public double getEnrollmentWeight(Assignment<Request, Enrollment> assignment, Request excludeRequest) {
            Enrollment enrollment;
            double weight = this.iEnrollmentWeight;
            if (excludeRequest != null && (enrollment = assignment.getValue(excludeRequest)) != null && this.iEnrollments.contains(enrollment) && (enrollment.getReservation() == null || !enrollment.getReservation().canBatchAssignOverLimit())) {
                weight -= excludeRequest.getWeight();
            }
            return weight;
        }

        public double getEnrollmentTotalWeight(Assignment<Request, Enrollment> assignment, Request excludeRequest) {
            Enrollment enrollment;
            double weight = this.iEnrollmentTotalWeight;
            if (excludeRequest != null && (enrollment = assignment.getValue(excludeRequest)) != null && this.iEnrollments.contains(enrollment)) {
                weight -= excludeRequest.getWeight();
            }
            return weight;
        }

        public double getMaxEnrollmentWeight() {
            return this.iMaxEnrollmentWeight;
        }

        public double getMinEnrollmentWeight() {
            return this.iMinEnrollmentWeight;
        }
    }
}

