/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.model;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentComparator;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.constraint.ConfigLimit;
import org.cpsolver.studentsct.constraint.CourseLimit;
import org.cpsolver.studentsct.constraint.LinkedSections;
import org.cpsolver.studentsct.constraint.SectionLimit;
import org.cpsolver.studentsct.model.Choice;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.RequestGroup;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.reservation.Reservation;
import org.cpsolver.studentsct.reservation.Restriction;

public class CourseRequest
extends Request {
    private static DecimalFormat sDF = new DecimalFormat("0.000");
    private List<Course> iCourses = null;
    private Set<Choice> iWaitlistedChoices = new HashSet<Choice>();
    private Set<Choice> iSelectedChoices = new HashSet<Choice>();
    private Set<Choice> iRequiredChoices = new HashSet<Choice>();
    private boolean iWaitlist = false;
    private Long iTimeStamp = null;
    private Double iCachedMinPenalty = null;
    private Double iCachedMaxPenalty = null;
    public static boolean sSameTimePrecise = false;
    private Set<RequestGroup> iRequestGroups = new HashSet<RequestGroup>();
    private Enrollment iFixed = null;
    private Map<Course, List<Reservation>> iReservations = null;
    private Map<Course, List<Restriction>> iRestrictions = null;

    public CourseRequest(long id, int priority, boolean alternative, Student student, List<Course> courses, boolean waitlist, boolean critical, Long timeStamp) {
        super(id, priority, alternative, student);
        this.iCourses = new ArrayList<Course>(courses);
        for (Course course : this.iCourses) {
            course.getRequests().add(this);
        }
        this.iWaitlist = waitlist;
        this.setRequestPriority(critical ? Request.RequestPriority.Critical : Request.RequestPriority.Normal);
        this.iTimeStamp = timeStamp;
    }

    public CourseRequest(long id, int priority, boolean alternative, Student student, List<Course> courses, boolean waitlist, Request.RequestPriority importance, Long timeStamp) {
        super(id, priority, alternative, student);
        this.iCourses = new ArrayList<Course>(courses);
        for (Course course : this.iCourses) {
            course.getRequests().add(this);
        }
        this.iWaitlist = waitlist;
        this.setRequestPriority(importance);
        this.iTimeStamp = timeStamp;
    }

    public CourseRequest(long id, int priority, boolean alternative, Student student, List<Course> courses, boolean waitlist, Long timeStamp) {
        this(id, priority, alternative, student, courses, waitlist, false, timeStamp);
    }

    public List<Course> getCourses() {
        return this.iCourses;
    }

    public Enrollment createEnrollment(Set<? extends SctAssignment> sections, Reservation reservation) {
        if (sections == null || sections.isEmpty()) {
            return null;
        }
        Config config = ((Section)sections.iterator().next()).getSubpart().getConfig();
        Course course = null;
        for (Course c : this.iCourses) {
            if (!c.getOffering().getConfigs().contains(config)) continue;
            course = c;
            break;
        }
        return new Enrollment(this, this.iCourses.indexOf(course), course, config, sections, reservation);
    }

    public Enrollment createEnrollment(Course course, Set<? extends SctAssignment> sections, Reservation reservation) {
        if (sections == null || sections.isEmpty()) {
            return null;
        }
        Config config = ((Section)sections.iterator().next()).getSubpart().getConfig();
        return new Enrollment(this, this.iCourses.indexOf(course), course, config, sections, reservation);
    }

    public Enrollment createEnrollment(Assignment<Request, Enrollment> assignment, Set<? extends SctAssignment> sections) {
        Enrollment ret = this.createEnrollment(sections, null);
        ret.guessReservation(assignment, true);
        return ret;
    }

    protected int getMaxDomainSize() {
        StudentSectioningModel model = (StudentSectioningModel)this.getModel();
        return model == null ? -1 : model.getMaxDomainSize();
    }

    @Override
    public List<Enrollment> computeEnrollments(Assignment<Request, Enrollment> assignment) {
        ArrayList<Enrollment> ret = new ArrayList<Enrollment>();
        if (this.isFixed()) {
            ret.add(this.getFixedValue());
            return ret;
        }
        if (this.getInitialAssignment() != null && this.getModel() != null && ((StudentSectioningModel)this.getModel()).isMPP() && ((StudentSectioningModel)this.getModel()).getKeepInitialAssignments()) {
            ret.add((Enrollment)this.getInitialAssignment());
            return ret;
        }
        int idx = 0;
        for (Course course : this.iCourses) {
            for (Config config : course.getOffering().getConfigs()) {
                this.computeEnrollments(assignment, ret, idx, 0.0, course, config, new HashSet<Section>(), 0, false, false, false, false, this.getMaxDomainSize() <= 0 ? -1 : ret.size() + this.getMaxDomainSize(), false);
            }
            ++idx;
        }
        return ret;
    }

    public List<Enrollment> computeRandomEnrollments(Assignment<Request, Enrollment> assignment, int limitEachConfig) {
        ArrayList<Enrollment> ret = new ArrayList<Enrollment>();
        if (this.isFixed()) {
            ret.add(this.getFixedValue());
            return ret;
        }
        if (this.getInitialAssignment() != null && this.getModel() != null && ((StudentSectioningModel)this.getModel()).isMPP() && ((StudentSectioningModel)this.getModel()).getKeepInitialAssignments()) {
            ret.add((Enrollment)this.getInitialAssignment());
            return ret;
        }
        int idx = 0;
        for (Course course : this.iCourses) {
            for (Config config : course.getOffering().getConfigs()) {
                this.computeEnrollments(assignment, ret, idx, 0.0, course, config, new HashSet<Section>(), 0, false, false, false, true, limitEachConfig <= 0 ? limitEachConfig : ret.size() + limitEachConfig, false);
            }
            ++idx;
        }
        return ret;
    }

    private boolean sameTimes(Set<Section> sections1, Set<Section> sections2) {
        for (Section s1 : sections1) {
            Section s2 = null;
            for (Section s : sections2) {
                if (!s.getSubpart().equals(s1.getSubpart())) continue;
                s2 = s;
                break;
            }
            if (s2 == null) {
                return false;
            }
            if (ToolBox.equals(s1.getTime(), s2.getTime())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void computeEnrollments(Assignment<Request, Enrollment> assignment, Collection<Enrollment> enrollments, int priority, double penalty, Course course, Config config, HashSet<Section> sections, int idx, boolean availableOnly, boolean skipSameTime, boolean selectedOnly, boolean random, int limit, boolean checkParent) {
        block49: {
            void var18_34;
            block48: {
                boolean bl;
                boolean bl2;
                Enrollment e;
                block50: {
                    if (limit > 0 && enrollments.size() >= limit) {
                        return;
                    }
                    if (checkParent && course.hasParent()) {
                        Course parent = course.getParent();
                        for (Request request : this.getStudent().getRequests()) {
                            Enrollment e2;
                            if (!request.hasCourse(parent) || (e2 = assignment.getValue(request)) != null && parent.equals(e2.getCourse())) continue;
                            return;
                        }
                    }
                    if (idx == 0) {
                        if (this.isNotAllowed(course, config)) {
                            return;
                        }
                        boolean canOverLimit = false;
                        if (availableOnly) {
                            for (Reservation reservation : this.getReservations(course)) {
                                if (!reservation.canBatchAssignOverLimit() || reservation.neverIncluded() || !reservation.getConfigs().isEmpty() && !reservation.getConfigs().contains(config) || reservation.getReservedAvailableSpace(assignment, this) < this.getWeight() || reservation.getReservedAvailableSpace(assignment, config, this) < this.getWeight()) continue;
                                canOverLimit = true;
                                break;
                            }
                        }
                        if (!canOverLimit) {
                            if (availableOnly && config.getLimit() >= 0 && ConfigLimit.getEnrollmentWeight(assignment, config, this) > (double)config.getLimit()) {
                                return;
                            }
                            if (availableOnly && course.getLimit() >= 0 && CourseLimit.getEnrollmentWeight(assignment, course, this) > (double)course.getLimit()) {
                                return;
                            }
                            if (config.getOffering().hasReservations()) {
                                boolean bl3;
                                boolean hasReservation = false;
                                boolean bl4 = false;
                                boolean reservationMustBeUsed = false;
                                for (Reservation reservation : this.getReservations(course)) {
                                    if (reservation.mustBeUsed()) {
                                        reservationMustBeUsed = true;
                                    }
                                    if (availableOnly && reservation.getReservedAvailableSpace(assignment, this) < this.getWeight() || availableOnly && reservation.getReservedAvailableSpace(assignment, config, this) < this.getWeight() || reservation.neverIncluded()) continue;
                                    if (reservation.getConfigs().isEmpty()) {
                                        hasReservation = true;
                                        continue;
                                    }
                                    if (reservation.getConfigs().contains(config)) {
                                        hasReservation = true;
                                        bl3 = true;
                                        continue;
                                    }
                                    if (reservation.areRestrictionsInclusive()) continue;
                                    hasReservation = true;
                                }
                                if (!bl3 && config.getTotalUnreservedSpace() < this.getWeight()) {
                                    return;
                                }
                                if (!hasReservation && config.getOffering().getTotalUnreservedSpace() < this.getWeight()) {
                                    return;
                                }
                                if (availableOnly && !hasReservation && config.getOffering().getUnreservedSpace(assignment, this) < this.getWeight()) {
                                    return;
                                }
                                if (availableOnly && !bl3 && config.getUnreservedSpace(assignment, this) < this.getWeight()) {
                                    return;
                                }
                                if (!hasReservation && reservationMustBeUsed) {
                                    return;
                                }
                            }
                        }
                    }
                    if (config.getSubparts().size() != idx) break block48;
                    if (skipSameTime && sSameTimePrecise) {
                        boolean waitListedOrSelected = false;
                        if (!this.getSelectedChoices().isEmpty() || !this.getWaitlistedChoices().isEmpty()) {
                            for (Section section : sections) {
                                if (!this.isWaitlisted(section) && !this.isSelected(section)) continue;
                                waitListedOrSelected = true;
                                break;
                            }
                        }
                        if (!waitListedOrSelected) {
                            for (Enrollment enrollment : enrollments) {
                                if (!this.sameTimes(enrollment.getSections(), sections)) continue;
                                return;
                            }
                        }
                    }
                    if (this.isNotAllowed(e = new Enrollment(this, priority, course, config, new HashSet<Section>(sections), null))) break block49;
                    if (config.getOffering().hasReservations()) break block50;
                    enrollments.add(e);
                    break block49;
                }
                boolean mustHaveReservation = config.getOffering().getTotalUnreservedSpace() < this.getWeight();
                boolean bl5 = config.getTotalUnreservedSpace() < this.getWeight();
                boolean mustHaveSectionReservation = false;
                boolean containDisabledSection = false;
                for (Section section : sections) {
                    if (section.getTotalUnreservedSpace() < this.getWeight()) {
                        mustHaveSectionReservation = true;
                    }
                    if (this.getStudent().isAllowDisabled() || section.isEnabled(this.getStudent())) continue;
                    containDisabledSection = true;
                }
                boolean bl6 = false;
                if (availableOnly) {
                    for (Reservation reservation : this.getReservations(course)) {
                        if (!reservation.canBatchAssignOverLimit() || !reservation.isIncluded(e) || reservation.getReservedAvailableSpace(assignment, config, this) < this.getWeight() || containDisabledSection && !reservation.isAllowDisabled()) continue;
                        enrollments.add(new Enrollment(this, priority, null, config, new HashSet<Section>(sections), reservation));
                        bl2 = true;
                    }
                }
                if (bl2) break block49;
                boolean bl7 = false;
                block7: for (Reservation r : availableOnly ? this.getSortedReservations(assignment, course) : this.getReservations(course)) {
                    if (r.mustBeUsed()) {
                        bl = true;
                    }
                    if (!r.isIncluded(e) || availableOnly && r.getReservedAvailableSpace(assignment, config, this) < this.getWeight() || bl5 && r.getConfigs().isEmpty()) continue;
                    if (mustHaveSectionReservation) {
                        for (Section s : sections) {
                            if (r.getSections(s.getSubpart()) != null || !(s.getTotalUnreservedSpace() < this.getWeight())) continue;
                            continue block7;
                        }
                    }
                    if (containDisabledSection && !r.isAllowDisabled()) continue;
                    enrollments.add(new Enrollment(this, priority, null, config, new HashSet<Section>(sections), r));
                    if (!availableOnly) continue;
                    return;
                }
                if (mustHaveReservation || bl5 || mustHaveSectionReservation || availableOnly && config.getOffering().getUnreservedSpace(assignment, this) < this.getWeight() || bl || containDisabledSection) break block49;
                enrollments.add(new Enrollment(this, priority, !this.getReservations(course).isEmpty(), null, config, new HashSet<Section>(sections), null));
                break block49;
            }
            Subpart subpart = config.getSubparts().get(idx);
            HashSet<TimeLocation> times = skipSameTime ? new HashSet<TimeLocation>() : null;
            List<Section> list = subpart.getSections();
            if (skipSameTime) {
                ArrayList<Section> arrayList = new ArrayList<Section>(subpart.getSections());
                Collections.sort(arrayList, new AssignmentComparator(assignment));
            }
            ArrayList<Section> matchingSectionsThisSubpart = new ArrayList<Section>(subpart.getSections().size());
            boolean hasChildren = !subpart.getChildren().isEmpty();
            for (Section section : var18_34) {
                boolean bl;
                if (section.isCancelled() || !this.isRequired(section) || this.getInitialAssignment() != null && this.getModel() != null && ((StudentSectioningModel)this.getModel()).getKeepInitialAssignments() && !((Enrollment)this.getInitialAssignment()).getAssignments().contains(section) || this.isFixed() && !this.getFixedValue().getAssignments().contains(section) || section.getParent() != null && !sections.contains(section.getParent()) || section.isOverlapping(sections) || selectedOnly && this.hasSelection(section) && !this.isSelected(section) || this.isNotAllowed(course, section)) continue;
                if (!this.getStudent().isAvailable(section)) {
                    bl = false;
                    for (Reservation r : this.getReservations(course)) {
                        if (!r.isAllowOverlap() || r.getSections(subpart) != null && !r.getSections(subpart).contains(section) || r.getReservedAvailableSpace(assignment, config, this) < this.getWeight()) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                }
                bl = false;
                if (availableOnly) {
                    for (Reservation r : this.getReservations(course)) {
                        if (!r.canBatchAssignOverLimit() || r.getSections(subpart) != null && !r.getSections(subpart).contains(section) || r.getReservedAvailableSpace(assignment, config, this) < this.getWeight()) continue;
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    if (availableOnly && section.getLimit() >= 0 && SectionLimit.getEnrollmentWeight(assignment, section, this) > (double)section.getLimit()) continue;
                    if (config.getOffering().hasReservations()) {
                        boolean hasReservation = false;
                        boolean hasSectionReservation = false;
                        boolean reservationMustBeUsed = false;
                        for (Reservation r : this.getReservations(course)) {
                            if (r.mustBeUsed()) {
                                reservationMustBeUsed = true;
                            }
                            if (availableOnly && r.getReservedAvailableSpace(assignment, config, this) < this.getWeight()) continue;
                            if (r.getSections(subpart) == null) {
                                hasReservation = true;
                                continue;
                            }
                            if (!r.getSections(subpart).contains(section)) continue;
                            hasReservation = true;
                            hasSectionReservation = true;
                        }
                        if (!hasSectionReservation && section.getTotalUnreservedSpace() < this.getWeight() || availableOnly && !hasSectionReservation && section.getUnreservedSpace(assignment, this) < this.getWeight() || !hasReservation && reservationMustBeUsed) continue;
                    }
                }
                if (!this.getStudent().isAllowDisabled() && !section.isEnabled(this.getStudent())) {
                    boolean allowDisabled = false;
                    for (Reservation r : this.getReservations(course)) {
                        if (!r.isAllowDisabled() || r.getSections(subpart) != null && !r.getSections(subpart).contains(section) || !r.getConfigs().isEmpty() && !r.getConfigs().contains(config)) continue;
                        allowDisabled = true;
                        break;
                    }
                    if (!allowDisabled) continue;
                }
                if (skipSameTime && section.getTime() != null && !hasChildren && !times.add(section.getTime()) && !this.isSelected(section) && !this.isWaitlisted(section) && (section.getIgnoreConflictWithSectionIds() == null || section.getIgnoreConflictWithSectionIds().isEmpty())) continue;
                matchingSectionsThisSubpart.add(section);
            }
            if (random || limit > 0) {
                ArrayList arrayList = new ArrayList(var18_34);
                Collections.shuffle(arrayList);
            }
            boolean bl = false;
            for (Section section : matchingSectionsThisSubpart) {
                void var21_50;
                sections.add(section);
                this.computeEnrollments(assignment, enrollments, priority, penalty + section.getPenalty(), course, config, sections, idx + 1, availableOnly, skipSameTime, selectedOnly, random, limit < 0 ? limit : Math.max(1, limit * (1 + var21_50) / matchingSectionsThisSubpart.size()), checkParent);
                sections.remove(section);
                ++var21_50;
            }
        }
    }

    public List<Enrollment> getAvaiableEnrollments(Assignment<Request, Enrollment> assignment) {
        return this.getAvaiableEnrollments(assignment, true);
    }

    public List<Enrollment> getAvaiableEnrollments(Assignment<Request, Enrollment> assignment, boolean checkParent) {
        ArrayList<Enrollment> ret = new ArrayList<Enrollment>();
        if (this.isFixed()) {
            ret.add(this.getFixedValue());
            return ret;
        }
        if (this.getInitialAssignment() != null && this.getModel() != null && ((StudentSectioningModel)this.getModel()).isMPP() && ((StudentSectioningModel)this.getModel()).getKeepInitialAssignments()) {
            ret.add((Enrollment)this.getInitialAssignment());
            return ret;
        }
        int idx = 0;
        for (Course course : this.iCourses) {
            for (Config config : course.getOffering().getConfigs()) {
                this.computeEnrollments(assignment, ret, idx, 0.0, course, config, new HashSet<Section>(), 0, true, false, false, false, this.getMaxDomainSize() <= 0 ? -1 : ret.size() + this.getMaxDomainSize(), checkParent);
            }
            ++idx;
        }
        return ret;
    }

    public List<Enrollment> getSelectedEnrollments(Assignment<Request, Enrollment> assignment, boolean availableOnly) {
        if (this.getSelectedChoices().isEmpty()) {
            return null;
        }
        ArrayList<Enrollment> enrollments = new ArrayList<Enrollment>();
        if (this.isFixed()) {
            return enrollments;
        }
        if (this.getInitialAssignment() != null && this.getModel() != null && ((StudentSectioningModel)this.getModel()).isMPP() && ((StudentSectioningModel)this.getModel()).getKeepInitialAssignments()) {
            return enrollments;
        }
        Iterator<Course> iterator = this.iCourses.iterator();
        if (iterator.hasNext()) {
            Course course = iterator.next();
            boolean hasChoice = false;
            for (Choice choice : this.getSelectedChoices()) {
                if (!course.getOffering().equals(choice.getOffering())) continue;
                hasChoice = true;
                break;
            }
            if (hasChoice) {
                for (Config config : course.getOffering().getConfigs()) {
                    this.computeEnrollments(assignment, enrollments, 0, 0.0, course, config, new HashSet<Section>(), 0, availableOnly, false, true, false, -1, false);
                }
            }
        }
        return enrollments;
    }

    public List<Enrollment> getAvaiableEnrollmentsSkipSameTime(Assignment<Request, Enrollment> assignment) {
        return this.getAvaiableEnrollmentsSkipSameTime(assignment, true);
    }

    public List<Enrollment> getAvaiableEnrollmentsSkipSameTime(Assignment<Request, Enrollment> assignment, boolean checkParent) {
        ArrayList<Enrollment> ret = new ArrayList<Enrollment>();
        if (this.isFixed()) {
            ret.add(this.getFixedValue());
            return ret;
        }
        if (this.getInitialAssignment() != null) {
            ret.add((Enrollment)this.getInitialAssignment());
            if (this.getModel() != null && ((StudentSectioningModel)this.getModel()).isMPP() && ((StudentSectioningModel)this.getModel()).getKeepInitialAssignments()) {
                return ret;
            }
        }
        int idx = 0;
        for (Course course : this.iCourses) {
            boolean skipSameTime = true;
            for (LinkedSections link : this.getStudent().getLinkedSections()) {
                if (!link.getOfferings().contains(course.getOffering())) continue;
                skipSameTime = false;
                break;
            }
            for (Config config : course.getOffering().getConfigs()) {
                this.computeEnrollments(assignment, ret, idx, 0.0, course, config, new HashSet<Section>(), 0, true, skipSameTime, false, false, this.getMaxDomainSize() <= 0 ? -1 : ret.size() + this.getMaxDomainSize(), checkParent);
            }
            ++idx;
        }
        return ret;
    }

    public List<Enrollment> getEnrollmentsSkipSameTime(Assignment<Request, Enrollment> assignment) {
        ArrayList<Enrollment> ret = new ArrayList<Enrollment>();
        if (this.isFixed()) {
            ret.add(this.getFixedValue());
            return ret;
        }
        if (this.getInitialAssignment() != null) {
            ret.add((Enrollment)this.getInitialAssignment());
            if (this.getModel() != null && ((StudentSectioningModel)this.getModel()).isMPP() && ((StudentSectioningModel)this.getModel()).getKeepInitialAssignments()) {
                return ret;
            }
        }
        int idx = 0;
        for (Course course : this.iCourses) {
            for (Config config : course.getOffering().getConfigs()) {
                boolean skipSameTime = true;
                for (LinkedSections link : this.getStudent().getLinkedSections()) {
                    if (!link.getOfferings().contains(course.getOffering())) continue;
                    skipSameTime = false;
                    break;
                }
                this.computeEnrollments(assignment, ret, idx, 0.0, course, config, new HashSet<Section>(), 0, false, skipSameTime, false, false, this.getMaxDomainSize() <= 0 ? -1 : ret.size() + this.getMaxDomainSize(), false);
            }
            ++idx;
        }
        return ret;
    }

    public Set<Choice> getWaitlistedChoices() {
        return this.iWaitlistedChoices;
    }

    public boolean isWaitlisted(Section section) {
        for (Choice choice : this.iWaitlistedChoices) {
            if (!choice.sameChoice(section)) continue;
            return true;
        }
        return false;
    }

    public Set<Choice> getSelectedChoices() {
        return this.iSelectedChoices;
    }

    public boolean isSelected(Section section) {
        for (Choice choice : this.iSelectedChoices) {
            if (!choice.sameSection(section) && !choice.sameConfiguration(section)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelection(Section section) {
        boolean hasSectionChoices = false;
        boolean hasSectionChoicesThisConfig = false;
        for (Choice choice : this.iSelectedChoices) {
            if (!choice.sameOffering(section)) continue;
            if (choice.isMatching(section)) {
                return true;
            }
            if (choice.getSubpartId() == null) continue;
            hasSectionChoices = true;
            for (Subpart subpart : section.getSubpart().getConfig().getSubparts()) {
                if (!choice.getSubpartId().equals(subpart.getId())) continue;
                hasSectionChoicesThisConfig = true;
            }
        }
        return hasSectionChoices && !hasSectionChoicesThisConfig;
    }

    public Set<Choice> getRequiredChoices() {
        return this.iRequiredChoices;
    }

    public boolean isRequired(Section section) {
        if (this.iRequiredChoices.isEmpty()) {
            return true;
        }
        boolean hasConfig = false;
        boolean hasMatchingConfig = false;
        boolean hasSubpart = false;
        boolean hasMatchingSection = false;
        boolean hasSectionReq = false;
        block0: for (Choice choice : this.iRequiredChoices) {
            if (!choice.getOffering().equals(section.getSubpart().getConfig().getOffering())) continue;
            if (choice.getConfigId() != null) {
                hasConfig = true;
                if (choice.sameConfiguration(section)) {
                    hasMatchingConfig = true;
                }
            }
            if (choice.getSubpartId() == null) continue;
            hasSectionReq = true;
            if (choice.getSubpartId().equals(section.getSubpart().getId())) {
                hasSubpart = true;
                if (!choice.sameSection(section)) continue;
                hasMatchingSection = true;
                continue;
            }
            if (hasMatchingConfig) continue;
            for (Subpart subpart : section.getSubpart().getConfig().getSubparts()) {
                if (!choice.getSubpartId().equals(subpart.getId())) continue;
                hasMatchingConfig = true;
                continue block0;
            }
        }
        if (hasConfig && !hasMatchingConfig) {
            return false;
        }
        if (hasSubpart && !hasMatchingSection) {
            return false;
        }
        return hasMatchingConfig || hasMatchingSection || !hasSectionReq;
    }

    @Override
    public String getName() {
        String ret = (this.isAlternative() ? "A" : "") + (1 + this.getPriority() + (this.isAlternative() ? -this.getStudent().nrRequests() : 0)) + ". " + (this.getRequestPriority() != Request.RequestPriority.Normal ? (this.isWaitlist() ? "(" + this.getRequestPriority().getAbbreviation() + "w) " : "(" + this.getRequestPriority().getAbbreviation() + ") ") : (this.isWaitlist() ? "(w) " : ""));
        int idx = 0;
        for (Course course : this.iCourses) {
            ret = idx == 0 ? ret + course.getName() : ret + ", " + idx + ". alt " + course.getName();
            ++idx;
        }
        if (this.getStudent().getExternalId() != null) {
            ret = "[" + this.getStudent().getExternalId() + "] " + ret;
        }
        return ret;
    }

    public boolean isWaitlist() {
        return this.iWaitlist;
    }

    public void setWaitlist(boolean waitlist) {
        this.iWaitlist = waitlist;
    }

    @Deprecated
    public void setCritical(boolean critical) {
        this.setRequestPriority(critical ? Request.RequestPriority.Critical : Request.RequestPriority.Normal);
    }

    public Long getTimeStamp() {
        return this.iTimeStamp;
    }

    @Override
    public String toString() {
        return this.getName() + (this.getWeight() != 1.0 ? " (W:" + sDF.format(this.getWeight()) + ")" : "");
    }

    public Course getCourse(long courseId) {
        for (Course course : this.iCourses) {
            if (course.getId() != courseId) continue;
            return course;
        }
        return null;
    }

    public Config getConfig(long configId) {
        for (Course course : this.iCourses) {
            for (Config config : course.getOffering().getConfigs()) {
                if (config.getId() != configId) continue;
                return config;
            }
        }
        return null;
    }

    public Subpart getSubpart(long subpartId) {
        for (Course course : this.iCourses) {
            for (Config config : course.getOffering().getConfigs()) {
                for (Subpart subpart : config.getSubparts()) {
                    if (subpart.getId() != subpartId) continue;
                    return subpart;
                }
            }
        }
        return null;
    }

    public Section getSection(long sectionId) {
        for (Course course : this.iCourses) {
            for (Config config : course.getOffering().getConfigs()) {
                for (Subpart subpart : config.getSubparts()) {
                    for (Section section : subpart.getSections()) {
                        if (section.getId() != sectionId) continue;
                        return section;
                    }
                }
            }
        }
        return null;
    }

    public double getMinPenalty() {
        if (this.iCachedMinPenalty == null) {
            double min = Double.MAX_VALUE;
            for (Course course : this.iCourses) {
                min = Math.min(min, course.getOffering().getMinPenalty());
            }
            this.iCachedMinPenalty = min;
        }
        return this.iCachedMinPenalty;
    }

    public double getMaxPenalty() {
        if (this.iCachedMaxPenalty == null) {
            double max = Double.MIN_VALUE;
            for (Course course : this.iCourses) {
                max = Math.max(max, course.getOffering().getMaxPenalty());
            }
            this.iCachedMaxPenalty = max;
        }
        return this.iCachedMaxPenalty;
    }

    public void clearCache() {
        this.iCachedMaxPenalty = null;
        this.iCachedMinPenalty = null;
    }

    @Override
    public double getBound() {
        return -this.getWeight() * ((StudentSectioningModel)this.getModel()).getStudentWeights().getBound(this);
    }

    @Override
    public boolean isAssigned(Assignment<Request, Enrollment> assignment) {
        Enrollment e = assignment.getValue(this);
        return e != null && !e.getAssignments().isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && o instanceof CourseRequest;
    }

    public synchronized List<Reservation> getReservations(Course course) {
        List<Reservation> reservations;
        if (this.iReservations == null) {
            this.iReservations = new HashMap<Course, List<Reservation>>();
        }
        if ((reservations = this.iReservations.get(course)) == null) {
            reservations = new ArrayList<Reservation>();
            boolean mustBeUsed = false;
            for (Reservation r : course.getOffering().getReservations()) {
                if (!r.isApplicable(this.getStudent(), course)) continue;
                if (!mustBeUsed && r.mustBeUsed()) {
                    reservations.clear();
                    mustBeUsed = true;
                }
                if (mustBeUsed && !r.mustBeUsed()) continue;
                reservations.add(r);
            }
            this.iReservations.put(course, reservations);
        }
        return reservations;
    }

    public TreeSet<Reservation> getSortedReservations(Assignment<Request, Enrollment> assignment, Course course) {
        TreeSet<Reservation> reservations = new TreeSet<Reservation>(new AssignmentComparator(assignment));
        reservations.addAll(this.getReservations(course));
        return reservations;
    }

    public boolean hasReservations() {
        for (Course course : this.getCourses()) {
            if (this.getReservations(course).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public synchronized void clearReservationCache() {
        if (this.iReservations != null) {
            this.iReservations.clear();
        }
    }

    public synchronized List<Restriction> getRestrictions(Course course) {
        List<Restriction> restrictions;
        if (this.iRestrictions == null) {
            this.iRestrictions = new HashMap<Course, List<Restriction>>();
        }
        if ((restrictions = this.iRestrictions.get(course)) == null) {
            restrictions = new ArrayList<Restriction>();
            for (Restriction r : course.getOffering().getRestrictions()) {
                if (!r.isApplicable(this.getStudent(), course)) continue;
                restrictions.add(r);
            }
            this.iRestrictions.put(course, restrictions);
        }
        return restrictions;
    }

    public boolean hasRestrictions(Course course) {
        return !this.getRestrictions(course).isEmpty();
    }

    public boolean isNotAllowed(Course course, Config config) {
        List<Restriction> restrictions = this.getRestrictions(course);
        if (restrictions.isEmpty()) {
            return false;
        }
        for (Restriction r : restrictions) {
            if (!r.isIncluded(config)) continue;
            return false;
        }
        return true;
    }

    public boolean isNotAllowed(Course course, Section section) {
        List<Restriction> restrictions = this.getRestrictions(course);
        if (restrictions.isEmpty()) {
            return false;
        }
        for (Restriction r : restrictions) {
            if (!r.isIncluded(section)) continue;
            return false;
        }
        return true;
    }

    public boolean isNotAllowed(Enrollment e) {
        List<Restriction> restrictions = this.getRestrictions(e.getCourse());
        if (restrictions.isEmpty()) {
            return false;
        }
        for (Restriction r : restrictions) {
            if (!r.isIncluded(e)) continue;
            return false;
        }
        return true;
    }

    public synchronized void clearRestrictionCache() {
        if (this.iRestrictions != null) {
            this.iRestrictions.clear();
        }
    }

    @Override
    public boolean isMPP() {
        StudentSectioningModel model = (StudentSectioningModel)this.getModel();
        if (model == null || !model.isMPP()) {
            return false;
        }
        return !this.getStudent().isDummy() && this.getInitialAssignment() != null;
    }

    @Override
    public boolean hasSelection() {
        if (this.getStudent().isDummy() || this.getSelectedChoices().isEmpty()) {
            return false;
        }
        for (Choice choice : this.getSelectedChoices()) {
            if (choice.getSectionId() == null && choice.getConfigId() == null) continue;
            return true;
        }
        return false;
    }

    public void addRequestGroup(RequestGroup group) {
        this.iRequestGroups.add(group);
        group.addRequest(this);
    }

    public void removeRequestGroup(RequestGroup group) {
        this.iRequestGroups.remove(group);
        group.removeRequest(this);
    }

    public Set<RequestGroup> getRequestGroups() {
        return this.iRequestGroups;
    }

    @Override
    public void variableAssigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment enrollment) {
        super.variableAssigned(assignment, iteration, enrollment);
        for (RequestGroup g : this.getRequestGroups()) {
            if (!g.getCourse().equals(enrollment.getCourse())) continue;
            g.assigned(assignment, enrollment);
        }
    }

    @Override
    public void variableUnassigned(Assignment<Request, Enrollment> assignment, long iteration, Enrollment enrollment) {
        super.variableUnassigned(assignment, iteration, enrollment);
        for (RequestGroup g : this.getRequestGroups()) {
            if (!g.getCourse().equals(enrollment.getCourse())) continue;
            g.unassigned(assignment, enrollment);
        }
    }

    @Override
    public float getMinCredit() {
        Float credit = null;
        for (Course course : this.getCourses()) {
            if (course.hasCreditValue() && (credit == null || credit.floatValue() > course.getCreditValue().floatValue())) {
                credit = course.getCreditValue();
            }
            for (Config config : course.getOffering().getConfigs()) {
                Float configCredit = config.getCreditValue();
                if (configCredit == null || credit != null && !(credit.floatValue() > configCredit.floatValue())) continue;
                credit = configCredit;
            }
        }
        return credit == null ? 0.0f : credit.floatValue();
    }

    public boolean isFixed() {
        return this.iFixed != null;
    }

    public Enrollment getFixedValue() {
        return this.iFixed;
    }

    public void setFixedValue(Enrollment constant) {
        this.iFixed = constant;
    }

    @Override
    public boolean hasCourse(Course course) {
        return this.iCourses.contains(course);
    }

    @Override
    public boolean hasChildren() {
        for (Course course : this.iCourses) {
            if (!course.hasChildren()) continue;
            return true;
        }
        return false;
    }
}

