/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.heuristics.studentord.StudentChoiceOrder;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class CriticalCoursesBranchAndBoundSelection
extends BranchBoundSelection {
    protected boolean iMPP = false;
    private Request.RequestPriority iPriority;

    public CriticalCoursesBranchAndBoundSelection(DataProperties properties, Request.RequestPriority priority) {
        super(properties);
        this.iMPP = properties.getPropertyBoolean("General.MPP", false);
        this.iTimeout = properties.getPropertyInt("Neighbour.CriticalCoursesBranchAndBoundTimeout", 10000);
        this.iPriority = priority;
        if (this.iOrder instanceof StudentChoiceOrder) {
            ((StudentChoiceOrder)this.iOrder).setCriticalOnly(true);
            ((StudentChoiceOrder)this.iOrder).setRequestPriority(this.iPriority);
        }
    }

    public CriticalCoursesBranchAndBoundSelection(DataProperties properties) {
        this(properties, Request.RequestPriority.Critical);
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        this.init(solver, this.iPriority.name() + " Courses B&B" + (this.iFilter == null ? "" : " (" + this.iFilter.getName().toLowerCase() + " students)") + "...");
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        Student student = null;
        while ((student = this.nextStudent()) != null) {
            BranchBoundSelection.BranchBoundNeighbour neighbour;
            Progress.getInstance(solution.getModel()).incProgress();
            if (!student.hasUnassignedCritical(solution.getAssignment(), this.iPriority) || (neighbour = this.getSelection(solution.getAssignment(), student).select()) == null) continue;
            return neighbour;
        }
        return null;
    }

    @Override
    public BranchBoundSelection.Selection getSelection(Assignment<Request, Enrollment> assignment, Student student) {
        return new CriticalCoursesSelection(student, assignment);
    }

    public class CriticalCoursesSelection
    extends BranchBoundSelection.Selection {
        public CriticalCoursesSelection(Student student, Assignment<Request, Enrollment> assignment) {
            super(student, assignment);
        }

        public boolean isCritical(int idx) {
            for (int i = idx; i < this.iStudent.getRequests().size(); ++i) {
                Request r = this.iStudent.getRequests().get(i);
                if (r.isAlternative() || !CriticalCoursesBranchAndBoundSelection.this.iPriority.isCritical(r)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void backTrack(int idx) {
            if (!this.isCritical(idx)) {
                if (CriticalCoursesBranchAndBoundSelection.this.iMinimizePenalty) {
                    if (this.getBestAssignment() == null || this.getNrAssigned() > this.getBestNrAssigned() || this.getNrAssigned() == this.getBestNrAssigned() && this.getPenalty() < this.getBestValue()) {
                        this.saveBest();
                    }
                } else if (this.getBestAssignment() == null || this.getValue() < this.getBestValue()) {
                    this.saveBest();
                }
                return;
            }
            if (!(idx >= this.iAssignment.length || CriticalCoursesBranchAndBoundSelection.this.iPriority.isCritical(this.iStudent.getRequests().get(idx)) || CriticalCoursesBranchAndBoundSelection.this.iMPP && this.iStudent.getRequests().get(idx).getInitialAssignment() != null || !this.canLeaveUnassigned(this.iStudent.getRequests().get(idx)))) {
                this.backTrack(idx + 1);
            } else {
                super.backTrack(idx);
            }
        }
    }
}

