/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.constraint;

import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class FreeTimeConflicts
extends GlobalConstraint<Request, Enrollment> {
    @Override
    public void computeConflicts(Assignment<Request, Enrollment> assignment, Enrollment value, Set<Enrollment> conflicts) {
        if (this.inConflict(assignment, value)) {
            conflicts.add(value);
        }
    }

    @Override
    public boolean inConflict(Assignment<Request, Enrollment> assignment, Enrollment value) {
        if (value.isAllowOverlap()) {
            return false;
        }
        Student student = value.getRequest().getStudent();
        for (Request request : student.getRequests()) {
            FreeTimeRequest ft;
            if (request.equals(value.getRequest())) break;
            if (!(request instanceof FreeTimeRequest) || !(ft = (FreeTimeRequest)request).isOverlapping(value.getSections())) continue;
            return true;
        }
        return false;
    }
}

