/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.heuristics;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.ifs.algorithms.SimpleSearch;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.NeighbourSelectionWithContext;
import org.cpsolver.ifs.extension.ConflictStatistics;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solution.SolutionListener;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;

public class MaxIdleNeighbourSelection<V extends Variable<V, T>, T extends Value<V, T>>
extends NeighbourSelectionWithContext<V, T, MaxIdleContext>
implements SolutionListener<V, T> {
    private Logger iLog = LogManager.getLogger(SimpleSearch.class);
    protected NeighbourSelection<V, T> iParent = null;
    protected int iMaxIdle = 1000;
    protected int iBestAssigned = 0;
    protected ConflictStatistics<V, T> iStat = null;
    protected long iTimeOut = -1L;

    public MaxIdleNeighbourSelection(DataProperties properties, NeighbourSelection<V, T> parent, int maxIdle) {
        this.iParent = parent;
        this.iMaxIdle = maxIdle;
        this.iTimeOut = -1L;
        try {
            String idle = properties.getProperty("Search.MinConstructionTime", "10%");
            if (idle != null && !idle.isEmpty()) {
                this.iTimeOut = idle.endsWith("%") ? Math.round(0.01 * Double.parseDouble(idle.substring(0, idle.length() - 1).trim()) * (double)properties.getPropertyLong("Termination.TimeOut", 0L)) : Long.parseLong(idle);
            }
            if (this.iTimeOut > 0L) {
                this.iLog.debug("Minimal construction time is " + this.iTimeOut + " seconds.");
            }
        }
        catch (Exception e) {
            this.iLog.warn("Failed to set the minimal construction time: " + e.getMessage());
        }
    }

    @Override
    public void init(Solver<V, T> solver) {
        super.init(solver);
        this.iParent.init(solver);
        solver.currentSolution().addSolutionListener(this);
        for (Extension<V, T> ext : solver.getExtensions()) {
            if (!(ext instanceof ConflictStatistics)) continue;
            this.iStat = (ConflictStatistics)ext;
        }
    }

    @Override
    public void solutionUpdated(Solution<V, T> solution) {
    }

    @Override
    public void getInfo(Solution<V, T> solution, Map<String, String> info) {
    }

    @Override
    public void getInfo(Solution<V, T> solution, Map<String, String> info, Collection<V> variables) {
    }

    @Override
    public void bestCleared(Solution<V, T> solution) {
        this.iBestAssigned = 0;
        ((MaxIdleContext)this.getContext(solution.getAssignment())).reset(solution);
    }

    @Override
    public void bestSaved(Solution<V, T> solution) {
        if (solution.getAssignment().nrAssignedVariables() > this.iBestAssigned) {
            ((MaxIdleContext)this.getContext(solution.getAssignment())).reset(solution);
        }
        this.iBestAssigned = solution.getAssignment().nrAssignedVariables();
    }

    @Override
    public void bestRestored(Solution<V, T> solution) {
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        if (this.iTimeOut >= 0L && solution.getTime() < (double)this.iTimeOut) {
            return this.iParent.selectNeighbour(solution);
        }
        if (this.iMaxIdle < 0) {
            return this.iParent.selectNeighbour(solution);
        }
        if (this.iMaxIdle == 0) {
            return null;
        }
        MaxIdleContext context = (MaxIdleContext)this.getContext(solution.getAssignment());
        if (context.inc() >= this.iMaxIdle) {
            if (this.iStat != null) {
                Collection<V> unassigned = solution.getAssignment().unassignedVariables(solution.getModel());
                for (Variable v : unassigned) {
                    if (this.iStat.countAssignments(v) >= context.getLimit(v)) continue;
                    return this.iParent.selectNeighbour(solution);
                }
                return null;
            }
            return null;
        }
        return this.iParent.selectNeighbour(solution);
    }

    @Override
    public MaxIdleContext createAssignmentContext(Assignment<V, T> assignment) {
        return new MaxIdleContext(assignment);
    }

    public class MaxIdleContext
    implements AssignmentContext {
        private int iCounter = 0;
        private Map<V, Long> iLimits = new HashMap();

        public MaxIdleContext(Assignment<V, T> assignment) {
        }

        public int inc() {
            return this.iCounter++;
        }

        public long getLimit(V v) {
            return this.iLimits.get(v);
        }

        public void reset(Solution<V, T> solution) {
            this.iCounter = 0;
            this.iLimits.clear();
            if (MaxIdleNeighbourSelection.this.iStat != null) {
                for (Variable v : solution.getModel().variables()) {
                    this.iLimits.put((Long)((Object)v), MaxIdleNeighbourSelection.this.iStat.countAssignments(v) + (long)(MaxIdleNeighbourSelection.this.iMaxIdle / 10));
                }
            }
        }
    }
}

