/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.criteria;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.AssignmentContextHelper;
import org.cpsolver.ifs.assignment.context.AssignmentContextReference;
import org.cpsolver.ifs.assignment.context.CanHoldContext;
import org.cpsolver.ifs.assignment.context.HasAssignmentContext;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;

public abstract class AbstractCriterion<V extends Variable<V, T>, T extends Value<V, T>>
implements Criterion<V, T>,
HasAssignmentContext<V, T, ValueContext>,
CanHoldContext {
    private Model<V, T> iModel;
    protected double iBest = 0.0;
    protected double iWeight = 0.0;
    protected static DecimalFormat sDoubleFormat = new DecimalFormat("0.##", new DecimalFormatSymbols(Locale.US));
    protected static DecimalFormat sPercentFormat = new DecimalFormat("0.##", new DecimalFormatSymbols(Locale.US));
    protected boolean iDebug = false;
    private AssignmentContextReference<V, T, ValueContext> iContextReference = null;
    private AssignmentContext[] iContext = new AssignmentContext[17];
    private int iLastCacheId = 0;
    private ValueUpdateType iValueUpdateType = ValueUpdateType.BeforeUnassignedBeforeAssigned;

    public String getWeightName() {
        return "Weight." + this.getClass().getName().substring(1 + this.getClass().getName().lastIndexOf(46));
    }

    public double getWeightDefault(DataProperties config) {
        return 0.0;
    }

    @Override
    public void setModel(Model<V, T> model) {
        this.iModel = model;
        if (model != null) {
            this.iContextReference = model.createReference(this);
        }
    }

    @Override
    public void configure(DataProperties properties) {
        this.iWeight = properties.getPropertyDouble(this.getWeightName(), this.getWeightDefault(properties));
        this.iDebug = properties.getPropertyBoolean("Debug." + this.getClass().getName().substring(1 + this.getClass().getName().lastIndexOf(46)), properties.getPropertyBoolean("Debug.Criterion", false));
    }

    @Override
    public boolean init(Solver<V, T> solver) {
        this.configure(solver.getProperties());
        return true;
    }

    public Model<V, T> getModel() {
        return this.iModel;
    }

    @Override
    public ValueContext getContext(Assignment<V, T> assignment) {
        return (ValueContext)AssignmentContextHelper.getContext(this, assignment);
    }

    @Override
    public ValueContext createAssignmentContext(Assignment<V, T> assignment) {
        return new ValueContext(assignment);
    }

    @Override
    public AssignmentContextReference<V, T, ValueContext> getAssignmentContextReference() {
        return this.iContextReference;
    }

    @Override
    public void setAssignmentContextReference(AssignmentContextReference<V, T, ValueContext> reference) {
        this.iContextReference = reference;
    }

    @Override
    public AssignmentContext[] getContext() {
        return this.iContext;
    }

    @Override
    public double getValue(Assignment<V, T> assignment) {
        return ((ValueContext)this.getContext((Assignment)assignment)).getTotal();
    }

    @Override
    public double getBest() {
        return this.iBest;
    }

    @Override
    public double getValue(Assignment<V, T> assignment, Collection<V> variables) {
        double ret = 0.0;
        for (Variable v : variables) {
            T t = assignment.getValue(v);
            if (t == null) continue;
            ret += this.getValue(assignment, t, null);
        }
        return ret;
    }

    @Override
    public double getWeight() {
        return this.iWeight;
    }

    @Override
    public double getWeightedBest() {
        return this.getWeight() == 0.0 ? 0.0 : this.getWeight() * this.getBest();
    }

    @Override
    public double getWeightedValue(Assignment<V, T> assignment) {
        return this.getWeight() == 0.0 ? 0.0 : this.getWeight() * this.getValue(assignment);
    }

    @Override
    public double getWeightedValue(Assignment<V, T> assignment, T value, Set<T> conflicts) {
        return this.getWeight() == 0.0 ? 0.0 : this.getWeight() * this.getValue(assignment, value, conflicts);
    }

    @Override
    public double getWeightedValue(Assignment<V, T> assignment, Collection<V> variables) {
        return this.getWeight() == 0.0 ? 0.0 : this.getWeight() * this.getValue(assignment, variables);
    }

    protected double[] computeBounds(Assignment<V, T> assignment) {
        return this.getBounds(assignment, new ArrayList<V>(this.getModel().variables()));
    }

    @Override
    public double[] getBounds(Assignment<V, T> assignment) {
        return ((ValueContext)this.getContext((Assignment)assignment)).getBounds(assignment);
    }

    @Override
    public double[] getBounds(Assignment<V, T> assignment, Collection<V> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        for (Variable v : variables) {
            Double min = null;
            Double max = null;
            for (Value t : v.values(assignment)) {
                double value = this.getValue(assignment, t, null);
                if (min == null) {
                    min = value;
                    max = value;
                    continue;
                }
                min = Math.min(min, value);
                max = Math.max(max, value);
            }
            if (min == null) continue;
            bounds[0] = bounds[0] + min;
            bounds[1] = bounds[1] + max;
        }
        return bounds;
    }

    @Override
    public void beforeAssigned(Assignment<V, T> assignment, long iteration, T value) {
        switch (this.getValueUpdateType()) {
            case AfterUnassignedBeforeAssigned: 
            case BeforeUnassignedBeforeAssigned: {
                ((ValueContext)this.getContext((Assignment)assignment)).assigned(assignment, value);
            }
        }
    }

    @Override
    public void afterAssigned(Assignment<V, T> assignment, long iteration, T value) {
        switch (this.getValueUpdateType()) {
            case AfterUnassignedAfterAssigned: 
            case BeforeUnassignedAfterAssigned: {
                ((ValueContext)this.getContext((Assignment)assignment)).assigned(assignment, value);
            }
        }
    }

    @Override
    public void beforeUnassigned(Assignment<V, T> assignment, long iteration, T value) {
        switch (this.getValueUpdateType()) {
            case BeforeUnassignedBeforeAssigned: 
            case BeforeUnassignedAfterAssigned: {
                ((ValueContext)this.getContext((Assignment)assignment)).unassigned(assignment, value);
            }
        }
    }

    @Override
    public void afterUnassigned(Assignment<V, T> assignment, long iteration, T value) {
        switch (this.getValueUpdateType()) {
            case AfterUnassignedBeforeAssigned: 
            case AfterUnassignedAfterAssigned: {
                ((ValueContext)this.getContext((Assignment)assignment)).unassigned(assignment, value);
            }
        }
    }

    @Override
    public void bestSaved(Assignment<V, T> assignment) {
        this.iBest = ((ValueContext)this.getContext((Assignment)assignment)).getTotal();
    }

    @Override
    public void bestRestored(Assignment<V, T> assignment) {
        ((ValueContext)this.getContext((Assignment)assignment)).setTotal(this.iBest);
    }

    @Override
    public void inc(Assignment<V, T> assignment, double value) {
        ((ValueContext)this.getContext((Assignment)assignment)).inc(value);
    }

    @Override
    public String getName() {
        return this.getClass().getName().substring(1 + this.getClass().getName().lastIndexOf(46)).replaceAll("(?<=[^A-Z])([A-Z])", " $1");
    }

    protected void clearCache() {
        ++this.iLastCacheId;
    }

    @Override
    public void variableAdded(V variable) {
        this.clearCache();
    }

    @Override
    public void variableRemoved(V variable) {
        this.clearCache();
    }

    @Override
    public void constraintAdded(Constraint<V, T> constraint) {
        this.clearCache();
    }

    @Override
    public void constraintRemoved(Constraint<V, T> constraint) {
        this.clearCache();
    }

    protected String getPerc(double value, double min, double max) {
        if (max == min) {
            return sPercentFormat.format(100.0);
        }
        return sPercentFormat.format(100.0 - 100.0 * (value - min) / (max - min));
    }

    protected String getPercRev(double value, double min, double max) {
        if (max == min) {
            return sPercentFormat.format(0.0);
        }
        return sPercentFormat.format(100.0 * (value - min) / (max - min));
    }

    @Override
    public void getInfo(Assignment<V, T> assignment, Map<String, String> info) {
    }

    @Override
    public void getInfo(Assignment<V, T> assignment, Map<String, String> info, Collection<V> variables) {
    }

    public String getPercentage(Assignment<V, T> assignment) {
        double val = this.getValue(assignment);
        double[] bounds = this.getBounds(assignment);
        if (bounds[0] <= val && val <= bounds[1] && bounds[0] < bounds[1]) {
            return this.getPerc(val, bounds[0], bounds[1]) + "%";
        }
        if (bounds[1] <= val && val <= bounds[0] && bounds[1] < bounds[0]) {
            return this.getPercRev(val, bounds[1], bounds[0]) + "%";
        }
        return sDoubleFormat.format(val);
    }

    @Override
    public void getExtendedInfo(Assignment<V, T> assignment, Map<String, String> info) {
        if (this.iDebug) {
            double val = this.getValue(assignment);
            double w = this.getWeightedValue(assignment);
            double prec = this.getValue(assignment, this.getModel().variables());
            double[] bounds = this.getBounds(assignment);
            if (bounds[0] <= val && val <= bounds[1] && bounds[0] < bounds[1]) {
                info.put("[C] " + this.getName(), this.getPerc(val, bounds[0], bounds[1]) + "% (value: " + sDoubleFormat.format(val) + (Math.abs(prec - val) > 1.0E-4 ? ", precise:" + sDoubleFormat.format(prec) : "") + ", weighted:" + sDoubleFormat.format(w) + ", bounds: " + sDoubleFormat.format(bounds[0]) + ".." + sDoubleFormat.format(bounds[1]) + ")");
            } else if (bounds[1] <= val && val <= bounds[0] && bounds[1] < bounds[0]) {
                info.put("[C] " + this.getName(), this.getPercRev(val, bounds[1], bounds[0]) + "% (value: " + sDoubleFormat.format(val) + (Math.abs(prec - val) > 1.0E-4 ? ", precise:" + sDoubleFormat.format(prec) : "") + ", weighted:" + sDoubleFormat.format(w) + ", bounds: " + sDoubleFormat.format(bounds[1]) + ".." + sDoubleFormat.format(bounds[0]) + ")");
            } else if (bounds[0] != val || val != bounds[1]) {
                info.put("[C] " + this.getName(), sDoubleFormat.format(val) + " (" + (Math.abs(prec - val) > 1.0E-4 ? "precise:" + sDoubleFormat.format(prec) + ", " : "") + "weighted:" + sDoubleFormat.format(w) + (bounds[0] != bounds[1] ? ", bounds: " + sDoubleFormat.format(bounds[0]) + ".." + sDoubleFormat.format(bounds[1]) : "") + ")");
            }
        }
    }

    @Override
    @Deprecated
    public double getWeightedValue() {
        return this.getWeightedValue(this.getModel().getDefaultAssignment());
    }

    @Override
    @Deprecated
    public double[] getBounds() {
        return this.getBounds(this.getModel().getDefaultAssignment());
    }

    @Override
    @Deprecated
    public double getWeightedValue(T value, Set<T> conflicts) {
        return this.getWeightedValue(this.getModel().getDefaultAssignment(), value, conflicts);
    }

    @Override
    @Deprecated
    public double getValue(T value, Set<T> conflicts) {
        return this.getValue(this.getModel().getDefaultAssignment(), value, conflicts);
    }

    @Override
    @Deprecated
    public double getWeightedValue(Collection<V> variables) {
        return this.getWeightedValue(this.getModel().getDefaultAssignment(), variables);
    }

    @Override
    @Deprecated
    public double getValue(Collection<V> variables) {
        return this.getValue(this.getModel().getDefaultAssignment(), variables);
    }

    @Override
    @Deprecated
    public double[] getBounds(Collection<V> variables) {
        return this.getBounds(this.getModel().getDefaultAssignment(), variables);
    }

    @Override
    @Deprecated
    public void inc(double value) {
        this.inc(this.getModel().getDefaultAssignment(), value);
    }

    public String getAbbreviation() {
        return this.getName().replaceAll("[a-z ]", "");
    }

    @Override
    public String toString(Assignment<V, T> assignment) {
        double val = this.getValue(assignment);
        if (Math.abs(this.getWeightedValue(assignment)) < 0.005) {
            return "";
        }
        double[] bounds = this.getBounds(assignment);
        if (bounds[0] <= val && val <= bounds[1] && bounds[0] < bounds[1] && this.getName().endsWith(" Preferences")) {
            return this.getAbbreviation() + ":" + sDoubleFormat.format(this.getValue(assignment)) + " (" + this.getPerc(val, bounds[0], bounds[1]) + "%)";
        }
        if (bounds[1] <= val && val <= bounds[0] && bounds[1] < bounds[0] && this.getName().endsWith(" Preferences")) {
            return this.getAbbreviation() + ":" + sDoubleFormat.format(this.getValue(assignment)) + " (" + this.getPercRev(val, bounds[1], bounds[0]) + ")%";
        }
        if (bounds[0] != val || val != bounds[1]) {
            return this.getAbbreviation() + ":" + sDoubleFormat.format(this.getValue(assignment));
        }
        return "";
    }

    public ValueUpdateType getValueUpdateType() {
        return this.iValueUpdateType;
    }

    public void setValueUpdateType(ValueUpdateType iValueUpdateType) {
        this.iValueUpdateType = iValueUpdateType;
    }

    public class ValueContext
    implements AssignmentContext {
        protected double iTotal = 0.0;
        private double[] iBounds = null;
        private int iCacheId = -1;

        protected ValueContext(Assignment<V, T> assignment) {
            if (AbstractCriterion.this.getValueUpdateType() != ValueUpdateType.NoUpdate) {
                this.iTotal = AbstractCriterion.this.getValue(assignment, AbstractCriterion.this.getModel().variables());
            }
        }

        protected ValueContext() {
        }

        protected void unassigned(Assignment<V, T> assignment, T value) {
            this.iTotal -= AbstractCriterion.this.getValue(assignment, value, null);
        }

        protected void assigned(Assignment<V, T> assignment, T value) {
            this.iTotal += AbstractCriterion.this.getValue(assignment, value, null);
        }

        public double getTotal() {
            return this.iTotal;
        }

        public void setTotal(double value) {
            this.iTotal = value;
        }

        public void inc(double value) {
            this.iTotal += value;
        }

        protected double[] getBounds(Assignment<V, T> assignment) {
            double[] dArray;
            if (this.iBounds == null || this.iCacheId < AbstractCriterion.this.iLastCacheId) {
                this.iCacheId = AbstractCriterion.this.iLastCacheId;
                this.iBounds = AbstractCriterion.this.computeBounds(assignment);
            }
            if (this.iBounds == null) {
                double[] dArray2 = new double[2];
                dArray2[0] = 0.0;
                dArray = dArray2;
                dArray2[1] = 0.0;
            } else {
                dArray = this.iBounds;
            }
            return dArray;
        }

        protected void setBounds(double[] bounds) {
            this.iBounds = bounds;
        }
    }

    protected static enum ValueUpdateType {
        BeforeUnassignedBeforeAssigned,
        AfterUnassignedBeforeAssigned,
        BeforeUnassignedAfterAssigned,
        AfterUnassignedAfterAssigned,
        NoUpdate;

    }
}

