/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.algorithms.neighbourhoods;

import java.util.List;
import org.cpsolver.ifs.algorithms.neighbourhoods.HillClimberSelection;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.SimpleNeighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class RandomMove<V extends Variable<V, T>, T extends Value<V, T>>
implements NeighbourSelection<V, T>,
HillClimberSelection {
    protected boolean iHC = false;

    public RandomMove(DataProperties config) {
    }

    @Override
    public void setHcMode(boolean hcMode) {
        this.iHC = hcMode;
    }

    @Override
    public void init(Solver<V, T> solver) {
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        Model<V, Value> model = solution.getModel();
        Assignment<V, T> assignment = solution.getAssignment();
        int varIdx = ToolBox.random(model.variables().size());
        for (int i = 0; i < model.variables().size(); ++i) {
            Variable variable = (Variable)model.variables().get((i + varIdx) % model.variables().size());
            List<T> values = variable.values(solution.getAssignment());
            if (values.isEmpty()) continue;
            int valIdx = ToolBox.random(values.size());
            for (int j = 0; j < values.size(); ++j) {
                Value value = (Value)values.get((j + valIdx) % values.size());
                if (model.inConflict(assignment, value)) continue;
                SimpleNeighbour<Variable, Value> n = new SimpleNeighbour<Variable, Value>(variable, value);
                if (this.iHC && !(n.value(assignment) <= 0.0)) continue;
                return n;
            }
        }
        return null;
    }
}

