/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.reports;

import java.text.DecimalFormat;
import java.util.List;
import org.cpsolver.exam.criteria.StudentBackToBackConflicts;
import org.cpsolver.exam.criteria.StudentDistanceBackToBackConflicts;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.CSVFile;

public class ExamStudentBackToBackConflicts {
    private ExamModel iModel = null;

    public ExamStudentBackToBackConflicts(ExamModel model) {
        this.iModel = model;
    }

    public CSVFile report(Assignment<Exam, ExamPlacement> assignment) {
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField("Exam 1"), new CSVFile.CSVField("Enrl 1"), new CSVFile.CSVField("Period 1"), new CSVFile.CSVField("Date 1"), new CSVFile.CSVField("Time 1"), new CSVFile.CSVField("Exam 2"), new CSVFile.CSVField("Enrl 2"), new CSVFile.CSVField("Back-To-Back"), new CSVFile.CSVField("Back-To-Back [%]"), new CSVFile.CSVField("Distance")});
        DecimalFormat df = new DecimalFormat("0.0");
        boolean isDayBreakBackToBack = ((StudentBackToBackConflicts)this.iModel.getCriterion(StudentBackToBackConflicts.class)).isDayBreakBackToBack();
        double backToBackDistance = ((StudentDistanceBackToBackConflicts)this.iModel.getCriterion(StudentDistanceBackToBackConflicts.class)).getBackToBackDistance();
        for (Exam ex1 : this.iModel.variables()) {
            ExamPlacement p1 = assignment.getValue(ex1);
            if (p1 == null || p1.getPeriod().next() == null || !isDayBreakBackToBack && p1.getPeriod().getDay() != p1.getPeriod().next().getDay()) continue;
            for (Exam ex2 : this.iModel.variables()) {
                double dist;
                List<ExamStudent> students;
                ExamPlacement p2 = assignment.getValue(ex2);
                if (p2 == null || !p2.getPeriod().equals(p1.getPeriod().next()) || (students = ex1.getJointEnrollments().get(ex2)) == null || students.isEmpty()) continue;
                String distStr = "";
                if (backToBackDistance >= 0.0 && (dist = p1.getDistanceInMeters(p2)) > 0.0) {
                    distStr = String.valueOf(dist);
                }
                csv.addLine(new CSVFile.CSVField[]{new CSVFile.CSVField(ex1.getName()), new CSVFile.CSVField(ex1.getStudents().size()), new CSVFile.CSVField(p1.getPeriod().getIndex() + 1), new CSVFile.CSVField(p1.getPeriod().getDayStr()), new CSVFile.CSVField(p1.getPeriod().getTimeStr()), new CSVFile.CSVField(ex2.getName()), new CSVFile.CSVField(ex2.getStudents().size()), new CSVFile.CSVField(students.size()), new CSVFile.CSVField(df.format(100.0 * (double)students.size() / (double)Math.min(ex1.getStudents().size(), ex2.getStudents().size()))), new CSVFile.CSVField(distStr)});
            }
        }
        return csv;
    }
}

