/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria.additional;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamDistributionConstraint;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;

public class DistributionViolation
extends ExamCriterion {
    public DistributionViolation() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.NoUpdate);
    }

    @Override
    public String getWeightName() {
        return "Exam.SoftDistributions";
    }

    @Override
    public String getXmlWeightName() {
        return "softDistributions";
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        int penalty = 0;
        ExamPlacement original = assignment.getValue((Exam)value.variable());
        for (ExamDistributionConstraint dc : ((Exam)value.variable()).getDistributionConstraints()) {
            if (dc.isHard() || this.getWeight() != (double)dc.getWeight()) continue;
            penalty += dc.countViolations(assignment, value);
            if (original == null) continue;
            penalty -= dc.countViolations(assignment, original);
        }
        return penalty;
    }

    @Override
    protected double[] computeBounds(Assignment<Exam, ExamPlacement> assignment) {
        double[] bounds = new double[]{0.0, 0.0};
        for (ExamDistributionConstraint dc : ((ExamModel)this.getModel()).getDistributionConstraints()) {
            if (dc.isHard() || this.getWeight() != (double)dc.getWeight()) continue;
            bounds[1] = bounds[1] + (double)(dc.variables().size() * (dc.variables().size() - 1) / 2);
        }
        return bounds;
    }

    @Override
    public boolean isRoomCriterion() {
        return true;
    }

    @Override
    public double getRoomValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value) {
        int penalty = 0;
        ExamPlacement original = assignment.getValue((Exam)value.variable());
        for (ExamDistributionConstraint dc : ((Exam)value.variable()).getDistributionConstraints()) {
            if (dc.isHard() || this.getWeight() != (double)dc.getWeight() || !dc.isRoomRelated()) continue;
            penalty += dc.countViolations(assignment, value);
            if (original == null) continue;
            penalty -= dc.countViolations(assignment, original);
        }
        return penalty;
    }

    @Override
    public boolean isPeriodCriterion() {
        return true;
    }

    @Override
    public double getPeriodValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value) {
        int penalty = 0;
        ExamPlacement original = assignment.getValue((Exam)value.variable());
        for (ExamDistributionConstraint dc : ((Exam)value.variable()).getDistributionConstraints()) {
            if (dc.isHard() || this.getWeight() != (double)dc.getWeight() || !dc.isPeriodRelated()) continue;
            penalty += dc.countViolations(assignment, value);
            if (original == null) continue;
            penalty -= dc.countViolations(assignment, original);
        }
        return penalty;
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, Collection<Exam> variables) {
        int penalty = 0;
        HashSet<ExamDistributionConstraint> added = new HashSet<ExamDistributionConstraint>();
        for (Exam exam : variables) {
            for (ExamDistributionConstraint dc : exam.getDistributionConstraints()) {
                if (!added.add(dc) || dc.isHard() || this.getWeight() != (double)dc.getWeight()) continue;
                penalty += dc.countViolations(assignment);
            }
        }
        return penalty;
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return this.getValue(assignment) <= 0.0 ? "" : "!D:" + sDoubleFormat.format(this.getValue(assignment));
    }
}

