/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil.csv;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.cpsolver.ifs.util.CSVFile;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.ClassAssignmentsReportForm;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.comparators.InstructorComparator;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.CachedClassAssignmentProxy;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamAssignmentProxy;
import org.unitime.timetable.webutil.csv.CsvClassListTableBuilder;

public class CsvClassAssignmentReportListTableBuilder
extends CsvClassListTableBuilder {
    @Override
    protected String additionalNote() {
        return " " + MSG.classAssignmentsAdditionalNote();
    }

    @Override
    protected CSVFile.CSVField csvBuildDatePatternCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        ClassAssignmentProxy.AssignmentInfo a = null;
        if (this.getDisplayTimetable() && this.isShowTimetable() && classAssignment != null && prefGroup instanceof Class_) {
            try {
                a = classAssignment.getAssignment((Class_)prefGroup);
            }
            catch (Exception e) {
                Debug.error(e);
            }
        }
        DatePattern dp = a != null ? a.getDatePattern() : prefGroup.effectiveDatePattern();
        CSVFile.CSVField cell = this.createCell();
        if (dp != null) {
            this.addText(cell, dp.getName(), true);
        }
        return cell;
    }

    /*
     * WARNING - void declaration
     */
    public void csvTableForClasses(PrintWriter out, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, ClassAssignmentsReportForm form, SessionContext context) throws Exception {
        this.setVisibleColumns(form);
        Collection<Class_> classes = form.getClasses();
        if (this.isShowTimetable()) {
            boolean hasTimetable = false;
            if (context.hasPermission(Right.ClassAssignments) && classAssignment != null) {
                if (classAssignment instanceof CachedClassAssignmentProxy) {
                    ((CachedClassAssignmentProxy)classAssignment).setCache(classes);
                }
                for (Object[] objectArray : classes) {
                    Class_ clazz = (Class_)objectArray[0];
                    if (classAssignment.getAssignment(clazz) == null) continue;
                    hasTimetable = true;
                    break;
                }
            }
            this.setDisplayTimetable(hasTimetable);
        }
        this.setUserSettings(context.getUser());
        if (examAssignment != null || Exam.hasTimetable(context.getUser().getCurrentAcademicSessionId())) {
            this.setShowExam(true);
            this.setShowExamTimetable(true);
            this.setShowExamName(false);
        }
        this.setShowInstructor(true);
        if (this.sessionHasEnrollments(context.getUser().getCurrentAcademicSessionId())) {
            this.setShowDemand(true);
        }
        this.iFile = new CSVFile();
        int ct = 0;
        Iterator<Class_> it = classes.iterator();
        Object var9_10 = null;
        String prevLabel = null;
        while (it.hasNext()) {
            void var9_11;
            Object[] o = (Object[])it.next();
            Class_ c = (Class_)o[0];
            CourseOffering co = (CourseOffering)o[1];
            if (var9_11 == null || !var9_11.getUniqueId().equals(co.getSubjectArea().getUniqueId())) {
                if (this.iFile.getLines() != null) {
                    this.iFile.addLine();
                }
                SubjectArea subjectArea = co.getSubjectArea();
                ct = 0;
                this.iFile.addLine(this.labelForTable(subjectArea));
                this.csvBuildTableHeader(context.getUser().getCurrentAcademicSessionId());
            }
            this.csvBuildClassRow(classAssignment, examAssignment, ++ct, co, c, "", context, prevLabel);
            prevLabel = c.getClassLabel(co);
        }
        this.save(out);
    }

    @Override
    protected CSVFile.CSVField csvBuildInstructor(PreferenceGroup prefGroup, boolean isEditable) {
        Class_ aClass;
        CSVFile.CSVField cell = this.createCell();
        if (prefGroup instanceof Class_ && (aClass = (Class_)prefGroup).isDisplayInstructor().booleanValue()) {
            InstructorComparator ic = new InstructorComparator();
            if (ApplicationProperty.InstructorsDropdownFollowNameFormatting.isTrue()) {
                ic.setNameFormat(this.getInstructorNameFormat());
            }
            TreeSet<ClassInstructor> sortedInstructors = new TreeSet<ClassInstructor>(ic);
            sortedInstructors.addAll(aClass.getClassInstructors());
            for (ClassInstructor ci : sortedInstructors) {
                String label = ci.getInstructor().getName(this.getInstructorNameFormat());
                this.addText(cell, label, true);
            }
        }
        return cell;
    }
}

