/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util.queue;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.LogManager;
import org.jgroups.Address;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.events.QueryEncoderBackend;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.util.queue.QueueMessage;

public abstract class QueueItem
implements Log,
Serializable,
Comparable<QueueItem> {
    private static final long serialVersionUID = 1L;
    protected static final GwtMessages GWT_MSG = Localization.create(GwtMessages.class);
    private Long iSessionId;
    private String iOwnerId;
    private String iOwnerName;
    private String iOwnerEmail;
    private transient File iOutput = null;
    private String iOutputName = null;
    private String iOutputLink = null;
    private List<QueueMessage> iLog = new ArrayList<QueueMessage>();
    private String iStatus = null;
    private Date iCreated = new Date();
    private Date iStarted = null;
    private Date iFinished = null;
    private transient Throwable iException = null;
    private String iLocale = null;
    private double iProgress = 0.0;
    private double iMaxProgress = 100.0;
    private String iId = null;
    private String iHost = null;
    private Long iTaskExecutionId = null;

    public QueueItem(Long sessionId, UserContext owner) {
        this.iSessionId = sessionId;
        this.iOwnerId = owner.getExternalUserId();
        this.iOwnerName = owner.getName();
        this.iOwnerEmail = owner.getEmail();
        this.iLocale = Localization.getLocale();
        this.iStatus = GWT_MSG.scriptStatusWaiting();
    }

    public QueueItem(Session session, UserContext owner) {
        this(session.getUniqueId(), owner);
    }

    public QueueItem(UserContext owner) {
        this(owner.getCurrentAcademicSessionId(), owner);
    }

    public Long getSessionId() {
        return this.iSessionId;
    }

    public Session getSession() {
        return (Session)SessionDAO.getInstance().get(this.iSessionId);
    }

    public String getOwnerId() {
        return this.iOwnerId;
    }

    public String getOwnerName() {
        return this.iOwnerName;
    }

    public boolean hasOwnerEmail() {
        return this.iOwnerEmail != null && !this.iOwnerEmail.isEmpty();
    }

    public String getOwnerEmail() {
        return this.iOwnerEmail;
    }

    public String getLocale() {
        return this.iLocale;
    }

    public Long getTaskExecutionId() {
        return this.iTaskExecutionId;
    }

    public void setTaskExecutionId(Long executionId) {
        this.iTaskExecutionId = executionId;
    }

    public abstract String type();

    public abstract String name();

    protected abstract void execute() throws Exception;

    public void executeItem() {
        this.iStarted = new Date();
        ApplicationProperties.setSessionId(this.getSessionId());
        Localization.setLocale(this.getLocale());
        try {
            this.execute();
        }
        catch (ThreadDeath e) {
            this.fatal(GWT_MSG.scriptLogExecutionStopped(), e);
        }
        catch (Exception e) {
            this.fatal(GWT_MSG.scriptLogExecutionFailed(), e);
        }
        finally {
            ApplicationProperties.setSessionId(null);
            HibernateUtil.closeCurrentThreadSessions();
            Localization.removeLocale();
        }
        this.iFinished = new Date();
        this.iStatus = GWT_MSG.scriptStatusAllDone();
        if (this.iException != null) {
            this.iStatus = this.iException instanceof ThreadDeath ? GWT_MSG.scriptStatusKilled() : GWT_MSG.scriptStatusFailed(this.iException.getMessage());
        }
    }

    public boolean hasOutput() {
        return this.iFinished != null && this.iOutputLink != null;
    }

    public File output() {
        return this.iOutput;
    }

    public void setOutput(File output) {
        this.iOutput = output;
        this.iOutputName = output == null ? null : output.getName();
        this.iOutputLink = output == null ? null : "qpfile?q=" + QueryEncoderBackend.encode(this.getId().toString());
    }

    protected File createOutput(String prefix, String ext) {
        if (this.iOutput != null) {
            throw new RuntimeException(GWT_MSG.scriptErrorOutputAlreadyCreated());
        }
        this.iOutput = ApplicationProperties.getTempFile(prefix, ext);
        this.iOutputName = prefix + "." + ext;
        this.iOutputLink = "qpfile?q=" + QueryEncoderBackend.encode(this.getId().toString());
        return this.iOutput;
    }

    public String getOutputName() {
        return this.iOutputName;
    }

    public String getOutputLink() {
        if (this.iOutput != null) {
            return "temp/" + this.iOutput.getName();
        }
        return this.iOutputLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueueMessage> getLog() {
        List<QueueMessage> list = this.iLog;
        synchronized (list) {
            return new ArrayList<QueueMessage>(this.iLog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String log() {
        List<QueueMessage> list = this.iLog;
        synchronized (list) {
            Object ret = "";
            for (QueueMessage m : this.iLog) {
                if (!((String)ret).isEmpty()) {
                    ret = (String)ret + "<br>";
                }
                ret = (String)ret + m.toHTML();
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String message) {
        List<QueueMessage> list = this.iLog;
        synchronized (list) {
            this.iLog.add(new QueueMessage(QueueMessage.Level.HTML, message));
        }
    }

    public void setStatus(String status) {
        this.setStatus(status, 100.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(String status, double maxProgress) {
        List<QueueMessage> list = this.iLog;
        synchronized (list) {
            this.iStatus = status;
            this.iProgress = 0.0;
            this.iMaxProgress = maxProgress;
            this.iLog.add(new QueueMessage(QueueMessage.Level.STAGE, status));
        }
    }

    public String status() {
        return this.iStatus;
    }

    public double progress() {
        return this.iProgress / this.iMaxProgress;
    }

    public void incProgress() {
        this.iProgress += 1.0;
    }

    public void incProgress(double value) {
        this.iProgress += value;
    }

    public void setProgress(double value) {
        this.iProgress = value;
    }

    public boolean hasError() {
        return this.iException != null;
    }

    protected void setError(Throwable exception) {
        this.iException = exception;
    }

    public Throwable error() {
        return this.iException;
    }

    public String getId() {
        return this.iId;
    }

    public void setId(String id) {
        this.iId = id;
    }

    public String getHost() {
        return this.iHost == null ? "Local" : this.iHost;
    }

    public void setAddress(Address address) {
        this.iHost = address == null ? null : address.toString();
    }

    public Date created() {
        return this.iCreated;
    }

    public Date started() {
        return this.iStarted;
    }

    public Date finished() {
        return this.iFinished;
    }

    public boolean isDebugEnabled() {
        return LogManager.getLogger(this.getClass()).isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return false;
    }

    public boolean isInfoEnabled() {
        return LogManager.getLogger(this.getClass()).isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return LogManager.getLogger(this.getClass()).isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(Object message) {
        LogManager.getLogger(this.getClass()).trace(message);
        List<QueueMessage> list = this.iLog;
        synchronized (list) {
            this.iLog.add(new QueueMessage(QueueMessage.Level.TRACE, message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(Object message, Throwable t) {
        LogManager.getLogger(this.getClass()).trace(message, t);
        List<QueueMessage> list = this.iLog;
        synchronized (list) {
            this.iLog.add(new QueueMessage(QueueMessage.Level.TRACE, message, t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(Object message) {
        LogManager.getLogger(this.getClass()).debug(message);
        List<QueueMessage> list = this.iLog;
        synchronized (list) {
            this.iLog.add(new QueueMessage(QueueMessage.Level.DEBUG, message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(Object message, Throwable t) {
        LogManager.getLogger(this.getClass()).debug(message, t);
        List<QueueMessage> list = this.iLog;
        synchronized (list) {
            this.iLog.add(new QueueMessage(QueueMessage.Level.DEBUG, message, t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(Object message) {
        LogManager.getLogger(this.getClass()).info(message);
        List<QueueMessage> list = this.iLog;
        synchronized (list) {
            this.iLog.add(new QueueMessage(QueueMessage.Level.INFO, message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(Object message, Throwable t) {
        LogManager.getLogger(this.getClass()).info(message, t);
        List<QueueMessage> list = this.iLog;
        synchronized (list) {
            this.iLog.add(new QueueMessage(QueueMessage.Level.INFO, message, t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(Object message) {
        LogManager.getLogger(this.getClass()).warn(message);
        List<QueueMessage> list = this.iLog;
        synchronized (list) {
            this.iLog.add(new QueueMessage(QueueMessage.Level.WARN, message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(Object message, Throwable t) {
        LogManager.getLogger(this.getClass()).warn(message, t);
        List<QueueMessage> list = this.iLog;
        synchronized (list) {
            this.iLog.add(new QueueMessage(QueueMessage.Level.WARN, message, t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Object message) {
        LogManager.getLogger(this.getClass()).error(message);
        List<QueueMessage> list = this.iLog;
        synchronized (list) {
            this.iLog.add(new QueueMessage(QueueMessage.Level.ERROR, message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Object message, Throwable t) {
        LogManager.getLogger(this.getClass()).error(message, t);
        List<QueueMessage> list = this.iLog;
        synchronized (list) {
            this.iLog.add(new QueueMessage(QueueMessage.Level.ERROR, message, t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fatal(Object message) {
        LogManager.getLogger(this.getClass()).fatal(message);
        List<QueueMessage> list = this.iLog;
        synchronized (list) {
            this.iLog.add(new QueueMessage(QueueMessage.Level.FATAL, message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fatal(Object message, Throwable t) {
        LogManager.getLogger(this.getClass()).fatal(message, t);
        List<QueueMessage> list = this.iLog;
        synchronized (list) {
            this.iLog.add(new QueueMessage(QueueMessage.Level.FATAL, message, t));
        }
    }

    @Override
    public int compareTo(QueueItem item) {
        int cmp = this.created().compareTo(item.created());
        if (cmp != 0) {
            return cmp;
        }
        return this.getId().compareTo(item.getId());
    }
}

