/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.spring.security;

import org.hibernate.Session;
import org.unitime.timetable.interfaces.ExternalUidTranslation;
import org.unitime.timetable.model.User;
import org.unitime.timetable.model.dao.UserDAO;

public class UserTableExternalUidTranslation
implements ExternalUidTranslation {
    @Override
    public String translate(String uid, ExternalUidTranslation.Source source, ExternalUidTranslation.Source target) {
        if (uid == null || source.equals((Object)target)) {
            return uid;
        }
        if (source.equals((Object)ExternalUidTranslation.Source.LDAP)) {
            return this.uid2ext(uid);
        }
        if (target.equals((Object)ExternalUidTranslation.Source.LDAP)) {
            return this.ext2uid(uid);
        }
        return uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uid2ext(String username) {
        try (Session hibSession = UserDAO.getInstance().createNewSession();){
            User user = (User)hibSession.createQuery("from User where username=:username", User.class).setParameter("username", (Object)username).setMaxResults(1).uniqueResult();
            String string = user == null ? username : user.getExternalUniqueId();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ext2uid(String externalUniqueId) {
        try (Session hibSession = UserDAO.getInstance().createNewSession();){
            User user = (User)hibSession.createQuery("from User where externalUniqueId=:externalUniqueId", User.class).setParameter("externalUniqueId", (Object)externalUniqueId).setMaxResults(1).uniqueResult();
            String string = user == null ? externalUniqueId : user.getUsername();
            return string;
        }
    }
}

