/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.spring.oauth2;

import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.ExternalUidTranslation;
import org.unitime.timetable.spring.oauth2.UniTimeOidcUserContext;

@Service(value="unitimeOidcUserService")
public class UniTimeOidcUserService
extends OidcUserService {
    private ExternalUidTranslation iTranslation = null;
    private RestOperations restOperations = null;

    public UniTimeOidcUserService() {
        if (ApplicationProperty.ExternalUserIdTranslation.value() != null) {
            try {
                this.iTranslation = (ExternalUidTranslation)Class.forName(ApplicationProperty.ExternalUserIdTranslation.value()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                Debug.error("Unable to instantiate external uid translation class, " + e.getMessage());
            }
        }
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        this.restOperations = restTemplate;
    }

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser user = super.loadUser(userRequest);
        Map additionalAttributes = null;
        if (ApplicationProperty.AuthenticationOAuht2AdditionalAttributes.value() != null && !ApplicationProperty.AuthenticationOAuht2AdditionalAttributes.value().isEmpty()) {
            try {
                HttpHeaders headers = new HttpHeaders();
                headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
                headers.setBearerAuth(userRequest.getAccessToken().getTokenValue());
                URI uri = new URI(ApplicationProperty.AuthenticationOAuht2AdditionalAttributes.value());
                RequestEntity request = new RequestEntity((MultiValueMap)headers, HttpMethod.GET, uri);
                ResponseEntity response = this.restOperations.exchange(request, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(){});
                additionalAttributes = (Map)response.getBody();
            }
            catch (Exception e) {
                Debug.error("Failed to query additional attributes: " + e.getMessage(), e);
            }
        }
        String userId = user.getName();
        if (ApplicationProperty.AuthenticationOAuht2IdAttribute.value() != null) {
            String[] keys = ApplicationProperty.AuthenticationOAuht2IdAttribute.value().split(",");
            String[] translate = ApplicationProperty.AuthenticationOAuht2IdAlwaysTranslate.value().split(",");
            boolean found = false;
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                String tr = translate[i < translate.length ? i : translate.length - 1];
                Object value = user.getAttribute(key);
                if (value == null && additionalAttributes != null) {
                    value = additionalAttributes.get(key);
                }
                if (value == null) continue;
                if (value instanceof List) {
                    Iterator iterator = ((List)value).iterator();
                    if (iterator.hasNext()) {
                        Object o = iterator.next();
                        userId = o.toString();
                    }
                } else {
                    userId = value.toString();
                }
                if ("true".equalsIgnoreCase(tr) && this.iTranslation != null) {
                    userId = this.iTranslation.translate(userId, ExternalUidTranslation.Source.LDAP, ExternalUidTranslation.Source.User);
                }
                found = true;
                break;
            }
            if (!found && this.iTranslation != null) {
                userId = this.iTranslation.translate(userId, ExternalUidTranslation.Source.LDAP, ExternalUidTranslation.Source.User);
            }
        } else if (this.iTranslation != null) {
            userId = this.iTranslation.translate(userId, ExternalUidTranslation.Source.LDAP, ExternalUidTranslation.Source.User);
        }
        String name = null;
        if (ApplicationProperty.AuthenticationOAuht2NameAttribute.value() != null) {
            Object value = user.getAttribute(ApplicationProperty.AuthenticationOAuht2NameAttribute.value());
            if (value == null && additionalAttributes != null) {
                value = additionalAttributes.get(ApplicationProperty.AuthenticationOAuht2NameAttribute.value());
            }
            if (value != null) {
                if (value instanceof List) {
                    Iterator iterator = ((List)value).iterator();
                    if (iterator.hasNext()) {
                        Object o = iterator.next();
                        name = o.toString();
                    }
                } else {
                    name = value.toString();
                }
            }
        }
        if (ApplicationProperty.AuthenticationOAuht2IdTrimLeadingZerosFrom.isTrue()) {
            while (userId.startsWith("0")) {
                userId = userId.substring(1);
            }
        }
        return new UniTimeOidcUserContext(userId, name, user);
    }
}

