/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.spring.oauth2;

import java.util.Iterator;
import java.util.List;
import org.springframework.security.oauth2.client.userinfo.DefaultOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserRequest;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.interfaces.ExternalUidTranslation;
import org.unitime.timetable.spring.oauth2.UniTimeOAuth2UserContext;

@Service(value="unitimeOAuth2UserService")
public class UniTimeOAuth2UserService
extends DefaultOAuth2UserService {
    private ExternalUidTranslation iTranslation = null;

    public UniTimeOAuth2UserService() {
        if (ApplicationProperty.ExternalUserIdTranslation.value() != null) {
            try {
                this.iTranslation = (ExternalUidTranslation)Class.forName(ApplicationProperty.ExternalUserIdTranslation.value()).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                Debug.error("Unable to instantiate external uid translation class, " + e.getMessage());
            }
        }
    }

    public OAuth2User loadUser(OAuth2UserRequest userRequest) throws OAuth2AuthenticationException {
        Object value;
        OAuth2User user = super.loadUser(userRequest);
        String userId = user.getName();
        if (ApplicationProperty.AuthenticationOAuht2IdAttribute.value() != null) {
            String[] keys = ApplicationProperty.AuthenticationOAuht2IdAttribute.value().split(",");
            String[] translate = ApplicationProperty.AuthenticationOAuht2IdAlwaysTranslate.value().split(",");
            boolean found = false;
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                String tr = translate[i < translate.length ? i : translate.length - 1];
                Object value2 = user.getAttribute(key);
                if (value2 == null) continue;
                if (value2 instanceof List) {
                    Iterator iterator = ((List)value2).iterator();
                    if (iterator.hasNext()) {
                        Object o = iterator.next();
                        userId = o.toString();
                    }
                } else {
                    userId = value2.toString();
                }
                if ("true".equalsIgnoreCase(tr) && this.iTranslation != null) {
                    userId = this.iTranslation.translate(userId, ExternalUidTranslation.Source.LDAP, ExternalUidTranslation.Source.User);
                }
                found = true;
                break;
            }
            if (!found && this.iTranslation != null) {
                userId = this.iTranslation.translate(userId, ExternalUidTranslation.Source.LDAP, ExternalUidTranslation.Source.User);
            }
        } else if (this.iTranslation != null) {
            userId = this.iTranslation.translate(userId, ExternalUidTranslation.Source.LDAP, ExternalUidTranslation.Source.User);
        }
        String name = null;
        if (ApplicationProperty.AuthenticationOAuht2NameAttribute.value() != null && (value = user.getAttribute(ApplicationProperty.AuthenticationOAuht2NameAttribute.value())) != null) {
            if (value instanceof List) {
                Iterator iterator = ((List)value).iterator();
                if (iterator.hasNext()) {
                    Object o = iterator.next();
                    name = o.toString();
                }
            } else {
                name = value.toString();
            }
        }
        if (ApplicationProperty.AuthenticationOAuht2IdTrimLeadingZerosFrom.isTrue()) {
            while (userId.startsWith("0")) {
                userId = userId.substring(1);
            }
        }
        return new UniTimeOAuth2UserContext(userId, name, user);
    }
}

