/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.spring.gwt;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import com.google.gwt.user.server.rpc.UnexpectedException;
import com.google.gwt.user.server.rpc.jakarta.RPC;
import com.google.gwt.user.server.rpc.jakarta.RemoteServiceServlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.shared.PageAccessException;

public class GwtDispatcherServlet
extends RemoteServiceServlet {
    private static final long serialVersionUID = 1L;
    private Gson iGson = null;
    private static ThreadLocal<GwtCallInfo> sLastQuery = new ThreadLocal();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.iGson = new GsonBuilder().registerTypeAdapter(Timestamp.class, (Object)new JsonSerializer<Timestamp>(){

            public JsonElement serialize(Timestamp src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(src));
            }
        }).registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd").format(src));
            }
        }).registerTypeAdapter(java.util.Date.class, (Object)new JsonSerializer<java.util.Date>(){

            public JsonElement serialize(java.util.Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(src));
            }
        }).setFieldNamingStrategy(new FieldNamingStrategy(){
            Pattern iPattern = Pattern.compile("i([A-Z])(.*)");

            public String translateName(Field f) {
                Matcher matcher = this.iPattern.matcher(f.getName());
                if (matcher.matches()) {
                    return matcher.group(1).toLowerCase() + matcher.group(2);
                }
                return f.getName();
            }
        }).create();
    }

    public String processCall(String payload) throws SerializationException {
        try {
            Object handler = this.getBean(this.getThreadLocalRequest());
            RPCRequest rpcRequest = RPC.decodeRequest((String)payload, handler.getClass(), (SerializationPolicyProvider)this);
            this.onAfterRequestDeserialized(rpcRequest);
            try {
                if (ApplicationProperty.QueryLogJSON.isTrue()) {
                    sLastQuery.set(new GwtCallInfo(rpcRequest.getMethod().getDeclaringClass().getSimpleName() + "#" + rpcRequest.getMethod().getName(), this.iGson.toJson((Object)rpcRequest.getParameters())));
                } else {
                    sLastQuery.set(new GwtCallInfo(rpcRequest.getMethod().getDeclaringClass().getSimpleName() + "#" + rpcRequest.getMethod().getName(), payload));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                return RPC.invokeAndEncodeResponse((Object)handler, (Method)rpcRequest.getMethod(), (Object[])rpcRequest.getParameters(), (SerializationPolicy)rpcRequest.getSerializationPolicy());
            }
            catch (UnexpectedException ex) {
                if (ex.getCause() instanceof AccessDeniedException) {
                    return RPC.encodeResponseForFailure((Method)rpcRequest.getMethod(), (Throwable)new PageAccessException(ex.getCause().getMessage()), (SerializationPolicy)rpcRequest.getSerializationPolicy());
                }
                throw ex;
            }
        }
        catch (IncompatibleRemoteServiceException ex) {
            return RPC.encodeResponseForFailure(null, (Throwable)ex);
        }
    }

    protected String getService(HttpServletRequest request) {
        String url = request.getRequestURI();
        String service = url.substring(url.lastIndexOf("/") + 1);
        return service;
    }

    protected Object getBean(HttpServletRequest request) {
        String service = this.getService(request);
        Object bean = this.getBean(service);
        return bean;
    }

    protected Object getBean(String name) {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        return applicationContext.getBean(name);
    }

    public static GwtCallInfo getLastQuery() {
        GwtCallInfo q = sLastQuery.get();
        if (q != null) {
            sLastQuery.remove();
        }
        return q;
    }

    public static class GwtCallInfo {
        String iTarget;
        String iQuery;

        public GwtCallInfo(String target, String query) {
            this.iTarget = target;
            this.iQuery = query;
        }

        public String getTarget() {
            return this.iTarget;
        }

        public String getQuery() {
            return this.iQuery;
        }
    }
}

