/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cpsolver.ifs.util.Progress;
import org.dom4j.Element;
import org.unitime.timetable.solver.ui.TimetableInfo;

public class LogInfo
implements TimetableInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    public static int sVersion = 1;
    public static int sNoSaveThreshold = 1;
    private List<Progress.Message> iLog = new ArrayList<Progress.Message>();

    public void setLog(List<Progress.Message> log) {
        this.iLog = log;
    }

    public List<Progress.Message> getLog() {
        return this.iLog;
    }

    public String getLog(int level) {
        StringBuffer sb = new StringBuffer();
        for (Progress.Message m : this.iLog) {
            String s = m.toString(level);
            if (s == null) continue;
            sb.append(s + "\n");
        }
        return sb.toString();
    }

    public String getHtmlLog(int level, boolean includeDate) {
        StringBuffer sb = new StringBuffer();
        for (Progress.Message m : this.iLog) {
            String s = m.toHtmlString(level, includeDate);
            if (s == null) continue;
            sb.append(s + "<br>");
        }
        return sb.toString();
    }

    public String getHtmlLog(int level, boolean includeDate, String fromStage) {
        StringBuffer sb = new StringBuffer();
        for (Progress.Message m : this.iLog) {
            String s;
            if (m.getLevel() == 4 && m.getMessage().equals(fromStage)) {
                sb = new StringBuffer();
            }
            if ((s = m.toHtmlString(level, includeDate)) == null) continue;
            sb.append(s + "<br>");
        }
        return sb.toString();
    }

    @Override
    public void load(Element root) {
        this.iLog.clear();
        int version = Integer.parseInt(root.attributeValue("version"));
        if (version == 1) {
            Iterator i = root.elementIterator("msg");
            while (i.hasNext()) {
                this.iLog.add(new Progress.Message((Element)i.next()));
            }
        }
    }

    @Override
    public void save(Element root) {
        root.addAttribute("version", String.valueOf(sVersion));
        for (Progress.Message msg : this.iLog) {
            if (msg.getLevel() <= sNoSaveThreshold) continue;
            msg.save(root.addElement("msg"));
        }
    }

    @Override
    public boolean saveToFile() {
        return false;
    }
}

