/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.DataProperties;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.SuspectedException;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.fork.ForkChannel;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.CommitedClassAssignmentProxy;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.jgroups.CourseSolverContainer;
import org.unitime.timetable.solver.jgroups.RemoteSolver;
import org.unitime.timetable.solver.jgroups.RemoteSolverContainer;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.solver.jgroups.UniTimeRpcDispatcher;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.solver.ui.TimetableInfo;
import org.unitime.timetable.solver.ui.TimetableInfoFileProxy;
import org.unitime.timetable.solver.ui.TimetableInfoUtil;

public class CourseSolverContainerRemote
extends CourseSolverContainer
implements RemoteSolverContainer<SolverProxy> {
    private static Log sLog = LogFactory.getLog(CourseSolverContainerRemote.class);
    private boolean iSaveFileInfos = false;
    private RpcDispatcher iDispatcher;
    private ForkChannel iChannel;

    public CourseSolverContainerRemote(JChannel channel, short scope, boolean saveFileInfos) throws Exception {
        this.iChannel = new ForkChannel(channel, String.valueOf(scope), "fork-" + scope, new Protocol[0]);
        this.iDispatcher = new UniTimeRpcDispatcher((JChannel)this.iChannel, this);
        this.iSaveFileInfos = saveFileInfos;
    }

    @Override
    public void setChannel(JChannel channel, short scope) throws Exception {
        ForkChannel oldChannel = this.iChannel;
        if (channel != null) {
            this.iChannel = new ForkChannel(channel, String.valueOf(scope), "fork-" + scope, new Protocol[0]);
            this.iChannel.connect("UniTime:RPC:Courses");
            this.iDispatcher = new UniTimeRpcDispatcher((JChannel)this.iChannel, this);
        }
        if (oldChannel != null && oldChannel.isConnected()) {
            oldChannel.disconnect();
        }
    }

    @Override
    public void start() throws Exception {
        this.iChannel.connect("UniTime:RPC:Courses");
        super.start();
    }

    @Override
    public void stop() throws Exception {
        this.iChannel.disconnect();
        super.stop();
    }

    @Override
    public RpcDispatcher getDispatcher() {
        return this.iDispatcher;
    }

    @Override
    public boolean createRemoteSolver(String user, DataProperties config, Address caller) {
        return super.createSolver(user, config) != null;
    }

    @Override
    public Object invoke(String method, String user, String locale, Class[] types, Object[] args) throws Exception {
        try {
            SolverProxy solver = (SolverProxy)this.iCourseSolvers.get(user);
            if ("exists".equals(method) && types.length == 0) {
                Boolean bl = solver != null;
                return bl;
            }
            if (solver == null) {
                throw new Exception("Solver " + user + " does not exist.");
            }
            if (locale != null) {
                Localization.setLocale(locale);
            }
            Object object = solver.getClass().getMethod(method, types).invoke((Object)solver, args);
            return object;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null && e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw e;
        }
        finally {
            HibernateUtil.closeCurrentThreadSessions();
        }
    }

    @Override
    public Object dispatch(Address address, String user, Method method, Object[] args) throws Exception {
        try {
            return this.iDispatcher.callRemoteMethod(address, "invoke", new Object[]{method.getName(), user, Localization.getLocale(), method.getParameterTypes(), args}, new Class[]{String.class, String.class, String.class, Class[].class, Object[].class}, SolverServerImplementation.sFirstResponse);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null && e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw e;
        }
        catch (Exception e) {
            if ("exists".equals(method.getName()) && e instanceof SuspectedException) {
                return false;
            }
            sLog.error((Object)("Excution of " + method.getName() + " on solver " + user + " failed: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    public Boolean saveToFile(String name, TimetableInfo info) {
        if (this.iSaveFileInfos) {
            try {
                return TimetableInfoUtil.getLocalInstance().saveToFile(name, info);
            }
            catch (Exception e) {
                sLog.error((Object)("Failed to save info " + name + ": " + e.getMessage()), (Throwable)e);
            }
        }
        return false;
    }

    public TimetableInfo loadFromFile(String name) {
        try {
            return TimetableInfoUtil.getLocalInstance().loadFromFile(name);
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to retrieve info " + name + ": " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public Boolean deleteFile(String name) {
        if (this.iSaveFileInfos) {
            return TimetableInfoUtil.getLocalInstance().deleteFile(name);
        }
        return false;
    }

    @Override
    public TimetableInfoFileProxy getFileProxy() {
        return new FileProxy();
    }

    @Override
    public SolverProxy createProxy(Address address, String user) {
        SolverInvocationHandler handler = new SolverInvocationHandler(address, user);
        SolverProxy px = (SolverProxy)Proxy.newProxyInstance(SolverProxy.class.getClassLoader(), new Class[]{SolverProxy.class, RemoteSolver.class}, (InvocationHandler)handler);
        handler.setRemoteSolverProxy(px);
        return px;
    }

    private class FileProxy
    implements TimetableInfoFileProxy {
        private FileProxy() {
        }

        @Override
        public boolean saveToFile(String name, TimetableInfo info) {
            try {
                RspList ret = CourseSolverContainerRemote.this.iDispatcher.callRemoteMethods(null, "saveToFile", new Object[]{name, info}, new Class[]{String.class, TimetableInfo.class}, SolverServerImplementation.sAllResponses);
                for (Rsp rsp : ret) {
                    if (rsp == null || rsp.getValue() == null || !((Boolean)rsp.getValue()).booleanValue()) continue;
                    return true;
                }
            }
            catch (Exception e) {
                sLog.error((Object)("Failed to save info " + name + ": " + e.getMessage()), (Throwable)e);
            }
            return false;
        }

        @Override
        public TimetableInfo loadFromFile(String name) {
            try {
                RspList ret = CourseSolverContainerRemote.this.iDispatcher.callRemoteMethods(null, "loadFromFile", new Object[]{name}, new Class[]{String.class}, SolverServerImplementation.sAllResponses);
                for (Rsp rsp : ret) {
                    if (rsp == null || rsp.getValue() == null) continue;
                    return (TimetableInfo)rsp.getValue();
                }
            }
            catch (Exception e) {
                sLog.error((Object)("Failed to load info " + name + ": " + e.getMessage()), (Throwable)e);
            }
            return null;
        }

        @Override
        public boolean deleteFile(String name) {
            try {
                RspList ret = CourseSolverContainerRemote.this.iDispatcher.callRemoteMethods(null, "deleteFile", new Object[]{name}, new Class[]{String.class}, SolverServerImplementation.sFirstResponse);
                for (Rsp rsp : ret) {
                    if (rsp == null || rsp.getValue() == null || !((Boolean)rsp.getValue()).booleanValue()) continue;
                    return true;
                }
            }
            catch (Exception e) {
                sLog.error((Object)("Failed to delete info " + name + ": " + e.getMessage()), (Throwable)e);
            }
            return false;
        }
    }

    public class SolverInvocationHandler
    implements InvocationHandler {
        private Address iAddress;
        private String iUser;
        private SolverProxy iRemoteSolverProxy;
        private CommitedClassAssignmentProxy iCommitedClassAssignmentProxy = null;

        private SolverInvocationHandler(Address address, String user) {
            this.iAddress = address;
            this.iUser = user;
            this.iCommitedClassAssignmentProxy = new CommitedClassAssignmentProxy();
        }

        private void setRemoteSolverProxy(SolverProxy proxy) {
            this.iRemoteSolverProxy = proxy;
        }

        public String getHost() {
            return this.iAddress.toString();
        }

        public String getUser() {
            return this.iUser;
        }

        public AssignmentPreferenceInfo getAssignmentInfo(Class_ clazz) throws Exception {
            Department dept = clazz.getManagingDept();
            if (dept != null && this.iRemoteSolverProxy.getDepartmentIds().contains(dept.getUniqueId())) {
                return this.iRemoteSolverProxy.getAssignmentInfo(clazz.getUniqueId());
            }
            return this.iCommitedClassAssignmentProxy.getAssignmentInfo(clazz);
        }

        public ClassAssignmentProxy.AssignmentInfo getAssignment(Class_ clazz) throws Exception {
            Department dept = clazz.getManagingDept();
            if (dept != null && this.iRemoteSolverProxy.getDepartmentIds().contains(dept.getUniqueId())) {
                return this.iRemoteSolverProxy.getAssignment(clazz.getUniqueId());
            }
            return this.iCommitedClassAssignmentProxy.getAssignment(clazz);
        }

        public Map<Long, ClassAssignmentProxy.AssignmentInfo> getAssignmentTable(Collection classesOrClassIds) throws Exception {
            Set<Long> deptIds = this.iRemoteSolverProxy.getDepartmentIds();
            HashMap<Long, ClassAssignmentProxy.AssignmentInfo> assignments = new HashMap<Long, ClassAssignmentProxy.AssignmentInfo>();
            ArrayList<Long> solverClassIds = new ArrayList<Long>(classesOrClassIds.size());
            for (Object classOrClassId : classesOrClassIds) {
                Class_ clazz;
                if (classOrClassId instanceof Object[]) {
                    classOrClassId = ((Object[])classOrClassId)[0];
                }
                Class_ class_ = clazz = classOrClassId instanceof Class_ ? (Class_)classOrClassId : (Class_)new Class_DAO().get((Long)classOrClassId);
                if (clazz.getManagingDept() == null || !deptIds.contains(clazz.getManagingDept().getUniqueId())) {
                    Assignment assignment = this.iCommitedClassAssignmentProxy.getAssignment(clazz);
                    if (assignment == null) continue;
                    assignments.put(clazz.getUniqueId(), assignment);
                    continue;
                }
                solverClassIds.add(clazz.getUniqueId());
            }
            if (!solverClassIds.isEmpty()) {
                assignments.putAll(this.iRemoteSolverProxy.getAssignmentTable2(solverClassIds));
            }
            return assignments;
        }

        public Map<Long, AssignmentPreferenceInfo> getAssignmentInfoTable(Collection classesOrClassIds) throws Exception {
            Set<Long> deptIds = this.iRemoteSolverProxy.getDepartmentIds();
            HashMap<Long, AssignmentPreferenceInfo> infos = new HashMap<Long, AssignmentPreferenceInfo>();
            ArrayList<Long> solverClassIds = new ArrayList<Long>(classesOrClassIds.size());
            for (Object classOrClassId : classesOrClassIds) {
                Class_ clazz;
                if (classOrClassId instanceof Object[]) {
                    classOrClassId = ((Object[])classOrClassId)[0];
                }
                Class_ class_ = clazz = classOrClassId instanceof Class_ ? (Class_)classOrClassId : (Class_)new Class_DAO().get((Long)classOrClassId);
                if (clazz.getManagingDept() == null || !deptIds.contains(clazz.getManagingDept().getUniqueId())) {
                    AssignmentPreferenceInfo info = this.iCommitedClassAssignmentProxy.getAssignmentInfo(clazz);
                    if (info == null) continue;
                    infos.put(clazz.getUniqueId(), info);
                    continue;
                }
                solverClassIds.add(clazz.getUniqueId());
            }
            if (!solverClassIds.isEmpty()) {
                infos.putAll(this.iRemoteSolverProxy.getAssignmentInfoTable2(solverClassIds));
            }
            return infos;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return this.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)this, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return CourseSolverContainerRemote.this.dispatch(this.iAddress, this.iUser, method, args);
            }
        }
    }
}

