/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.course.ui;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.unitime.commons.Debug;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.EventDateMapping;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.solver.course.ui.ClassDateInfo;
import org.unitime.timetable.solver.course.ui.ClassInfo;
import org.unitime.timetable.solver.course.ui.ClassRoomInfo;
import org.unitime.timetable.solver.course.ui.ClassTimeInfo;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.util.duration.DurationModel;

public class ClassAssignment
extends ClassInfo
implements Serializable {
    private static final long serialVersionUID = -5426079388298794551L;
    protected Vector<ClassRoomInfo> iRooms = new Vector();
    protected ClassTimeInfo iTime = null;
    protected ClassDateInfo iDate = null;

    public ClassAssignment(Assignment assignment) {
        super(assignment.getClazz());
        AssignmentPreferenceInfo info = null;
        try {
            info = (AssignmentPreferenceInfo)assignment.getAssignmentInfo("AssignmentInfo");
        }
        catch (Exception e) {
            Debug.info("Unable to retrieve assignment info for " + assignment.getPlacement().getLongName(true));
        }
        if (info == null) {
            info = new AssignmentPreferenceInfo();
        }
        for (Location room : assignment.getRooms()) {
            this.iRooms.add(new ClassRoomInfo(room, info.getRoomPreference(room.getUniqueId())));
        }
        this.iDate = new ClassDateInfo(assignment.getDatePattern().getUniqueId(), assignment.getClassId(), assignment.getDatePattern().getName(), assignment.getDatePattern().getPatternBitSet(), info == null ? 0 : info.getDatePatternPref());
        DurationModel dm = assignment.getClazz().getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
        this.iTime = new ClassTimeInfo(assignment.getClassId(), assignment.getDays(), assignment.getStartSlot(), assignment.getSlotPerMtg(), assignment.getMinutesPerMeeting(), info.getTimePreference(), assignment.getTimePattern(), this.iDate, assignment.getBreakTime(), dm.getDates(assignment.getClazz().getSchedulingSubpart().getMinutesPerWk(), assignment.getDatePattern(), assignment.getDays(), assignment.getMinutesPerMeeting(), EventDateMapping.getMapping(assignment.getDatePattern().getUniqueId())));
    }

    public ClassAssignment(Class_ clazz, ClassTimeInfo time, ClassDateInfo date, Collection<ClassRoomInfo> rooms) {
        super(clazz);
        this.iTime = time;
        this.iDate = date;
        if (rooms != null) {
            this.iRooms.addAll(rooms);
        }
    }

    public boolean hasTime() {
        return this.iTime != null;
    }

    public ClassTimeInfo getTime() {
        return this.iTime;
    }

    public String getTimeId() {
        return this.hasTime() ? this.getTime().getId() : null;
    }

    public boolean hasDate() {
        return this.iDate != null;
    }

    public ClassDateInfo getDate() {
        return this.iDate;
    }

    public String getDateId() {
        return this.iDate == null ? null : this.iDate.getId().toString();
    }

    public Collection<ClassRoomInfo> getRooms() {
        return this.iRooms;
    }

    public TableInterface.CellInterface toRoomCell() {
        TableInterface.CellInterface r = new TableInterface.CellInterface();
        r.setNoWrap(true);
        for (ClassRoomInfo rm : this.getRooms()) {
            if (r.hasItems()) {
                r.add(", ");
            }
            r.addItem(rm.toCell());
        }
        return r;
    }

    public boolean hasRoom(Long roomId) {
        if (this.iRooms == null) {
            return false;
        }
        for (ClassRoomInfo room : this.iRooms) {
            if (!room.getLocationId().equals(roomId)) continue;
            return true;
        }
        return false;
    }

    public Collection<Long> getRoomIds() {
        Vector<Long> roomIds = new Vector<Long>(this.getNrRooms());
        for (ClassRoomInfo room : this.getRooms()) {
            roomIds.add(room.getLocationId());
        }
        return roomIds;
    }

    public int getNrRooms() {
        return this.iRooms.size();
    }

    public ClassRoomInfo getRoom(int idx) {
        return this.iRooms.elementAt(idx);
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.getClassName() + " ");
        if (this.hasDate()) {
            s.append(this.getDate().getName() + " ");
        }
        if (this.hasTime()) {
            s.append(this.getTime().getName());
        }
        if (this.getNrRooms() > 0) {
            s.append((this.hasTime() ? " " : "") + this.getRoomNames(", "));
        }
        return s.toString();
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(ClassInfo a) {
        int cmp = super.compareTo(a);
        if (cmp != 0) {
            return cmp;
        }
        if (a instanceof ClassAssignment) {
            ClassAssignment ci = (ClassAssignment)a;
            if (this.hasDate() && !ci.hasDate()) {
                return 1;
            }
            if (!this.hasDate() && ci.hasDate()) {
                return -1;
            }
            if (this.hasDate() && (cmp = this.getDate().compareTo(ci.getDate())) != 0) {
                return cmp;
            }
            if (this.hasTime() && !ci.hasTime()) {
                return 1;
            }
            if (!this.hasTime() && ci.hasTime()) {
                return -1;
            }
            if (this.hasTime() && (cmp = this.getTime().compareTo(ci.getTime())) != 0) {
                return cmp;
            }
            cmp = this.getRooms().size() - ci.getRooms().size();
            if (cmp != 0) {
                return cmp;
            }
            for (int i = 0; i < this.getNrRooms(); ++i) {
                cmp = this.getRoom(i).compareTo(ci.getRoom(i));
                if (cmp == 0) continue;
                return cmp;
            }
            return this.hashCode() - ci.hashCode();
        }
        return 1;
    }

    public int getValue() {
        int value = 0;
        if (this.hasTime()) {
            value += this.getTime().getPreference();
        }
        for (ClassRoomInfo room : this.getRooms()) {
            value += room.getPreference();
        }
        return value;
    }

    public String getRoomNames(String delim) {
        if (this.getNrRooms() == 0) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        Iterator<ClassRoomInfo> i = this.getRooms().iterator();
        while (i.hasNext()) {
            s.append(i.next().getName());
            if (!i.hasNext()) continue;
            s.append(delim);
        }
        return s.toString();
    }

    public String getRoomNamesHtml(String delim) {
        if (this.getNrRooms() == 0) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        Iterator<ClassRoomInfo> i = this.getRooms().iterator();
        while (i.hasNext()) {
            s.append(i.next().getNameHtml());
            if (!i.hasNext()) continue;
            s.append(delim);
        }
        return s.toString();
    }

    public boolean isValid() {
        return this.hasTime() && this.getNrRooms() == this.getNumberOfRooms();
    }

    public String getTimeNameHtml() {
        return this.hasTime() ? this.getTime().getNameHtml() : "<i>" + MSG.timeNotApplicable() + "</i>";
    }

    public String getTimeLongNameHtml() {
        return this.hasTime() ? this.getTime().getLongNameHtml() : "<i>" + MSG.timeNotApplicable() + "</i>";
    }

    public int getRoomSize() {
        int count = 0;
        for (ClassRoomInfo room : this.getRooms()) {
            count += room.getCapacity();
        }
        return count;
    }

    public String getDateNameHtml() {
        return this.hasDate() ? this.getDate().toHtml() : "<i>" + MSG.dateNotApplicable() + "</i>";
    }

    public String getDateLongNameHtml() {
        return this.hasDate() ? this.getDate().toLongHtml() : "<i>" + MSG.dateNotApplicable() + "</i>";
    }
}

